/***********************************************************************************

  Module :	Floor.c

  Description :	

  Last Modified $Date: $

  $Revision: $

  Copyright (C) 05 June 2005 T Swann

***********************************************************************************/

//**********************************************************************************
//   Include Files
//**********************************************************************************
#include "Types.h"
#include "Floor.h"
#include "Graphics.h"
#include "Vector.h"
#include "Controller.h"

//**********************************************************************************
//   Local Macros
//**********************************************************************************

//**********************************************************************************
//   Local Constants
//**********************************************************************************

//**********************************************************************************
//   Static Prototypes
//**********************************************************************************

//**********************************************************************************
//   Global Variables
//**********************************************************************************

//**********************************************************************************
//   Static Variables
//**********************************************************************************
static const s32	s_SinTab[ 256 ] =
{
	0, 411733, 823218, 1234208, 1644454, 2053710, 2461728, 2868264, 3273072, 3675908, 4076530, 4474697, 4870168, 5262706, 5652073, 6038036,
	6420362, 6798821, 7173184, 7543226, 7908724, 8269459, 8625212, 8975770, 9320921, 9660458, 9994175, 10321873, 10643353, 10958421, 11266889, 11568570,
	11863283, 12150849, 12431097, 12703856, 12968963, 13226258, 13475586, 13716797, 13949745, 14174290, 14390298, 14597637, 14796183, 14985817, 15166423, 15337894,
	15500126, 15653021, 15796488, 15930439, 16054794, 16169479, 16274423, 16369565, 16454846, 16530215, 16595627, 16651043, 16696429, 16731757, 16757007, 16772163,
	16777216, 16772163, 16757007, 16731757, 16696429, 16651043, 16595627, 16530215, 16454846, 16369565, 16274423, 16169479, 16054794, 15930439, 15796488, 15653021,
	15500126, 15337894, 15166423, 14985817, 14796183, 14597637, 14390298, 14174290, 13949745, 13716797, 13475586, 13226258, 12968963, 12703856, 12431097, 12150849,
	11863283, 11568570, 11266889, 10958421, 10643353, 10321873, 9994175, 9660458, 9320921, 8975770, 8625212, 8269459, 7908724, 7543226, 7173184, 6798821,
	6420362, 6038036, 5652073, 5262706, 4870168, 4474697, 4076530, 3675908, 3273072, 2868264, 2461728, 2053710, 1644454, 1234208, 823218, 411733,
	0, -411733, -823218, -1234208, -1644454, -2053710, -2461728, -2868264, -3273072, -3675908, -4076530, -4474697, -4870168, -5262706, -5652073, -6038036,
	-6420362, -6798821, -7173184, -7543226, -7908724, -8269459, -8625212, -8975770, -9320921, -9660458, -9994175, -10321873, -10643353, -10958421, -11266889, -11568570,
	-11863283, -12150849, -12431097, -12703856, -12968963, -13226258, -13475586, -13716797, -13949745, -14174290, -14390298, -14597637, -14796183, -14985817, -15166423, -15337894,
	-15500126, -15653021, -15796488, -15930439, -16054794, -16169479, -16274423, -16369565, -16454846, -16530215, -16595627, -16651043, -16696429, -16731757, -16757007, -16772163,
	-16777216, -16772163, -16757007, -16731757, -16696429, -16651043, -16595627, -16530215, -16454846, -16369565, -16274423, -16169479, -16054794, -15930439, -15796488, -15653021,
	-15500126, -15337894, -15166423, -14985817, -14796183, -14597637, -14390298, -14174290, -13949745, -13716797, -13475586, -13226258, -12968963, -12703856, -12431097, -12150849,
	-11863283, -11568570, -11266889, -10958421, -10643353, -10321873, -9994175, -9660458, -9320921, -8975770, -8625212, -8269459, -7908724, -7543226, -7173184, -6798821,
	-6420362, -6038036, -5652073, -5262706, -4870168, -4474697, -4076530, -3675908, -3273072, -2868264, -2461728, -2053710, -1644454, -1234208, -823218, -411733
};

static const s32	s_CosTab[ 256 ] = 
{
	16777216, 16772163, 16757007, 16731757, 16696429, 16651043, 16595627, 16530215, 16454846, 16369565, 16274423, 16169479, 16054794, 15930439, 15796488, 15653021,
	15500126, 15337894, 15166423, 14985817, 14796183, 14597637, 14390298, 14174290, 13949745, 13716797, 13475586, 13226258, 12968963, 12703856, 12431097, 12150849,
	11863283, 11568570, 11266889, 10958421, 10643353, 10321873, 9994175, 9660458, 9320921, 8975770, 8625212, 8269459, 7908724, 7543226, 7173184, 6798821,
	6420362, 6038036, 5652073, 5262706, 4870168, 4474697, 4076530, 3675908, 3273072, 2868264, 2461728, 2053710, 1644454, 1234208, 823218, 411733,
	0, -411733, -823218, -1234208, -1644454, -2053710, -2461728, -2868264, -3273072, -3675908, -4076530, -4474697, -4870168, -5262706, -5652073, -6038036,
	-6420362, -6798821, -7173184, -7543226, -7908724, -8269459, -8625212, -8975770, -9320921, -9660458, -9994175, -10321873, -10643353, -10958421, -11266889, -11568570,
	-11863283, -12150849, -12431097, -12703856, -12968963, -13226258, -13475586, -13716797, -13949745, -14174290, -14390298, -14597637, -14796183, -14985817, -15166423, -15337894,
	-15500126, -15653021, -15796488, -15930439, -16054794, -16169479, -16274423, -16369565, -16454846, -16530215, -16595627, -16651043, -16696429, -16731757, -16757007, -16772163,
	-16777216, -16772163, -16757007, -16731757, -16696429, -16651043, -16595627, -16530215, -16454846, -16369565, -16274423, -16169479, -16054794, -15930439, -15796488, -15653021,
	-15500126, -15337894, -15166423, -14985817, -14796183, -14597637, -14390298, -14174290, -13949745, -13716797, -13475586, -13226258, -12968963, -12703856, -12431097, -12150849,
	-11863283, -11568570, -11266889, -10958421, -10643353, -10321873, -9994175, -9660458, -9320921, -8975770, -8625212, -8269459, -7908724, -7543226, -7173184, -6798821,
	-6420362, -6038036, -5652073, -5262706, -4870168, -4474697, -4076530, -3675908, -3273072, -2868264, -2461728, -2053710, -1644454, -1234208, -823218, -411733,
	0, 411733, 823218, 1234208, 1644454, 2053710, 2461728, 2868264, 3273072, 3675908, 4076530, 4474697, 4870168, 5262706, 5652073, 6038036,
	6420362, 6798821, 7173184, 7543226, 7908724, 8269459, 8625212, 8975770, 9320921, 9660458, 9994175, 10321873, 10643353, 10958421, 11266889, 11568570,
	11863283, 12150849, 12431097, 12703856, 12968963, 13226258, 13475586, 13716797, 13949745, 14174290, 14390298, 14597637, 14796183, 14985817, 15166423, 15337894,
	15500126, 15653021, 15796488, 15930439, 16054794, 16169479, 16274423, 16369565, 16454846, 16530215, 16595627, 16651043, 16696429, 16731757, 16757007, 16772163
};

static const s32	s_DivideTab[ 256 ] =
{
	2097152, 1048576, 699050, 524288, 419430, 349525, 299593, 262144, 233016, 209715, 190650, 174762, 161319, 149796, 139810, 131072,
	123361, 116508, 110376, 104857, 99864, 95325, 91180, 87381, 83886, 80659, 77672, 74898, 72315, 69905, 67650, 65536,
	63550, 61680, 59918, 58254, 56679, 55188, 53773, 52428, 51150, 49932, 48770, 47662, 46603, 45590, 44620, 43690,
	42799, 41943, 41120, 40329, 39568, 38836, 38130, 37449, 36792, 36157, 35544, 34952, 34379, 33825, 33288, 32768,
	32263, 31775, 31300, 30840, 30393, 29959, 29537, 29127, 28728, 28339, 27962, 27594, 27235, 26886, 26546, 26214,
	25890, 25575, 25266, 24966, 24672, 24385, 24105, 23831, 23563, 23301, 23045, 22795, 22550, 22310, 22075, 21845,
	21620, 21399, 21183, 20971, 20763, 20560, 20360, 20164, 19972, 19784, 19599, 19418, 19239, 19065, 18893, 18724,
	18558, 18396, 18236, 18078, 17924, 17772, 17623, 17476, 17331, 17189, 17050, 16912, 16777, 16644, 16513, 16384,
	16256, 16131, 16008, 15887, 15768, 15650, 15534, 15420, 15307, 15196, 15087, 14979, 14873, 14768, 14665, 14563,
	14463, 14364, 14266, 14169, 14074, 13981, 13888, 13797, 13706, 13617, 13530, 13443, 13357, 13273, 13189, 13107,
	13025, 12945, 12865, 12787, 12710, 12633, 12557, 12483, 12409, 12336, 12264, 12192, 12122, 12052, 11983, 11915,
	11848, 11781, 11715, 11650, 11586, 11522, 11459, 11397, 11335, 11275, 11214, 11155, 11096, 11037, 10979, 10922,
	10866, 10810, 10754, 10699, 10645, 10591, 10538, 10485, 10433, 10381, 10330, 10280, 10230, 10180, 10131, 10082,
	10034, 9986, 9939, 9892, 9845, 9799, 9754, 9709, 9664, 9619, 9576, 9532, 9489, 9446, 9404, 9362,
	9320, 9279, 9238, 9198, 9157, 9118, 9078, 9039, 9000, 8962, 8924, 8886, 8848, 8811, 8774, 8738,
	8701, 8665, 8630, 8594, 8559, 8525, 8490, 8456, 8422, 8388, 8355, 8322, 8289, 8256, 8224, 8192
};

static const u32	g_floorWidth = 128;
static const u32	g_floorWidthBits = 7;
static const u32	g_floorHeight = 128;
static const u32	g_floorHeightBits = 7;
static const u16	g_floorData[] =
{
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB049, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB469, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB469, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB469, 0xB46A, 0xB06A, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB469, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB069, 0xB469, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48B, 0xB48B, 0xB48B, 0xB88B, 0xB48B, 0xB48B, 0xB48B, 0xB48B, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB469, 0xB069, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB469, 0xB469, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48B, 0xB88B, 0xB88B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB88B, 0xB88B, 0xB88B, 0xB48B, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48B, 0xB88B, 0xB88B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB88B, 0xB88B, 0xB48B, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB469, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB88B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xB8AB, 0xB8AC, 0xB8AC, 0xB8AC, 0xB8AB, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48B, 0xB88B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB88B, 0xB48B, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB469, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48B, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB469, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCAC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xBCED, 0xBCED, 0xBCED, 0xBCED, 0xBCED, 0xBCED, 0xBCED, 0xBCCD, 0xBCED, 0xBCCD, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8CC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48B, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB06A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xBCED, 0xBCED, 0xBCED, 0xBCED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xBCED, 0xBCED, 0xBCED, 0xBCED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB88B, 0xB48B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB469, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xBCED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC10D, 0xC0ED, 0xC10D, 0xC10D, 0xC10D, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xBCED, 0xBCED, 0xBCCD, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCD, 0xBCED, 0xBCED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10D, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xBCED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8CC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB469, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xBCED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC10D, 0xC10E, 0xC10E, 0xC10E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10D, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xBCED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8CC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB469, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB06A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xBCED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC10D, 0xC10E, 0xC10E, 0xC10E, 0xC50E, 0xC50E, 0xC50E, 0xC52E, 0xC52E, 0xC52E, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52E, 0xC52E, 0xC52E, 0xC50E, 0xC50E, 0xC50E, 0xC10E, 0xC10E, 0xC10E, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xBCED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB469, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC10E, 0xC10E, 0xC10E, 0xC50E, 0xC50E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC92F, 0xC92F, 0xC92F, 0xC92F, 0xC92F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC50E, 0xC10E, 0xC10E, 0xC10E, 0xC10D, 0xC0ED, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCAC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC10D, 0xC10E, 0xC10E, 0xC50E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC92F, 0xC92F, 0xC94F, 0xC94F, 0xC94F, 0xC94F, 0xC950, 0xC94F, 0xC950, 0xC950, 0xC94F, 0xC94F, 0xC94F, 0xC94F, 0xC94F, 0xC94F, 0xC92F, 0xC92F, 0xC52F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC50E, 0xC50E, 0xC10E, 0xC10E, 0xC10D, 0xC0ED, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC10E, 0xC10E, 0xC50E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC52F, 0xC92F, 0xC94F, 0xC94F, 0xC94F, 0xC94F, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC94F, 0xC94F, 0xC92F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC50E, 0xC10E, 0xC10E, 0xC0ED, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCD, 0xC0ED, 0xC0ED, 0xC0ED, 0xC10E, 0xC10E, 0xC50E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC52F, 0xC92F, 0xC94F, 0xC94F, 0xC950, 0xC950, 0xC950, 0xC950, 0xC970, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xC970, 0xC950, 0xC950, 0xC950, 0xC950, 0xC94F, 0xC94F, 0xC92F, 0xC52F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC10E, 0xC10D, 0xC0ED, 0xC0ED, 0xBCED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC10E, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC52F, 0xC92F, 0xC94F, 0xC950, 0xC950, 0xC950, 0xC950, 0xCD70, 0xCD70, 0xCD70, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD70, 0xCD70, 0xCD70, 0xC950, 0xC950, 0xC950, 0xC950, 0xC94F, 0xC92F, 0xC52F, 0xC52F, 0xC52E, 0xC52E, 0xC50E, 0xC10E, 0xC10E, 0xC0ED, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB469, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC10E, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC92F, 0xC94F, 0xC950, 0xC950, 0xC950, 0xC970, 0xCD70, 0xCD70, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD91, 0xCD91, 0xCD91, 0xCD91, 0xCD91, 0xD191, 0xCD91, 0xCD91, 0xCD91, 0xCD91, 0xCD91, 0xCD91, 0xCD91, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD70, 0xCD70, 0xC970, 0xC950, 0xC950, 0xC950, 0xC94F, 0xC92F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC10E, 0xC10D, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10D, 0xC10E, 0xC50E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xC950, 0xC950, 0xC970, 0xCD70, 0xCD70, 0xCD71, 0xCD71, 0xCD91, 0xCD91, 0xCD91, 0xD191, 0xD191, 0xD191, 0xD192, 0xD192, 0xD192, 0xD192, 0xD192, 0xD192, 0xD192, 0xD192, 0xD192, 0xD192, 0xD191, 0xD191, 0xCD91, 0xCD91, 0xCD91, 0xCD71, 0xCD71, 0xCD70, 0xCD70, 0xC970, 0xC950, 0xC950, 0xC94F, 0xC94F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC50E, 0xC10E, 0xC0EE, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB469, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10D, 0xC10E, 0xC50E, 0xC50E, 0xC52F, 0xC52F, 0xC92F, 0xC94F, 0xC950, 0xC950, 0xC950, 0xCD70, 0xCD71, 0xCD71, 0xCD71, 0xCD91, 0xCD91, 0xD191, 0xD192, 0xD192, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD192, 0xD192, 0xD192, 0xD191, 0xCD91, 0xCD91, 0xCD71, 0xCD71, 0xCD71, 0xCD70, 0xC970, 0xC950, 0xC950, 0xC94F, 0xC92F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB469, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10D, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC94F, 0xC94F, 0xC950, 0xC950, 0xCD70, 0xCD70, 0xCD71, 0xCD71, 0xCD91, 0xCD91, 0xD192, 0xD192, 0xD192, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD5B2, 0xD5B3, 0xD5B2, 0xD5B3, 0xD5B3, 0xD5B3, 0xD5B3, 0xD5B3, 0xD5B3, 0xD5B2, 0xD5B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD192, 0xD192, 0xD191, 0xD191, 0xCD91, 0xCD91, 0xCD71, 0xCD70, 0xCD70, 0xC950, 0xC950, 0xC94F, 0xC92F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48B, 0xB8AB, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCD, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC94F, 0xC94F, 0xC950, 0xC970, 0xCD70, 0xCD71, 0xCD71, 0xCD91, 0xCD91, 0xD192, 0xD192, 0xD1B2, 0xD1B2, 0xD1B2, 0xD5B2, 0xD5B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5B3, 0xD5B3, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD192, 0xD191, 0xD191, 0xCD91, 0xCD71, 0xCD71, 0xCD70, 0xC970, 0xC950, 0xC94F, 0xC94F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xC0ED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC94F, 0xC94F, 0xC950, 0xC970, 0xCD70, 0xCD71, 0xCD91, 0xCD91, 0xD191, 0xD192, 0xD1B2, 0xD1B2, 0xD1B2, 0xD5B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD9D3, 0xD5D3, 0xD9D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5B3, 0xD5B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD192, 0xD191, 0xCD91, 0xCD71, 0xCD71, 0xCD70, 0xC970, 0xC950, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48B, 0xB48A, 0xB48A, 0xB46A, 0xB469, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xC950, 0xCD70, 0xCD70, 0xCD71, 0xCD91, 0xCD91, 0xD192, 0xD1B2, 0xD1B2, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD5F4, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD192, 0xD191, 0xCD91, 0xCD71, 0xCD70, 0xCD70, 0xC950, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8CC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xC950, 0xCD70, 0xCD70, 0xCD71, 0xCD91, 0xD191, 0xD192, 0xD1B2, 0xD1B2, 0xD5B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xDA14, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD1B2, 0xD1B2, 0xD192, 0xD191, 0xCD91, 0xCD71, 0xCD70, 0xC970, 0xC950, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC50E, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCD, 0xC0ED, 0xC0ED, 0xC10E, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC92F, 0xC950, 0xC950, 0xCD70, 0xCD70, 0xCD71, 0xCD91, 0xD191, 0xD192, 0xD1B2, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xDA14, 0xDA15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDA15, 0xDA14, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5B2, 0xD1B2, 0xD1B2, 0xD192, 0xD191, 0xCD91, 0xCD71, 0xCD70, 0xCD70, 0xC950, 0xC950, 0xC94F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xBCED, 0xBCCD, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48B, 0xB8AB, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC92F, 0xC94F, 0xC950, 0xC970, 0xCD70, 0xCD71, 0xCD91, 0xD191, 0xD192, 0xD1B2, 0xD5B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xDA14, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE35, 0xDE15, 0xDE35, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDA14, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD1B2, 0xD192, 0xD191, 0xCD91, 0xCD71, 0xCD70, 0xC970, 0xC950, 0xC94F, 0xC92F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB469, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB469, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xC970, 0xCD70, 0xCD71, 0xCD91, 0xD191, 0xD192, 0xD1B2, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xDA14, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE35, 0xDE35, 0xDE35, 0xDE36, 0xDE36, 0xE236, 0xDE36, 0xDE36, 0xDE36, 0xDE36, 0xDE36, 0xDE35, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDA14, 0xD9F4, 0xD9F4, 0xD9F4, 0xD5D4, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5B2, 0xD1B2, 0xD192, 0xD191, 0xCD91, 0xCD71, 0xCD70, 0xC970, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC52E, 0xC10E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCCD, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48B, 0xB8AB, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD191, 0xD192, 0xD1B2, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xD9F4, 0xDA14, 0xDE15, 0xDE15, 0xDE15, 0xDE35, 0xDE35, 0xDE36, 0xE236, 0xE236, 0xE236, 0xE236, 0xE236, 0xE236, 0xE256, 0xE236, 0xE236, 0xE236, 0xE236, 0xE236, 0xE236, 0xDE36, 0xDE35, 0xDE15, 0xDE15, 0xDE15, 0xDA15, 0xDA14, 0xD9F4, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD1B2, 0xD192, 0xD191, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC950, 0xC94F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB48B, 0xB48A, 0xB48A, 0xB46A, 0xB469, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC92F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD191, 0xD192, 0xD1B2, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xD9F4, 0xDA14, 0xDE15, 0xDE15, 0xDE15, 0xDE35, 0xDE36, 0xE236, 0xE236, 0xE236, 0xE256, 0xE256, 0xE256, 0xE256, 0xE256, 0xE257, 0xE256, 0xE256, 0xE256, 0xE256, 0xE256, 0xE236, 0xE236, 0xE236, 0xDE36, 0xDE35, 0xDE15, 0xDE15, 0xDE15, 0xDA14, 0xD9F4, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD1B2, 0xD192, 0xD191, 0xCD71, 0xCD70, 0xC970, 0xC950, 0xC94F, 0xC92F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCCD, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB8AB, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC10E, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xC970, 0xCD70, 0xCD71, 0xCD91, 0xD192, 0xD1B2, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xD9F4, 0xDA14, 0xDE15, 0xDE15, 0xDE35, 0xDE36, 0xE236, 0xE236, 0xE256, 0xE256, 0xE257, 0xE257, 0xE257, 0xE657, 0xE657, 0xE657, 0xE657, 0xE657, 0xE657, 0xE257, 0xE257, 0xE257, 0xE256, 0xE256, 0xE256, 0xE236, 0xE236, 0xDE36, 0xDE35, 0xDE15, 0xDE15, 0xDA14, 0xD9F4, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD1B2, 0xD192, 0xCD91, 0xCD71, 0xCD70, 0xC970, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC50E, 0xC10E, 0xC10E, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB48B, 0xB48A, 0xB48A, 0xB46A, 0xB06A, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCD, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC92F, 0xC950, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD191, 0xD192, 0xD1B2, 0xD5B2, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xD9F4, 0xDA14, 0xDE15, 0xDE15, 0xDE35, 0xDE36, 0xE236, 0xE236, 0xE256, 0xE257, 0xE257, 0xE657, 0xE677, 0xE677, 0xE677, 0xE677, 0xE677, 0xE677, 0xE677, 0xE677, 0xE677, 0xE677, 0xE677, 0xE657, 0xE257, 0xE257, 0xE256, 0xE236, 0xE236, 0xDE36, 0xDE35, 0xDE15, 0xDE15, 0xDA15, 0xD9F4, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B2, 0xD1B2, 0xD192, 0xD191, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC94F, 0xC92F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCEC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC10D, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xCD70, 0xCD70, 0xCD71, 0xCD91, 0xD192, 0xD1B2, 0xD1B2, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xD9F4, 0xDA15, 0xDE15, 0xDE15, 0xDE35, 0xDE36, 0xE236, 0xE256, 0xE257, 0xE257, 0xE657, 0xE677, 0xE677, 0xE677, 0xE677, 0xE678, 0xE678, 0xE678, 0xE678, 0xE678, 0xE678, 0xE678, 0xE678, 0xE677, 0xE677, 0xE677, 0xE657, 0xE257, 0xE256, 0xE256, 0xE236, 0xE236, 0xDE35, 0xDE15, 0xDE15, 0xDA15, 0xD9F4, 0xD9F4, 0xD5F4, 0xD5D3, 0xD5D3, 0xD5B2, 0xD1B2, 0xD192, 0xCD91, 0xCD71, 0xCD71, 0xC970, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8CC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB469, 0xB46A, 0xB46A, 0xB48A, 0xB48B, 0xB88B, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCC, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC92F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD191, 0xD1B2, 0xD1B2, 0xD5D3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDA15, 0xDE15, 0xDE15, 0xDE35, 0xE236, 0xE236, 0xE256, 0xE257, 0xE257, 0xE677, 0xE677, 0xE677, 0xE678, 0xE678, 0xE678, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xE678, 0xE678, 0xE678, 0xE677, 0xE677, 0xE677, 0xE257, 0xE257, 0xE256, 0xE236, 0xE236, 0xDE35, 0xDE15, 0xDE15, 0xDA15, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5D3, 0xD1B2, 0xD1B2, 0xD191, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC94F, 0xC92F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48B, 0xB48A, 0xB48A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC94F, 0xC950, 0xC970, 0xCD70, 0xCD71, 0xD191, 0xD192, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDA14, 0xDE15, 0xDE15, 0xDE35, 0xDE36, 0xE236, 0xE256, 0xE257, 0xE657, 0xE677, 0xE677, 0xE678, 0xE678, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xE678, 0xE678, 0xE677, 0xE677, 0xE657, 0xE257, 0xE256, 0xE236, 0xE236, 0xDE35, 0xDE15, 0xDE15, 0xD9F4, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B2, 0xD1B2, 0xD192, 0xD191, 0xCD71, 0xCD71, 0xC970, 0xC950, 0xC94F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB469, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xBCAC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC10E, 0xC10E, 0xC50E, 0xC52F, 0xC92F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD191, 0xD1B2, 0xD1B2, 0xD5D3, 0xD5D3, 0xD9D3, 0xD9F4, 0xD9F4, 0xDA15, 0xDE15, 0xDE35, 0xDE36, 0xE236, 0xE256, 0xE257, 0xE657, 0xE677, 0xE677, 0xE678, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xEA99, 0xEA99, 0xEAB9, 0xEAB9, 0xEAB9, 0xEAB9, 0xEAB9, 0xEA99, 0xEA99, 0xEA98, 0xEA98, 0xEA98, 0xE698, 0xE678, 0xE677, 0xE677, 0xE657, 0xE257, 0xE256, 0xE236, 0xDE36, 0xDE35, 0xDE15, 0xDE15, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD1B2, 0xD191, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8CC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCD, 0xBCED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC94F, 0xC950, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD192, 0xD1B2, 0xD5B2, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDA14, 0xDE15, 0xDE15, 0xDE36, 0xE236, 0xE256, 0xE257, 0xE657, 0xE677, 0xE678, 0xE678, 0xEA98, 0xEA98, 0xEA98, 0xEA99, 0xEAB9, 0xEAB9, 0xEEB9, 0xEEB9, 0xEEB9, 0xEEB9, 0xEEB9, 0xEEB9, 0xEEB9, 0xEAB9, 0xEAB9, 0xEA99, 0xEA98, 0xEA98, 0xEA98, 0xE678, 0xE678, 0xE677, 0xE657, 0xE257, 0xE256, 0xE236, 0xDE36, 0xDE15, 0xDE15, 0xDA15, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B2, 0xD1B2, 0xD192, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC950, 0xC92F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB48A, 0xB48A, 0xB48B, 0xB8AB, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCD, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD191, 0xD1B2, 0xD1B2, 0xD5B3, 0xD5D3, 0xD9D3, 0xD9F4, 0xD9F4, 0xDE15, 0xDE15, 0xDE35, 0xE236, 0xE256, 0xE257, 0xE657, 0xE677, 0xE677, 0xE678, 0xEA98, 0xEA98, 0xEA99, 0xEAB9, 0xEAB9, 0xEEB9, 0xEEB9, 0xEEB9, 0xEEB9, 0xEEB9, 0xEEBA, 0xEEB9, 0xEEBA, 0xEEB9, 0xEEB9, 0xEEB9, 0xEAB9, 0xEAB9, 0xEA99, 0xEA98, 0xEA98, 0xE678, 0xE677, 0xE677, 0xE257, 0xE256, 0xE236, 0xE236, 0xDE35, 0xDE15, 0xDE15, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5D3, 0xD1B2, 0xD1B2, 0xD191, 0xCD91, 0xCD71, 0xC970, 0xC950, 0xC94F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88A, 0xB48A, 0xB48A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB469, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD191, 0xD1B2, 0xD1B2, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDA14, 0xDE15, 0xDE15, 0xDE36, 0xE236, 0xE256, 0xE257, 0xE677, 0xE677, 0xE678, 0xEA98, 0xEA98, 0xEA99, 0xEAB9, 0xEEB9, 0xEEB9, 0xEEB9, 0xEEBA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEBA, 0xEEB9, 0xEEB9, 0xEEB9, 0xEAB9, 0xEA99, 0xEA98, 0xEA98, 0xE678, 0xE677, 0xE677, 0xE257, 0xE256, 0xE236, 0xDE36, 0xDE35, 0xDE15, 0xDA14, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B2, 0xD1B2, 0xD192, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB48B, 0xB48A, 0xB48A, 0xB46A, 0xB469, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xBCAC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC10E, 0xC10E, 0xC50E, 0xC52F, 0xC92F, 0xC950, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD192, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDE15, 0xDE15, 0xDE35, 0xE236, 0xE256, 0xE257, 0xE657, 0xE677, 0xE678, 0xE698, 0xEA98, 0xEA99, 0xEAB9, 0xEEB9, 0xEEB9, 0xEEBA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEDA, 0xF2DA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEBA, 0xEEB9, 0xEEB9, 0xEAB9, 0xEA99, 0xEA98, 0xEA98, 0xE678, 0xE677, 0xE657, 0xE257, 0xE256, 0xE236, 0xDE35, 0xDE15, 0xDE15, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD192, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC950, 0xC92F, 0xC52F, 0xC50E, 0xC10E, 0xC10E, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCAC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB469, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCC, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC94F, 0xC950, 0xC970, 0xCD71, 0xCD91, 0xD191, 0xD192, 0xD1B2, 0xD5D3, 0xD5D3, 0xD9D3, 0xD9F4, 0xD9F4, 0xDE15, 0xDE15, 0xDE36, 0xE236, 0xE256, 0xE257, 0xE677, 0xE677, 0xE678, 0xEA98, 0xEA98, 0xEAB9, 0xEAB9, 0xEEB9, 0xEEBA, 0xEEDA, 0xEEDA, 0xF2DA, 0xF2DA, 0xF2DA, 0xF2FB, 0xF2FA, 0xF2DB, 0xF2DA, 0xF2DA, 0xF2DA, 0xEEDA, 0xEEDA, 0xEEBA, 0xEEB9, 0xEEB9, 0xEAB9, 0xEA98, 0xEA98, 0xE678, 0xE677, 0xE677, 0xE257, 0xE256, 0xE236, 0xDE36, 0xDE15, 0xDE15, 0xD9F4, 0xD9F4, 0xD9D3, 0xD5D3, 0xD5D3, 0xD1B2, 0xD192, 0xD191, 0xCD71, 0xCD71, 0xC970, 0xC950, 0xC94F, 0xC52F, 0xC52E, 0xC10E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCC, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC94F, 0xC950, 0xC970, 0xCD71, 0xCD91, 0xD191, 0xD1B2, 0xD1B2, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDA14, 0xDE15, 0xDE35, 0xDE36, 0xE236, 0xE257, 0xE657, 0xE677, 0xE678, 0xEA98, 0xEA98, 0xEA99, 0xEAB9, 0xEEB9, 0xEEBA, 0xEEDA, 0xEEDA, 0xF2DA, 0xF2DA, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2DA, 0xF2DA, 0xEEDA, 0xEEDA, 0xEEBA, 0xEEB9, 0xEAB9, 0xEA99, 0xEA98, 0xEA98, 0xE678, 0xE677, 0xE657, 0xE256, 0xE236, 0xE236, 0xDE35, 0xDE15, 0xDA15, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD1B2, 0xD1B2, 0xD191, 0xCD91, 0xCD71, 0xC970, 0xC950, 0xC94F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCCD, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCD, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD192, 0xD1B2, 0xD5B2, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDA15, 0xDE15, 0xDE35, 0xE236, 0xE256, 0xE257, 0xE677, 0xE677, 0xE678, 0xEA98, 0xEA99, 0xEAB9, 0xEEB9, 0xEEB9, 0xEEDA, 0xEEDA, 0xF2DA, 0xF2FA, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2DA, 0xF2DA, 0xEEDA, 0xEEDA, 0xEEB9, 0xEEB9, 0xEAB9, 0xEA98, 0xEA98, 0xE678, 0xE677, 0xE657, 0xE257, 0xE256, 0xE236, 0xDE35, 0xDE15, 0xDA15, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B2, 0xD1B2, 0xD192, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD192, 0xD1B2, 0xD5B2, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDE15, 0xDE15, 0xDE36, 0xE236, 0xE256, 0xE257, 0xE677, 0xE678, 0xE698, 0xEA98, 0xEA99, 0xEAB9, 0xEEB9, 0xEEBA, 0xEEDA, 0xEEDA, 0xF2DA, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF6FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2DA, 0xF2DA, 0xEEDA, 0xEEBA, 0xEEB9, 0xEAB9, 0xEA99, 0xEA98, 0xEA78, 0xE678, 0xE677, 0xE257, 0xE256, 0xE236, 0xDE36, 0xDE15, 0xDE15, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD192, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52F, 0xC92F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD192, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDE15, 0xDE15, 0xDE36, 0xE236, 0xE256, 0xE257, 0xE677, 0xE678, 0xEA98, 0xEA98, 0xEA99, 0xEEB9, 0xEEB9, 0xEEDA, 0xEEDA, 0xF2DA, 0xF2FB, 0xF2FB, 0xF2FB, 0xF6FB, 0xF71B, 0xF71C, 0xF71C, 0xF71B, 0xF71B, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2DA, 0xEEDA, 0xEEDA, 0xEEB9, 0xEEB9, 0xEA99, 0xEA98, 0xE698, 0xE678, 0xE677, 0xE657, 0xE256, 0xE236, 0xDE36, 0xDE15, 0xDE15, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD192, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC94F, 0xC92F, 0xC52F, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD192, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDE15, 0xDE15, 0xDE36, 0xE236, 0xE256, 0xE657, 0xE677, 0xE678, 0xEA98, 0xEA98, 0xEAB9, 0xEEB9, 0xEEB9, 0xEEDA, 0xEEDA, 0xF2DA, 0xF2FB, 0xF2FB, 0xF2FB, 0xF71B, 0xF71C, 0xF71C, 0xF71C, 0xF71C, 0xF71C, 0xF71B, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2DA, 0xEEDA, 0xEEDA, 0xEEB9, 0xEEB9, 0xEAB9, 0xEA98, 0xEA98, 0xE678, 0xE677, 0xE657, 0xE256, 0xE236, 0xDE36, 0xDE15, 0xDE15, 0xD9F4, 0xD9F4, 0xD9D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD192, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC950, 0xC52F, 0xC52F, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB48A, 0xB48A, 0xB48B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52F, 0xC92F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD192, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD9F4, 0xDA14, 0xDE15, 0xDE15, 0xDE36, 0xE236, 0xE256, 0xE657, 0xE677, 0xE678, 0xEA98, 0xEA98, 0xEAB9, 0xEEB9, 0xEEBA, 0xEEDA, 0xEEDA, 0xF2DB, 0xF2FB, 0xF2FB, 0xF6FB, 0xF71C, 0xF71C, 0xF71C, 0xF71C, 0xF71C, 0xF71C, 0xF71C, 0xF6FB, 0xF2FB, 0xF2FB, 0xF2DB, 0xEEDA, 0xEEDA, 0xEEBA, 0xEEB9, 0xEAB9, 0xEA98, 0xEA98, 0xE678, 0xE677, 0xE657, 0xE256, 0xE236, 0xE236, 0xDE35, 0xDE15, 0xD9F4, 0xD9F4, 0xD9D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD192, 0xD191, 0xCD71, 0xCD70, 0xC950, 0xC94F, 0xC92F, 0xC52F, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB48B, 0xB48A, 0xB48A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB469, 0xB46A, 0xB48A, 0xB48A, 0xB48B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC10D, 0xC10E, 0xC50E, 0xC52F, 0xC92F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD192, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5F3, 0xD9F4, 0xDA14, 0xDE15, 0xDE15, 0xDE36, 0xE256, 0xE256, 0xE657, 0xE677, 0xE678, 0xEA98, 0xEA99, 0xEAB9, 0xEEB9, 0xEEB9, 0xEEDA, 0xF2DA, 0xF2FB, 0xF2FB, 0xF2FB, 0xF6FB, 0xF71C, 0xF71C, 0xF71C, 0xF71C, 0xF71C, 0xF71C, 0xF71C, 0xF6FB, 0xF2FB, 0xF2FB, 0xF2FA, 0xF2DA, 0xEEDA, 0xEEBA, 0xEEB9, 0xEAB9, 0xEA99, 0xEA98, 0xE678, 0xE677, 0xE657, 0xE257, 0xE236, 0xDE36, 0xDE15, 0xDE15, 0xDA14, 0xD9F4, 0xD9D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD192, 0xD191, 0xCD71, 0xCD70, 0xC950, 0xC950, 0xC92F, 0xC52F, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB48B, 0xB48A, 0xB48A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC10D, 0xC10E, 0xC52E, 0xC52F, 0xC92F, 0xC950, 0xC950, 0xCD70, 0xCD71, 0xD191, 0xD192, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDE15, 0xDE15, 0xDE36, 0xE236, 0xE257, 0xE657, 0xE677, 0xE678, 0xEA98, 0xEA98, 0xEAB9, 0xEEB9, 0xEEBA, 0xEEDA, 0xEEDA, 0xF2DA, 0xF2FB, 0xF2FB, 0xF6FB, 0xF71C, 0xF71C, 0xF71C, 0xF71C, 0xF71C, 0xF71C, 0xF71C, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2DB, 0xEEDA, 0xEEDA, 0xEEBA, 0xEEB9, 0xEAB9, 0xEA98, 0xEA98, 0xE678, 0xE677, 0xE657, 0xE256, 0xE236, 0xDE36, 0xDE35, 0xDE15, 0xD9F4, 0xD9F4, 0xD5D4, 0xD5D3, 0xD5B3, 0xD1B2, 0xD192, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC950, 0xC92F, 0xC52F, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB48B, 0xB48A, 0xB48A, 0xB46A, 0xB469, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB469, 0xB46A, 0xB48A, 0xB48A, 0xB48B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xD191, 0xD192, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDE15, 0xDE15, 0xDE36, 0xE236, 0xE256, 0xE657, 0xE677, 0xE678, 0xEA98, 0xEA98, 0xEAB9, 0xEEB9, 0xEEB9, 0xEEDA, 0xEEDA, 0xF2DA, 0xF2FB, 0xF2FB, 0xF2FB, 0xF71B, 0xF71C, 0xF71C, 0xF71C, 0xF71C, 0xF71C, 0xF71B, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2DA, 0xEEDA, 0xEEDA, 0xEEB9, 0xEEB9, 0xEAB9, 0xEA98, 0xEA98, 0xE678, 0xE677, 0xE657, 0xE256, 0xE236, 0xDE36, 0xDE15, 0xDE15, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD192, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB48B, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52F, 0xC92F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD192, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDE15, 0xDE15, 0xDE36, 0xE236, 0xE256, 0xE257, 0xE677, 0xE678, 0xEA98, 0xEA98, 0xEA99, 0xEEB9, 0xEEB9, 0xEEDA, 0xEEDA, 0xF2DA, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF71B, 0xF71C, 0xF71C, 0xF71B, 0xF71B, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2DA, 0xEEDA, 0xEEDA, 0xEEB9, 0xEEB9, 0xEA99, 0xEA98, 0xEA98, 0xE678, 0xE677, 0xE657, 0xE256, 0xE236, 0xDE36, 0xDE15, 0xDE15, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD192, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC950, 0xC52F, 0xC52F, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB8AB, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCD, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD192, 0xD1B2, 0xD5B2, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDE15, 0xDE15, 0xDE36, 0xE236, 0xE256, 0xE257, 0xE677, 0xE678, 0xE698, 0xEA98, 0xEA99, 0xEAB9, 0xEEB9, 0xEEBA, 0xEEDA, 0xF2DA, 0xF2DA, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF6FB, 0xF6FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2DA, 0xEEDA, 0xEEDA, 0xEEBA, 0xEEB9, 0xEAB9, 0xEA99, 0xEA98, 0xEA98, 0xE678, 0xE677, 0xE257, 0xE256, 0xE236, 0xDE35, 0xDE15, 0xDE15, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B2, 0xD1B2, 0xD192, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCCD, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB48B, 0xB48A, 0xB48A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD192, 0xD1B2, 0xD5B2, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDA15, 0xDE15, 0xDE35, 0xE236, 0xE256, 0xE257, 0xE677, 0xE677, 0xE678, 0xEA98, 0xEA98, 0xEAB9, 0xEEB9, 0xEEB9, 0xEEDA, 0xEEDA, 0xF2DA, 0xF2DA, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2DA, 0xEEDA, 0xEEDA, 0xEEBA, 0xEEB9, 0xEAB9, 0xEA98, 0xEA98, 0xE678, 0xE677, 0xE657, 0xE257, 0xE256, 0xE236, 0xDE35, 0xDE15, 0xDA15, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B2, 0xD1B2, 0xD191, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC94F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB48B, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCD, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xC970, 0xCD71, 0xCD91, 0xD191, 0xD1B2, 0xD1B2, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDA14, 0xDE15, 0xDE15, 0xDE36, 0xE236, 0xE257, 0xE657, 0xE677, 0xE678, 0xEA98, 0xEA98, 0xEA99, 0xEAB9, 0xEEB9, 0xEEB9, 0xEEDA, 0xEEDA, 0xF2DA, 0xF2DA, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2FB, 0xF2DA, 0xF2DA, 0xEEDA, 0xEEDA, 0xEEBA, 0xEEB9, 0xEAB9, 0xEA99, 0xEA98, 0xEA98, 0xE678, 0xE677, 0xE657, 0xE256, 0xE256, 0xDE36, 0xDE35, 0xDE15, 0xDA14, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD1B2, 0xD1B2, 0xD191, 0xCD91, 0xCD71, 0xC970, 0xC950, 0xC94F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCCD, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8CC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC94F, 0xC950, 0xC950, 0xCD70, 0xCD71, 0xD191, 0xD192, 0xD1B2, 0xD5B3, 0xD5D3, 0xD9F3, 0xD9F4, 0xD9F4, 0xDE15, 0xDE15, 0xDE36, 0xE236, 0xE256, 0xE257, 0xE677, 0xE677, 0xE678, 0xEA98, 0xEA98, 0xEA99, 0xEAB9, 0xEEB9, 0xEEBA, 0xEEDA, 0xEEDA, 0xF2DA, 0xF2DA, 0xF2DA, 0xF2DA, 0xF2DB, 0xF2FB, 0xF2DA, 0xF2DA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEBA, 0xEEB9, 0xEEB9, 0xEAB9, 0xEA98, 0xEA98, 0xE678, 0xE677, 0xE677, 0xE257, 0xE256, 0xE236, 0xDE36, 0xDE15, 0xDE15, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5D3, 0xD1B2, 0xD192, 0xD191, 0xCD71, 0xCD71, 0xC970, 0xC950, 0xC92F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8CC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC10D, 0xC10E, 0xC52E, 0xC52F, 0xC92F, 0xC950, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD192, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDE15, 0xDE15, 0xDE35, 0xE236, 0xE256, 0xE257, 0xE657, 0xE677, 0xE678, 0xEA98, 0xEA98, 0xEA99, 0xEAB9, 0xEEB9, 0xEEB9, 0xEEBA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEDA, 0xF2DA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEB9, 0xEEB9, 0xEEB9, 0xEAB9, 0xEA99, 0xEA98, 0xE698, 0xE678, 0xE677, 0xE657, 0xE257, 0xE256, 0xE236, 0xDE35, 0xDE15, 0xDA15, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B2, 0xD1B2, 0xD192, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC950, 0xC92F, 0xC52F, 0xC52E, 0xC10E, 0xC10D, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB06A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD192, 0xD1B2, 0xD1B2, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDA14, 0xDE15, 0xDE35, 0xDE36, 0xE236, 0xE256, 0xE257, 0xE677, 0xE677, 0xE678, 0xEA98, 0xEA98, 0xEA99, 0xEAB9, 0xEAB9, 0xEEB9, 0xEEB9, 0xEEBA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEDA, 0xEEBA, 0xEEB9, 0xEEB9, 0xEEB9, 0xEAB9, 0xEA99, 0xEA98, 0xEA98, 0xE678, 0xE677, 0xE677, 0xE257, 0xE256, 0xE236, 0xDE36, 0xDE15, 0xDE15, 0xDA14, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD1B2, 0xD1B2, 0xD192, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB469, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB8AB, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCD, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD191, 0xD1B2, 0xD1B2, 0xD5B3, 0xD5D3, 0xD9D3, 0xD9F4, 0xD9F4, 0xDE15, 0xDE15, 0xDE35, 0xE236, 0xE236, 0xE257, 0xE257, 0xE677, 0xE678, 0xE678, 0xEA98, 0xEA98, 0xEA99, 0xEA99, 0xEAB9, 0xEEB9, 0xEEB9, 0xEEB9, 0xEEB9, 0xEEBA, 0xEEBA, 0xEEBA, 0xEEB9, 0xEEB9, 0xEEB9, 0xEEB9, 0xEAB9, 0xEAB9, 0xEA98, 0xEA98, 0xEA98, 0xE678, 0xE678, 0xE677, 0xE657, 0xE257, 0xE236, 0xE236, 0xDE35, 0xDE15, 0xDE15, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5D3, 0xD1B2, 0xD1B2, 0xD191, 0xCD91, 0xCD71, 0xC970, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48B, 0xB88B, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCC, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC94F, 0xC950, 0xC950, 0xCD70, 0xCD71, 0xD191, 0xD192, 0xD1B2, 0xD5B2, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDA14, 0xDE15, 0xDE15, 0xDE36, 0xE236, 0xE256, 0xE257, 0xE657, 0xE677, 0xE678, 0xE678, 0xEA98, 0xEA98, 0xEA99, 0xEA99, 0xEAB9, 0xEAB9, 0xEAB9, 0xEEB9, 0xEEB9, 0xEEB9, 0xEEB9, 0xEEB9, 0xEEB9, 0xEAB9, 0xEAB9, 0xEA99, 0xEA98, 0xEA98, 0xEA98, 0xE678, 0xE678, 0xE677, 0xE657, 0xE257, 0xE256, 0xE236, 0xDE36, 0xDE15, 0xDE15, 0xDA14, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B2, 0xD1B2, 0xD192, 0xCD91, 0xCD71, 0xCD70, 0xC970, 0xC950, 0xC94F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCCC, 0xBCCC, 0xB8CC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC10D, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD192, 0xD1B2, 0xD1B2, 0xD5D3, 0xD5D3, 0xD9D4, 0xD9F4, 0xD9F4, 0xDA15, 0xDE15, 0xDE35, 0xDE36, 0xE236, 0xE256, 0xE257, 0xE657, 0xE677, 0xE678, 0xE678, 0xE698, 0xEA98, 0xEA98, 0xEA98, 0xEA99, 0xEA99, 0xEAB9, 0xEAB9, 0xEAB9, 0xEAB9, 0xEAB9, 0xEAB9, 0xEA99, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xE678, 0xE677, 0xE677, 0xE657, 0xE257, 0xE256, 0xE236, 0xDE36, 0xDE35, 0xDE15, 0xDA15, 0xD9F4, 0xD9F4, 0xD9D3, 0xD5D3, 0xD5D3, 0xD1B2, 0xD1B2, 0xD192, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC94F, 0xC950, 0xC970, 0xCD70, 0xCD91, 0xCD91, 0xD192, 0xD1B2, 0xD5B2, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xD9F4, 0xDE15, 0xDE15, 0xDE35, 0xE236, 0xE236, 0xE256, 0xE257, 0xE657, 0xE677, 0xE677, 0xE678, 0xE678, 0xE698, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xEA99, 0xEA98, 0xEA99, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xE678, 0xE678, 0xE677, 0xE677, 0xE657, 0xE257, 0xE256, 0xE236, 0xE236, 0xDE35, 0xDE15, 0xDE15, 0xD9F4, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B2, 0xD1B2, 0xD192, 0xD191, 0xCD91, 0xCD71, 0xC970, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB48B, 0xB48A, 0xB48A, 0xB46A, 0xB469, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB8AB, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCC, 0xC0ED, 0xC0ED, 0xC10E, 0xC10E, 0xC52E, 0xC52F, 0xC92F, 0xC950, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD191, 0xD1B2, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xDA15, 0xDE15, 0xDE15, 0xDE35, 0xE236, 0xE236, 0xE256, 0xE257, 0xE657, 0xE677, 0xE677, 0xE678, 0xE678, 0xE678, 0xE698, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xEA98, 0xE678, 0xE678, 0xE678, 0xE677, 0xE677, 0xE677, 0xE657, 0xE257, 0xE256, 0xE236, 0xE236, 0xDE35, 0xDE15, 0xDE15, 0xDA14, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD1B2, 0xD191, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC950, 0xC92F, 0xC52F, 0xC52E, 0xC10E, 0xC10E, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB48B, 0xB48A, 0xB48A, 0xB46A, 0xB469, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xBCAC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD71, 0xCD91, 0xD192, 0xD1B2, 0xD5B2, 0xD5D3, 0xD5D3, 0xD9F3, 0xD9F4, 0xD9F4, 0xDA15, 0xDE15, 0xDE15, 0xDE35, 0xE236, 0xE236, 0xE256, 0xE256, 0xE257, 0xE657, 0xE677, 0xE677, 0xE677, 0xE678, 0xE678, 0xE678, 0xE678, 0xE678, 0xE678, 0xE678, 0xE678, 0xE678, 0xE677, 0xE677, 0xE677, 0xE657, 0xE257, 0xE256, 0xE256, 0xE236, 0xDE36, 0xDE35, 0xDE15, 0xDE15, 0xDA14, 0xD9F4, 0xD9F4, 0xD9D3, 0xD5D3, 0xD5D3, 0xD5B2, 0xD1B2, 0xD192, 0xCD91, 0xCD91, 0xCD70, 0xC970, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCAC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB469, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC94F, 0xC950, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD191, 0xD1B2, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xD9F4, 0xDA14, 0xDE15, 0xDE15, 0xDE35, 0xDE36, 0xE236, 0xE256, 0xE256, 0xE257, 0xE257, 0xE657, 0xE677, 0xE677, 0xE677, 0xE677, 0xE677, 0xE677, 0xE677, 0xE677, 0xE677, 0xE677, 0xE657, 0xE657, 0xE257, 0xE257, 0xE256, 0xE256, 0xE236, 0xDE36, 0xDE35, 0xDE15, 0xDE15, 0xDA15, 0xD9F4, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD1B2, 0xD191, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC950, 0xC92F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB469, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC10E, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xC970, 0xCD70, 0xCD71, 0xCD91, 0xD192, 0xD1B2, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xD9F4, 0xDA14, 0xDE15, 0xDE15, 0xDE35, 0xDE36, 0xE236, 0xE236, 0xE256, 0xE256, 0xE256, 0xE257, 0xE257, 0xE257, 0xE657, 0xE657, 0xE657, 0xE657, 0xE657, 0xE257, 0xE257, 0xE257, 0xE257, 0xE256, 0xE256, 0xE236, 0xE236, 0xDE36, 0xDE35, 0xDE15, 0xDE15, 0xDA15, 0xD9F4, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD1B2, 0xD192, 0xCD91, 0xCD71, 0xCD70, 0xC970, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48B, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC92F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD71, 0xCD91, 0xD192, 0xD1B2, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xD9F4, 0xDA14, 0xDE15, 0xDE15, 0xDE15, 0xDE35, 0xDE36, 0xE236, 0xE236, 0xE236, 0xE256, 0xE256, 0xE256, 0xE257, 0xE257, 0xE256, 0xE256, 0xE256, 0xE256, 0xE256, 0xE256, 0xE236, 0xE236, 0xE236, 0xDE36, 0xDE35, 0xDE15, 0xDE15, 0xDE15, 0xDA14, 0xD9F4, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD1B2, 0xD192, 0xD191, 0xCD71, 0xCD71, 0xCD70, 0xC950, 0xC94F, 0xC92F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC10D, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xC950, 0xCD70, 0xCD71, 0xCD91, 0xD191, 0xD192, 0xD1B2, 0xD1B2, 0xD5D3, 0xD5D3, 0xD5D3, 0xD9D4, 0xD9F4, 0xD9F4, 0xD9F4, 0xDA15, 0xDE15, 0xDE15, 0xDE35, 0xDE35, 0xDE36, 0xE236, 0xE236, 0xE236, 0xE236, 0xE236, 0xE236, 0xE256, 0xE236, 0xE236, 0xE236, 0xE236, 0xE236, 0xDE36, 0xDE36, 0xDE35, 0xDE15, 0xDE15, 0xDE15, 0xDA15, 0xDA14, 0xD9F4, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5D3, 0xD1B2, 0xD1B2, 0xD192, 0xD191, 0xCD91, 0xCD71, 0xCD70, 0xC950, 0xC950, 0xC94F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB48B, 0xB48A, 0xB48A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xC970, 0xCD70, 0xCD71, 0xCD91, 0xD191, 0xD192, 0xD1B2, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD5F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xDA14, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE35, 0xDE35, 0xDE36, 0xDE36, 0xDE36, 0xDE36, 0xDE36, 0xDE36, 0xDE36, 0xDE36, 0xDE35, 0xDE35, 0xDE35, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDA15, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5B2, 0xD1B2, 0xD192, 0xD191, 0xCD91, 0xCD71, 0xCD70, 0xC970, 0xC950, 0xC94F, 0xC92F, 0xC52F, 0xC52E, 0xC10E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC92F, 0xC94F, 0xC950, 0xC970, 0xCD70, 0xCD71, 0xCD91, 0xD191, 0xD192, 0xD1B2, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xDA15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE35, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDA15, 0xDA14, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD1B2, 0xD192, 0xD191, 0xCD91, 0xCD71, 0xCD70, 0xC970, 0xC950, 0xC94F, 0xC92F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB48B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB469, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCD, 0xC0ED, 0xC0ED, 0xC10D, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC92F, 0xC94F, 0xC950, 0xCD70, 0xCD71, 0xCD71, 0xCD91, 0xD191, 0xD192, 0xD1B2, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xDA15, 0xDA15, 0xDA15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDE15, 0xDA15, 0xDA14, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD5D4, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD1B2, 0xD192, 0xD191, 0xCD91, 0xCD71, 0xCD70, 0xCD70, 0xC950, 0xC950, 0xC92F, 0xC52F, 0xC52F, 0xC50E, 0xC10E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xBCAC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC10E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xC950, 0xCD70, 0xCD70, 0xCD71, 0xCD91, 0xD191, 0xD192, 0xD1B2, 0xD1B2, 0xD5B2, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xDA14, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5B3, 0xD1B2, 0xD1B2, 0xD1B2, 0xD192, 0xD191, 0xCD91, 0xCD71, 0xCD70, 0xC970, 0xC950, 0xC94F, 0xC94F, 0xC52F, 0xC52F, 0xC50E, 0xC10E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB48B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB469, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC50E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xC950, 0xCD70, 0xCD70, 0xCD71, 0xCD91, 0xCD91, 0xD192, 0xD192, 0xD1B2, 0xD1B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD9F4, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5B2, 0xD1B2, 0xD1B2, 0xD192, 0xD192, 0xD191, 0xCD91, 0xCD71, 0xCD70, 0xCD70, 0xC950, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB469, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCED, 0xBCED, 0xC0ED, 0xC10D, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC94F, 0xC950, 0xC950, 0xC970, 0xCD70, 0xCD71, 0xCD91, 0xCD91, 0xD191, 0xD192, 0xD1B2, 0xD1B2, 0xD1B2, 0xD5B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D4, 0xD5F3, 0xD9D4, 0xD9D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5B3, 0xD5B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD192, 0xD191, 0xCD91, 0xCD91, 0xCD71, 0xCD70, 0xC970, 0xC950, 0xC950, 0xC94F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xBCED, 0xBCCD, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB48B, 0xB48A, 0xB48A, 0xB46A, 0xB469, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48B, 0xB8AB, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10D, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC94F, 0xC94F, 0xC950, 0xC970, 0xCD70, 0xCD71, 0xCD71, 0xCD91, 0xD191, 0xD192, 0xD192, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD5B2, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5B3, 0xD5B3, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD192, 0xD191, 0xD191, 0xCD91, 0xCD71, 0xCD71, 0xCD70, 0xC970, 0xC950, 0xC94F, 0xC94F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB48B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10D, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC94F, 0xC94F, 0xC950, 0xC950, 0xCD70, 0xCD70, 0xCD71, 0xCD71, 0xCD91, 0xCD91, 0xD191, 0xD192, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD5B3, 0xD5B3, 0xD5B3, 0xD5B3, 0xD5B3, 0xD5B3, 0xD5B3, 0xD5B3, 0xD5B2, 0xD5B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD192, 0xD191, 0xD191, 0xCD91, 0xCD71, 0xCD71, 0xCD70, 0xCD70, 0xC950, 0xC950, 0xC94F, 0xC92F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB469, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10D, 0xC10E, 0xC50E, 0xC50E, 0xC52F, 0xC52F, 0xC92F, 0xC94F, 0xC950, 0xC950, 0xC970, 0xCD70, 0xCD71, 0xCD71, 0xCD71, 0xCD91, 0xCD91, 0xD191, 0xD192, 0xD192, 0xD192, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD1B2, 0xD192, 0xD192, 0xD191, 0xD191, 0xCD91, 0xCD91, 0xCD71, 0xCD71, 0xCD70, 0xCD70, 0xC970, 0xC950, 0xC950, 0xC94F, 0xC92F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10D, 0xC10E, 0xC50E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC94F, 0xC94F, 0xC950, 0xC950, 0xC970, 0xCD70, 0xCD71, 0xCD71, 0xCD71, 0xCD91, 0xCD91, 0xD191, 0xD191, 0xD191, 0xD192, 0xD192, 0xD192, 0xD192, 0xD192, 0xD192, 0xD192, 0xD192, 0xD192, 0xD192, 0xD192, 0xD191, 0xD191, 0xCD91, 0xCD91, 0xCD91, 0xCD71, 0xCD71, 0xCD70, 0xCD70, 0xC970, 0xC950, 0xC950, 0xC94F, 0xC94F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB469, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC10E, 0xC50E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC92F, 0xC94F, 0xC950, 0xC950, 0xC950, 0xC970, 0xCD70, 0xCD70, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD91, 0xCD91, 0xCD91, 0xCD91, 0xCD91, 0xD191, 0xCD91, 0xD191, 0xCD91, 0xCD91, 0xCD91, 0xCD91, 0xCD91, 0xCD91, 0xCD71, 0xCD71, 0xCD70, 0xCD70, 0xCD70, 0xC970, 0xC950, 0xC950, 0xC950, 0xC94F, 0xC92F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB469, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB06A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC10E, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC52F, 0xC92F, 0xC94F, 0xC94F, 0xC950, 0xC950, 0xC950, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD70, 0xCD70, 0xC970, 0xC950, 0xC950, 0xC950, 0xC94F, 0xC94F, 0xC94F, 0xC52F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC10E, 0xC10E, 0xC0ED, 0xC0ED, 0xBCED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB48B, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB06A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCD, 0xBCED, 0xC0ED, 0xC0ED, 0xC10E, 0xC10E, 0xC10E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC52F, 0xC92F, 0xC94F, 0xC94F, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xCD70, 0xC970, 0xC970, 0xC950, 0xC950, 0xC950, 0xC950, 0xC94F, 0xC94F, 0xC92F, 0xC52F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC50E, 0xC10E, 0xC10D, 0xC0ED, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC10D, 0xC10E, 0xC10E, 0xC50E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC92F, 0xC94F, 0xC94F, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC950, 0xC94F, 0xC94F, 0xC92F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52E, 0xC50E, 0xC50E, 0xC10E, 0xC10E, 0xC10D, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCD, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC10D, 0xC10E, 0xC10E, 0xC50E, 0xC50E, 0xC50E, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC92F, 0xC92F, 0xC94F, 0xC94F, 0xC94F, 0xC94F, 0xC94F, 0xC94F, 0xC950, 0xC950, 0xC94F, 0xC94F, 0xC94F, 0xC94F, 0xC94F, 0xC94F, 0xC92F, 0xC92F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC50E, 0xC50E, 0xC50E, 0xC10E, 0xC10E, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCEC, 0xBCED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC10D, 0xC10E, 0xC10E, 0xC50E, 0xC50E, 0xC50E, 0xC52E, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC92F, 0xC92F, 0xC92F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52E, 0xC52E, 0xC52E, 0xC50E, 0xC50E, 0xC10E, 0xC10E, 0xC10D, 0xC0ED, 0xC0ED, 0xC0ED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8CC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB48B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB469, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCD, 0xBCED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC10E, 0xC10E, 0xC10E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC52E, 0xC52E, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52F, 0xC52E, 0xC52E, 0xC52E, 0xC50E, 0xC50E, 0xC50E, 0xC10E, 0xC10E, 0xC10E, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xBCED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB469, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCED, 0xBCED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC10D, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC50E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xBCED, 0xBCED, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8CC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCD, 0xBCED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC10D, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC10E, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xBCED, 0xBCED, 0xBCCD, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCD, 0xBCED, 0xBCED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC10D, 0xC10D, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xBCED, 0xBCED, 0xBCCD, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB469, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48B, 0xB88B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCD, 0xBCED, 0xBCED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xC0ED, 0xBCED, 0xBCED, 0xBCED, 0xBCED, 0xBCCD, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8CC, 0xB8AC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48B, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB469, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCD, 0xBCED, 0xBCED, 0xBCED, 0xBCED, 0xBCED, 0xBCED, 0xBCED, 0xBCED, 0xBCCD, 0xBCEC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB469, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xB8AC, 0xB8CC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8CC, 0xB8AC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB48B, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xB8AC, 0xB8CC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xBCCC, 0xB8CC, 0xB8AC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB88B, 0xB48B, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB069, 0xB469, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48B, 0xB88B, 0xB88B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AC, 0xB8AC, 0xB8AB, 0xB8AC, 0xB8AC, 0xB8AC, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB88B, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB469, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB48B, 0xB88B, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB88B, 0xB48B, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB88B, 0xB48B, 0xB88B, 0xB88B, 0xB8AB, 0xB88B, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB8AB, 0xB88B, 0xB88B, 0xB88B, 0xB88B, 0xB88B, 0xB88B, 0xB48B, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB469, 0xB469, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB469, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48B, 0xB48B, 0xB48B, 0xB48B, 0xB48B, 0xB48B, 0xB88B, 0xB48B, 0xB48B, 0xB48B, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB48A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB469, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB469, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB46A, 0xB06A, 0xB469, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB469, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB069, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
	0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 0xB049, 
};

static const f32	CAM_OFFSET = 16.f * 512.f;

static s32			s_Yaw = 0;
static V3			s_Pos = { 0.f, 0.f, 0.f };

//**********************************************************************************
//   Class Definition
//**********************************************************************************

//*************************************************************************************
//	
//*************************************************************************************
void	FLOOR_Update()
{
	const u32	yaw_360 = ( ( 360 << 12 ) / 256 ) * s_Yaw;
	V3			direction = RotateY( &gAtVector, ( yaw_360 >> 12 ) );

	s_Yaw++;
	s_Yaw &= 0xff;

	s_Pos = V3_Mul( &direction, CAM_OFFSET );
}

//*************************************************************************************
//	
//*************************************************************************************
void	FLOOR_Render( u32 y_start )
{
	s32			x, y;
	const u32	bit_mask_w = ( ( ( g_floorWidth >> 1 ) - 1 ) << ( g_floorWidthBits + 1 ) );
	const u32	bit_mask_h = ( ( ( g_floorHeight >> 1 ) - 1 ) << ( g_floorHeightBits + 1 ) );
	const s32	map_x = ( s32 )s_Pos.x;
	const s32	map_z = ( s32 )s_Pos.z;
	u16 *		p_dest = pgGetFrame();

	const u16	blend_rgb = RGB( 8, 8, 32 );
	const u32	clear_rgb = blend_rgb + ( blend_rgb << 16 );

	for ( y = 0; y < y_start; y++ )
	{
		for ( x = 0; x < ( SCREEN_WIDTH >> 1 ); x++ )
		{
			*( ( ( u32 * )( p_dest ) ) + x + ( y * ( LINE_SIZE >> 1 ) ) ) = clear_rgb;
		}
	}

	p_dest = pgGetFrame() + ( y_start * LINE_SIZE );

	for ( y = 0; y < ( SCREEN_HEIGHT - y_start ) >> 1; y++ )
	{
		const s32	div = s_DivideTab[ y + 1 ];
		const s32	ad = ( s32 )( ( ( s64 )s_CosTab[ s_Yaw ] * div ) >> 32 );
		const s32	bc = ( s32 )( ( ( s64 )s_SinTab[ s_Yaw ] * div ) >> 32 );

		const s32	x2 = 0 - 256;
		const s32	y2 = y - 256;

		const s32	yc = y2 * bc;
		const s32	yd = y2 * ad;

		s32			xac = x2 * ad - yc + map_x;
		s32			xbd = x2 * bc + yd + map_z;

		for ( x = 0; x < SCREEN_WIDTH; x+=2 )
		{
			const s32	ry3 = ( xbd & bit_mask_h ) + ( ( xac & bit_mask_w ) >> g_floorWidthBits );
			const u16	rgb = *( u16 * )( g_floorData + ry3 );

			*( u32 * )( p_dest + x ) = rgb + ( rgb << 16 );
			*( u32 * )( p_dest + x + LINE_SIZE ) = rgb + ( rgb << 16 );

			xac += ( ad << 1 );
			xbd += ( bc << 1 );
		}

		p_dest += ( LINE_SIZE << 1 );
	}

	//
	//	Blend out to the horizon
	//
	s16	alpha = 0xff;

	p_dest = pgGetFrame() + ( y_start * LINE_SIZE );

	while ( alpha > 0 )
	{
		for ( x = 0; x < SCREEN_WIDTH; x++ )
		{
			*p_dest = BlendRGB( *p_dest, blend_rgb, alpha );
			p_dest++;
		}

		alpha -= 4;
	}
}

//*******************************  END OF FILE  ************************************
