/***********************************************************************************

  Module :	Maths.c

  Description :	

  Last Modified $Date: $

  $Revision: $

  Copyright (C) 24 May 2005 T Swann

***********************************************************************************/

//**********************************************************************************
//   Include Files
//**********************************************************************************
#include "Types.h"
#include "Maths.h"

//**********************************************************************************
//   Local Macros
//**********************************************************************************

//**********************************************************************************
//   Local Constants
//**********************************************************************************

//**********************************************************************************
//   Static Prototypes
//**********************************************************************************

//**********************************************************************************
//   Global Variables
//**********************************************************************************
u16	g_SinTableU16[ 360 ] =
{
	0x8000,	0x8327,	0x864E,	0x8974,	0x8C98,	0x8FBA,	0x92DA,	0x95F7,
	0x9911,	0x9C27,	0x9F38,	0xA245,	0xA54C,	0xA84D,	0xAB48,	0xAE3D,
	0xB12A,	0xB40F,	0xB6ED,	0xB9C2,	0xBC8E,	0xBF50,	0xC209,	0xC4B8,
	0xC75B,	0xC9F4,	0xCC81,	0xCF02,	0xD177,	0xD3E0,	0xD63B,	0xD889,
	0xDAC9,	0xDCFB,	0xDF1F,	0xE134,	0xE339,	0xE530,	0xE716,	0xE8ED,
	0xEAB3,	0xEC69,	0xEE0D,	0xEFA1,	0xF123,	0xF294,	0xF3F3,	0xF540,
	0xF67B,	0xF7A3,	0xF8B9,	0xF9BC,	0xFAAC,	0xFB89,	0xFC52,	0xFD09,
	0xFDAC,	0xFE3B,	0xFEB7,	0xFF1F,	0xFF74,	0xFFB4,	0xFFE1,	0xFFFA,
	0xFFFF,	0xFFF0,	0xFFCD,	0xFF96,	0xFF4C,	0xFEEE,	0xFE7C,	0xFDF6,
	0xFD5D,	0xFCB0,	0xFBF0,	0xFB1D,	0xFA36,	0xF93D,	0xF830,	0xF711,
	0xF5E0,	0xF49C,	0xF346,	0xF1DE,	0xF064,	0xEED9,	0xED3D,	0xEB90,
	0xE9D2,	0xE804,	0xE625,	0xE436,	0xE238,	0xE02B,	0xDE0F,	0xDBE4,
	0xD9AB,	0xD764,	0xD50F,	0xD2AD,	0xD03F,	0xCDC3,	0xCB3C,	0xC8A9,
	0xC60B,	0xC362,	0xC0AE,	0xBDF0,	0xBB29,	0xB858,	0xB57F,	0xB29E,
	0xAFB4,	0xACC3,	0xA9CC,	0xA6CD,	0xA3C9,	0xA0BF,	0x9DB0,	0x9A9C,
	0x9785,	0x9469,	0x914B,	0x8E29,	0x8B06,	0x87E1,	0x84BA,	0x8193,
	0x7E6C,	0x7B45,	0x781E,	0x74F9,	0x71D6,	0x6EB4,	0x6B96,	0x687A,
	0x6563,	0x624F,	0x5F40,	0x5C36,	0x5932,	0x5633,	0x533C,	0x504B,
	0x4D61,	0x4A80,	0x47A7,	0x44D6,	0x420F,	0x3F51,	0x3C9D,	0x39F4,
	0x3756,	0x34C3,	0x323C,	0x2FC0,	0x2D52,	0x2AF0,	0x289B,	0x2654,
	0x241B,	0x21F0,	0x1FD4,	0x1DC7,	0x1BC9,	0x19DA,	0x17FB,	0x162D,
	0x146F,	0x12C2,	0x1126,	0xF9B,	0xE21,	0xCB9,	0xB63,	0xA1F,
	0x8EE,	0x7CF,	0x6C2,	0x5C9,	0x4E2,	0x40F,	0x34F,	0x2A2,
	0x209,	0x183,	0x111,	0xB3,	0x69,	0x32,	0xF,	0x0,
	0x5,	0x1E,	0x4B,	0x8B,	0xE0,	0x148,	0x1C4,	0x253,
	0x2F6,	0x3AD,	0x476,	0x553,	0x643,	0x746,	0x85C,	0x984,
	0xABF,	0xC0C,	0xD6B,	0xEDC,	0x105E,	0x11F2,	0x1396,	0x154C,
	0x1712,	0x18E9,	0x1ACF,	0x1CC6,	0x1ECB,	0x20E0,	0x2304,	0x2536,
	0x2776,	0x29C4,	0x2C1F,	0x2E88,	0x30FD,	0x337E,	0x360B,	0x38A4,
	0x3B47,	0x3DF6,	0x40AF,	0x4371,	0x463D,	0x4912,	0x4BF0,	0x4ED5,
	0x51C2,	0x54B7,	0x57B2,	0x5AB3,	0x5DBA,	0x60C7,	0x63D8,	0x66EE,
	0x6A08,	0x6D25,	0x7045,	0x7367,	0x768C,	0x79B1,	0x7CD8, 0x7e00,
};

f32	g_SinTableF32[ 360 ] =
{
	0.00f,	0.02f,	0.03f,	0.05f,	0.07f,	0.09f,	0.10f,	0.12f,
	0.14f,	0.16f,	0.17f,	0.19f,	0.21f,	0.22f,	0.24f,	0.26f,
	0.28f,	0.29f,	0.31f,	0.33f,	0.34f,	0.36f,	0.37f,	0.39f,
	0.41f,	0.42f,	0.44f,	0.45f,	0.47f,	0.48f,	0.50f,	0.52f,
	0.53f,	0.54f,	0.56f,	0.57f,	0.59f,	0.60f,	0.62f,	0.63f,
	0.64f,	0.66f,	0.67f,	0.68f,	0.69f,	0.71f,	0.72f,	0.73f,
	0.74f,	0.75f,	0.77f,	0.78f,	0.79f,	0.80f,	0.81f,	0.82f,
	0.83f,	0.84f,	0.85f,	0.86f,	0.87f,	0.87f,	0.88f,	0.89f,
	0.90f,	0.91f,	0.91f,	0.92f,	0.93f,	0.93f,	0.94f,	0.95f,
	0.95f,	0.96f,	0.96f,	0.97f,	0.97f,	0.97f,	0.98f,	0.98f,
	0.98f,	0.99f,	0.99f,	0.99f,	0.99f,	1.00f,	1.00f,	1.00f,
	1.00f,	1.00f,	1.00f,	1.00f,	1.00f,	1.00f,	1.00f,	1.00f,
	0.99f,	0.99f,	0.99f,	0.99f,	0.98f,	0.98f,	0.98f,	0.97f,
	0.97f,	0.97f,	0.96f,	0.96f,	0.95f,	0.95f,	0.94f,	0.93f,
	0.93f,	0.92f,	0.91f,	0.91f,	0.90f,	0.89f,	0.88f,	0.87f,
	0.87f,	0.86f,	0.85f,	0.84f,	0.83f,	0.82f,	0.81f,	0.80f,
	0.79f,	0.78f,	0.77f,	0.75f,	0.74f,	0.73f,	0.72f,	0.71f,
	0.69f,	0.68f,	0.67f,	0.66f,	0.64f,	0.63f,	0.62f,	0.60f,
	0.59f,	0.57f,	0.56f,	0.54f,	0.53f,	0.52f,	0.50f,	0.48f,
	0.47f,	0.45f,	0.44f,	0.42f,	0.41f,	0.39f,	0.37f,	0.36f,
	0.34f,	0.33f,	0.31f,	0.29f,	0.28f,	0.26f,	0.24f,	0.22f,
	0.21f,	0.19f,	0.17f,	0.16f,	0.14f,	0.12f,	0.10f,	0.09f,
	0.07f,	0.05f,	0.03f,	0.02f,	-0.00f,	-0.02f,	-0.03f,	-0.05f,
	-0.07f,	-0.09f,	-0.10f,	-0.12f,	-0.14f,	-0.16f,	-0.17f,	-0.19f,
	-0.21f,	-0.22f,	-0.24f,	-0.26f,	-0.28f,	-0.29f,	-0.31f,	-0.33f,
	-0.34f,	-0.36f,	-0.37f,	-0.39f,	-0.41f,	-0.42f,	-0.44f,	-0.45f,
	-0.47f,	-0.48f,	-0.50f,	-0.52f,	-0.53f,	-0.54f,	-0.56f,	-0.57f,
	-0.59f,	-0.60f,	-0.62f,	-0.63f,	-0.64f,	-0.66f,	-0.67f,	-0.68f,
	-0.69f,	-0.71f,	-0.72f,	-0.73f,	-0.74f,	-0.75f,	-0.77f,	-0.78f,
	-0.79f,	-0.80f,	-0.81f,	-0.82f,	-0.83f,	-0.84f,	-0.85f,	-0.86f,
	-0.87f,	-0.87f,	-0.88f,	-0.89f,	-0.90f,	-0.91f,	-0.91f,	-0.92f,
	-0.93f,	-0.93f,	-0.94f,	-0.95f,	-0.95f,	-0.96f,	-0.96f,	-0.97f,
	-0.97f,	-0.97f,	-0.98f,	-0.98f,	-0.98f,	-0.99f,	-0.99f,	-0.99f,
	-0.99f,	-1.00f,	-1.00f,	-1.00f,	-1.00f,	-1.00f,	-1.00f,	-1.00f,
	-1.00f,	-1.00f,	-1.00f,	-1.00f,	-0.99f,	-0.99f,	-0.99f,	-0.99f,
	-0.98f,	-0.98f,	-0.98f,	-0.97f,	-0.97f,	-0.97f,	-0.96f,	-0.96f,
	-0.95f,	-0.95f,	-0.94f,	-0.93f,	-0.93f,	-0.92f,	-0.91f,	-0.91f,
	-0.90f,	-0.89f,	-0.88f,	-0.87f,	-0.87f,	-0.86f,	-0.85f,	-0.84f,
	-0.83f,	-0.82f,	-0.81f,	-0.80f,	-0.79f,	-0.78f,	-0.77f,	-0.75f,
	-0.74f,	-0.73f,	-0.72f,	-0.71f,	-0.69f,	-0.68f,	-0.67f,	-0.66f,
	-0.64f,	-0.63f,	-0.62f,	-0.60f,	-0.59f,	-0.57f,	-0.56f,	-0.54f,
	-0.53f,	-0.52f,	-0.50f,	-0.48f,	-0.47f,	-0.45f,	-0.44f,	-0.42f,
	-0.41f,	-0.39f,	-0.37f,	-0.36f,	-0.34f,	-0.33f,	-0.31f,	-0.29f,
	-0.28f,	-0.26f,	-0.24f,	-0.22f,	-0.21f,	-0.19f,	-0.17f,	-0.16f,
	-0.14f,	-0.12f,	-0.10f,	-0.09f,	-0.07f,	-0.05f,	-0.03f,	-0.02f,
};

f32	g_CosTableF32[ 360 ] =
{
	1.00f,	1.00f,	1.00f,	1.00f,	1.00f,	1.00f,	0.99f,	0.99f,
	0.99f,	0.99f,	0.98f,	0.98f,	0.98f,	0.97f,	0.97f,	0.97f,
	0.96f,	0.96f,	0.95f,	0.95f,	0.94f,	0.93f,	0.93f,	0.92f,
	0.91f,	0.91f,	0.90f,	0.89f,	0.88f,	0.87f,	0.87f,	0.86f,
	0.85f,	0.84f,	0.83f,	0.82f,	0.81f,	0.80f,	0.79f,	0.78f,
	0.77f,	0.75f,	0.74f,	0.73f,	0.72f,	0.71f,	0.69f,	0.68f,
	0.67f,	0.66f,	0.64f,	0.63f,	0.62f,	0.60f,	0.59f,	0.57f,
	0.56f,	0.54f,	0.53f,	0.52f,	0.50f,	0.48f,	0.47f,	0.45f,
	0.44f,	0.42f,	0.41f,	0.39f,	0.37f,	0.36f,	0.34f,	0.33f,
	0.31f,	0.29f,	0.28f,	0.26f,	0.24f,	0.22f,	0.21f,	0.19f,
	0.17f,	0.16f,	0.14f,	0.12f,	0.10f,	0.09f,	0.07f,	0.05f,
	0.03f,	0.02f,	-0.00f,	-0.02f,	-0.03f,	-0.05f,	-0.07f,	-0.09f,
	-0.10f,	-0.12f,	-0.14f,	-0.16f,	-0.17f,	-0.19f,	-0.21f,	-0.22f,
	-0.24f,	-0.26f,	-0.28f,	-0.29f,	-0.31f,	-0.33f,	-0.34f,	-0.36f,
	-0.37f,	-0.39f,	-0.41f,	-0.42f,	-0.44f,	-0.45f,	-0.47f,	-0.48f,
	-0.50f,	-0.52f,	-0.53f,	-0.54f,	-0.56f,	-0.57f,	-0.59f,	-0.60f,
	-0.62f,	-0.63f,	-0.64f,	-0.66f,	-0.67f,	-0.68f,	-0.69f,	-0.71f,
	-0.72f,	-0.73f,	-0.74f,	-0.75f,	-0.77f,	-0.78f,	-0.79f,	-0.80f,
	-0.81f,	-0.82f,	-0.83f,	-0.84f,	-0.85f,	-0.86f,	-0.87f,	-0.87f,
	-0.88f,	-0.89f,	-0.90f,	-0.91f,	-0.91f,	-0.92f,	-0.93f,	-0.93f,
	-0.94f,	-0.95f,	-0.95f,	-0.96f,	-0.96f,	-0.97f,	-0.97f,	-0.97f,
	-0.98f,	-0.98f,	-0.98f,	-0.99f,	-0.99f,	-0.99f,	-0.99f,	-1.00f,
	-1.00f,	-1.00f,	-1.00f,	-1.00f,	-1.00f,	-1.00f,	-1.00f,	-1.00f,
	-1.00f,	-1.00f,	-0.99f,	-0.99f,	-0.99f,	-0.99f,	-0.98f,	-0.98f,
	-0.98f,	-0.97f,	-0.97f,	-0.97f,	-0.96f,	-0.96f,	-0.95f,	-0.95f,
	-0.94f,	-0.93f,	-0.93f,	-0.92f,	-0.91f,	-0.91f,	-0.90f,	-0.89f,
	-0.88f,	-0.87f,	-0.87f,	-0.86f,	-0.85f,	-0.84f,	-0.83f,	-0.82f,
	-0.81f,	-0.80f,	-0.79f,	-0.78f,	-0.77f,	-0.75f,	-0.74f,	-0.73f,
	-0.72f,	-0.71f,	-0.69f,	-0.68f,	-0.67f,	-0.66f,	-0.64f,	-0.63f,
	-0.62f,	-0.60f,	-0.59f,	-0.57f,	-0.56f,	-0.54f,	-0.53f,	-0.52f,
	-0.50f,	-0.48f,	-0.47f,	-0.45f,	-0.44f,	-0.42f,	-0.41f,	-0.39f,
	-0.37f,	-0.36f,	-0.34f,	-0.33f,	-0.31f,	-0.29f,	-0.28f,	-0.26f,
	-0.24f,	-0.22f,	-0.21f,	-0.19f,	-0.17f,	-0.16f,	-0.14f,	-0.12f,
	-0.10f,	-0.09f,	-0.07f,	-0.05f,	-0.03f,	-0.02f,	0.00f,	0.02f,
	0.03f,	0.05f,	0.07f,	0.09f,	0.10f,	0.12f,	0.14f,	0.16f,
	0.17f,	0.19f,	0.21f,	0.22f,	0.24f,	0.26f,	0.28f,	0.29f,
	0.31f,	0.33f,	0.34f,	0.36f,	0.37f,	0.39f,	0.41f,	0.42f,
	0.44f,	0.45f,	0.47f,	0.48f,	0.50f,	0.52f,	0.53f,	0.54f,
	0.56f,	0.57f,	0.59f,	0.60f,	0.62f,	0.63f,	0.64f,	0.66f,
	0.67f,	0.68f,	0.69f,	0.71f,	0.72f,	0.73f,	0.74f,	0.75f,
	0.77f,	0.78f,	0.79f,	0.80f,	0.81f,	0.82f,	0.83f,	0.84f,
	0.85f,	0.86f,	0.87f,	0.87f,	0.88f,	0.89f,	0.90f,	0.91f,
	0.91f,	0.92f,	0.93f,	0.93f,	0.94f,	0.95f,	0.95f,	0.96f,
	0.96f,	0.97f,	0.97f,	0.97f,	0.98f,	0.98f,	0.98f,	0.99f,
	0.99f,	0.99f,	0.99f,	1.00f,	1.00f,	1.00f,	1.00f,	1.00f,
};

//**********************************************************************************
//   Static Variables
//**********************************************************************************

//**********************************************************************************
//   Class Definition
//**********************************************************************************

//*************************************************************************************
//	
//*************************************************************************************
f32	RSqrt( f32 number )
{
	f32	x2 = number * 0.5f;
	f32	y  = number;
	s32	i  = * (s32 *) &y;

	i  = 0x5f3759df - (i >> 1);
	y  = * (f32 *) &i;
	y  = y * (1.5f - (x2 * y * y));

	return y;
}

//*************************************************************************************
//	
//*************************************************************************************
f32	Absf( f32 x )
{
	long *	t = ( s32 * )&x;
	*t &= 0x7fffffff;
	return x;
}

//*************************************************************************************
//	
//*************************************************************************************
u16	sin_u16( u8 degs )
{
	return g_SinTableU16[ degs ];
}

//*************************************************************************************
//	
//*************************************************************************************
f32	sin_f32( u16 degs )
{
	return g_SinTableF32[ degs ];
}

//*************************************************************************************
//	
//*************************************************************************************
f32	cos_f32( u16 degs )
{
	return g_CosTableF32[ degs ];
}

//*************************************************************************************
//	
//*************************************************************************************
bool	IsLessThan( f32 v0, f32 v1 )
{
	f32	diff = v1 - v0;

	return ( FP_SIGN_BIT( diff ) == 0 );
}

//*************************************************************************************
//	
//*************************************************************************************
bool	IsGreaterThan( f32 v0, f32 v1 )
{
	f32	diff = v1 - v0;

	return ( FP_SIGN_BIT( diff ) != 0 );
}

//*******************************  END OF FILE  ************************************
