/***********************************************************************************

  Module :	Maths.h

  Description :	

  Last Modified $Date: $

  $Revision: $

  Copyright (C) 24 May 2005 T Swann

***********************************************************************************/

#ifndef _MATHS_H_
#define _MATHS_H_

//**********************************************************************************
//   Include Files
//**********************************************************************************
//#include "Types.h"

//**********************************************************************************
//   Macros
//**********************************************************************************
#define FP_BITS( fp )		( *( u32 * )&( fp ) )
#define FP_ABS_BITS( fp )	( FP_BITS( fp ) & 0x7FFFFFFF )
#define FP_SIGN_BIT( fp )	( FP_BITS( fp ) & 0x80000000 )
#define FP_ONE_BITS			0x3F800000

#define SQRTF( x )			( 1.f / RSqrt( x ) )
#define ABSF( x )			Absf( x )

#define SINU( x )			sin_u16( x )

#define SINF( x )			sin_f32( x )
#define COSF( x )			cos_f32( x )

#define DEGS_TO_RADS( val )	( val * ONE_DEGREE )
#define RADS_TO_DEGS( val )	( val * INV_ONE_DEGREE )

//**********************************************************************************
//   Types
//**********************************************************************************

//**********************************************************************************
//   Constants
//**********************************************************************************
#define	ONE_BITS			12
#define	ONE					( 1 << ONE_BITS )

#define ONE_DEGREE			0.0174532925199432957692369076848861271344f
#define INV_ONE_DEGREE		( 1.f / ONE_DEGREE )

//**********************************************************************************
//   Class definitions
//**********************************************************************************

//**********************************************************************************
//   Externs
//**********************************************************************************
extern u16	g_SinTable[ 360 ];
extern f32	g_SinTableF32[ 360 ];

//**********************************************************************************
//   Prototypes
//**********************************************************************************
u16		sin_u16( u8 degs );

f32		sin_f32( u16 degs );
f32		cos_f32( u16 degs );

f32		Absf( f32 number );
f32		RSqrt( f32 number );

bool	IsLessThan( f32 v0, f32 v1 );
bool	IsGreaterThan( f32 v0, f32 v1 );

#endif /* _MATHS_H_ */
