/***********************************************************************************

  Module :	Object.c

  Description :	

  Last Modified $Date: $

  $Revision: $

  Copyright (C) 28 May 2005 T Swann

***********************************************************************************/

//**********************************************************************************
//   Include Files
//**********************************************************************************
#include "Types.h"
#include "Maths.h"
#include "Vector.h"
#include "Object.h"
#include "Matrix.h"
#include "Rasteriser.h"

//**********************************************************************************
//   Local Macros
//**********************************************************************************

//**********************************************************************************
//   Local Constants
//**********************************************************************************

//**********************************************************************************
//   Static Prototypes
//**********************************************************************************

//**********************************************************************************
//   Global Variables
//**********************************************************************************
SObject	g_CubeObject =
{
	{	255,	255,	255 },
	8,
	{
		{	{	-25.0000f,	+25.0000f,	-25.0000f	},	},
		{	{	25.0000f,	+25.0000f,	-25.0000f	},	},
		{	{	-25.0000f,	+25.0000f,	25.0000f	},	},
		{	{	25.0000f,	+25.0000f,	25.0000f	},	},
		{	{	-25.0000f,	-25.0000f,	-25.0000f	},	},
		{	{	25.0000f,	-25.0000f,	-25.0000f	},	},
		{	{	-25.0000f,	-25.0000f,	25.0000f	},	},
		{	{	25.0000f,	-25.0000f,	25.0000f	},	},
	},

	12,
	{
		{	{	0,	2,	3	},	},
		{	{	3,	1,	0	},	},
		{	{	4,	5,	7	},	},
		{	{	7,	6,	4	},	},
		{	{	0,	1,	5	},	},
		{	{	5,	4,	0	},	},
		{	{	1,	3,	7	},	},
		{	{	7,	5,	1	},	},
		{	{	3,	2,	6	},	},
		{	{	6,	7,	3	},	},
		{	{	2,	0,	4	},	},
		{	{	4,	6,	2	},	},
	},
};

//*************************************************************************************
//	
//*************************************************************************************
SObject	g_DuckObject =
{
	{	(u8)( 255 * 0.8784f ),	(u8)( 255 * 0.7765f ),	(u8)( 255 * 0.3412f )	},

	179,
	{
		{	{	-19.0539f,	-33.7689f,	108.3799f,	},	},
		{	{	-19.0539f,	-29.2447f,	125.2643f	},	},
		{	{	-27.4961f,	-29.2447f,	123.0023f	},	},
		{	{	-33.6763f,	-29.2447f,	116.8221f	},	},
		{	{	-35.9384f,	-29.2447f,	108.3799f	},	},
		{	{	-33.6763f,	-29.2447f,	99.9377f	},	},
		{	{	-27.4961f,	-29.2447f,	93.7575f	},	},
		{	{	-19.0539f,	-29.2447f,	91.4954f	},	},
		{	{	-10.6117f,	-29.2447f,	93.7575f	},	},
		{	{	-4.4315f,	-29.2447f,	99.9377f	},	},
		{	{	-2.1694f,	-29.2447f,	108.3799f	},	},
		{	{	-4.4315f,	-29.2447f,	116.8221f	},	},
		{	{	-10.6117f,	-29.2447f,	123.0023f	},	},
		{	{	-19.0539f,	-16.8845f,	137.6246f	},	},
		{	{	-33.6763f,	-16.8845f,	133.7066f	},	},
		{	{	-44.3806f,	-16.8845f,	123.0023f	},	},
		{	{	-48.2987f,	-16.8845f,	103.9018f	},	},
		{	{	-44.3806f,	-16.8845f,	93.7575f	},	},
		{	{	-33.6763f,	-16.8845f,	83.0532f	},	},
		{	{	-19.0539f,	-16.8845f,	79.1351f	},	},
		{	{	-4.4315f,	-16.8845f,	83.0532f	},	},
		{	{	6.2728f,	-16.8845f,	93.7575f	},	},
		{	{	10.1908f,	-16.8845f,	108.3799f	},	},
		{	{	6.2728f,	-16.8845f,	123.0023f	},	},
		{	{	-4.4315f,	-16.8845f,	133.7066f	},	},
		{	{	-19.0539f,	-0.0000f,	142.1488f	},	},
		{	{	-35.9384f,	-0.0000f,	137.6246f	},	},
		{	{	-48.2987f,	-0.0000f,	125.2643f	},	},
		{	{	-52.8228f,	-0.0000f,	108.3799f	},	},
		{	{	-48.2986f,	-0.0000f,	91.4954f	},	},
		{	{	-35.9384f,	-0.0000f,	79.1351f	},	},
		{	{	-26.2756f,	1.0841f,	76.1616f	},	},
		{	{	-2.1694f,	-0.0000f,	79.1844f	},	},
		{	{	10.1908f,	-0.0000f,	91.4954f	},	},
		{	{	14.7150f,	-0.0000f,	108.3799f	},	},
		{	{	10.1908f,	-0.0000f,	125.2644f	},	},
		{	{	-2.1695f,	-0.0000f,	137.6246f	},	},
		{	{	-19.0539f,	16.8845f,	137.6246f	},	},
		{	{	-33.6763f,	16.8845f,	133.7066f	},	},
		{	{	-44.3806f,	16.8845f,	123.0023f	},	},
		{	{	-48.2986f,	16.8845f,	103.9018f	},	},
		{	{	-44.3806f,	16.8845f,	93.7575f	},	},
		{	{	-33.6763f,	16.8845f,	83.0532f	},	},
		{	{	-19.0539f,	16.8845f,	79.1351f	},	},
		{	{	-4.4315f,	16.8845f,	83.0532f	},	},
		{	{	6.2728f,	16.8845f,	93.7575f	},	},
		{	{	10.1908f,	16.8845f,	108.3799f	},	},
		{	{	6.2728f,	16.8845f,	123.0023f	},	},
		{	{	-4.4315f,	16.8845f,	133.7066f	},	},
		{	{	-19.0539f,	29.2447f,	125.2643f	},	},
		{	{	-27.4961f,	29.2447f,	123.0023f	},	},
		{	{	-33.6763f,	29.2447f,	116.8221f	},	},
		{	{	-35.9384f,	29.2447f,	108.3799f	},	},
		{	{	-33.6763f,	29.2447f,	99.9377f	},	},
		{	{	-27.4961f,	29.2447f,	93.7575f	},	},
		{	{	-19.0539f,	29.2447f,	91.4954f	},	},
		{	{	-10.6117f,	29.2447f,	93.7575f	},	},
		{	{	-4.4315f,	29.2447f,	99.9377f	},	},
		{	{	-2.1694f,	29.2447f,	108.3799f	},	},
		{	{	-4.4315f,	29.2447f,	116.8221f	},	},
		{	{	-10.6117f,	29.2447f,	123.0023f	},	},
		{	{	-19.0539f,	33.7689f,	108.3799f	},	},
		{	{	-54.9842f,	-15.8261f,	92.1594f	},	},
		{	{	-58.9023f,	-15.8261f,	99.4933f	},	},
		{	{	-62.1057f,	-0.0000f,	101.8996f	},	},
		{	{	-58.9023f,	15.8261f,	99.4933f	},	},
		{	{	-54.9842f,	15.8261f,	92.1594f	},	},
		{	{	-58.9023f,	-0.0000f,	89.8973f	},	},
		{	{	-64.7330f,	-12.9900f,	92.8673f	},	},
		{	{	-68.4499f,	-12.9900f,	96.9350f	},	},
		{	{	-72.4013f,	-0.0000f,	99.3413f	},	},
		{	{	-68.4499f,	12.9900f,	96.9350f	},	},
		{	{	-66.9877f,	12.9900f,	93.0518f	},	},
		{	{	-68.6510f,	-0.0000f,	91.1549f	},	},
		{	{	-67.1475f,	13.6151f,	93.8820f	},	},
		{	{	-73.0056f,	-0.0000f,	94.2040f	},	},
		{	{	-67.5744f,	-13.6151f,	93.9454f	},	},
		{	{	-45.4973f,	-18.8956f,	99.7172f	},	},
		{	{	-57.8508f,	-17.7111f,	96.4473f	},	},
		{	{	-44.6153f,	18.8956f,	97.6765f	},	},
		{	{	-57.1050f,	17.7111f,	95.0737f	},	},
		{	{	6.0829f,	-49.0742f,	42.9888f	},	},
		{	{	6.5954f,	-42.2236f,	58.3466f	},	},
		{	{	-9.8987f,	-42.2236f,	55.0804f	},	},
		{	{	-21.9733f,	-42.2236f,	46.1569f	},	},
		{	{	-25.9160f,	-42.2236f,	33.9672f	},	},
		{	{	-21.4964f,	-42.2263f,	29.8677f	},	},
		{	{	-9.8987f,	-42.2263f,	20.9442f	},	},
		{	{	6.5954f,	-42.2263f,	17.6780f	},	},
		{	{	23.0895f,	-42.2263f,	20.9442f	},	},
		{	{	35.1641f,	-42.2263f,	29.8677f	},	},
		{	{	41.4176f,	-42.2236f,	38.6249f	},	},
		{	{	42.8650f,	-42.2236f,	59.5536f	},	},
		{	{	23.1102f,	-42.2236f,	59.5173f	},	},
		{	{	6.5954f,	-24.3794f,	76.1935f	},	},
		{	{	-21.9733f,	-24.3899f,	70.5363f	},	},
		{	{	-42.6345f,	-24.3899f,	61.6378f	},	},
		{	{	-50.2895f,	-24.3899f,	40.5246f	},	},
		{	{	-38.6303f,	-24.3794f,	20.9442f	},	},
		{	{	-17.7166f,	-24.3794f,	5.4883f	},	},
		{	{	6.5954f,	-24.3794f,	-0.1690f	},	},
		{	{	35.1641f,	-24.3794f,	5.4883f		},	},
		{	{	56.0778f,	-24.3794f,	20.9442f	},	},
		{	{	63.7327f,	-24.3899f,	33.9672f	},	},
		{	{	60.4624f,	-24.3899f,	54.0731f	},	},
		{	{	43.7377f,	-24.3899f,	64.2629f	},	},
		{	{	-2.1627f,	-0.1554f,	79.1827f	},	},
		{	{	-26.3929f,	-0.0000f,	76.2225f	},	},
		{	{	-50.2895f,	-0.0286f,	64.9040f	},	},
		{	{	-59.1287f,	-0.0286f,	40.5246f	},	},
		{	{	-46.2852f,	0.0000f,	17.6780f	},	},
		{	{	-22.1361f,	0.0000f,	-0.1690f	},	},
		{	{	6.5954f,	0.0000f,	-6.7014f	},	},
		{	{	39.5837f,	0.0000f,	-0.1690f	},	},
		{	{	63.7327f,	0.0000f,	17.6780f	},	},
		{	{	72.5719f,	-0.0286f,	33.9672f	},	},
		{	{	68.1174f,	-0.0286f,	50.2712f	},	},
		{	{	39.5757f,	-0.0000f,	69.9202f	},	},
		{	{	6.5954f,	24.3794f,	76.1935f	},	},
		{	{	-21.9733f,	24.3327f,	70.5363f	},	},
		{	{	-42.6345f,	24.3327f,	61.6378f	},	},
		{	{	-50.2895f,	24.3327f,	40.5246f	},	},
		{	{	-38.6303f,	24.3794f,	20.9442f	},	},
		{	{	-17.7166f,	24.3794f,	5.4883f	},	},
		{	{	6.5954f,	24.3794f,	-0.1690f	},	},
		{	{	35.1641f,	24.3794f,	5.4883f	},	},
		{	{	56.0778f,	24.3794f,	20.9442f	},	},
		{	{	63.7327f,	24.3327f,	33.9672f	},	},
		{	{	60.4624f,	24.3327f,	54.0731f	},	},
		{	{	43.7377f,	24.3327f,	64.2629f	},	},
		{	{	6.5954f,	42.1664f,	58.3466f	},	},
		{	{	-9.8987f,	42.1664f,	55.0804f	},	},
		{	{	-21.9733f,	42.1664f,	46.1569f	},	},
		{	{	-25.9160f,	42.1664f,	33.9672f	},	},
		{	{	-21.4964f,	42.2263f,	29.8677f	},	},
		{	{	-9.8987f,	42.2263f,	20.9442f	},	},
		{	{	6.5954f,	42.2263f,	17.6780f	},	},
		{	{	23.0895f,	42.2263f,	20.9442f	},	},
		{	{	35.1641f,	42.2263f,	29.8677f	},	},
		{	{	41.4176f,	42.1664f,	38.6249f	},	},
		{	{	42.8650f,	42.1664f,	59.5536f	},	},
		{	{	23.1102f,	42.1664f,	59.5173f	},	},
		{	{	5.9825f,	48.9276f,	43.0495f	},	},
		{	{	53.4006f,	-24.3794f,	68.4005f	},	},
		{	{	65.5068f,	-22.0320f,	61.9275f	},	},
		{	{	73.1617f,	-0.0286f,	58.1256f	},	},
		{	{	65.5068f,	21.9748f,	61.9275f	},	},
		{	{	53.4006f,	24.3794f,	68.4005f	},	},
		{	{	49.2386f,	-0.0000f,	74.0578f	},	},
		{	{	64.9988f,	-17.4284f,	69.7819f	},	},
		{	{	68.2561f,	-17.4284f,	68.4181f	},	},
		{	{	73.8463f,	0.0000f,	70.8372f	},	},
		{	{	67.9968f,	17.4284f,	69.3087f	},	},
		{	{	64.9988f,	17.4284f,	71.0853f	},	},
		{	{	63.3948f,	-0.0000f,	73.9132f	},	},
		{	{	4.5927f,	-46.5067f,	58.1078f	},	},
		{	{	-11.4500f,	-45.6064f,	53.1536f	},	},
		{	{	-22.4940f,	-44.3708f,	43.0577f	},	},
		{	{	-25.1060f,	-43.1485f,	30.5750f	},	},
		{	{	-20.2743f,	-42.9553f,	26.9755f	},	},
		{	{	-7.7914f,	-42.5979f,	19.3476f	},	},
		{	{	8.9515f,	-42.9216f,	17.8327f	},	},
		{	{	24.9943f,	-43.8218f,	22.7869f	},	},
		{	{	36.0382f,	-45.0575f,	32.8828f	},	},
		{	{	41.3148f,	-46.0578f,	42.2076f	},	},
		{	{	40.5102f,	-47.9589f,	63.0845f	},	},
		{	{	20.8806f,	-47.2228f,	60.9890f	},	},
		{	{	-11.8172f,	45.1872f,	52.6376f	},	},
		{	{	4.0818f,	45.9785f,	58.0525f	},	},
		{	{	20.2831f,	46.6382f,	61.3978f	},	},
		{	{	39.8464f,	47.3412f,	64.0505f	},	},
		{	{	41.2276f,	45.9674f,	43.1624f	},	},
		{	{	36.2095f,	45.2540f,	33.6699f	},	},
		{	{	25.4493f,	44.2619f,	23.2461f	},	},
		{	{	9.5503f,	43.4705f,	17.8313f	},	},
		{	{	-7.2274f,	43.0919f,	18.8763f	},	},
		{	{	-19.9157f,	43.2444f,	26.1644f	},	},
		{	{	-24.8433f,	43.2850f,	29.6372f	},	},
		{	{	-22.5774f,	44.1951f,	42.2138f	},	},
	},

	350,
	{
		{	{	0,	1,	2	},	},
		{	{	0,	2,	3	},	},
		{	{	0,	3,	4	},	},
		{	{	0,	4,	5	},	},
		{	{	0,	5,	6	},	},
		{	{	0,	6,	7	},	},
		{	{	0,	7,	8	},	},
		{	{	0,	8,	9	},	},
		{	{	0,	9,	10	},	},
		{	{	0,	10,	11	},	},
		{	{	0,	11,	12	},	},
		{	{	0,	12,	1	},	},
		{	{	1,	13,	14	},	},
		{	{	14,	2,	1	},	},
		{	{	2,	14,	15	},	},
		{	{	15,	3,	2	},	},
		{	{	3,	15,	16	},	},
		{	{	16,	4,	3	},	},
		{	{	4,	16,	77	},	},
		{	{	4,	77,	17	},	},
		{	{	4,	17,	5	},	},
		{	{	5,	17,	18	},	},
		{	{	18,	6,	5	},	},
		{	{	6,	18,	19	},	},
		{	{	19,	7,	6	},	},
		{	{	7,	19,	20	},	},
		{	{	20,	8,	7	},	},
		{	{	8,	20,	21	},	},
		{	{	21,	9,	8	},	},
		{	{	9,	21,	22	},	},
		{	{	22,	10,	9	},	},
		{	{	10,	22,	23	},	},
		{	{	23,	11,	10	},	},
		{	{	11,	23,	24	},	},
		{	{	24,	12,	11	},	},
		{	{	12,	24,	13	},	},
		{	{	13,	1,	12	},	},
		{	{	13,	25,	26	},	},
		{	{	26,	14,	13	},	},
		{	{	14,	26,	27	},	},
		{	{	27,	15,	14	},	},
		{	{	15,	27,	28	},	},
		{	{	28,	16,	15	},	},
		{	{	76,	69,	70	},	},
		{	{	70,	75,	76	},	},
		{	{	17,	29,	30	},	},
		{	{	30,	18,	17	},	},
		{	{	18,	30,	31	},	},
		{	{	31,	19,	18	},	},
		{	{	19,	31,	32	},	},
		{	{	32,	20,	19	},	},
		{	{	20,	32,	33	},	},
		{	{	33,	21,	20	},	},
		{	{	21,	33,	34	},	},
		{	{	34,	22,	21	},	},
		{	{	22,	34,	35	},	},
		{	{	35,	23,	22	},	},
		{	{	23,	35,	36	},	},
		{	{	36,	24,	23	},	},
		{	{	24,	36,	25	},	},
		{	{	25,	13,	24	},	},
		{	{	25,	37,	38	},	},
		{	{	38,	26,	25	},	},
		{	{	26,	38,	39	},	},
		{	{	39,	27,	26	},	},
		{	{	27,	39,	40	},	},
		{	{	40,	28,	27	},	},
		{	{	75,	70,	71	},	},
		{	{	71,	74,	75	},	},
		{	{	29,	41,	42	},	},
		{	{	42,	30,	29	},	},
		{	{	30,	42,	43	},	},
		{	{	43,	31,	30	},	},
		{	{	31,	43,	44	},	},
		{	{	44,	32,	31	},	},
		{	{	32,	44,	45	},	},
		{	{	45,	33,	32	},	},
		{	{	33,	45,	46	},	},
		{	{	46,	34,	33	},	},
		{	{	34,	46,	47	},	},
		{	{	47,	35,	34	},	},
		{	{	35,	47,	48	},	},
		{	{	48,	36,	35	},	},
		{	{	36,	48,	37	},	},
		{	{	37,	25,	36	},	},
		{	{	37,	49,	50	},	},
		{	{	50,	38,	37	},	},
		{	{	38,	50,	51	},	},
		{	{	51,	39,	38	},	},
		{	{	39,	51,	52	},	},
		{	{	52,	40,	39	},	},
		{	{	53,	41,	79	},	},
		{	{	53,	79,	40	},	},
		{	{	53,	40,	52	},	},
		{	{	41,	53,	54	},	},
		{	{	54,	42,	41	},	},
		{	{	42,	54,	55	},	},
		{	{	55,	43,	42	},	},
		{	{	43,	55,	56	},	},
		{	{	56,	44,	43	},	},
		{	{	44,	56,	57	},	},
		{	{	57,	45,	44	},	},
		{	{	45,	57,	58	},	},
		{	{	58,	46,	45	},	},
		{	{	46,	58,	59	},	},
		{	{	59,	47,	46	},	},
		{	{	47,	59,	60	},	},
		{	{	60,	48,	47	},	},
		{	{	48,	60,	49	},	},
		{	{	49,	37,	48	},	},
		{	{	61,	50,	49	},	},
		{	{	61,	51,	50	},	},
		{	{	61,	52,	51	},	},
		{	{	61,	53,	52	},	},
		{	{	61,	54,	53	},	},
		{	{	61,	55,	54	},	},
		{	{	61,	56,	55	},	},
		{	{	61,	57,	56	},	},
		{	{	61,	58,	57	},	},
		{	{	61,	59,	58	},	},
		{	{	61,	60,	59	},	},
		{	{	61,	49,	60	},	},
		{	{	62,	17,	77	},	},
		{	{	77,	78,	62	},	},
		{	{	64,	63,	16	},	},
		{	{	16,	28,	64	},	},
		{	{	65,	64,	28	},	},
		{	{	28,	40,	65	},	},
		{	{	80,	65,	40	},	},
		{	{	40,	79,	80	},	},
		{	{	67,	66,	41	},	},
		{	{	41,	29,	67	},	},
		{	{	62,	67,	29	},	},
		{	{	29,	17,	62	},	},
		{	{	68,	62,	78	},	},
		{	{	78,	76,	68	},	},
		{	{	70,	69,	63	},	},
		{	{	63,	64,	70	},	},
		{	{	71,	70,	64	},	},
		{	{	64,	65,	71	},	},
		{	{	74,	71,	65	},	},
		{	{	65,	80,	74	},	},
		{	{	73,	72,	66	},	},
		{	{	66,	67,	73	},	},
		{	{	68,	73,	67	},	},
		{	{	67,	62,	68	},	},
		{	{	75,	74,	72	},	},
		{	{	72,	73,	75	},	},
		{	{	68,	76,	75	},	},
		{	{	75,	73,	68	},	},
		{	{	78,	77,	16	},	},
		{	{	16,	63,	78	},	},
		{	{	76,	78,	63	},	},
		{	{	63,	69,	76	},	},
		{	{	66,	80,	79	},	},
		{	{	79,	41,	66	},	},
		{	{	72,	74,	80	},	},
		{	{	80,	66,	72	},	},
		{	{	81,	155,	156	},	},
		{	{	81,	156,	157	},	},
		{	{	81,	157,	158	},	},
		{	{	81,	158,	159	},	},
		{	{	81,	159,	160	},	},
		{	{	81,	160,	161	},	},
		{	{	81,	161,	162	},	},
		{	{	81,	162,	163	},	},
		{	{	81,	163,	164	},	},
		{	{	81,	164,	165	},	},
		{	{	81,	165,	166	},	},
		{	{	81,	166,	155	},	},
		{	{	82,	94,	95	},	},
		{	{	95,	83,	82	},	},
		{	{	83,	95,	96	},	},
		{	{	96,	84,	83	},	},
		{	{	84,	96,	97	},	},
		{	{	97,	85,	84	},	},
		{	{	85,	97,	98	},	},
		{	{	98,	86,	85	},	},
		{	{	86,	98,	99	},	},
		{	{	99,	87,	86	},	},
		{	{	87,	99,	100	},	},
		{	{	100,	88,	87	},	},
		{	{	88,	100,	101	},	},
		{	{	101,	89,	88	},	},
		{	{	89,	101,	102	},	},
		{	{	102,	90,	89	},	},
		{	{	90,	102,	103	},	},
		{	{	103,	91,	90	},	},
		{	{	91,	103,	104	},	},
		{	{	104,	92,	91	},	},
		{	{	92,	104,	105	},	},
		{	{	105,	93,	92	},	},
		{	{	93,	105,	94	},	},
		{	{	94,	82,	93	},	},
		{	{	94,	106,	107	},	},
		{	{	107,	95,	94	},	},
		{	{	95,	107,	108	},	},
		{	{	108,	96,	95	},	},
		{	{	96,	108,	109	},	},
		{	{	109,	97,	96	},	},
		{	{	97,	109,	110	},	},
		{	{	110,	98,	97	},	},
		{	{	98,	110,	111	},	},
		{	{	111,	99,	98	},	},
		{	{	99,	111,	112	},	},
		{	{	112,	100,	99	},	},
		{	{	100,	112,	113	},	},
		{	{	113,	101,	100	},	},
		{	{	101,	113,	114	},	},
		{	{	114,	102,	101	},	},
		{	{	102,	114,	115	},	},
		{	{	115,	103,	102	},	},
		{	{	103,	115,	116	},	},
		{	{	116,	104,	103	},	},
		{	{	150,	151,	154	},	},
		{	{	154,	149,	150	},	},
		{	{	105,	117,	106	},	},
		{	{	106,	94,	105	},	},
		{	{	106,	118,	119	},	},
		{	{	119,	107,	106	},	},
		{	{	107,	119,	120	},	},
		{	{	120,	108,	107	},	},
		{	{	108,	120,	121	},	},
		{	{	121,	109,	108	},	},
		{	{	109,	121,	122	},	},
		{	{	122,	110,	109	},	},
		{	{	110,	122,	123	},	},
		{	{	123,	111,	110	},	},
		{	{	111,	123,	124	},	},
		{	{	124,	112,	111	},	},
		{	{	112,	124,	125	},	},
		{	{	125,	113,	112	},	},
		{	{	113,	125,	126	},	},
		{	{	126,	114,	113	},	},
		{	{	114,	126,	127	},	},
		{	{	127,	115,	114	},	},
		{	{	115,	127,	128	},	},
		{	{	128,	116,	115	},	},
		{	{	151,	152,	153	},	},
		{	{	153,	154,	151	},	},
		{	{	117,	129,	118	},	},
		{	{	118,	106,	117	},	},
		{	{	118,	130,	131	},	},
		{	{	131,	119,	118	},	},
		{	{	119,	131,	132	},	},
		{	{	132,	120,	119	},	},
		{	{	120,	132,	133	},	},
		{	{	133,	121,	120	},	},
		{	{	121,	133,	134	},	},
		{	{	134,	122,	121	},	},
		{	{	122,	134,	135	},	},
		{	{	135,	123,	122	},	},
		{	{	123,	135,	136	},	},
		{	{	136,	124,	123	},	},
		{	{	124,	136,	137	},	},
		{	{	137,	125,	124	},	},
		{	{	125,	137,	138	},	},
		{	{	138,	126,	125	},	},
		{	{	126,	138,	139	},	},
		{	{	139,	127,	126	},	},
		{	{	127,	139,	140	},	},
		{	{	140,	128,	127	},	},
		{	{	128,	140,	141	},	},
		{	{	141,	129,	128	},	},
		{	{	129,	141,	130	},	},
		{	{	130,	118,	129	},	},
		{	{	142,	167,	168	},	},
		{	{	142,	178,	167	},	},
		{	{	142,	177,	178	},	},
		{	{	142,	176,	177	},	},
		{	{	142,	175,	176	},	},
		{	{	142,	174,	175	},	},
		{	{	142,	173,	174	},	},
		{	{	142,	172,	173	},	},
		{	{	142,	171,	172	},	},
		{	{	142,	170,	171	},	},
		{	{	142,	169,	170	},	},
		{	{	142,	168,	169	},	},
		{	{	144,	143,	105	},	},
		{	{	105,	104,	144	},	},
		{	{	145,	144,	104	},	},
		{	{	104,	116,	145	},	},
		{	{	146,	145,	116	},	},
		{	{	116,	128,	146	},	},
		{	{	147,	146,	128	},	},
		{	{	128,	129,	147	},	},
		{	{	148,	147,	129	},	},
		{	{	129,	117,	148	},	},
		{	{	143,	148,	117	},	},
		{	{	117,	105,	143	},	},
		{	{	150,	149,	143	},	},
		{	{	143,	144,	150	},	},
		{	{	151,	150,	144	},	},
		{	{	144,	145,	151	},	},
		{	{	152,	151,	145	},	},
		{	{	145,	146,	152	},	},
		{	{	153,	152,	146	},	},
		{	{	146,	147,	153	},	},
		{	{	154,	153,	147	},	},
		{	{	147,	148,	154	},	},
		{	{	149,	154,	148	},	},
		{	{	148,	143,	149	},	},
		{	{	156,	155,	82	},	},
		{	{	82,	83,	156	},	},
		{	{	157,	156,	83	},	},
		{	{	83,	84,	157	},	},
		{	{	158,	157,	84	},	},
		{	{	84,	85,	158	},	},
		{	{	159,	158,	85	},	},
		{	{	85,	86,	159	},	},
		{	{	160,	159,	86	},	},
		{	{	86,	87,	160	},	},
		{	{	161,	160,	87	},	},
		{	{	87,	88,	161	},	},
		{	{	162,	161,	88	},	},
		{	{	88,	89,	162	},	},
		{	{	163,	162,	89	},	},
		{	{	89,	90,	163	},	},
		{	{	164,	163,	90	},	},
		{	{	90,	91,	164	},	},
		{	{	165,	164,	91	},	},
		{	{	91,	92,	165	},	},
		{	{	166,	165,	92	},	},
		{	{	92,	93,	166	},	},
		{	{	155,	166,	93	},	},
		{	{	93,	82,	155	},	},
		{	{	168,	167,	131	},	},
		{	{	131,	130,	168	},	},
		{	{	169,	168,	130	},	},
		{	{	130,	141,	169	},	},
		{	{	170,	169,	141	},	},
		{	{	141,	140,	170	},	},
		{	{	171,	170,	140	},	},
		{	{	140,	139,	171	},	},
		{	{	172,	171,	139	},	},
		{	{	139,	138,	172	},	},
		{	{	173,	172,	138	},	},
		{	{	138,	137,	173	},	},
		{	{	174,	173,	137	},	},
		{	{	137,	136,	174	},	},
		{	{	175,	174,	136	},	},
		{	{	136,	135,	175	},	},
		{	{	176,	175,	135	},	},
		{	{	135,	134,	176	},	},
		{	{	177,	176,	134	},	},
		{	{	134,	133,	177	},	},
		{	{	178,	177,	133	},	},
		{	{	133,	132,	178	},	},
		{	{	167,	178,	132	},	},
		{	{	132,	131,	167	},	},
	},
};

//*************************************************************************************
//	
//*************************************************************************************
SObject	g_SphereObject =
{
	{	192,	192,	255	},
	114,
	{
		{	{	0.0000f,	-50.0000f,	-0.0000f	},	},
		{	{	-0.0000f,	-46.1940f,	19.1342f	},	},
		{	{	-7.3223f,	-46.1940f,	17.6777f	},	},
		{	{	-13.5299f,	-46.1940f,	13.5299f	},	},
		{	{	-17.6777f,	-46.1940f,	7.3223f	},	},
		{	{	-19.1342f,	-46.1940f,	-0.0000f	},	},
		{	{	-17.6777f,	-46.1940f,	-7.3223f	},	},
		{	{	-13.5299f,	-46.1940f,	-13.5299f	},	},
		{	{	-7.3223f,	-46.1940f,	-17.6777f	},	},
		{	{	0.0000f,	-46.1940f,	-19.1342f	},	},
		{	{	7.3223f,	-46.1940f,	-17.6777f	},	},
		{	{	13.5299f,	-46.1940f,	-13.5299f	},	},
		{	{	17.6777f,	-46.1940f,	-7.3223f	},	},
		{	{	19.1342f,	-46.1940f,	0.0000f	},	},
		{	{	17.6777f,	-46.1940f,	7.3223f	},	},
		{	{	13.5299f,	-46.1940f,	13.5299f	},	},
		{	{	7.3223f,	-46.1940f,	17.6777f	},	},
		{	{	-0.0000f,	-35.3553f,	35.3553f	},	},
		{	{	-13.5299f,	-35.3553f,	32.6641f	},	},
		{	{	-25.0000f,	-35.3553f,	25.0000f	},	},
		{	{	-32.6641f,	-35.3553f,	13.5299f	},	},
		{	{	-35.3553f,	-35.3553f,	-0.0000f	},	},
		{	{	-32.6641f,	-35.3553f,	-13.5299f	},	},
		{	{	-25.0000f,	-35.3553f,	-25.0000f	},	},
		{	{	-13.5299f,	-35.3553f,	-32.6641f	},	},
		{	{	0.0000f,	-35.3553f,	-35.3553f	},	},
		{	{	13.5299f,	-35.3553f,	-32.6641f	},	},
		{	{	25.0000f,	-35.3553f,	-25.0000f	},	},
		{	{	32.6641f,	-35.3553f,	-13.5299f	},	},
		{	{	35.3553f,	-35.3553f,	0.0000f	},	},
		{	{	32.6641f,	-35.3553f,	13.5299f	},	},
		{	{	25.0000f,	-35.3553f,	25.0000f	},	},
		{	{	13.5299f,	-35.3553f,	32.6641f	},	},
		{	{	-0.0000f,	-19.1342f,	46.1940f	},	},
		{	{	-17.6777f,	-19.1342f,	42.6777f	},	},
		{	{	-32.6641f,	-19.1342f,	32.6641f	},	},
		{	{	-42.6777f,	-19.1342f,	17.6777f	},	},
		{	{	-46.1940f,	-19.1342f,	-0.0000f	},	},
		{	{	-42.6777f,	-19.1342f,	-17.6777f	},	},
		{	{	-32.6641f,	-19.1342f,	-32.6641f	},	},
		{	{	-17.6777f,	-19.1342f,	-42.6777f	},	},
		{	{	0.0000f,	-19.1342f,	-46.1940f	},	},
		{	{	17.6777f,	-19.1342f,	-42.6777f	},	},
		{	{	32.6641f,	-19.1342f,	-32.6641f	},	},
		{	{	42.6777f,	-19.1342f,	-17.6777f	},	},
		{	{	46.1940f,	-19.1342f,	0.0000f	},	},
		{	{	42.6777f,	-19.1342f,	17.6777f	},	},
		{	{	32.6641f,	-19.1342f,	32.6641f	},	},
		{	{	17.6777f,	-19.1342f,	42.6777f	},	},
		{	{	-0.0000f,	-0.0000f,	50.0000f	},	},
		{	{	-19.1342f,	0.0000f,	46.1940f	},	},
		{	{	-35.3553f,	0.0000f,	35.3553f	},	},
		{	{	-46.1940f,	0.0000f,	19.1342f	},	},
		{	{	-50.0000f,	0.0000f,	-0.0000f	},	},
		{	{	-46.1940f,	0.0000f,	-19.1342f	},	},
		{	{	-35.3553f,	0.0000f,	-35.3553f	},	},
		{	{	-19.1342f,	0.0000f,	-46.1940f	},	},
		{	{	0.0000f,	0.0000f,	-50.0000f	},	},
		{	{	19.1342f,	0.0000f,	-46.1940f	},	},
		{	{	35.3553f,	0.0000f,	-35.3553f	},	},
		{	{	46.1940f,	0.0000f,	-19.1342f	},	},
		{	{	50.0000f,	0.0000f,	0.0000f	},	},
		{	{	46.1940f,	0.0000f,	19.1342f	},	},
		{	{	35.3553f,	0.0000f,	35.3553f	},	},
		{	{	19.1342f,	0.0000f,	46.1940f	},	},
		{	{	-0.0000f,	19.1342f,	46.1940f	},	},
		{	{	-17.6777f,	19.1342f,	42.6777f	},	},
		{	{	-32.6641f,	19.1342f,	32.6641f	},	},
		{	{	-42.6777f,	19.1342f,	17.6777f	},	},
		{	{	-46.1940f,	19.1342f,	-0.0000f	},	},
		{	{	-42.6777f,	19.1342f,	-17.6777f	},	},
		{	{	-32.6641f,	19.1342f,	-32.6641f	},	},
		{	{	-17.6777f,	19.1342f,	-42.6777f	},	},
		{	{	0.0000f,	19.1342f,	-46.1940f	},	},
		{	{	17.6777f,	19.1342f,	-42.6777f	},	},
		{	{	32.6641f,	19.1342f,	-32.6641f	},	},
		{	{	42.6777f,	19.1342f,	-17.6777f	},	},
		{	{	46.1940f,	19.1342f,	0.0000f	},	},
		{	{	42.6777f,	19.1342f,	17.6777f	},	},
		{	{	32.6641f,	19.1342f,	32.6641f	},	},
		{	{	17.6777f,	19.1342f,	42.6777f	},	},
		{	{	-0.0000f,	35.3553f,	35.3553f	},	},
		{	{	-13.5299f,	35.3553f,	32.6641f	},	},
		{	{	-25.0000f,	35.3553f,	25.0000f	},	},
		{	{	-32.6641f,	35.3553f,	13.5299f	},	},
		{	{	-35.3553f,	35.3553f,	-0.0000f	},	},
		{	{	-32.6641f,	35.3553f,	-13.5299f	},	},
		{	{	-25.0000f,	35.3553f,	-25.0000f	},	},
		{	{	-13.5299f,	35.3553f,	-32.6641f	},	},
		{	{	0.0000f,	35.3553f,	-35.3553f	},	},
		{	{	13.5299f,	35.3553f,	-32.6641f	},	},
		{	{	25.0000f,	35.3553f,	-25.0000f	},	},
		{	{	32.6641f,	35.3553f,	-13.5299f	},	},
		{	{	35.3553f,	35.3553f,	0.0000f	},	},
		{	{	32.6641f,	35.3553f,	13.5299f	},	},
		{	{	25.0000f,	35.3553f,	25.0000f	},	},
		{	{	13.5299f,	35.3553f,	32.6641f	},	},
		{	{	-0.0000f,	46.1940f,	19.1342f	},	},
		{	{	-7.3223f,	46.1940f,	17.6777f	},	},
		{	{	-13.5299f,	46.1940f,	13.5299f	},	},
		{	{	-17.6777f,	46.1940f,	7.3223f	},	},
		{	{	-19.1342f,	46.1940f,	0.0000f	},	},
		{	{	-17.6777f,	46.1940f,	-7.3223f	},	},
		{	{	-13.5299f,	46.1940f,	-13.5299f	},	},
		{	{	-7.3223f,	46.1940f,	-17.6777f	},	},
		{	{	0.0000f,	46.1940f,	-19.1342f	},	},
		{	{	7.3223f,	46.1940f,	-17.6777f	},	},
		{	{	13.5299f,	46.1940f,	-13.5299f	},	},
		{	{	17.6777f,	46.1940f,	-7.3223f	},	},
		{	{	19.1342f,	46.1940f,	0.0000f	},	},
		{	{	17.6777f,	46.1940f,	7.3223f	},	},
		{	{	13.5299f,	46.1940f,	13.5299f	},	},
		{	{	7.3223f,	46.1940f,	17.6777f	},	},
		{	{	0.0000f,	50.0000f,	0.0000f	},	},
	},

	224,
	{
		{	{	0,	1,	2	},	},
		{	{	0,	2,	3	},	},
		{	{	0,	3,	4	},	},
		{	{	0,	4,	5	},	},
		{	{	0,	5,	6	},	},
		{	{	0,	6,	7	},	},
		{	{	0,	7,	8	},	},
		{	{	0,	8,	9	},	},
		{	{	0,	9,	10	},	},
		{	{	0,	10,	11	},	},
		{	{	0,	11,	12	},	},
		{	{	0,	12,	13	},	},
		{	{	0,	13,	14	},	},
		{	{	0,	14,	15	},	},
		{	{	0,	15,	16	},	},
		{	{	0,	16,	1	},	},
		{	{	1,	17,	18	},	},
		{	{	1,	18,	2	},	},
		{	{	2,	18,	19	},	},
		{	{	2,	19,	3	},	},
		{	{	3,	19,	20	},	},
		{	{	3,	20,	4	},	},
		{	{	4,	20,	21	},	},
		{	{	4,	21,	5	},	},
		{	{	5,	21,	22	},	},
		{	{	5,	22,	6	},	},
		{	{	6,	22,	23	},	},
		{	{	6,	23,	7	},	},
		{	{	7,	23,	24	},	},
		{	{	7,	24,	8	},	},
		{	{	8,	24,	25	},	},
		{	{	8,	25,	9	},	},
		{	{	9,	25,	26	},	},
		{	{	9,	26,	10	},	},
		{	{	10,	26,	27	},	},
		{	{	10,	27,	11	},	},
		{	{	11,	27,	28	},	},
		{	{	11,	28,	12	},	},
		{	{	12,	28,	29	},	},
		{	{	12,	29,	13	},	},
		{	{	13,	29,	30	},	},
		{	{	13,	30,	14	},	},
		{	{	14,	30,	31	},	},
		{	{	14,	31,	15	},	},
		{	{	15,	31,	32	},	},
		{	{	15,	32,	16	},	},
		{	{	16,	32,	17	},	},
		{	{	16,	17,	1	},	},
		{	{	17,	33,	34	},	},
		{	{	17,	34,	18	},	},
		{	{	18,	34,	35	},	},
		{	{	18,	35,	19	},	},
		{	{	19,	35,	36	},	},
		{	{	19,	36,	20	},	},
		{	{	20,	36,	37	},	},
		{	{	20,	37,	21	},	},
		{	{	21,	37,	38	},	},
		{	{	21,	38,	22	},	},
		{	{	22,	38,	39	},	},
		{	{	22,	39,	23	},	},
		{	{	23,	39,	40	},	},
		{	{	23,	40,	24	},	},
		{	{	24,	40,	41	},	},
		{	{	24,	41,	25	},	},
		{	{	25,	41,	42	},	},
		{	{	25,	42,	26	},	},
		{	{	26,	42,	43	},	},
		{	{	26,	43,	27	},	},
		{	{	27,	43,	44	},	},
		{	{	27,	44,	28	},	},
		{	{	28,	44,	45	},	},
		{	{	28,	45,	29	},	},
		{	{	29,	45,	46	},	},
		{	{	29,	46,	30	},	},
		{	{	30,	46,	47	},	},
		{	{	30,	47,	31	},	},
		{	{	31,	47,	48	},	},
		{	{	31,	48,	32	},	},
		{	{	32,	48,	33	},	},
		{	{	32,	33,	17	},	},
		{	{	33,	49,	50	},	},
		{	{	33,	50,	34	},	},
		{	{	34,	50,	51	},	},
		{	{	34,	51,	35	},	},
		{	{	35,	51,	52	},	},
		{	{	35,	52,	36	},	},
		{	{	36,	52,	53	},	},
		{	{	36,	53,	37	},	},
		{	{	37,	53,	54	},	},
		{	{	37,	54,	38	},	},
		{	{	38,	54,	55	},	},
		{	{	38,	55,	39	},	},
		{	{	39,	55,	56	},	},
		{	{	39,	56,	40	},	},
		{	{	40,	56,	57	},	},
		{	{	40,	57,	41	},	},
		{	{	41,	57,	58	},	},
		{	{	41,	58,	42	},	},
		{	{	42,	58,	59	},	},
		{	{	42,	59,	43	},	},
		{	{	43,	59,	60	},	},
		{	{	43,	60,	44	},	},
		{	{	44,	60,	61	},	},
		{	{	44,	61,	45	},	},
		{	{	45,	61,	62	},	},
		{	{	45,	62,	46	},	},
		{	{	46,	62,	63	},	},
		{	{	46,	63,	47	},	},
		{	{	47,	63,	64	},	},
		{	{	47,	64,	48	},	},
		{	{	48,	64,	49	},	},
		{	{	48,	49,	33	},	},
		{	{	49,	65,	66	},	},
		{	{	49,	66,	50	},	},
		{	{	50,	66,	67	},	},
		{	{	50,	67,	51	},	},
		{	{	51,	67,	68	},	},
		{	{	51,	68,	52	},	},
		{	{	52,	68,	69	},	},
		{	{	52,	69,	53	},	},
		{	{	53,	69,	70	},	},
		{	{	53,	70,	54	},	},
		{	{	54,	70,	71	},	},
		{	{	54,	71,	55	},	},
		{	{	55,	71,	72	},	},
		{	{	55,	72,	56	},	},
		{	{	56,	72,	73	},	},
		{	{	56,	73,	57	},	},
		{	{	57,	73,	74	},	},
		{	{	57,	74,	58	},	},
		{	{	58,	74,	75	},	},
		{	{	58,	75,	59	},	},
		{	{	59,	75,	76	},	},
		{	{	59,	76,	60	},	},
		{	{	60,	76,	77	},	},
		{	{	60,	77,	61	},	},
		{	{	61,	77,	78	},	},
		{	{	61,	78,	62	},	},
		{	{	62,	78,	79	},	},
		{	{	62,	79,	63	},	},
		{	{	63,	79,	80	},	},
		{	{	63,	80,	64	},	},
		{	{	64,	80,	65	},	},
		{	{	64,	65,	49	},	},
		{	{	65,	81,	82	},	},
		{	{	65,	82,	66	},	},
		{	{	66,	82,	83	},	},
		{	{	66,	83,	67	},	},
		{	{	67,	83,	84	},	},
		{	{	67,	84,	68	},	},
		{	{	68,	84,	85	},	},
		{	{	68,	85,	69	},	},
		{	{	69,	85,	86	},	},
		{	{	69,	86,	70	},	},
		{	{	70,	86,	87	},	},
		{	{	70,	87,	71	},	},
		{	{	71,	87,	88	},	},
		{	{	71,	88,	72	},	},
		{	{	72,	88,	89	},	},
		{	{	72,	89,	73	},	},
		{	{	73,	89,	90	},	},
		{	{	73,	90,	74	},	},
		{	{	74,	90,	91	},	},
		{	{	74,	91,	75	},	},
		{	{	75,	91,	92	},	},
		{	{	75,	92,	76	},	},
		{	{	76,	92,	93	},	},
		{	{	76,	93,	77	},	},
		{	{	77,	93,	94	},	},
		{	{	77,	94,	78	},	},
		{	{	78,	94,	95	},	},
		{	{	78,	95,	79	},	},
		{	{	79,	95,	96	},	},
		{	{	79,	96,	80	},	},
		{	{	80,	96,	81	},	},
		{	{	80,	81,	65	},	},
		{	{	81,	97,	98	},	},
		{	{	81,	98,	82	},	},
		{	{	82,	98,	99	},	},
		{	{	82,	99,	83	},	},
		{	{	83,	99,	100	},	},
		{	{	83,	100,	84	},	},
		{	{	84,	100,	101	},	},
		{	{	84,	101,	85	},	},
		{	{	85,	101,	102	},	},
		{	{	85,	102,	86	},	},
		{	{	86,	102,	103	},	},
		{	{	86,	103,	87	},	},
		{	{	87,	103,	104	},	},
		{	{	87,	104,	88	},	},
		{	{	88,	104,	105	},	},
		{	{	88,	105,	89	},	},
		{	{	89,	105,	106	},	},
		{	{	89,	106,	90	},	},
		{	{	90,	106,	107	},	},
		{	{	90,	107,	91	},	},
		{	{	91,	107,	108	},	},
		{	{	91,	108,	92	},	},
		{	{	92,	108,	109	},	},
		{	{	92,	109,	93	},	},
		{	{	93,	109,	110	},	},
		{	{	93,	110,	94	},	},
		{	{	94,	110,	111	},	},
		{	{	94,	111,	95	},	},
		{	{	95,	111,	112	},	},
		{	{	95,	112,	96	},	},
		{	{	96,	112,	97	},	},
		{	{	96,	97,	81	},	},
		{	{	113,	98,	97	},	},
		{	{	113,	99,	98	},	},
		{	{	113,	100,	99	},	},
		{	{	113,	101,	100	},	},
		{	{	113,	102,	101	},	},
		{	{	113,	103,	102	},	},
		{	{	113,	104,	103	},	},
		{	{	113,	105,	104	},	},
		{	{	113,	106,	105	},	},
		{	{	113,	107,	106	},	},
		{	{	113,	108,	107	},	},
		{	{	113,	109,	108	},	},
		{	{	113,	110,	109	},	},
		{	{	113,	111,	110	},	},
		{	{	113,	112,	111	},	},
		{	{	113,	97,	112	},	},
	},
};


//**********************************************************************************
//   Static Variables
//**********************************************************************************

//**********************************************************************************
//   Class Definition
//**********************************************************************************

//*************************************************************************************
//	
//*************************************************************************************
void	OBJECT_Init( SObject * const p_obj )
{
	u32		i, a, b, c;
	V3		face_normal;
	V3 *	v0,	* v1, * v2;

	for ( i = 0; i < p_obj->num_verts; ++i )
	{
		p_obj->verts[ i ].normal = gZeroVector;
	}

	for ( i = 0; i < p_obj->num_faces; ++i )
	{
		a = p_obj->faces[ i ].verts[ 0 ];
		b = p_obj->faces[ i ].verts[ 1 ];
		c = p_obj->faces[ i ].verts[ 2 ];

		v0 = &p_obj->verts[ a ].pos;
		v1 = &p_obj->verts[ b ].pos;
		v2 = &p_obj->verts[ c ].pos;

		face_normal.x = ( v1->y - v0->y ) * ( v0->z - v2->z ) - ( v1->z - v0->z ) * ( v0->y - v2->y );
		face_normal.y = ( v1->z - v0->z ) * ( v0->x - v2->x ) - ( v1->x - v0->x ) * ( v0->z - v2->z );
		face_normal.z = ( v1->x - v0->x ) * ( v0->y - v2->y ) - ( v1->y - v0->y ) * ( v0->x - v2->x );

		V3_Normalise( &face_normal );

		p_obj->faces[ i ].normal = face_normal;
	}

	for ( i = 0; i < p_obj->num_faces; ++i )
	{
		a = p_obj->faces[ i ].verts[ 0 ];
		b = p_obj->faces[ i ].verts[ 1 ];
		c = p_obj->faces[ i ].verts[ 2 ];

		if ( p_obj->verts[ a ].normal.x == 0.f && p_obj->verts[ a ].normal.y == 0.f && p_obj->verts[ a ].normal.z == 0.f )
		{
			p_obj->verts[ a ].normal = p_obj->faces[ i ].normal;
		}
		else
		{
			p_obj->verts[ a ].normal = V3_Add( &p_obj->verts[ a ].normal, &p_obj->faces[ i ].normal );
			p_obj->verts[ a ].normal = V3_Mul( &p_obj->verts[ a ].normal, 0.5 );
		}
	}
}

//*************************************************************************************
//	
//*************************************************************************************
void	OBJECT_Render( SObject * const p_object, const V3 * const p_pos, const V3 * scale, s16 rot_x, s16 rot_y, s16 rot_z, bool flat )
{
	M44		mtx;
	M44		x_mtx, y_mtx, z_mtx;

	MTX_SetIdentity( &mtx );

	MTX_SetRotationX( &x_mtx, rot_x );
	MTX_SetRotationY( &y_mtx, rot_y );
	MTX_SetRotationZ( &z_mtx, rot_z );

	MTX_Multiply( &mtx, &x_mtx );
	MTX_Multiply( &mtx, &y_mtx );
	MTX_Multiply( &mtx, &z_mtx );

	MTX_Scale( &mtx, scale->x, scale->y, scale->z );
	MTX_SetPos( &mtx, p_pos );

	RenderObject( p_object, &mtx, flat );
}

//*******************************  END OF FILE  ************************************
