/***********************************************************************************

  Module :	Object.h

  Description :	

  Last Modified $Date: $

  $Revision: $

  Copyright (C) 28 May 2005 T Swann

***********************************************************************************/

#ifndef _OBJECT_H_
#define _OBJECT_H_

//**********************************************************************************
//   Include Files
//**********************************************************************************
#include "Types.h"
#include "Graphics.h"

//**********************************************************************************
//   Macros
//**********************************************************************************

//**********************************************************************************
//   Types
//**********************************************************************************
typedef struct
{
	V3		pos;
	V3		trans_pos;
	V3		normal;
	RGBA	col;
} SVertex;

typedef struct
{
	u32		verts[ 3 ];
	f32		centre_z;
	RGBA	col;
	V3		normal;
} SFace;

typedef struct
{
	RGBA	diffuse;

	s32		num_verts;
	SVertex	verts[ 512 ];

	s32		num_faces;
	SFace	faces[ 512 ];

	s32		num_visible;
	u32		visible[ 512 ];
} SObject;

//**********************************************************************************
//   Constants
//**********************************************************************************

//**********************************************************************************
//   Class definitions
//**********************************************************************************

//**********************************************************************************
//   Externs
//**********************************************************************************
extern SObject	g_CubeObject;
extern SObject	g_DuckObject;
extern SObject	g_SphereObject;

//**********************************************************************************
//   Prototypes
//**********************************************************************************
void	OBJECT_Init( SObject * const p_object );
void	OBJECT_Render( SObject * const p_object, const V3 * const p_pos, const V3 * scale, s16 rot_x, s16 rot_y, s16 rot_z, bool flat );

#endif /* _OBJECT_H_ */
