/***********************************************************************************

  Module :	Vector.h

  Description :	

  Last Modified $Date: $

  $Revision: $

  Copyright (C) 28 May 2005 T Swann

***********************************************************************************/

#ifndef _VECTOR_H_
#define _VECTOR_H_

//**********************************************************************************
//   Include Files
//**********************************************************************************

//**********************************************************************************
//   Macros
//**********************************************************************************

//**********************************************************************************
//   Types
//**********************************************************************************
typedef struct
{
	f32	x;
	f32	y;
	f32	z;
} V3;

//**********************************************************************************
//   Constants
//**********************************************************************************
extern const V3	gZeroVector;
extern const V3	gAtVector;
extern const V3	gUpVector;
extern const V3	gRightVector;

//**********************************************************************************
//   Class definitions
//**********************************************************************************
V3		V3_Add( const V3 * const p_lhs, const V3 * const p_rhs );
V3		V3_Sub( const V3 * const p_lhs, const V3 * const p_rhs );
V3		V3_Mul( const V3 * const p_lhs, f32 val );
V3		V3_Div( const V3 * const p_lhs, f32 val );

f32		V3_Length( const V3 * const p_lhs );
f32		V3_LengthSq( const V3 * const p_lhs );

f32		V3_Dot( const V3 * const p_lhs, const V3 * const p_rhs );
V3		V3_Cross( const V3 * const p_lhs, const V3 * const p_rhs );
f32		V3_Normalise( V3 * const p_lhs );

V3		RotateX( const V3 * const p_v, u16 x_angle );
V3		RotateY( const V3 * const p_v, u16 y_angle );
V3		RotateZ( const V3 * const p_v, u16 z_angle );

//**********************************************************************************
//   Externs
//**********************************************************************************

//**********************************************************************************
//   Prototypes
//**********************************************************************************

#endif /* _VECTOR_H_ */
