; 3D ENGINE                 
; all code by ago 
; e-mail:  firegear@mail.ru  or gobuzov@yahoo.com
;--------
sound   equ 1
RGBSet: MACRO
        dw      \3 << 10 + \2 << 5 + \1
        ENDM
;-----------------------------------conditions
trisafe equ 1

;-----------------------------------
 include "define.h"
 include "vars.h"
 include "objects.h"
 include "hiram.asm"
 include "macros.asm"

SECTION  "Startup",Home[0]
;rst0  
 push af
 xor  a
 ldio [$4f],a           ; VBK (VRAM Bank) char code
 pop  af
 ret
 ds   2

;rst8 
 push af
 ld   a,1
 ldio [$4f],a           ; VBK (VRAM Bank) attr code
 pop  af
 ret
 ds   1
;-------------------------- rst $10     ; rst  $10      
 pop  hl                                ; db   Page
 ld   a,[hli]                           ; dw   Adress in Page
 ld   e,[hl]
 inc  hl
 ld   d,[hl]
 inc  hl
 push hl
 push de
;-------------------------- rst $18     ; switch ROM page
rst18:
 ld   [$2000],a
 ret
 ds   4
;-------------------------- rst $20
 pop  hl
 ld   a,[hli]
 ld   [$2000],a
 jp   [hl]
 ds   2
;-------------------------- rst $28
 ldio [$f3],a
 ld   a,l
 ldio [$f0],a
 jp   Rst28continue
;-------------------------- rst $30     ; switch Internal RAM page
 pop  hl
 ld   a,[hli]
 ldio [$ff70],a
 jp   [hl]
 ds   3
;-------------------------- rst $38     ; waiting Vblank
 ldio a,[$41]
 and  2
 jr   nz,@-4
 ret       

SECTION  "Vertical blank IRQ",home[$0040]
 jp   vblank_int
 ds   6

;SECTION  "LCD IRQ",home[$0048]
 reti

 db 10,"contacts:",10
 db "   gobuzov@pisem.net",10
 db "or gobuzov@rambler.ru",10
 db "or gobuzov@aport.ru",10
 db "or gobuzov@yahoo.com",10

;------
;                            Header Equates
;Cartridge type:
; 0 - Rom only      3 - ROM+MBC1+RAM+Battery  1 - ROM+MBC1      5 - ROM+MBC2
; 2 - ROM+MBC1+RAM  6 - ROM+MBC2+Battery
CARTTYPE  EQU 2
;Rom Size:
; 0 - 256kBit =  32kB =  2 banks ; 1 - 512kBit =  64kB =  4 banks
; 2 -   1MBit = 128kB =  8 banks ; 3 -   2MBit = 256kB = 16 banks
; 4 -   4MBit = 512kB = 32 banks
ROMSIZE   EQU 1
;Ram Size:
; 0 - None ; 1 -  16kBit =  2kB = 1/4 of  bank
; 3 - 256kBit = 32kB = 4 banks
RAMSIZE   EQU 0         ;
;Manufacturer code (word):
MANUCODE  EQU 1
;Version Number (byte):
VERSION   EQU 1

;-----
;     Do NOT modify unless you are familiar with header info *Modified for Game Boy Color*

SECTION  "Header",home[$0100]
  ;Jumper
  nop
  jp Start              ; go to Start of program:
  ;Nintendo Scrolling Title Graphic
  DB $CE,$ED,$66,$66,$CC,$0D,$00,$0B,$03,$73,$00,$83,$00,$0C,$00,$0D
  DB $00,$08,$11,$1F,$88,$89,$00,$0E,$DC,$CC,$6E,$E6,$DD,$DD,$D9,$99
  DB $BB,$BB,$67,$63,$6E,$0E,$EC,$CC,$DD,$DC,$99,$9F,$BB,$B9,$33,$3E
  ;Title of the game
  db "DIMENSION OF M.",128 ; Filled in by RGBFIX
  ;Not used
  db 0,0,0; last should be 3, won't work in emu unles it's 0
  ;Cartridge type:
  db CARTTYPE
  ;Rom Size:
  db ROMSIZE
  ;Ram Size:
  db RAMSIZE
  ;Manufacturer code:
  db 00, $33
  ;Version Number
  db VERSION
  ;Complement check
  db $0a
  ;Checksum
  dw 0

;-----
;          This is the start of the program

;SECTION  "Main", home
;------ jump Table since $150
 dw   CopyHLtoDE        ; $50
 dw   CopyHLtoDEinC     ; $52
 dw   FillHL            ; $54
 dw   FillHLinC         ; $56
 dw   SetBkgPalette     ; $58
 dw   SetObjPalette     ; $5a
 dw   FillRect          ; $5c
;------
Rst28continue:
 ld   a,h
 pop  hl
 ldio [$fff1],a
 ld   a,[hli]
 rra
 jr   nc,@+4
 ld   c,[hl]
 inc  hl
 rra
 jr   nc,@+4
 ld   b,[hl]
 inc  hl
 rra 
 jr   nc,@+4
 ld   e,[hl]
 inc  hl
 rra
 jr   nc,@+4
 ld   d,[hl]
 inc  hl
 rra
 jr   nc,@+7
 push af
 ld   a,[hli]   ; l
 ldio [$fff0],a
 pop  af
 rra
 jr   nc,@+7
 push af
 ld   a,[hli]   ; h
 ldio [$fff1],a
 pop  af
 rra
 jr   nc,@+7
 push af
 ld   a,[hli]   ; a
 ldio [$fff3],a
 pop  af
 rra
 jr   nc,@+4
 ld   a,[hli]   ; ROM page
 rst  24

 ld   a,[hli]   ; number in table
 push hl
 ld   h,1
 ld   l,a
 ld   a,[hli]
 ld   h,[hl]
 ld   l,a       ; on $ffef: ld   hl,NN 
 push hl        ;           ld   a,N
 jp   $ffef     ;           ret
; 
LCDoff:
 ld   a,[rIE]
 push af
 res  0,a
 ld   [rIE],a           ; Disable vblank interrupt if enabled

.loop:  
 ld   a,[rLY]           ; Loop until in first part of vblank
 cp   145
 jr   nz,.loop
 xor  a
 ldio [$40],a           ; Turn the screen off
 pop  af
 ld   [rIE],a           ; Restore the state of vblank interrupt
 ret

dmaCode:
 ld   a,MyObjects/256
 ldio [$46],a
 ld   a,$28
dmaWait:
 dec  a
 jr   nz,dmaWait
 ret
dmaEnd:
;--------------- put something here ---------------


;--------------------------------------------------
vblank_int:
 push af
 push bc
 push de
 push hl
 if sound
 call plaPlayMusic
 endc
 ld   hl,vmode
 bit  7,[hl]
 call nz,dmaTrans          ; objects update
 ld   hl,VblankFlag
 ld   [hl],1
 pop  hl
 pop  de
 pop  bc
 ld   a,[vproc]
 cp   1
 jp   z,InfWorldsBlank

 pop  af
 reti
;
 include "setup.asm"
 include "math.asm"
 include "my_rut.asm"
 include "fps_calc.asm"
 include "messages.asm"
;
 include "pack_fnt.asm"
 include "obj_scroll.asm"
 include "sazerland-kohen.asm"
 include "textured-triangles.asm"
 include "hicolor.asm"
;
;------------------------------------- EdgeSets 
es1:
;EdgeSet1  ;128 times  
 rept 128
 add  a,e
 cp   b
 jr   nc,@+7
 sub  e
 add  a,d
 ld   [hl],c
 inc  l
 inc  l
 dec  c
 endr
 ret  
;--------
es2:
;EdgeSet2  ;120 times  
 rept 120
 ld   [hl],c
 inc  l
 inc  l
 add  a,e
 cp   b
 jr   nc,@+5
 sub  e
 add  a,d
 dec  c
 endr
 ret
;---------
es3:
;EdgeSet3  ;128 times  
 rept 128
 add  a,e
 cp   b
 jr   nc,@+7
 sub  e
 add  a,d
 ld   [hl],c
 inc  l
 inc  l
 inc  c
 endr
 ret
;---------
es4:
;EdgeSet4  ;120 times  
 rept 120
 ld   [hl],c
 inc  l
 inc  l
 add  a,e
 cp   b
 jr   nc,@+5
 sub  e
 add  a,d
 inc  c
 endr
 ret
;--------------------------------------------------------
SECTION  "multimedia",data[$4000]
sintab:
 include "sincos.asm"
MyFnt:                           ; must to be /256
 db $00,$00,$00,$00,$00,$04,$00
 db $00,$6C,$A4,$A4,$A4,$CE,$00
 db $00,$CE,$22,$E6,$82,$EE,$00
 db $80,$8E,$A8,$EE,$22,$2C,$00
 db $00,$6E,$82,$E4,$A4,$C8,$08
 db $00,$66,$AA,$4E,$A2,$CC,$00
 db $04,$0A,$4A,$0E,$08,$46,$00
 db $00,$6C,$AA,$AC,$EA,$AE,$20
 db $00,$6C,$8A,$8A,$8A,$EE,$00
 db $00,$EE,$88,$CC,$88,$E8,$08
 db $02,$EA,$8A,$AE,$AA,$EA,$08
 db $42,$00,$42,$42,$42,$4E,$00
 db $88,$A8,$A8,$C8,$A8,$AE,$20
 db $80,$AC,$EA,$EA,$AA,$AA,$22
 db $00,$CC,$AA,$AA,$AE,$68,$08
 db $00,$EE,$AA,$AC,$AA,$EA,$22
 db $00,$6E,$84,$E4,$24,$C4,$04
 db $82,$AA,$AA,$AA,$AA,$E4,$00
 db $82,$AA,$AA,$E4,$EA,$AA,$28
 db $80,$AE,$A2,$E4,$28,$EE,$00
 include "music/player.gsm"
MusicOne:
 incbin  "music/music.bin"
 include "music/mus_vars.h"
 include "gfx/gbdevs.z80"
 include "gfx/dimens.z80"
TTable:
 db $cc,$dc,$ec,$fc ; 7
 db $c0,$d0,$e0,$f0 ; 4
 db $84,$94,$a4,$b4 ; 1
 db $c4,$d4,$e4,$f4 ; 5
 db $80,$90,$a0,$b0 ; 0
 db $8c,$9c,$ac,$bc ; 3
 db $c8,$d8,$e8,$f8 ; 6
 db $88,$98,$a8,$b8 ; 2
 db $cc,$dc,$ec,$fc ; 7
 db $c0,$d0,$e0,$f0 ; 4

GreetinxText:
 db   " CARMODI IS LOST IN UNIVERSE/ HE MUST TO FIND NATIVE EARTH/"
 db   " NEED TO KNOW WHERE/ WHEN/ WHAT THE EARTH/  HERE IS INFINITE"
 db   " WORLDS/ SOME WORLDS IS TOTAL DIFFERENTS/ SOME LIKE TWO DROPS"
 db   " OF WATER/ BUT ALWAYS HERE AT LEAST ONE DETAIL /"
 db   " CONTROL KEYS IN THIS PART: SELECT TO EXIT/ B TO CHANGE PALLETE/"
 db   " A TO SELECT CUBE/ HEXAEDR OR TETRAEDR/"
 db   " CURSOR KEYS TO CHANGE SCY AND SCX REGISTERS/ START TO STOP"
 db   " LCD SCROLL/ "
 db   " AND NOW SOME WORDS ABT ACTION YOU SEE ON LCD:"
 db   " IT WORKS IN 60 FPS/ YES/ ITS REAL REALTIME"
 db   " HERE ONE PT2 MUSIC/ 21 OBJECTS SCROLL AND"
 db   " FULL SCREEN BG MOTION/ HERE NO STACK PERVERSIONS/ BUT TURBO IS ON/"
 db   " WHO CAN MAKE BETTER///"
 db   " SOME WORDS ABT MUSIC YOU HEAR NOW: IT WROTE FOR ENLIGHT96 BY SLASH ON SPECCY/"
 db   " IT CALLED LOVE/ PLAYER MADE BY FREEMAN AND LITTLE CORRECTED BY ME/"
 db   " OK NOW YOU CAN PRESS SELECT                         "
 db   " WELL/ I HAVE PLENTY OF FREE SPACE SO MAYBE SOME BLABLAH///"
 db   " MAYBE ABT MUSIC I LIKE///   I LIKE KINO/NAUTILUS/CREMATORIY/DDT"
 db   " ITS RUSSIAN ROCKBANDS/ ALSO I LIKE CLASSIC MUSIC LIKE BACH/ HANDEL/"
 db   " VIVALDI/   HEY/ ARS/ SEND MAIL TO ME RIGHT NOW AND SPEACK:"
 db   " 4TO TY DUMAECH OB ETOJ FIGNE///         "
 db   $ff
FinalWords:
 db   22,8,$10
 db   "FINAL WORDS OF WISDOM:                  "
 db   " THANK YOU FOR PATIENCE AND WATCHING    "
 db   "NOW SOME GREETINX TO SOME PEOPLE ON     "
 db   "GAMEBOY AND SPECCY SCENE:               "
 db   "  QUANG/THANK YOU FOR COMPETENTION      "
 db   "  ARS/THANK YOU FOR IDEA FROM LEMMINGS  "
 db   "  FREEMAN/THANK YOU FOR NICE PT2 PLAYER "
 db   "  KVA/THANK YOU FOR SOURCE OF CONVERTER "
 db   "  SLASH/THANK YOU FOR NICE TUNE         "
 db   "  DSC/THANK YOU FOR ALL/LANDSCAPE COMING"
 db   "  PAN/THANK YOU FOR SOME MACROS FROM YOU"
 db   "  JIM BAGLEY/THANK YOU FOR ANSWERS/     "
 db   "  DARKFADER/THANK YOU FOR CUBE RAIDER   "
 db   "  DOX/YOU ARE THE REAL GREAT CODER      "
 db   "  BLACKBOX/MUSICBOX FOR MAZOHIST ONLY   "
 db   "  HITMEN/BITTE 8 BITS IS THE GREAT      "
 db   "CONTACTS:                               "
 db   " GOBUZOV@PISEM.NET OR GOBUZOV@YAHOO.COM "
 db   $ff
;
FirstNote:
 db   22,40,$60      ; at
 db   16,0           ; attr
 db   17,0           ; | tile bank
 dw   $8000+53*16    ; | tile addres
; db   19,0,4         ; PalMark,IndexPal,How many bytes of colors
; RGBSet  0, 0, 0
; RGBSet 31,31,31
 db   "ORIGINAL NOVEL: ROBERT SHECKLEY"
 db   13,"GAMEBOY INTERPRETATION: AGO"
 db   13,"NO PACKED/PRECALCULATED DATA"
 db   13,"ALL STUFF THAT YOU WILL SEE"
 db   13,"ITS A REALTIME PURE ASM CODING",$ff
snowPal:
 RGBSet  0, 0, 0
 RGBSet  0, 4,31
 RGBSet 31,31,31
 RGBSet 13,22,26


;
 db " the end"