; i use hiram (memory since $ff80->fffe),; when need fast access to often used 
; vars (for example in math part). It's speed optimization.
; Because ldio a,[$nn] occures only 3 tacts, but ld a,[nn] 4 tacts. 

;----------- additional registers (mainly for DMA)
SecondPartDMA equ $ff80
RenderingEnd  equ $ff81

;-------------
wbuf         equ $ff82
brezTemp     equ $ff83
brezColor    equ $ff84

kosuha_d     equ $ff85
kosuha_d1    equ kosuha_d+1
kosuha_d2    equ kosuha_d+2
kosuha_x     equ kosuha_d+3 
kosuha_dx    equ kosuha_d+4
kosuha_dy    equ kosuha_d+5
nPoints      equ kosuha_d+6
nTriangles   equ kosuha_d+7
nSurfaces    equ kosuha_d+8
nPointsTmp   equ kosuha_d+9
nTrianglesTmp equ kosuha_d+10
nSurfacesTmp equ kosuha_d+11
RighTriMask  equ kosuha_d+12
EdgeBufLow   equ kosuha_d+13
currentColor equ kosuha_d+14
Tridy        equ kosuha_d+15
TriStart     equ kosuha_d+16
HiTemp1      equ kosuha_d+17
HiTemp2      equ kosuha_d+18

;----------- math part, uses 23 bytes of hiram
wp    equ kosuha_d+19   ; work Matrix [M]
vp    equ wp+9          ; work vector [x]
nvp   equ vp+3          ; new vector  [x']=[M]*[x]
tp    equ nvp+3         ; temporary matrix,when makes [T]=[Mx]*[My]*[Mz]
;---------------------------------------------
