; macros.inc

WaitHRAM: MACRO
	ldh	a,[rSTAT]
	and	3
	jr	nz,@-4
	ENDM

WaitVRAM: MACRO
        ldh     a,[rSTAT]       ; <---+
        and     2      ;     |
        jr      nz,@-4          ; ----+
        ENDM

SelBank:	MACRO
	ld	a,BANK(\1)
	ld	[$2000],a
	ENDM

incDB:	MACRO
	ld	a,[\1]
	inc	a
	ld	[\1],a
	ENDM

decDB:	MACRO
	ld	a,[\1]
	dec	a
	ld	[\1],a
	ENDM

ldHLBC:	MACRO
	ld	h,b
	ld	l,c
	ENDM

ldBCHL:	MACRO
	ld	b,h
	ld	c,l
	ENDM

addDBnum:	MACRO
	ld	a,[\1]
	add	\2
	ld	[\1],a
	ENDM

subDBnum:	MACRO
	ld	a,[\1]
	sub	\2
	ld	[\1],a
	ENDM

subHLBC:	MACRO
	ld	a,l
	sub	c
	jr	nc,@+3
	dec	h
	ld	l,a
	ld	a,h
	sub	b
	ld	h,a
	ENDM

subHLDE:	MACRO
	ld	a,l
	sub	e
	jr	nc,@+3
	dec	h
	ld	l,a
	ld	a,h
	sub	d
	ld	h,a
	ENDM

subHLnum:	MACRO
	ld	a,l
	sub	\2
	jr	nc,@+3
	dec	h
	ld	l,a
	ld	a,h
	sub	\1
	ld	h,a
	ENDM

subHLdw:	MACRO
	ld	a,[\1]
	ld	b,a
	ld	a,[\1+1]
	ld	c,a
	subHLBC
	ENDM

addHLdw:	MACRO
	ld	a,[\1]
	ld	b,a
	ld	a,[\1+1]
	ld	c,a
	add	hl,bc
	ENDM

ldHLdw:	MACRO
	ld	a,[\1]
	ld	h,a
	ld	a,[\1+1]
	ld	l,a
	ENDM

ldBCdw:	MACRO
	ld	a,[\1]
	ld	b,a
	ld	a,[\1+1]
	ld	c,a
	ENDM

ldDEdw:	MACRO
	ld	a,[\1]
	ld	d,a
	ld	a,[\1+1]
	ld	e,a
	ENDM

slaHL:	MACRO
	sla	h
	sla	l
	jr	nc,@+3
	inc	h
	ENDM

slaBC:	MACRO
	sla	b
	sla	c
	jr	nc,@+3
	inc	b
	ENDM

slaDE:	MACRO
	sla	d
	sla	e
	jr	nc,@+3
	inc	d
	ENDM

negHL:	MACRO
	ld	a,h
	cpl
	ld	h,a
	ld	a,l
	cpl
	ld	l,a
	inc	hl
	ENDM

negBC:	MACRO
	ld	a,b
	cpl
	ld	b,a
	ld	a,c
	cpl
	ld	c,a
	inc	bc
	ENDM

negDE:	MACRO
	ld	a,d
	cpl
	ld	d,a
	ld	a,e
	cpl
	ld	e,a
	inc	de
	ENDM

negA:	MACRO
	cpl
	inc	a
	ENDM

negB:	MACRO
	ld	a,b
	cpl
	inc	a
	ld	b,a
	ENDM

negC:	MACRO
	ld	a,c
	cpl
	inc	a
	ld	c,a
	ENDM

negD:	MACRO
	ld	a,d
	cpl
	inc	a
	ld	d,a
	ENDM

negE:	MACRO
	ld	a,e
	cpl
	inc	a
	ld	e,a
	ENDM

negH:	MACRO
	ld	a,h
	cpl
	inc	a
	ld	h,a
	ENDM

negL:	MACRO
	ld	a,l
	cpl
	inc	a
	ld	l,a
	ENDM

addBCnum:	MACRO
	push	hl
	ld	h,b
	ld	l,c
	ld	bc,\1
	add	hl,bc
	ld	b,h
	ld	c,l
	pop	hl
	ENDM

addDEnum:	MACRO
	push	hl
	ld	h,d
	ld	l,e
	ld	de,\1
	add	hl,de
	ld	d,h
	ld	e,l
	pop	hl
	ENDM

addHLnum:	MACRO
	push	de
	ld	d,h
	ld	e,l
	ld	hl,\1
	add	hl,de
	pop	de
	ENDM

cpHLBC:	MACRO
	push	de
	ld	e,0
	ld	a,h
	cp	b
	jr	c,.g\@
	jr	nz,.end\@
	ld	a,l
	cp	c
	jr	z,.e\@
	jr	nc,.end\@
.g\@	ld	e,%00010000
	jr	.end\@
.e\@	ld	e,%10000000
.end\@	push	de
	pop	af
	pop	de
	ENDM


cpBCDE:	MACRO
	push	hl
	ld	l,0
	ld	a,b
	cp	d
	jr	c,.g\@
	jr	nz,.end\@
	ld	a,c
	cp	e
	jr	z,.e\@
	jr	nc,.end\@
.g\@	ld	l,%00010000
	jr	.end\@
.e\@	ld	l,%10000000
.end\@	push	hl
	pop	af
	pop	hl
	ENDM

