;  Borrowed from MagicKit.. Thanks, guys!
; SLIDSHOW.ASM
;
; Split Resolution Demo by Chris Covell
; Yeah, all routines are spread out in only 1 assembly file.  It's horrible
; but this isn't a super professional demo anyway.  Enjoy!

_xres	.equ 256	; set this before including 'startup.asm'
			; that will set up a 320x240 screen in place
			; of the default 256x240 screen

	.include "startup.asm"
	.nomlist
	.list

; ----
; defines

NB_PICS	.equ 1		; the number of pictures in the slideshow
SATB_BASE	.equ $7F00
SPRITE_BASE	.equ $6000
BOING		.equ SPRITE_BASE
PANEL_SPR	.equ BOING+$1000
TEXT_SPR	.equ BOING+$1C00

LIGHT_ON	.equ $0038	;Palette value for lit...
LIGHT_OFF	.equ $FFFF	;...and unlit option "lights".

BALLMIN_X	.equ $001D
BALLMIN_Y	.equ $0040	;Minima for ball sprite.
BALLMAX_X	.equ $01A8
BALLMAX_Y	.equ $00B9	;Maxima for ball sprite.
BALLSPD_X	.equ $0001
BALLSPD_Y	.equ $0002	;Speed for ball movement.
PANEL_INIT_X	.equ $0028
PANEL_INIT_Y	.equ $0048
PAN_DELAY	.equ $0380	;Delay before hiding panel.

SCROLLINIT_1_X	.equ $0000	;Initial X scroll
SCROLLINIT_2_X	.equ $0040
SCROLLINIT_3_X	.equ $0080
SCROLLINIT_1_Y	.equ $0000
SCROLLINIT_2_Y	.equ $0000
SCROLLINIT_3_Y	.equ $0000

; ----
; variables

	.zp
vbpassed	.ds 1
region_num	.ds 1	;0 = first region, 2 = second, 4 = third
vce_copy	.ds 2	;A soft copy of $0400 (VCE register)
interlace_on	.ds 1	;1 = on (for HSync routine use)
scroll_1_x	.ds 2
scroll_2_x	.ds 2
scroll_3_x	.ds 2
scroll_1_y	.ds 2	;Scroll settings for all 3 regions
scroll_2_y	.ds 2
scroll_3_y	.ds 2
splitpos_1	.ds 2	;Scanline to start the 2nd, 3rd split...
splitpos_2	.ds 2
splitpos_3	.ds 2
reso_1		.ds 2	;Resolution for 1st region (1=256, 2=320, 3=512)
reso_2		.ds 2	;for 2nd and 3rd region 0 = no change!
reso_3		.ds 2
interlace_1	.ds 2
interlace_2	.ds 2
interlace_3	.ds 2

; Soft copy of the palette!!!!!
pal_region1	.ds 2
pal_region2	.ds 2
pal_region3	.ds 2
pal_blank	.ds 2	;The sprite colour index 0!
pal_1_lores	.ds 2
pal_1_medres	.ds 2
pal_1_hires	.ds 2
pal_2_lores	.ds 2
pal_2_medres	.ds 2
pal_2_hires	.ds 2
pal_3_lores	.ds 2
pal_3_medres	.ds 2
pal_3_hires	.ds 2
pal_1_laceevn	.ds 2
pal_1_laceodd	.ds 2
pal_2_laceevn	.ds 2
pal_2_laceodd	.ds 2
pal_3_laceevn	.ds 2
pal_3_laceodd	.ds 2
;----------------------- soft copy
panelpos_x	.ds 2
panelpos_y	.ds 2
panel_delay	.ds 2

pic:	.ds  1		; the current picture number
vbtimer	.ds  1
vbtimer2 .ds 1
scanline .ds 2
currscroll_x .ds 2
currscroll_y .ds 2
dirflag_x	.ds 1	; used to remember in which direction the ball moves
dirflag_y	.ds 1
sx	.ds 2	; the sprite coordinates
sy	.ds 2
pal_idx .ds 2
flicker_line	.ds 2


	.bss
y_idx   .ds 2   ; index in the y coordinate table (0-63)
cnt	.ds 1	; counter used for loops;
ball_x .ds 2
ball_y .ds 2
top_x .ds 2
top_y .ds 2

block_ram .ds 16

satb	.ds 512	; the local SATB

;[ MAIN CODE ]

	.code
	.bank MAIN_BANK
	.org  $C000
main:
	jsr	Copy_Instructions_To_RAM
	stz	<vbtimer
	stz	<vbtimer2
	stz	<pic
	stz	<scanline
	stz	<vbpassed

	stz	<region_num	;Region 0 first
	stz	<interlace_on	;No interlacing

	stw	#PAN_DELAY,<panel_delay		;Set the delay!
	stw	#SCROLLINIT_1_X,<scroll_1_x	;Init scrolling.
	stw	#SCROLLINIT_2_X,<scroll_2_x
	stw	#SCROLLINIT_3_X,<scroll_3_x
	stw	#SCROLLINIT_1_Y,<scroll_1_y
	stw	#SCROLLINIT_2_Y,<scroll_2_y
	stw	#SCROLLINIT_3_Y,<scroll_3_y
	stw	#$FFFF,<splitpos_1	;not needed.  (?)
	stw	#$0090,<splitpos_2
	stw	#$00E0,<splitpos_3
	stw	#$0003,<reso_1	;512 horiz
	stw	#$0002,<reso_2	;320 horiz
	stw	#$0001,<reso_3	;256 horiz
	stwz	<interlace_1		;Lacing OFF!
	stwz	<interlace_2
	stwz	<interlace_3
	stwz	<flicker_line

	stw	#PANEL_INIT_X,<panelpos_x
	stw	#PANEL_INIT_Y,<panelpos_y

	stz	<dirflag_x
	stz	<dirflag_y
	lda	#$1C
	sta	<pal_idx
	stz	<pal_idx+1

	; disable display

	vreg  #5
	lda   #$00
	sta   $0002
	stz   $0003

	; load the picture in VRAM

	st0	#$9	;Memory Access Width Register
	st1	#%01010000	;64x64 BG map!
	st2	#$00
;-----------------------
	jsr	load_pic
	jsr	Setup_Sprite

	jsr	xres_512

	stwz	scroll_1_x
	stw	#$0000,currscroll_y

	setcolor #256,0,0,0
	
	; enable display

	vec_off #VSYNC
	vec_off #HSYNC

	st0   #6		; restart the scanline counter on the first
	stw   #$40,video_data	; line
	stw   #$40,<scanline

	setvec #VSYNC,vsync_proc
	vec_on #VSYNC
	setvec #HSYNC,hsync_proc
	vec_on #HSYNC

	vreg  #5
	lda   #%11001100
	sta   $0002
	stz	$0003

.wait:	bbr0	<vbpassed,.wait		;wait until NMI passes.
	jsr	Test_Joypad
	jsr	Update_Panel_Colours
	jsr	Check_Panel_Delay

;	lda	<vbtimer
;	and	#$0F
;	cmp	#$0F
;	bne	.no_inc_scrolling
;	incw	scroll_1_x
;.no_inc_scrolling:

	stz	<vbpassed
	bra	.wait


vsync_proc:
	st0   #6		; restart the scanline counter on the first
	stw   #$40,video_data	; line
	stw   #$40,<scanline
;	stwz	currscroll_x
	st0   #7
	stw	<scroll_1_x,<currscroll_x
	stw	<currscroll_x,video_data
	jsr	Flicker_VCE
	clx
	jsr	Change_H_Resolutions
	clx
	jsr	Write_Y_Scroll
	jsr	Move_Boing_Sprite
	jsr	Update_Satb_BLOCKTRANSFER
	
;	bbr0	<vbtimer,.no_cycle_cols
	jsr	Cycle_Colours
.no_cycle_cols:
	jsr	Write_Panel_Colours
	lda	#$01
	sta	<vbpassed
	inc	<vbtimer
	rts
;===================================================

hsync_proc:
	cmpw	<splitpos_2,<scanline	;Check split 2!
	bne	.no_region_2
	lda	<reso_2		;What's the resolution?
	beq	.no_change_h_reso_2	;If 0, no change.
	ldx	#$02
	jsr	Change_H_Resolutions
	st0   #7
	stw	<scroll_2_x,<currscroll_x
	stw	<currscroll_x,video_data
	ldx	#$02
	jsr	Write_Y_Scroll
.no_change_h_reso_2:
	jmp	.inc_scanline

;-------------------------
.no_region_2:
	cmpw	<splitpos_3,<scanline
	bne	.no_region_3
	lda	<reso_3		;What's the resolution?
	beq	.no_change_h_reso_3	;If 0, no change.
	ldx	#$04
	jsr	Change_H_Resolutions
	st0   #7
	stw	<scroll_3_x,<currscroll_x
	stw	<currscroll_x,video_data
	ldx	#$04
	jsr	Write_Y_Scroll
.no_change_h_reso_3:
	jmp	.inc_scanline

;-------------------------
.no_region_3:
	cmpw	#$0130,<scanline
	bne	.no_region_4
	jsr	xres_512
	jmp	.inc_scanline
.no_region_4:


.inc_scanline:
	incw	<currscroll_y
	bbr0	<interlace_on,.no_scale_scanline
	incw	<currscroll_y
	st0   #8
	stw	<currscroll_y,video_data
.no_scale_scanline:
	st0   #6
	incw  <scanline
	stw   <scanline,video_data
	rts


;[ SUB CODE ]

Write_Y_Scroll:
	incw  <scanline		;Add a scanline for delay purposes!!!
;-------------
	stz	<interlace_on	;Interlacing is on!
	lda	<interlace_1,X	;Get interlacing value first...
	beq	.no_add_interlace_line	;Do nothing if 0.
	inc	<interlace_on	;Interlacing is on!
	lsr	a		;If interlacing =2, add 1 scanline.
	eor	vbtimer		;Blend with the even/odd scanline
	and	#$01		;Restrict to 0/1.
.no_add_interlace_line:
	clc	;+adc!!!
	adc	<scroll_1_y,X	;Add Y-scroll for the correct region
	sta	currscroll_y
	lda	<scroll_1_y+1,X	;Get Y-scroll for the correct region
	adc	#$00
	sta	currscroll_y+1
	st0   #8		;Now write Y
	stw	currscroll_y,video_data
	rts


Flicker_VCE:
;---------------- modify the "241/240-line" bit.
	lda	<interlace_1
	bne	.int_modify_VCE
	lda	<interlace_2
	bne	.int_modify_VCE
	lda	<interlace_3
	bne	.int_modify_VCE
	bra	.no_modify_VCE
.int_modify_VCE:
	lda	vbtimer
	asl	a
	asl	a
	and	#%00000100	;isolate "blurring bit"
	sta	<flicker_line	;Put this bit somewhere...
.no_modify_VCE:
;-----------------------------------
	rts

Change_H_Resolutions:
	lda	<reso_1,X	;Get resolution for the correct region
	asl	a		;Mult by 2!
	tax
	jmp	[hres_jump,X]
	rts
hres_jump: .dw _reset,xres_256,xres_320,xres_512
;--------------
;--------------

Check_Panel_Delay:
	cmpw	#$0000,<panel_delay	;Is the delay at 0?
	bne	.no_move_panel		;If not, don't move at all
	cmpw	#$FFE3,<panelpos_x	;Is the panel nearly off-screen?
	beq	.pan_del_end		;If so, end!
	decw	<panelpos_x		;Otherwise, slide panel off-screen.
	bra	.pan_del_end
.no_move_panel:
	decw	<panel_delay
.pan_del_end:
	rts



Write_Panel_Colours:
	stw	#$011D,$0402	;Set palette write add. to Pal #2 arrows!
	tia	pal_region1,$0404,$0026	;Write to VCE
	rts

Update_Panel_Colours:
	stw	#LIGHT_OFF,pal_region1
	tii	pal_region1,pal_region2,$0024	;Clear palette
	ldx	<region_num
	lda	#low(LIGHT_ON)
	sta	<pal_region1,X
	lda	#high(LIGHT_ON)	     ;This is as straightforward as it'll get!
	sta	<pal_region1+1,X

;------------------ WRITE RESOLUTION PALETTES!!!
	lda	<reso_1			;(Should be 1,2,3)
	beq	.no_colour_reso_1	;If it's 0, don't write anything
	dec	a			;(Should be 0,1,2
	asl	a			;(Should be 0,2,4)
	tax
	lda	#low(LIGHT_ON)
	sta	<pal_1_lores,X
	lda	#high(LIGHT_ON)
	sta	<pal_1_lores+1,X
.no_colour_reso_1:
	lda	<reso_2			;(Should be 0,1,2,3)
	beq	.no_colour_reso_2	;If it's 0, don't write anything
	dec	a			;(Should be 0,1,2
	asl	a			;(Should be 0,2,4)
	tax
	lda	#low(LIGHT_ON)
	sta	<pal_2_lores,X
	lda	#high(LIGHT_ON)
	sta	<pal_2_lores+1,X
.no_colour_reso_2:
	lda	<reso_3			;(Should be 0,1,2,3)
	beq	.no_colour_reso_3	;If it's 0, don't write anything
	dec	a			;(Should be 0,1,2
	asl	a			;(Should be 0,2,4)
	tax
	lda	#low(LIGHT_ON)
	sta	<pal_3_lores,X
	lda	#high(LIGHT_ON)
	sta	<pal_3_lores+1,X
.no_colour_reso_3:

;------------------ WRITE INTERLACING PALETTES!!!
	lda	<interlace_1		;(Should be 0,1,2)
	beq	.no_colour_lace_1	;If it's 0, don't write anything
	dec	a			;(Should be 0,1)
	asl	a			;(Should be 0,2)
	tax
	lda	#low(LIGHT_ON)
	sta	<pal_1_laceevn,X
	lda	#high(LIGHT_ON)
	sta	<pal_1_laceevn+1,X
.no_colour_lace_1:
	lda	<interlace_2		;(Should be 0,1,2)
	beq	.no_colour_lace_2	;If it's 0, don't write anything
	dec	a			;(Should be 0,1)
	asl	a			;(Should be 0,2)
	tax
	lda	#low(LIGHT_ON)
	sta	<pal_2_laceevn,X
	lda	#high(LIGHT_ON)
	sta	<pal_2_laceevn+1,X
.no_colour_lace_2:
	lda	<interlace_3		;(Should be 0,1,2)
	beq	.no_colour_lace_3	;If it's 0, don't write anything
	dec	a			;(Should be 0,1)
	asl	a			;(Should be 0,2)
	tax
	lda	#low(LIGHT_ON)
	sta	<pal_3_laceevn,X
	lda	#high(LIGHT_ON)
	sta	<pal_3_laceevn+1,X
.no_colour_lace_3:

	rts

Cycle_Colours:
	stw	#Cycle_Pal,block_ram+1	;Save to source...
	addw	<pal_idx,block_ram+1
	stw	#$0102,$0402	;Set palette write address
	jsr	block_ram	;Sets palette!
	dec	<pal_idx
	dec	<pal_idx
	lda	<pal_idx
	bne	.no_reset_cycle
	lda	#$1C
	sta	<pal_idx
.no_reset_cycle:
	rts

Cycle_Pal:	.incpal "BoingPal.pcx",0,2

Copy_Instructions_To_RAM:
	clx
.copy_insts:
	lda	.instructions_hard,X
	sta	block_ram,X
	inx
	cpx	#$0C
	bne	.copy_insts
	rts
;------------------- SOFT INSTRUCTIONS! -----------------------
; These instructions go in RAM and can be modified.
.instructions_hard:	tia	Cycle_Pal,$0404,$001C
	rts

xres_256:
	lda	#%00000000	;Hmmmm... It seems like a good idea
	ora	<flicker_line	;Add flicker, if present.
	sta	$0400		;To write to $0400 FIRST!
;	sta	<vce_copy
	st0	#$0A		;THEN change the VDC settings!
	st1	#$02		;Otherwise, there is BAD glitching!
	st2	#$02
	st0	#$0B
	st1	#$1F
	st2	#$04
	rts

xres_320:
	lda	#%00000001
	ora	<flicker_line	;Add flicker, if present.
	sta	$0400
;	sta	<vce_copy
	st0	#$0A
	st1	#$02
	st2	#$04
;	stw	#$0402,video_data
	st0	#$0B
	st1	#$2A
	st2	#$04
;	stw	#$042A,video_data
;	st0	#$0A
;	st1	#$02
;	st2	#$05
;	st0	#$0B
;	st1	#$27
;	st2	#$04
	rts

xres_512:
	lda	#%00000010
	ora	<flicker_line	;Add flicker, if present.
	sta	$0400
;	sta	<vce_copy
	st0	#$0A
	st1	#$02
	st2	#$0B
	st0	#$0B
	st1	#$3F
	st2	#$04
	rts

Update_Satb_BLOCKTRANSFER:
	stw   #SATB_BASE,<_di	;Default SATB location
	jsr	set_write	;Load up into latch
	tia   satb,$0002,$0200	;BLOCK TRANSFER INSTRUCTION!
				;Block transfer 512 bytes...
				;from RAM to VRAM thru $0002!
			;MUCH more efficient than the MagicKit code!
	rts

; ----
; load_pic
; ----
; upload a whole pic in VRAM
; ----

load_pic:
	map	Split_Gfx1
	vload	Split_Gfx1,#$1000	;$2000 bytes ($1000 words)
	map	Split_Gfx2
	vload	Split_Gfx2,#$1000	;$2000 bytes ($1000 words)
	map	Split_Gfx3
	vload	Split_Gfx3,#$1000	;$2000 bytes ($1000 words)
	map	Split_Gfx4
	vload	Split_Gfx4,#$1000	;$2000 bytes ($1000 words)
	map	Split_Gfx5
	vload	Split_Gfx5,#$1000	;$2000 bytes ($1000 words)
	; now set the palette

	map	Split_Pal
	set_bgpal #0,Split_Pal,#5
	set_sprpal #0,Boing_Pal,#4

	map	Split_Map
	; and finaly copy the BAT
	batcpy $0000,#64,Split_Map,#64,#64	;512x512 image.
	; ok, done

	rts

Setup_Sprite:
	load_sprites BOING,Boing_Sprite,#8
	load_sprites PANEL_SPR,Panel_Sprite,#8
	load_sprites TEXT_SPR,Text_Sprite,#1
	init_satb satb

	stw	#BALLMIN_X,ball_x
	stw	#BALLMIN_Y,ball_y

;----------------------------- TEXT SPRITE (3x1 sprites)
	spr_set #$01,satb
		lda   #LOW((TEXT_SPR) >> 5)
		sta   <_di
		lda   #HIGH((TEXT_SPR) >> 5)
		sta   <_di+1		;Point to sprites.  What shite!
	spr_pattern _di
	stw	#$23,sx
	stw	#$118,sy
	spr_x sx
	spr_y sy
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_32x16|NO_FLIP
	spr_pri   #1
	spr_pal   #3

	addw	#$0004,<_di
	spr_set #$02,satb
	spr_pattern _di
	addw	#$20,sx
	spr_x sx
	spr_y sy
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_32x16|NO_FLIP
	spr_pri   #1
	spr_pal   #3

	addw	#$0004,<_di
	spr_set #$03,satb
	spr_pattern _di
	addw	#$20,sx
	spr_x sx
	spr_y sy
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_32x16|NO_FLIP
	spr_pri   #1
	spr_pal   #3
;-------------------------------- Scanline pointer sprites!!!
;	addw	#$0004,<_di
;	spr_set #$3E,satb
;	stw	#$20,sx
;	spr_x sx
;	spr_pattern _di
;	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_16x16|NO_FLIP
;	spr_pri   #1
;	spr_pal   #3
;
;	addw	#$0002,<_di
;	spr_set #$3F,satb
;	spr_x sx
;	spr_pattern _di
;	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_16x16|NO_FLIP
;	spr_pri   #1
;	spr_pal   #3

;----------------------------- BOING BALL (4x2 sprites)
	spr_set #$10,satb
		lda   #LOW((BOING) >> 5)
		sta   <_di
		lda   #HIGH((BOING) >> 5)
		sta   <_di+1		;Point to sprites.  What shite!
	spr_pattern _di
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_32x64|NO_FLIP
	spr_pri   #1
	spr_pal   #0

	addw	#$0010,<_di
	spr_set #$11,satb
	spr_pattern _di
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_32x64|NO_FLIP
	spr_pri   #1
	spr_pal   #0

	addw	#$0010,<_di
	spr_set #$12,satb
	spr_pattern _di
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_32x64|NO_FLIP
	spr_pri   #1
	spr_pal   #0

	addw	#$0010,<_di
	spr_set #$13,satb
	spr_pattern _di
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_32x64|NO_FLIP
	spr_pri   #1
	spr_pal   #0

	addw	#$0010,<_di
	spr_set #$14,satb
	spr_pattern _di
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_32x64|NO_FLIP
	spr_pri   #1
	spr_pal   #0

	addw	#$0010,<_di
	spr_set #$15,satb
	spr_pattern _di
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_32x64|NO_FLIP
	spr_pri   #1
	spr_pal   #0

	addw	#$0010,<_di
	spr_set #$16,satb
	spr_pattern _di
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_32x64|NO_FLIP
	spr_pri   #1
	spr_pal   #0

	addw	#$0010,<_di
	spr_set #$17,satb
	spr_pattern _di
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_32x64|NO_FLIP
	spr_pri   #1
	spr_pal   #0

;------------------------------ CONTROL PANEL (2x2 sprites)
	addw	#$0010,<_di
	spr_set #$1A,satb
	spr_pattern _di
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_32x64|NO_FLIP
	spr_pri   #1
	spr_pal   #1

	addw	#$0010,<_di
	spr_set #$1B,satb
	spr_pattern _di
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_32x64|NO_FLIP
	spr_pri   #1
	spr_pal   #1

	addw	#$0010,<_di
	spr_set #$1C,satb
	spr_pattern _di
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_32x64|NO_FLIP
	spr_pri   #1
	spr_pal   #1

	addw	#$0010,<_di
	spr_set #$1D,satb
	spr_pattern _di
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_32x64|NO_FLIP
	spr_pri   #1
	spr_pal   #1

;------------------------------ COLOURED TEXT (2x1 sprites)
	addw	#$0010,<_di
	spr_set #$18,satb
	spr_pattern _di
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_32x64|NO_FLIP
	spr_pri   #1
	spr_pal   #2

	addw	#$0010,<_di
	spr_set #$19,satb
	spr_pattern _di
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_32x64|NO_FLIP
	spr_pri   #1
	spr_pal   #2
;-------------------------
	jsr	Position_Boing_Sprite
	jsr	Position_Panel_Sprites
	jsr	Update_Satb_BLOCKTRANSFER
	rts

Position_Panel_Sprites:
	stw	panelpos_x,sx
	stw	panelpos_y,sy
	spr_set #$1A,satb
	spr_x sx
	spr_y sy
	addw	#$20,sx
	spr_set #$1B,satb
	spr_x sx
	spr_y sy
	subw	#$20,sx
	addw	#$40,sy
	spr_set #$1C,satb
	spr_x sx
	spr_y sy
	addw	#$20,sx
	spr_set #$1D,satb
	spr_x sx
	spr_y sy
	subw	#$20,sx
;	addw	#$40,sy
	spr_set #$18,satb
	spr_x sx
	spr_y sy
	addw	#$20,sx
	spr_set #$19,satb
	spr_x sx
	spr_y sy
	rts


Position_Boing_Sprite:
	stw	ball_x,sx
	stw	ball_y,sy
	spr_set #$10,satb
	spr_x sx
	spr_y sy
	addw	#$20,sx
	spr_set #$11,satb
	spr_x sx
	spr_y sy
	addw	#$20,sx
	spr_set #$12,satb
	spr_x sx
	spr_y sy
	addw	#$20,sx
	spr_set #$13,satb
	spr_x sx
	spr_y sy
	subw	#$60,sx
	addw	#$40,sy
	spr_set #$14,satb
	spr_x sx
	spr_y sy
	addw	#$20,sx
	spr_set #$15,satb
	spr_x sx
	spr_y sy
	addw	#$20,sx
	spr_set #$16,satb
	spr_x sx
	spr_y sy
	addw	#$20,sx
	spr_set #$17,satb
	spr_x sx
	spr_y sy
	rts

;Position_Scanline_Sprites:
;	stw	<splitpos_2,sy
;	subw	#$04,sy
;	spr_set #$3E,satb
;	spr_y sy
;	stw	<splitpos_3,sy
;	subw	#$04,sy
;	spr_set #$3F,satb
;	spr_y sy
;	rts

Move_Boing_Sprite:	;Bounce the ball around the screen.
	bbs0	<dirflag_x,.backwards_x		;If 1, move backwards.
	addw	#BALLSPD_X,ball_x		;Add X speed
	cmpw	#BALLMAX_X,ball_x		;If exceeded limit!
	bcs	.set_x_neg
	bra	.mov_x_end			;Done
.set_x_neg:
	lda	#$01
	sta	<dirflag_x
	stw	#BALLMAX_X,ball_x		;Set it to the limit.
	bra	.mov_x_end
.backwards_x:
	subw	#BALLSPD_X,ball_x		;Sub X speed
	cmpw	#BALLMIN_X,ball_x		;If below limit!
	bcc	.set_x_pos
	bra	.mov_x_end			;Done
.set_x_pos:
	stz	<dirflag_x
	stw	#BALLMIN_X,ball_x		;Set it to the limit.
	bra	.mov_x_end
;----------------------
.mov_x_end:
	bbs0	<dirflag_y,.backwards_y		;If 1, move backwards.
	addw	#BALLSPD_Y,ball_y		;Add Y speed
	cmpw	#BALLMAX_Y,ball_y		;If exceeded limit!
	bcs	.set_y_neg
	bra	.mov_y_end			;Done
.set_y_neg:
	lda	#$01
	sta	<dirflag_y
	stw	#BALLMAX_Y,ball_y		;Set it to the limit.
	bra	.mov_y_end
.backwards_y:
	subw	#BALLSPD_Y,ball_y		;Sub Y speed
	cmpw	#BALLMIN_Y,ball_y		;If below limit!
	bcc	.set_y_pos
	bra	.mov_y_end			;Done
.set_y_pos:
	stz	<dirflag_y
	stw	#BALLMIN_Y,ball_y		;Set it to the limit.
	bra	.mov_y_end
;----------------------
.mov_y_end:


.Move_Spr_End:
	jsr	Position_Boing_Sprite
	jsr	Position_Panel_Sprites
;	jsr	Position_Scanline_Sprites
	rts
;#######################################################

Test_Joypad:
	tst	#JOY_RIGHT,joytrg	;This is RIGHT
	beq	.NoPushRight
	jsr	Joy_Rt_Routine
.NoPushRight
	tst	#JOY_LEFT,joy		;This is LEFT
	beq	.NoPushLeft
	jsr	Joy_Le_Routine
.NoPushLeft
	tst	#JOY_UP,joy	;This is UP
	beq	.NoPushUp
	jsr	Joy_Up_Routine
.NoPushUp
	tst	#JOY_DOWN,joy	;This is DOWN
	beq	.NoPushDown
	jsr	Joy_Dn_Routine
.NoPushDown
	tst	#JOY_SEL,joy	;This is SELECT
	beq	.NoPushSelect
	jsr	Joy_Se_Routine
.NoPushSelect
	tst	#JOY_RUN,joy	;This is RUN!!!
	beq	.NoPushRun
	jsr	Joy_Rn_Routine
.NoPushRun
	tst	#JOY_II,joytrg	;This is BUTTON II
	beq	.NoPushButII
	jsr	Joy_II_Routine
.NoPushButII
	tst	#JOY_I,joytrg	;This is BUTTON II
	beq	.NoPushButI
	jsr	Joy_I_Routine
.NoPushButI
	rts
;############################

Joy_Rt_Routine:
	stw	#PAN_DELAY,<panel_delay		;Set the delay!
	stw	#PANEL_INIT_X,<panelpos_x
	inc	<region_num	;Increase region
	inc	<region_num
	lda	<region_num
	cmp	#$06
	bne	.NoResetRegion
	stz	<region_num
.NoResetRegion:
	rts

Joy_Le_Routine:
	stw	#PAN_DELAY,<panel_delay		;Set the delay!
	stw	#PANEL_INIT_X,<panelpos_x
	ldx	<region_num	;Region number points to scroll.
	lda	<scroll_1_x,X
	add	#$02			;Increase scroll by 2
	sta	<scroll_1_x,X
	lda	<scroll_1_x+1,X
	adc	#$00
	sta	<scroll_1_x+1,X	
	rts

Joy_Up_Routine:
	stw	#PAN_DELAY,<panel_delay		;Set the delay!
	stw	#PANEL_INIT_X,<panelpos_x
	ldx	<region_num		;Region number points to scroll.
	lda	<scroll_1_y,X
	add	#$01			;Increase scroll by 1
	sta	<scroll_1_y,X
	lda	<scroll_1_y+1,X
	adc	#$00
	sta	<scroll_1_y+1,X	
	rts

Joy_Dn_Routine:
	stw	#PAN_DELAY,<panel_delay		;Set the delay!
	stw	#PANEL_INIT_X,<panelpos_x
	ldx	<region_num
	lda	<scroll_1_y,X
	sub	#$01
	sta	<scroll_1_y,X		;Decrease scroll by 1		
	lda	<scroll_1_y+1,X
	sbc	#$00
	sta	<scroll_1_y+1,X	
	rts

Joy_Se_Routine:
	stw	#PAN_DELAY,<panel_delay		;Set the delay!
	stw	#PANEL_INIT_X,<panelpos_x
	ldx	<region_num		;Region number points to scanline.
	lda	<splitpos_1,X
	sub	#$01			;Decrease split line by 1
	sta	<splitpos_1,X
	lda	<splitpos_1+1,X
	sbc	#$00
	sta	<splitpos_1+1,X	
	rts

Joy_Rn_Routine:
	stw	#PAN_DELAY,<panel_delay		;Set the delay!
	stw	#PANEL_INIT_X,<panelpos_x
	ldx	<region_num		;Region number points to scanline.
	lda	<splitpos_1,X
	add	#$01			;Increase split line by 1
	sta	<splitpos_1,X
	lda	<splitpos_1+1,X
	adc	#$00
	sta	<splitpos_1+1,X	
	rts

Joy_II_Routine:
	stw	#PAN_DELAY,<panel_delay		;Set the delay!
	stw	#PANEL_INIT_X,<panelpos_x
	ldx	<region_num	;Region number points to lacing.
	inc	<interlace_1,X	;Change interlace type
	lda	<interlace_1,X
	cmp	#$03		;(only 0,1,2)
	bne	.no_reset_interlace
	stz	<interlace_1,X
.no_reset_interlace:
	rts

Joy_I_Routine:
	stw	#PAN_DELAY,<panel_delay		;Set the delay!
	stw	#PANEL_INIT_X,<panelpos_x
	ldx	<region_num	;Region number points to resolution.
	inc	<reso_1,X	;Change resolution type
	lda	<reso_1,X
	cmp	#$04		;(only 0,1,2,3)
	bne	.no_reset_resolution
	cla
	cpx	#$00		;If X=0, res can't be "none".
	bne	.no_change_res_for_region_1
	inc	a		;res will be 1.
.no_change_res_for_region_1:
	sta	<reso_1,X
.no_reset_resolution:
	rts

;[ PICTURE DATA ]

	.data
	.bank MAIN_BANK+1		;
	.org	$4000
Split_Map:	.incbin "Collag.map"		;The MAP

	.bank MAIN_BANK+2		;Palettes...
	.org	$4000

Split_Pal:	.incpal "CollageComp.pcx",0,5
Boing_Pal:	.incpal "BoingBall.pcx",0,1
		.incpal "ConPanel.pcx",0,1
		.incpal "ConText.pcx",0,1
		.incpal "Spl_Text.pcx",0,1

	.bank MAIN_BANK+3
	.org	$4000
Boing_Sprite:
	.vram	BOING		;Boing Ball
	.incspr "BoingBall.pcx",0,0,2,4		;32x64
	.incspr "BoingBall.pcx",32,0,2,4	;32x64
	.incspr "BoingBall.pcx",64,0,2,4	;32x64
	.incspr "BoingBall.pcx",96,0,2,4	;32x64
	.incspr "BoingBall.pcx",0,64,2,4	;32x64
	.incspr "BoingBall.pcx",32,64,2,4	;32x64
	.incspr "BoingBall.pcx",64,64,2,4	;32x64
	.incspr "BoingBall.pcx",96,64,2,4	;32x64

	.bank MAIN_BANK+4		;"Peace" splash screen!
	.org	$4000
Panel_Sprite:
	.vram	PANEL_SPR		;Control Panel
	.incspr "ConPanel.pcx",0,0,2,4		;32x64
	.incspr "ConPanel.pcx",32,0,2,4		;32x64
	.incspr "ConPanel.pcx",0,64,2,4		;32x64
	.incspr "ConPanel.pcx",32,64,2,4	;32x64
	.incspr "ConText.pcx",0,0,2,4		;32x64
	.incspr "ConText.pcx",32,0,2,4		;32x64
Text_Sprite:
	.vram	TEXT_SPR		;"SPLIT DEMO BY CHRIS COVELL"
	.incspr "Spl_Text.pcx",0,0,8,1		;32x16

;-------------------------------------------------------------
	.bank MAIN_BANK+5		;Tile set 1
	.org	$4000

Split_Gfx1:	.vram	$1000
		.incchr "CollageComp.pcx",32,8	;1/5 tiles
;-------------------------------
	.bank MAIN_BANK+6		;Tile set 2
	.org	$4000

Split_Gfx2:	.vram	$2000
		.incchr "CollageComp.pcx",0,64,32,8	;2/5 tiles
;-------------------------------
	.bank MAIN_BANK+7		;Tile set 3
	.org	$4000

Split_Gfx3:	.vram	$3000
		.incchr "CollageComp.pcx",0,128,32,8	;3/5 tiles
;-------------------------------
	.bank MAIN_BANK+8		;Tile set 4
	.org	$4000

Split_Gfx4:	.vram	$4000
		.incchr "CollageComp.pcx",0,192,32,8	;4/5 tiles
;-------------------------------
	.bank MAIN_BANK+9		;Tile set 5
	.org	$4000

Split_Gfx5:	.vram	$5000
		.incchr "CollageComp.pcx",0,256,32,8	;5/5 tiles