/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.UniPixelViewer;
import classes.Util;

public class CPCSCRHandler {
    public static int[] GAInks = new int[]{13, 27, 19, 25, 1, 7, 10, 16, 28, 29, 24, 26, 6, 8, 15, 17, 30, 31, 18, 20, 0, 2, 9, 11, 4, 22, 21, 23, 3, 5, 12, 14};
    public static int[] Palette = new int[]{20, 4, 21, 28, 24, 29, 12, 5, 13, 22, 6, 23, 30, 0, 31, 14, 7, 15, 18, 2, 19, 26, 25, 27, 10, 3, 11, 1, 8, 9, 16, 17};
    public static byte[] flipCode = new byte[]{1, 12, -68, -19, 73, 1, 48, -67, -19, 73, -51, 25, -67, 118, 118, -51, 9, -69, -2, 32, -54, -7, -25, 1, 12, -68, -19, 73, 1, 16, -67, -19, 73, -51, 25, -67, 118, 118, -61, -48, -25, -55};
    public static byte[] CodeOv = new byte[]{33, 69, 8, -51, 52, 8, 58, 0, 8, -51, 28, -67, 33, 1, 8, -81, 78, 65, -11, -27, -51, 50, -68, -31, -15, 35, 60, -2, 16, 32, -15, -55, 33, 85, 8, 1, 0, -68, 126, -89, -56, -19, 121, 4, 35, 126, -19, 121, 35, 5, 24, -14, 1, 48, 2, 50, 3, -119, 6, 34, 7, 35, 12, 13, 13, 0, 0, 0, 1, 40, 2, 46, 3, -114, 6, 25, 7, 30, 12, 48, 0, 0};
    public static byte[] normalCode = new byte[]{58, -48, -41, -51, 28, -67, 33, -47, -41, 70, 72, -51, 56, -68, -81, 33, -47, -41, 70, 72, -11, -27, -51, 50, -68, -31, -15, 35, 60, -2, 16, 32, -15, -55};
    public static byte[] CPCPalette = new byte[16];
    public static int[] CPCInkPalette = new int[16];
    protected static byte[] CPCRam = new byte[65536];
    protected static byte[][] UndoRam = new byte[200][65536];
    protected static int undopos = 0;
    static int[] CodeOvP = new int[]{243, 1, 17, 188, 33, 134, 8, 4, 237, 163, 13, 32, 250, 33, 151, 8, 205, 117, 8, 1, 184, 127, 58, 0, 8, 237, 73, 237, 121, 33, 1, 8, 17, 0, 100, 1, 32, 0, 237, 176, 175, 1, 14, 244, 237, 73, 1, 192, 246, 237, 73, 237, 121, 1, 146, 247, 237, 73, 1, 69, 246, 237, 73, 6, 244, 237, 120, 1, 130, 247, 237, 73, 23, 56, 221, 1, 160, 127, 237, 73, 251, 33, 165, 8, 1, 188, 0, 126, 167, 200, 237, 121, 4, 35, 126, 237, 121, 35, 5, 24, 242, 255, 0, 255, 119, 179, 81, 168, 212, 98, 57, 156, 70, 43, 21, 138, 205, 238, 1, 48, 2, 50, 6, 34, 7, 35, 12, 13, 13, 0, 0, 0, 1, 40, 2, 46, 6, 25, 7, 30, 12, 48};
    public static int mode = 0;
    static int[] CodeP0 = new int[]{243, 1, 17, 188, 33, 208, 223, 126, 237, 121, 35, 13, 32, 249, 1, 160, 127, 58, 208, 215, 237, 121, 237, 73, 1, 184, 127, 237, 73, 33, 209, 215, 17, 0, 100, 1, 34, 0, 237, 176, 205, 208, 207, 56, 251, 251, 201};
    static int[] CodeP1 = new int[]{1, 14, 244, 237, 73, 1, 192, 246, 237, 73, 175, 237, 121, 1, 146, 247, 237, 73, 1, 69, 246, 237, 73, 6, 244, 237, 120, 1, 130, 247, 237, 73, 1, 0, 246, 237, 73, 23, 201};
    static int[] CodeP3 = new int[]{255, 0, 255, 119, 179, 81, 168, 212, 98, 57, 156, 70, 43, 21, 138, 205, 238};
    static byte[] pluspalette = new byte[32];
    static byte[] sprite;
    protected static int[] pixelsA;
    protected static int[] pixelsB;
    public static byte[] normalSCRHeader;
    public static byte[] overSCRHeader;

    public static byte[] getNormalSCR(byte[] data) {
        byte[] n = new byte[16512];
        System.arraycopy(normalSCRHeader, 0, n, 0, 128);
        System.arraycopy(data, 0, n, 128, 16384);
        return n;
    }

    public static int getPen(int color) {
        return GAInks[Palette[color]];
    }

    public static byte[] getOverSCR(byte[] data) {
        byte[] n = new byte[32064];
        System.arraycopy(overSCRHeader, 0, n, 0, 128);
        System.arraycopy(data, 0, n, 128, 31936);
        return n;
    }

    public static void makeUndo() {
        System.arraycopy(CPCRam, 0, UndoRam[undopos], 0, 65536);
        System.out.println("Undo created to pos " + undopos);
        if (++undopos > 199) {
            undopos = 199;
            for (int i = 197; i >= 0; --i) {
                System.arraycopy(UndoRam[i], 0, UndoRam[i + 1], 0, 65536);
            }
        }
    }

    public static void undo() {
        System.arraycopy(UndoRam[undopos - 1], 0, CPCRam, 0, 65536);
        System.out.println("Undo retrieved from pos " + undopos);
        if (--undopos < 1) {
            undopos = 1;
        }
    }

    protected static void POKE(int address, int value) {
        CPCSCRHandler.CPCRam[address & 0xFFFF] = (byte)value;
    }

    protected static int PEEK(int address) {
        return CPCRam[address & 0xFFFF] & 0xFF;
    }

    public static byte[] getOverDATA() {
        int start = 512;
        int size = 31936;
        byte[] data = new byte[size];
        System.arraycopy(CodeOv, 0, CPCRam, 2065, CodeOv.length);
        System.arraycopy(CPCPalette, 0, CPCRam, 2049, CPCPalette.length);
        CPCSCRHandler.CPCRam[2048] = (byte)mode;
        System.arraycopy(CPCRam, start, data, 0, size);
        return CPCSCRHandler.getOverSCR(data);
    }

    public static byte[] getOverPlusDATA() {
        int start = 512;
        int size = 31936;
        byte[] data = new byte[size];
        for (int i = 0; i < CodeOvP.length; ++i) {
            CPCSCRHandler.POKE(2081 + i, (byte)CodeOvP[i]);
        }
        byte[] pluspal = CPCSCRHandler.getPlusPalette();
        System.arraycopy(pluspal, 0, CPCRam, 2049, 32);
        int mo = -116;
        if (mode == 1) {
            mo = -115;
        }
        if (mode == 2) {
            mo = -114;
        }
        CPCSCRHandler.CPCRam[2048] = mo;
        System.arraycopy(CPCRam, start, data, 0, size);
        return CPCSCRHandler.getOverSCR(data);
    }

    public static byte[] getNormalDATA() {
        int start = 49152;
        int size = 16384;
        byte[] data = new byte[size];
        System.arraycopy(CPCRam, start, data, 0, size);
        System.arraycopy(normalCode, 0, data, 2000, normalCode.length);
        data[6096] = (byte)mode;
        System.arraycopy(CPCPalette, 0, data, 6097, CPCPalette.length);
        System.arraycopy(flipCode, 0, data, 10192, flipCode.length);
        return CPCSCRHandler.getNormalSCR(data);
    }

    public static byte[] getScreenFromRam(boolean overscan) {
        byte[] screenBytes;
        if (overscan) {
            screenBytes = new byte[31936];
            System.arraycopy(CPCRam, 512, screenBytes, 0, 31936);
        } else {
            screenBytes = new byte[16384];
            System.arraycopy(CPCRam, 49152, screenBytes, 0, 16384);
        }
        return screenBytes;
    }

    public static void writeScreenIntoRam(byte[] screen, boolean overscan) {
        if (overscan) {
            System.arraycopy(screen, 0, CPCRam, 512, 31936);
        } else {
            System.arraycopy(screen, 0, CPCRam, 49152, 16384);
        }
    }

    public static byte[] getNormalPlusDATA() {
        int i;
        int start = 49152;
        int size = 16384;
        byte[] data = new byte[size];
        for (i = 0; i < CodeP0.length; ++i) {
            CPCSCRHandler.POKE(51152 + i, (byte)CodeP0[i]);
        }
        for (i = 0; i < CodeP1.length; ++i) {
            CPCSCRHandler.POKE(53200 + i, (byte)CodeP1[i]);
        }
        for (i = 0; i < CodeP3.length; ++i) {
            CPCSCRHandler.POKE(57296 + i, (byte)CodeP3[i]);
        }
        System.arraycopy(CPCRam, start, data, 0, size);
        int mo = -116;
        if (mode == 1) {
            mo = -115;
        }
        if (mode == 2) {
            mo = -114;
        }
        data[6096] = mo;
        byte[] pluspal = CPCSCRHandler.getPlusPalette();
        System.arraycopy(pluspal, 0, data, 6097, pluspal.length);
        System.arraycopy(flipCode, 0, data, 10192, flipCode.length);
        return CPCSCRHandler.getNormalSCR(data);
    }

    public static byte[] getPlusPalette() {
        CPCSCRHandler.makePlusPalette();
        return pluspalette;
    }

    protected static int[] getRGB(int value) {
        int[] rgb = new int[]{value >> 16 & 0xFF, value >> 8 & 0xFF, value & 0xFF};
        return rgb;
    }

    public static void makePlusPalette() {
        try {
            for (int pen = 0; pen < (mode == 1 ? 4 : 16); ++pen) {
                int pos = pen * 2;
                int f = mode == 1 ? UniPixelViewer.mode1palette[pen] : UniPixelViewer.mode0palette[pen];
                int[] rgb = CPCSCRHandler.getRGB(f);
                int r = rgb[0] >> 4;
                int g = rgb[1] >> 4;
                int b = rgb[2] >> 4;
                String R = Integer.toHexString(r);
                String G = Integer.toHexString(g);
                String B = Integer.toHexString(b);
                String result = R + B;
                int bg = Util.hexValue(result);
                CPCSCRHandler.pluspalette[pos] = (byte)bg;
                result = G;
                bg = Util.hexValue(result);
                CPCSCRHandler.pluspalette[pos + 1] = (byte)bg;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void PLOT(int x, int y, int pen, int mode, boolean overscan) {
        int scraddr = 0;
        int soffset = 0;
        if (overscan) {
            int byteX;
            int charX;
            switch (mode) {
                case 0: {
                    charX = x / 4;
                    byteX = (x & 3) / 2;
                    break;
                }
                case 1: {
                    charX = x / 8;
                    byteX = (x & 7) / 4;
                    break;
                }
                default: {
                    charX = x / 16;
                    byteX = (x & 0xF) / 8;
                }
            }
            int char_offset = y / 8 * 48 + charX + 256;
            if (char_offset >= 1024) {
                soffset = 16384;
                char_offset &= 0x3FF;
            }
            scraddr += char_offset * 2 + byteX + (y & 7) * 2048;
            scraddr += soffset;
        } else {
            int scrline = y / 8 * 80 + (y & 7) * 2048;
            scrline += 49152;
            int xbyteoffs = x / 4;
            if (mode == 0) {
                xbyteoffs = x / 2;
            }
            if (mode == 2) {
                xbyteoffs = x / 8;
            }
            scraddr = scrline + xbyteoffs;
        }
        int data = CPCSCRHandler.PEEK(scraddr);
        int pixel = x & 3;
        if (mode == 0) {
            pixel = x & 1;
        }
        if (mode == 2) {
            pixel = x & 7;
        }
        if (mode == 2) {
            data &= ~(1 << 7 - pixel);
            if (pen != 0) {
                data |= 1 << 7 - pixel;
            }
        }
        if (mode == 1) {
            block4 : switch (pixel) {
                case 0: {
                    data &= 0xFFFFFF77;
                    switch (pen) {
                        case 1: {
                            data |= 0x80;
                            break;
                        }
                        case 2: {
                            data |= 8;
                            break;
                        }
                        case 3: {
                            data |= 0x88;
                        }
                    }
                    break;
                }
                case 1: {
                    data &= 0xFFFFFFBB;
                    switch (pen) {
                        case 1: {
                            data |= 0x40;
                            break;
                        }
                        case 2: {
                            data |= 4;
                            break;
                        }
                        case 3: {
                            data |= 0x44;
                        }
                    }
                    break;
                }
                case 2: {
                    data &= 0xFFFFFFDD;
                    switch (pen) {
                        case 1: {
                            data |= 0x20;
                            break;
                        }
                        case 2: {
                            data |= 2;
                            break;
                        }
                        case 3: {
                            data |= 0x22;
                        }
                    }
                    break;
                }
                case 3: {
                    data &= 0xFFFFFFEE;
                    switch (pen) {
                        case 1: {
                            data |= 0x10;
                            break block4;
                        }
                        case 2: {
                            data |= 1;
                            break block4;
                        }
                        case 3: {
                            data |= 0x11;
                        }
                    }
                }
            }
        }
        if (mode == 0) {
            switch (pixel) {
                case 0: {
                    data &= 0xFFFFFF55;
                    data |= pixelsA[pen];
                    break;
                }
                case 1: {
                    data &= 0xFFFFFFAA;
                    data |= pixelsB[pen];
                }
            }
        }
        CPCSCRHandler.POKE(scraddr, data);
    }

    public static byte[] grabSprite(boolean hasSize, int x, int y, int w, int h, boolean overscan, boolean flipped) {
        byte[] data = new byte[w * h + (hasSize ? 2 : 0)];
        int off = 2;
        data[0] = (byte)w;
        data[1] = (byte)h;
        if (!hasSize) {
            off = 0;
        }
        if (flipped) {
            for (int sy = h - 1; sy >= 0; --sy) {
                for (int sx = 0; sx < w; ++sx) {
                    data[off++] = CPCSCRHandler.getScreenByte(x + sx, y + sy, overscan);
                }
            }
        } else {
            for (int sy = 0; sy < h; ++sy) {
                for (int sx = 0; sx < w; ++sx) {
                    data[off++] = CPCSCRHandler.getScreenByte(x + sx, y + sy, overscan);
                }
            }
        }
        return data;
    }

    public static byte[] getSprite() {
        return sprite;
    }

    public static String grabSpriteASM(boolean hasSize, int x, int y, int w, int h, boolean overscan, boolean flipped, int index) {
        String s;
        StringBuilder builder = new StringBuilder();
        sprite = CPCSCRHandler.grabSprite(hasSize, x, y, w, h, overscan, flipped);
        String a = "";
        if (hasSize) {
            a = "SPRITE_" + (index + 1) + ":\r\n      DB ";
            int wd = sprite[0] & 0xFF;
            int ht = sprite[1] & 0xFF;
            s = "" + Integer.toHexString(wd);
            if (s.length() < 2) {
                s = "0" + s;
            }
            s = "#" + s + ",";
            a = a + s;
            s = "" + Integer.toHexString(ht);
            if (s.length() < 2) {
                s = "0" + s;
            }
            s = "#" + s;
            a = a + s + "  ;; width and height\r\n\r\n";
        }
        a = a + ";;Sprite " + (index + 1) + " data" + (flipped ? " (GGPFLIP)" : "") + "\r\n";
        builder.append(a);
        a = "      DB ";
        for (int i = 0; i < sprite.length - (hasSize ? 2 : 0); ++i) {
            s = "" + Integer.toHexString(sprite[i + (hasSize ? 2 : 0)] & 0xFF);
            if (s.length() < 2) {
                s = "0" + s;
            }
            s = "#" + s;
            a = a + s;
            a = i % w == w - 1 ? a + "\r\n      DB " : a + ",";
        }
        if (a.endsWith(",")) {
            a = a.substring(0, a.length() - 1);
        }
        if (a.endsWith("      DB ")) {
            a = a.substring(0, a.length() - 9);
        }
        a = a + "\r\n";
        builder.append(a);
        return builder.toString();
    }

    public static byte getScreenByte(int x, int y, boolean overscan) {
        int scraddr = 0;
        if (overscan) {
            int scrline = y / 8 * 96 + (y & 7) * 2048;
            if (y > 127) {
                scrline += 14336;
            }
            scraddr = (scrline += 512) + x;
            return (byte)CPCSCRHandler.PEEK(scraddr);
        }
        int scrline = y / 8 * 80 + (y & 7) * 2048;
        scraddr = (scrline += 49152) + x;
        return (byte)CPCSCRHandler.PEEK(scraddr);
    }

    public static int ChecksumAMSDOS(byte[] pHeader) {
        int Checksum = 0;
        for (int i = 0; i < 67; ++i) {
            int CheckSumByte = pHeader[i] & 0xFF;
            Checksum += CheckSumByte;
        }
        return Checksum;
    }

    public static byte[] getCPCFile(byte[] data) {
        if (CPCSCRHandler.CheckAMSDOS(data)) {
            byte[] result = new byte[data.length - 128];
            System.arraycopy(data, 128, result, 0, result.length);
            return result;
        }
        return data;
    }

    public static boolean CheckAMSDOS(byte[] pHeader) {
        int CalculatedChecksum;
        try {
            CalculatedChecksum = CPCSCRHandler.ChecksumAMSDOS(pHeader);
        }
        catch (Exception e) {
            return false;
        }
        int ChecksumFromHeader = pHeader[67] & 0xFF | (pHeader[68] & 0xFF) << 8;
        return ChecksumFromHeader == CalculatedChecksum && ChecksumFromHeader != 0;
    }

    static {
        pixelsA = new int[]{0, 128, 8, 136, 32, 160, 40, 168, 2, 130, 10, 138, 34, 162, 42, 170};
        pixelsB = new int[]{0, 64, 4, 68, 16, 80, 20, 84, 1, 65, 5, 69, 17, 81, 21, 85};
        normalSCRHeader = new byte[]{0, 74, 65, 86, 65, 67, 80, 67, 32, 83, 67, 82, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, -64, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 66, 4, 0, 0, 74, 65, 86, 65, 67, 80, 67, 32, 36, 36, 36, -1, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 85, 110, 105, 80, 105, 120, 101, 108, 86, 105, 101, 119, 101, 114, 32};
        overSCRHeader = new byte[]{0, 74, 65, 86, 65, 67, 80, 67, 32, 66, 73, 78, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2, 0, -64, 124, 17, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -64, 124, 0, -122, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 85, 110, 105, 80, 105, 120, 101, 108, 86, 105, 101, 119, 101, 114, 32, 67, 80, 67, 32, 79, 86, 69, 82, 83, 67, 65, 78, 32, 83, 67, 82};
    }
}

