/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.io;

import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;

public class SubImageOutputStream
extends ImageOutputStreamImpl {
    private ImageOutputStream out;
    private long offset;
    private long length;
    private boolean forwardFlushAndClose;

    public SubImageOutputStream(ImageOutputStream out, ByteOrder bo, boolean forwardFlushAndClose) throws IOException {
        this(out, out.getStreamPosition(), bo, forwardFlushAndClose);
    }

    public SubImageOutputStream(ImageOutputStream out, long offset, ByteOrder bo, boolean forwardFlushAndClose) throws IOException {
        this.out = out;
        this.offset = offset;
        this.forwardFlushAndClose = forwardFlushAndClose;
        this.setByteOrder(bo);
        out.seek(offset);
    }

    private long available() throws IOException {
        this.checkClosed();
        long pos = this.out.getStreamPosition();
        if (pos < this.offset) {
            this.out.seek(this.offset);
            pos = this.offset;
        }
        return this.offset + this.out.length() - pos;
    }

    @Override
    public int read() throws IOException {
        if (this.available() <= 0L) {
            return -1;
        }
        return this.out.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long av = this.available();
        if (av <= 0L) {
            return -1;
        }
        int result = this.out.read(b, off, (int)Math.min((long)len, av));
        return result;
    }

    @Override
    public long getStreamPosition() throws IOException {
        return this.out.getStreamPosition() - this.offset;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.out.seek(pos + this.offset);
        this.length = Math.max(pos - this.offset + 1L, this.length);
    }

    @Override
    public void flush() throws IOException {
        if (this.forwardFlushAndClose) {
            this.out.flush();
        }
    }

    @Override
    public long getFlushedPosition() {
        return this.out.getFlushedPosition() - this.offset;
    }

    @Override
    public boolean isCached() {
        return this.out.isCached();
    }

    @Override
    public boolean isCachedMemory() {
        return this.out.isCachedMemory();
    }

    @Override
    public boolean isCachedFile() {
        return this.out.isCachedFile();
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.length = Math.max(this.out.getStreamPosition() - this.offset, this.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.length = Math.max(this.out.getStreamPosition() - this.offset, this.length);
    }
}

