;Voxel landscape example...
;dox@emugaming.com

copy    equ $fffe
index   equ $fffd
color   equ $fffc
index2  equ $fffb
yx      equ $fffa
xx      equ $fff9
frm     equ $fff8
mode    equ $fff6

SECTION "colors",HOME[0]
incbin "bcpd.bin"

SECTION "vblank",HOME[$40]
        push af       ;GDMA+HDMA (BUFFER 2 SCREEN)
        push hl
        ld a,[copy]
        or a
        jp z,exit2
        ld a,[frm]
        bit 0,a
        ld a,$c0      ;C000
        jr nz,exit3
        or $10        ;D000
exit3:
        push af
        ld hl,$ff51
        ld [hl+],a
        xor a
        ld [hl+],a
        ld [hl+],a
        ld [hl+],a
        ld a,127
        ld [hl],a
        ld hl,$ff51   ;
        pop af        ;  FIX FOR EMULATORS
        add 8         ;  LD A,$FF
        ld [hl+],a    ;  LD [HL],A ;$FF55
        xor a         ;  FOR REAL GBC/NO$
        ld [hl+],a    ;
        ld a,$88      ;
        ld [hl+],a    ;
        xor a         ;
        ld [hl+],a    ;
        cpl           ;
        ld [hl],a     ;
        cpl           ;
        ld [copy],a   ;
exit2:
        pop hl
        pop af
        reti

SECTION "header",HOME[$100]
        nop
        jp start
        ds 48           ;NIN LOGO
        db "VXL test      ",0,$C0
        db 0,0,0
        db $19          ;MBC5
        db 1            ;64 KB ROM
        db 0            ;0 KB RAM
        db 1,0
        db 1
        ds 3
start:
        di
        ld a,$30
        ld [$ff00],a
        ld a,1
        ld [$ff4d],a
        stop
        ld sp,$fff4
        xor a
        ld [mode],a
        ld [$ffff],a
        ld [$ff0f],a
        ld hl,$ff41
lcd_off:
        bit 0,[hl]     ; WAIT FOR VBL
        jr z,lcd_off
        dec hl
        res 7,[hl]

        ld a,$19
        ld [yx],a
        ld a,$3c
        ld [xx],a      ;STARTUP VALUES

        ld a,128
        ld hl,$ff68
        ld [hl+],a
        ld d,0
        ld e,d
        ld c,10
coloop:                ;PALETTES
        ld a,[de]
        ld [hl],a
        inc de
        dec c
        jr nz,coloop
        ld h,$80
        ld l,0
        ld b,$10
        ld c,l
l1:
        xor a
        ld [hl+],a
        dec bc
        ld a,b
        or c
        jr nz,l1
        ld hl,map
        ld de,$9800
        ld bc,32*18
maploop:               ;MAP
        ld a,[hl+]
        ld [de],a
        inc de
        dec bc
        ld a,b
        or c
        jr nz,maploop
        ld a,1
        ld [$ff4f],a
        ld hl,mapa
        ld de,$9800
        ld bc,32*18
atrloop:               ;ATR MAP
        ld a,[hl+]
        ld [de],a
        inc de
        dec bc
        ld a,b
        or c
        jr nz,atrloop
        ld h,$80
        xor a
        ld l,a
        ld c,16
atr2l:
        ld [hl+],a
        dec c
        jr nz,atr2l
        ld [copy],a
        ld [$ff4f],a
        inc a
        ld [$ffff],a
        ld hl,$ff40
        set 7,[hl]
        call clr
        ei
main:                   ;MAIN LOOP
        call frame
        ld a,$c0
        ld [copy],a
        ld hl,frm
        inc [hl]
        call clr        ;CLEAR
loop:
        ld a,%100000
        ld [$ff00],a    ;PAD
        ld a,[$ff00]
        ld a,[$ff00]
        cpl
        and $0f
        ld c,a
        jr z,loop_2
        bit 3,c
        ld hl,yx
        jr z,l11
        dec [hl]
l11:
        bit 2,c
        jr z,l2
        inc [hl]
l2:
        dec hl
        bit 1,c
        jr z,l3
        dec [hl]
l3:
        bit 0,c
        jr z,loop_2
        inc [hl]
loop_2:
        ld  a,$10
        ld  [$ff00],a
REPT 6
        ld  a,[$ff00]
ENDR
        cpl
        and $f
        jr z,main
        ld a,[mode]
        cpl
        ld [mode],a
        jr main
clr:
        ld a,[frm]
        ld h,$c0     ;$C000
        bit 0,a
        jr z,skip
        ld h,$d0     ;$D000
skip:
        xor a
        ld l,a
REPT 4096
        ld [hl+],a   ; .. PUSH SHOULD BE FASTER ;)
ENDR
        ret


frame:
        ld e,0  ;E=X
loop_x:
        xor a
        ld [index],a
        ld d,a  ;D=Y
loop_y:
        ld l,0
        ld h,d
        srl h
        rr l
        ld a,e
        add a,a
        or l
        ld l,a     ;HL=(Y*64+X)*2
        ld a,$34   ;RAY TABLE
        add h
        ld h,a
        ld a,[xx]
        add [hl]
        ld c,a
        inc hl
        ld a,[yx]
        add [hl]
        ld b,a
        ld a,[mode]
        or a
        jr z,m0
        srl b
        jr nc,m1
        set 7,c
        jr m1
m0:
        srl b
        rr c
m1:
        set 6,b
        ld a,2
        ld [$2000],a
        ld a,[bc]    ;TEXEL
        ld [color],a
        ld a,3
        ld [$2000],a
        ld a,[bc]    ;HEIGHT
        ld b,0
        add a,a
        rl b
        add a,a
        rl b
        add d
        ld l,a
        ld a,$3c ;PERSPECT. CORRECTION
        add b
        ld h,a
        ld a,[index]
        ld b,a
        cp [hl]
        jr nc,skip_1
        ld b,a
        ld a,[hl]
        ld [index],a
        dec a
        ld [index2],a
plot:
        push bc
        push de
        ld c,e  ;C=X
        ld a,[color]
        ld d,a
        ld a,63
        sub b
        sla c
        rra
        jr nc,not_o
        set 7,c
not_o:
        ld b,a
        ld l,c
        ld a,$13  ;PIXEL TABLE
        add b
        ld h,a
        ld a,[hl+]
        ld c,a
        ld a,[hl]
        add $20   ;MASK TABLE
        ld b,a
        ld a,[frm]
        and %1
        jr z,not_o1
        set 4,b
not_o1:
        ld a,e
        and %11
        swap a
        srl a
        or d
        add a,a
        add a,a
        ld h,$33
        ld l,a
REPT 4                  ;WRITE 4 PIXELS (MODIFY 8 BYTES)
        ld a,[bc]
        or [hl]
        ld [bc],a
        inc hl
        inc bc
ENDR
        pop de
        pop bc
        inc b
        ld a,[index2]
        cp b
        jr nc,plot
skip_1:
        inc d
        bit 4,d      ;  0-15
        jp z,loop_y
        inc e
        bit 6,e      ;  0-63
        jp z,loop_x
        ret

SECTION "tables",HOME[$1300]
include "tab.inc"
include "mask.inc"

SECTION "tables2",HOME[$3400]
incbin "rays.bin"
incbin "persp.bin"


section "bank1", CODE[$4000],BANK[1]
map:
include "map.inc"
mapa:
include "mapa.inc"

section "bank2", CODE[$4000],BANK[2]
incbin "tex.raw"

section "bank3", CODE[$4000],BANK[3]
incbin "height.raw"