#version 410

#define THRESHOLD 0.7
#define TILE_SIZE 4.0
#define EPS       0.01

uniform float time;
uniform vec3 cam_pos, cam_rot, tint;

in  vec3 v2f_coord;
out vec4 output;

// tiny hsv2rgb:
vec3 hsv(float h,float s,float v) {
	return mix(vec3(1.),clamp((abs(fract(h+vec3(3.,2.,1.)/3.)*6.-3.)-1.),0.,1.),s)*v;
}

vec3 rotateX(vec3 p, float ang)
{
    float c = cos(ang), s = sin(ang);
    return vec3(p.x, p.y * c - p.z * s, p.y * s + p.z * c);
}

vec3 rotateY(vec3 p, float ang)
{
    float c = cos(ang), s = sin(ang);
    return vec3(p.z * c - p.x * s, p.y, p.z * s + p.x * c);
}

vec3 rotateZ(vec3 p, float ang)
{
    float c = cos(ang), s = sin(ang);
    return vec3(p.x * c - p.y * s, p.x * s + p.y * c, p.z);
}

float sphere(vec3 p) { return length(p) - 1.0; }

float plane(vec3 p, vec3 n, float d) { return dot(p, n) - d; }

float cylinder(vec3 p) { return length(p.xy) - 1.0; }

float saturate(float x) { return min(1, max(0, x)); }

float square(float x) { return x * x; }

float cubesq(vec3 p, float s)
{
    return  pow(max(0.0,   p.z - s),  2.0) +
            pow(max(0.0, -(p.z + s)), 2.0) +
            pow(max(0.0,   p.y - s),  2.0) +
            pow(max(0.0, -(p.y + s)), 2.0) +
            pow(max(0.0,   p.x - s),  2.0) +
            pow(max(0.0, -(p.x + s)), 2.0);
}

float pacman(vec3 p, float r)
{
    float d = 0.0;
 
    // pacman 'body'
    d += pow(max(0.0,   p.z - 0.1),  2.0);
    d += pow(max(0.0, -(p.z + 0.1)), 2.0);
    d += pow(max(0.0,  cylinder(p)), 2.0);
    
    // pacman eye
    if(mod(time, 3.0) > 0.1) // blinking effect
        d += pow(max(0.0, -0.7-cylinder((p - vec3(-0.4, 0.5, 0.0)))), 2.0);
        
    float mouth_angle = mix(mod(time * 8.0, 3.1415926 * 2.0), 3.1415926, smoothstep(28.0, 30.0, time));
    
    // pacman mouth 2
    d += pow( min(max(0.0, plane(p, rotateZ(vec3(0.0, +1.0, 0.0), -(1.2 + cos(mouth_angle)) * 0.4), 0.0)),
              max(0.0, plane(p, rotateZ(vec3(0.0, -1.0, 0.0), +(1.2 + cos(mouth_angle)) * 0.4), 0.0)))
                , 2.0);

    float final_d = 100000.0;

    final_d = min(final_d, sqrt(d) - 0.1  + cos(p.x * 180.0) *
               sin(p.y * 180.0) * sin(p.z * 180.0)  * 0.001);
               
     // pills
    if(p.x + time < 30.0)
    {
        float d2 = 0.0;
        vec3 p2 = vec3(mod(p.x + time, 2.0) - 1.0, p.y, p.z);
        d2 += pow(max(0.0,   p2.z - 0.02),  2.0);
        d2 += pow(max(0.0, -(p2.z + 0.02)), 2.0);
        d2 += pow(max(0.0,   p2.y - 0.1),  2.0);
        d2 += pow(max(0.0, -(p2.y + 0.1)), 2.0);
        d2 += pow(max(0.0,   p2.x - 0.1),  2.0);
        d2 += pow(max(0.0, -(p2.x + 0.1)), 2.0);

        final_d = min(final_d, max(sqrt(d2) - 0.1  + cos(p2.x * 180.0) *
                   sin(p2.y * 180.0) * sin(p2.z * 180.0)  * 0.001, -p.x));
     
    }
    
    return final_d;
}

float subject(vec3 p)
{
    return pacman(p - vec3(0.0, 0.0, 1.5), 0.3);
}

float scene(vec3 p)
{
    return min(subject(p), 2 - p.z + cos(p.x * 50.0) *
                sin(p.y * 50.0) * sin(p.z * 50.0)  * 0.01);
}

float ao_strength = 0.2, ao_eps = 0.1;

float ambient_occlusion(vec3 p, vec3 n)
{
    float ao = 1.0, w = ao_strength / ao_eps;
    float dist = 2.0 * ao_eps;

    for(int i = 0; i < 5; i++)
    {
        float d = scene(p + n * dist);
        ao -= (dist - d) * w;
        w *= 0.5;
        dist = dist * 2.0 - ao_eps;
    }
    
    return clamp(ao, 0.0, 1.0);
}

float circle(vec2 p, float r)
{
    return length(p) - r;
}

float square(vec2 p, vec2 s)
{
    return length(max(vec2(0.0, 0.0), abs(p) - s)) - 0.1;
}

float ring(vec2 p, float r1, float r2)
{
    return max(-circle(p, r1), circle(p, r2));
}

float cring(vec2 p, float r1, float r2, float g)
{
    return max(ring(p, r1, r2), -square(p - vec2(r2 * 0.5, 0.0), vec2(r2, g)));
}

vec2 rotate(vec2 p, float angle)
{
    return vec2(p.x * cos(angle) - p.y * sin(angle),
                p.y * cos(angle) + p.x * sin(angle));
}

float floorPattern(vec2 p)
{
    return min(cring(p, 2.0, 3.0, 0.2), cring(p, 4.0, 5.0, 0.2));
}

vec3 colour(vec3 p)
{
    return mix(vec3(1.0, 1.0, 1.0), vec3(1.0, 0.5, 0.2), min(step(1.99, p.z), smoothstep(-0.04, 0.04, floorPattern(p.xy))));
}

float lightShadow(vec3 p, vec3 n, vec3 l)
{
    float s = 0, k = 0.5;

    vec3 q = normalize(l - p);
    
    for (float i = 0.; i < 5.; ++i)
        s += (i * k - scene(p + q * i * k)) / exp2(i);
    
    return (1.0 - s);
}

float vignet(vec2 p)
{
    p *= vec2(0.75, 1.0);
    return p.x * p.x * p.x * p.x + p.y * p.y * p.y * p.y;
}

void main()
{
    vec3  p = cam_pos, d = normalize(v2f_coord);

    d = rotateZ(d, cam_rot.z);
    
    for(int i = 0; i < 300; ++i)
    {
        float f = scene(p);
        
        if(f < 0.001)
        {
            vec3 n = normalize(vec3( scene(p + vec3(EPS, 0.0, 0.0)) - f,
                                     scene(p + vec3(0.0, EPS, 0.0)) - f,
                                     scene(p + vec3(0.0, 0.0, EPS)) - f ));
            
            vec3 lpos = vec3(5, 3, -10);

            vec4 col = colour(p).rgbb;

            output = col * vec4(0.2 + dot(normalize(lpos - p), n)) * 0.7 * vec4(1.2, 1.1, 1.0, 1.0);
            output += vec4(ambient_occlusion(p, n)) * vec4(0.8, 0.8, 1.0, 1.0) * 0.3;
            
            output *= vec4(lightShadow(p, n, lpos));
            
            output = mix(output * max(0.0, (1.0 - vignet(v2f_coord.xy))), output, 0.3);
            
            if(time > 20.0 && mod(time, 0.7) < 0.2)
            {
                float f2 = subject(p);
                
                vec3 n2 = normalize(vec3( subject(p + vec3(EPS, 0.0, 0.0)) - f2,
                                          subject(p + vec3(0.0, EPS, 0.0)) - f2,
                                          subject(p + vec3(0.0, 0.0, EPS)) - f2 ));
                                      
                vec4 fl = vec4(0.0);
            
                if(f2 < 0.01)
                    fl += vec4(2.0);
                else
                    fl += vec4(max(0.1, dot(n, -n2)) / (0.1 + f2)) * colour(p).rgbb;
            
                output += fl * (0.2 - mod(time, 0.7)) * 5.0;
            }
            
            output.rgb *= tint;
            return;
        }
        
        p += d * f;
    }
    
    output = vec4(0);
}

