#version 410

#define saturate(x) clamp(x, 0.0, 1.0)

uniform sampler2D display;
uniform sampler1D pal;
uniform float aspect_ratio, time, tint;

noperspective in vec2 v2f_coord;

const vec2 resolution = vec2(80.0, 60.0);

out vec4 output;

float mask(vec2 p)
{
   return 1.0 - smoothstep(0.05, 0.07, length(max(vec2(0.0), abs(p * vec2(0.75, 1.0)) - vec2(1.2))));
}

vec3 screen(vec2 p)
{
    vec2 f = fract(p);

    float m = saturate(pow(1.4 - length(f - vec2(0.5, 0.5)), 5.0));
    
    p = floor(p) / resolution;

    return texture(pal, texture2D(display, p).r).rgb * m * 0.5;
}

void main()
{
    vec3 p = vec3((v2f_coord.xy * 2.0 - vec2(1.0, 1.0)) * vec2(aspect_ratio, 1.0), 1.0);

    p *= pow(length(p), 1.2);

    float m = mask(p.xy);
    
    p.xy = (p.xy + vec2(1.0, 1.0)) * 0.5 * resolution;
    
    output.rgb = (screen(p.xy + vec2( 0.2, 0.0)) * m * vec3(0.9, 0.1, 0.1) +
                  screen(p.xy + vec2( 0.0, 0.0)) * m * vec3(0.1, 0.9, 0.1) +
                  screen(p.xy + vec2(-0.2, 0.0)) * m * vec3(0.1, 0.1, 0.9)) * tint;
}
