#version 410

uniform sampler2D tex0;
uniform vec2 scale;

in vec2 v2f_coord;

out vec4 output;

const int samp_count = 64;

void main()
{
    output = vec4(0.0);

    vec2 direction = (v2f_coord - vec2(0.5, 0.5)) * scale;
    float weights_sum = 0.0f;
    
    for(int i = 0; i < samp_count; ++i)
    {
        float x = float(i) / float(samp_count), weight = 1.0 - x;
        output += texture2D(tex0, v2f_coord + direction * x) * weight;
        weights_sum += weight;
    }
    
    output /= weights_sum;
}

