FONT_WIDTH:     	equ     (624/8)*1
DEBUG_SCREEN_SIZE_X:	equ	40
TXTLEN_WORD:		equ	3
TXTLEN_LWORD:		equ	7

		
agdDebugWindow:
		movem.l d0-d7/a0-a3,-(a7)
		
		;COL0_PURPLE

                moveq   #0,d0
		lea	DEBUG_VARS,a3
; Do Words
                rept    6
                move.l  (a3)+,d0                                ; Get X Position
		move.l	d0,d2
                move.l  (a3)+,d1                                ; Get Y Position
                move.l  DEBUG_SCREEN_PTR,a1                ; Screen Address
		move.l	hAddress(a1),a1
                move.l  (a3)+,a0                                ; Get Text Pointer

                bsr     agdDebugText                            ; Draw Text in a0
                lea     TXT_WORD,a0                         ; Buffer for word in
                move.l  (a3)+,a2                                ; Pointer to value
                move.w  (a2),d0                                 ; Dereference
                
		moveq   #TXTLEN_WORD,d7                         ; size of a word
                bsr     agdHexToAscii                            ; convert it
                move.l	d2,d0
		add.w   #7,d0                                   ; Index to the Right of the text
		lea     TXT_WORD,a0                         ; Print the converted word
                move.l  DEBUG_SCREEN_PTR,a1
		move.l	hAddress(a1),a1
                bsr     agdDebugText
                endr

; Do Lwords
                rept    6
                move.l  (a3)+,d0                                ; Get X Position
		move.l	d0,d2
                move.l  (a3)+,d1                                ; Get Y Position
                move.l  DEBUG_SCREEN_PTR,a1                ; Screen Address
		move.l	hAddress(a1),a1
                move.l  (a3)+,a0                                ; Get Text Pointer

                bsr     agdDebugText                            ; Draw Text in a0
                lea     TXT_LWORD,a0                        ; Buffer for word in
                move.l  (a3)+,a2                                ; Pointer to value
                move.l  (a2),d0                                 ; Dereference
                
		moveq   #TXTLEN_LWORD,d7                        ; size of a word
                bsr     agdHexToAscii                            ; convert it
                move.l	d2,d0
		add.w   #7,d0                                   ; Index to the Right of the text
		lea     TXT_LWORD,a0                        ; Print the converted word
                move.l  DEBUG_SCREEN_PTR,a1
		move.l	hAddress(a1),a1
                bsr     agdDebugText
                endr
		
		;COL0_BLACK

.exit:          movem.l (a7)+,d0-d7/a0-a3
                rts

;d0=word
;a0=text pointer
;d7=length 3=Word 7=LWORD
agdHexToAscii:
		movem.l d0-d1,-(a7)
		clr.b   1(a0,d7)                        ; Safe terminate
.loop:  	move.b  d0,d1
		and.b   #$f,d1
		cmp.b   #10,d1
		bge.s   .alpha
		add.b   #48,d1
		bra.s   .num
.alpha: 	add.b   #55,d1
.num:   	move.b  d1,(a0,d7)
		lsr.l   #4,d0
		dbf     d7,.loop
		movem.l (a7)+,d0-d1
		rts

; d0=8x8 X Char position (0 to 38)
; d1=8x8 Y Char position (0 to depth)
; a0=text
; a1=Debug Screen Origin
agdDebugText:
		movem.l d0-d1/a0-a2,-(a7)
		add.l   d0,a1				; Index to X Position
		
		lsl.w   #3,d1				; Multiply 8x8 Block to Pixel Position		

		move.l	d1,d0				; mulitply d1 by 40 (screen size)
		lsl.w	#3,d0				; 1=8
		lsl.w	#5,d1				; 1=32
		add.l	d0,a1				; 8+32=40
		add.l	d1,a1				; Index to Y Position
		
.loop:		moveq   #0,d0
		lea  	DEBUG_FONT(a6),a2
		move.b  (a0)+,d0
		beq.s	.exit
		sub.b   #32,d0
		lsl.w	#3,d0

		add.l   d0,a2           		; index into character

		move.b  (a2)+,(a1)
		move.b  (a2)+,DEBUG_SCREEN_SIZE_X*1(a1)
		move.b  (a2)+,DEBUG_SCREEN_SIZE_X*2(a1)
		move.b  (a2)+,DEBUG_SCREEN_SIZE_X*3(a1)
		move.b 	(a2)+,DEBUG_SCREEN_SIZE_X*4(a1)
		move.b  (a2)+,DEBUG_SCREEN_SIZE_X*5(a1)
		move.b  (a2)+,DEBUG_SCREEN_SIZE_X*6(a1)
		addq.w  #1,a1
		bra.s	.loop
.exit:  	movem.l (a7)+,d0-d1/a0-a2
		rts


agdCreateDebugCopper:
	move.l	#$01060200,(a1)+;
        move.l  #$01820000,(a1)+
        move.l  #$01060000,(a1)+
        move.l  #$01820707,(a1)+
	
        ;move.w  #FMODE,(a1)+
        ;move.w  #0,(a1)+

        move.w  #DIWSTRT,(a1)+  ;
        move.w  #$2c81,(a1)+    ;
        move.w  #DIWSTOP,(a1)+  ;
        move.w  #$f4c1,(a1)+    ;
        move.w  #DDFSTRT,(a1)+  ;
        move.w  #$0030,(a1)+    ;
        move.w  #DDFSTOP,(a1)+  ;
        move.w  #$00d0,(a1)+    ;

        move.l  DEBUG_SCREEN_PTR,a0
	move.l	hAddress(a0),d0
	
	;sub.l	#4,d0
        move.w  #BPL0PTL,(a1)+
        move.w  d0,(a1)+
        swap    d0
        move.w  #BPL0PTH,(a1)+
        move.w  d0,(a1)+

        move.w  #BPLCON1,(a1)+  ;
        move.w  #0,(a1)+        ;
        move.w  #BPLCON2,(a1)+  ;
        move.w  #$00,(a1)+      ;
        move.w  #BPL1MOD,(a1)+
        move.w  #-2,(a1)+               ; a0
        move.w  #BPL2MOD,(a1)+
        move.w  #-2,(a1)+               ; a0

        move.w  #BPLCON0,(a1)+
        move.w  #$1204,(a1)+

; Bottom play area (8)                  ; Wait till bottom area
        ;move.w  #$ffdf,(a1)+            ; Wait for line 255
        ;move.w  #$fffe,(a1)+
        ;move.w  #$1707,(a1)+            ; Wait Horizontal position
        ;move.w  #$ff00,(a1)+            ; unmask verticla and horizontal
        rts
	
; a0 = Text Pointer
agdPrintString:
		IFEQ	ENABLE_DEBUG_MESSAGES
		bra	.exit
		ENDC
		movem.l	d0-d7/a0-a6,-(a7)
		move.l	DOSBASE,a6
		moveq	#-1,d3
		move.l	a0,d2
.strlen:	addq.l	#1,d3
		tst.b	(a0)+
		bne.s	.strlen
		jsr	_LVOOutput(a6)
		move.l	d0,d1
		jsr	_LVOWrite(a6)
		move.l	a6,a1
		movem.l	(a7)+,d0-d7/a0-a6
.exit:		rts


; a0 = Text Pointer
agdPrintLine:
		movem.l	d0-d7/a0-a6,-(a7)
		move.l	DOSBASE,a6
		moveq	#-1,d3
		move.l	a0,d2
.strlen:	addq.l	#1,d3
		tst.b	(a0)+
		bne.s	.strlen
		jsr	_LVOOutput(a6)
		move.l	d0,d1
		jsr	_LVOWrite(a6)
		move.l	a6,a1
		movem.l	(a7)+,d0-d7/a0-a6
.exit:		rts

