; Inputs 

IFACE0:	equ	0
IFACE1:	equ	1
IFACE2:	equ	2
IFACE3:	equ	3
IFACE4:	equ	4
IFACE5:	equ	5
IFACE6:	equ	6
IFACE7:	equ	7

; Joystick Return codes
TURN_NO_MOVE:	equ	0
TURN_UP:	equ	4
TURN_DOWN:	equ	8
TURN_LEFT:	equ	1		; *4 = UP
TURN_RIGHT:	equ	2		; *4 = DOWN
;JOY1_UP_LEFT:	equ	5		
;JOY1_UP_RIGHT:	equ	6
;JOY1_DOWN_LEFT:	equ	9
;OY1_DOWN_RIGHT	equ	10
;JOY1_FIRE:	equ	3

;
; JOYDETECT
;
; Joystick detect routine in port 1 	
;
; Out:
;	d3=Joystick direction code (see Constants)
;

ssSetAllDrones:
		moveq	#maxCars-1,d1
.loop:
		GET_CAR_CONTEXT
		move.w	#-1,carIsDrone(a4)
		move.w	#-1,carIsDroneLast(a4)
		clr.b	carAttrTraction(a4)
		clr.b	carAttrTurbo(a4)
		clr.b	carAttrSpeed(a4)
		bsr	ssRaceSetCarAttributes
		dbf	d1,.loop
		rts
		
		
; This causes the drone to become a player
; Event caused by player pressing button.
ssSetDroneToPlayerInput:
		moveq	#maxCars-1,d7
		
.loop_car:	move.l	d7,d1
		GET_CAR_CONTEXT
		move.l	d7,-(a7)
		bsr	.scene
		move.l	(a7)+,d7
		dbf	d7,.loop_car
		bra	.exit


.scene:		cmp.w	#sceneTrackSelect,CURRENT_SCENE(a6)			; Chance to enter race
		beq.s	.handle_track_select
		bra.s	.handle_prepare_race
		
.handle_track_select:					; Car becomes player from drone if 
		tst.w	carIsDrone(a4)			; button is pressed.
		beq	.exit
		tst.w	carFrameButton(a4)
		beq	.exit
		clr.w	carIsDrone(a4)
		clr.b	carOutOfRace(a4)
		bra	.exit
		

.handle_prepare_race:	
		tst.b	carOutOfRace(a4)		; If the car is out of the race
		bmi.s	.do_hiscore			; Then the hiscore is waiting
		
		tst.w	carIsDrone(a4)			; If the car is a player
		beq.s	.faster_countdown		; then do a faster countdown
		
		tst.w	carFrameButton(a4)		; If the car is a drone and
		bmi.s	.enter_race			; button is pressed then re-enter race.
		
		bra	.exit
		
.lose_custom:	clr.b	carAttrTraction(a4)
		clr.b	carAttrTurbo(a4)
		clr.b	carAttrSpeed(a4)
				
; Car is a drone so lets bring it back into the race.
.enter_race:	clr.w	carIsDrone(a4)
		clr.b	carOutOfRace(a4)
		clr.w	carSpanners(a4)
		clr.l	carScore(a4)
		move.w	#-1,carUpdateScore(a4)
		move.w	#-1,carUpdateSpanners(a4)	

	rept	4
	moveq	#sampleRevs,d0
	bsr	agdPlaySample
	endr
	
	
		bra	.exit
		

; All in player cars can press button to cause countdown to decrease faster		
.faster_countdown:
		bsr	ssPrepareRaceCarsOutOfRace
		tst.l	d0			; Check if any cars still are
		beq	.exit			; out of race.
		tst.w	carStateButton(a4)
		beq	.exit
		addq.l	#4,COUNTDOWN(a6)
		nop
		bra	.exit
		
.do_hiscore:
		tst.w	carStateButton(a4)			; If button is not held
		beq.s	.timer					; then skip timer add.
		
		cmp.l	#120,carTimer(a4)
		bge.s	.lose_custom
		addq.l	#1,carTimer(a4)	
	
.timer:
		tst.w	carFrameButton(a4)			; Button pressed?
		bmi.s	.initial				; Yup...
; hiscore code entry here....
		cmp.w	#TURN_LEFT,carFrameDirection(a4)
		beq	.right
		cmp.w	#TURN_RIGHT,carFrameDirection(a4)
		beq	.left
		bra	.exit
		
.initial:	lea	.alpha(pc),a0
		moveq	#0,d0
		move.b	carHiScoreAlphaPos(a4),d0	; Initial position
		move.b	(a0,d0),d0
		cmp.b	#"Z"+1,d0
		bne.s	.i
		tst.b	carHiscoreInitials+3(a4)
		beq	.disp
		subq.b	#1,carHiscoreInitials+3(a4)
		bra.s	.disp
.i:		addq.b	#1,carHiscoreInitials+3(a4)
		cmp.b	#3,carHiscoreInitials+3(a4)
		bne.s	.disp
; Car now becomes drone
		move.l	carScore(a4),HISCORE_NEW
		move.b	carHiscoreInitials(a4),HISCORE_NEW+4
		move.b	carHiscoreInitials+1(a4),HISCORE_NEW+5
		move.b	carHiscoreInitials+2(a4),HISCORE_NEW+6
; copy the initials to all World record entries for this car.

		bsr	ssHiscoreSetWorldRecordInitials
		
		move.w	#-1,HISCORE_SAVE_REQUIRED(a6)	; Hiscore need saving.
		move.w	#-1,carIsDrone(a4)
		clr.b	carOutOfRace(a4)
		bsr	ssHiscoreConvertToText
		bsr	ssHiscoreSort
		bsr	ssHiscoreCopy
		bra.s	.exit
		
.left:		subq.b	#1,carHiScoreAlphaPos(a4)
		tst.b	carHiScoreAlphaPos(a4)
		bpl.s	.disp
		move.b	#36,carHiScoreAlphaPos(a4)
		bra.s	.disp
		
.right:		addq.b	#1,carHiScoreAlphaPos(a4)
		cmp.b	#36,carHiScoreAlphaPos(a4)
		blt.s	.disp
		clr.b	carHiScoreAlphaPos(a4)
		bra.s	.disp
		nop
		
.disp:		lea	.alpha(pc),a0
		moveq	#0,d0
		move.b	carHiScoreAlphaPos(a4),d0	; Initial position
		
		lea	carHiscoreInitials(a4),a1
		moveq	#0,d1
		move.b	carHiscoreInitials+3(a4),d1	; position
		move.b	(a0,d0),(a1,d1)
		bra	.exit

.alpha:		dc.b	"ABCDEFGHIJKLMNOPQRSTUVWXYZ","Z"+1,"0123456789",0
		even
.exit:		rts


ssGetCarButtons:
ssGetFirstPlayerCar:
		lea	INPUTS_TAB(a6),a0
		moveq	#-1,d0
		moveq	#maxCars-1,d7
.loop:		move.l	4(a0,d7*8),a1
		tst.w	(a1)			; Input pressed?
		beq.s	.next			; Nope. next input port.

		move.w	d7,d0			; Move player car
		bra.s	.exit
.next:		dbf	d7,.loop
.exit:		rts



agdReadInputs:	
		tst.w	INPUT_DISABLED(a6)
		bmi	.exit

		;move.w	#%1010101000000000,POTGO(a5)
		move.w	#$ff00,POTGO(a5)
		bsr	.inputIface13			; Joy Port 1 (left + Right), Joy Port 1 (up + down)		
		bsr	.inputIface02			; Joy Port 0 (left + Right), Joy Port 0 (up + down)
		bsr	.inputIface4	
		bsr	.inputIface5
		bsr	.inputIface6
		bsr	.inputIface7
		
		lea	INPUTS_TAB(a6),a1
		moveq	#maxCars-1,d1
		
.input:		GET_CAR_CONTEXT
		move.l	4(a1,d1*8),a2
		move.l	(a2),carStateButton(a4)
		move.l	(a1,d1*8),a2		
		move.l	(a2),carStateDirection(a4)
		
		cmp.l	#CAR_1,carNumber(a4)
		bne.s	.n
		nop	
.n:		dbf	d1,.input
		
		bra	.exit
	
; a0=INPUT_STATE,INTUT_FRAME
; d3=State	
INPUT_STATE:	equ	0
INPUT_FRAME:	equ	2

.set:		cmp.w	INPUT_STATE(a0),d3		; Is the input state different this frame?
		beq	.unset				; Yes, so unset the frame
		move.w	d3,INPUT_FRAME(a0)
		move.w	d3,INPUT_STATE(a0)
		bra	.exit
.unset:		clr.w	INPUT_FRAME(a0)
		move.w	d3,INPUT_STATE(a0)
		bra	.exit
		
; Read Joystick 1 Left/Right+button 1 and hybrid up/down button 2	
.inputIface13:
		move.w	JOY1DAT(a5),d0
		bsr	.read_joyport
		lea	IFACE1_PORT(a6),a0
		bsr	.set
		and.w	#$c,d3				; Hybrid 
		lsr.w	#2,d3				; Up(4)=Left(1) Down(8)=Right(2)
		lea	IFACE3_PORT(a6),a0
		bsr	.set
		
; Read button #1 of game port 0
		moveq	#0,d3
		btst	#CIAB_GAMEPORT1,CIAA		; Is the button pressed?
		bne.s	.if1b				; No so doesnt matter
		moveq	#-1,d3
.if1b:		lea	IFACE1_BTN1_INPUT(a6),a0
		bsr	.set
			
; Read button #2 of game port 0
		moveq	#0,d3
		btst	#14,POTGOR(a5)
		bne	.if3b
		moveq	#-1,d3
.if3b:		lea	IFACE3_BTN1_INPUT(a6),a0
		bsr	.set
		bra	.exit



; Read Joystick 2 Left/Right+button 1 and hybrid up/down button 2	
.inputIface02:
		move.w	JOY0DAT(a5),d0
		bsr	.read_joyport
		lea	IFACE0_PORT(a6),a0
		bsr	.set
		and.w	#$c,d3				; Hybrid 
		lsr.w	#2,d3				; Up(4)=Left(1) Down(8)=Right(2)
		lea	IFACE2_PORT(a6),a0
		bsr	.set
		
; Read button #1 of game port 0
		moveq	#0,d3
		btst	#CIAB_GAMEPORT0,CIAA		; Is the button pressed?
		bne.s	.if0b				; No so doesnt matter
		moveq	#-1,d3
.if0b:		lea	IFACE0_BTN1_INPUT(a6),a0
		bsr	.set
			
; Read button #2 of game port 0		
		moveq	#0,d3
		btst	#10,POTGOR(a5)
		bne	.if2b
		moveq	#-1,d3
.if2b:		lea	IFACE2_BTN1_INPUT(a6),a0
		bsr	.set
		bra	.exit



.inputIface4:	
		move.b	#$0,$bfe301
		nop
		nop
		moveq	#0,d3
		move.b	$bfe101,d3
		lsr.b	#2,d3				
		and.b	#%11,d3
		lea	IFACE4_PORT(a6),a0
		bsr	.set
		
		moveq	#0,d3
		move.b	$bfd000,d0		
		btst	#2,d0
		bne.s	.i41
		moveq	#-1,d3
.i41:		lea	IFACE4_BTN1_INPUT(a6),a0
		bsr	.set
		bra	.exit

.inputIface5:	
		move.b	#$0,$bfe301
		nop
		nop
		moveq	#0,d3
		move.b	$bfe101,d3			;
		lsr.b	#6,d3				
		and.b	#%11,d3
		lea	IFACE5_PORT(a6),a0
		bsr	.set
		
		moveq	#0,d3
		move.b	$bfd000,d0
		btst	#0,d0
		bne.s	.i51
		moveq	#-1,d3
.i51:		lea	IFACE5_BTN1_INPUT(a6),a0
		bsr	.set
		bra	.exit


; Keyboard - Keyset Left
.inputIface6:	lea	KEYARRAY,a1
		moveq	#-1,d3
		tst.b	$40(a1)				; space
		bmi.s	.i6b
		moveq	#0,d3
.i6b:		lea	IFACE6_BTN1_INPUT(a6),a0
		bsr	.set
		
		moveq	#TURN_RIGHT,d3
		tst.b	$10(a1)				; q
		bmi.s	.i6p
		moveq	#TURN_LEFT,d3
		tst.b	$11(a1)				; x
		bmi.s	.i6p
		moveq	#0,d3
.i6p:		lea	IFACE6_PORT(a6),a0
		bsr	.set
		bra	.exit

; Keyboard - Keyset Right
.inputIface7:	lea	KEYARRAY(a6),a1
		moveq	#-1,d3
		tst.b	$37(a1)				; m
		bmi.s	.i7b
		moveq	#0,d3
.i7b:		lea	IFACE7_BTN1_INPUT(a6),a0
		bsr	.set
		
		moveq	#TURN_RIGHT,d3
		tst.b	$18(a1)				; o
		bmi.s	.i7p
		moveq	#TURN_LEFT,d3
		tst.b	$19(a1)				; p
		bmi.s	.i7p
		moveq	#0,d3
.i7p:		lea	IFACE7_PORT(a6),a0
		bsr	.set
		bra	.exit
	
			
		
; Read joyport 0 or 1	
.read_joyport:	moveq	#0,d3
		move.w	d0,d1			; check joystick down
		move.w	d0,d2
		lsr.w	#1,d2
		and.w	#1,d1
		and.w	#1,d2
		eor.w	d1,d2
		cmp.w	#1,d2
		beq.s	.down			
		
		move.w	d0,d1			; check joystick up
		lsr.w	#8,d1
		move.w	d1,d2
		lsr.w	#1,d2
		and.w	#1,d1
		and.w	#1,d2
		eor.w	d1,d2
		cmp.w	#1,d2
		beq.s	.up
		
.leftright:	btst	#1,d0
		bne.s	.left
		btst	#9,d0
		bne.s	.right
		
.standing:	clr.w	d1		; no movement
		bra.s	.exit
.left:		addq.w	#TURN_LEFT,d3	; left = 2		
		bra.s	.exit
.right:		addq.w	#TURN_RIGHT,d3	; right = 1
		bra.s	.exit
.up:		moveq	#TURN_UP,d3	; up + right = 5	up=4
		bra.s	.leftright	; up + left  = 7
.down:		moveq	#TURN_DOWN,d3	; down + right = 9	down=8
		bra.s	.leftright	; down + left  = 10
		nop
.exit:		rts

