
; hAsset = agdLoadAndUnpackAsset(*filename, memtype)
;    d0                                  a0     d1
agdLoadPackedAsset:
	move.l	a6,-(a7)
	move.l	a0,-(a7)
	lea	txtDbgLoadPackedAsset(a6),a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	
	move.l	a0,-(a7)
	lea	txtDbgNewLine(a6),a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	
	move.l	a0,-(a7)
	;lea	txtDbgLoadPackedAsset,a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	
	movem.l	d1-d7/a0-a1,-(a7)		; Save Registers
	move.l	d1,d5				; Save Requested Memory Type
	
; Open the file for reading
	move.l	a0,-(a7)
	lea	.txtDbgOpenDos(pc),a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	
	move.l	a6,-(a7)
	move.l	a0,d1				      
        move.l  #MODE_OLDFILE,d2
	move.l  DOSBASE(a6),a6 
        jsr     _LVOOpen(a6)         		; handle[d0] = LVOOpenFile(filename[d1],mode[d2])
	move.l	(a7)+,a6
	tst.l	d0				
	beq	.open_error
	
	move.l	a0,-(a7)
	lea	.txtDbgReadHeader(pc),a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	
; Read the RNC header file
	move.l	d0,d4				; Save the file handle for later use.	
	move.l	d0,d1
	lea	amgRncHeaderBuffer(a6),a0		; Buffer to read RNC header bytes into
	move.l	a0,d2						
	move.l	#16,d3				; Read the first 16 bytes of the file.				
	move.l	a6,-(a7)
    	move.l  DOSBASE(a6),a6   
	jsr     _LVORead(a6)         		; bytes[d0] = LVORead(handle[d1],buffer[d2],size[d3])
	move.l	(a7)+,a6
	tst.l	d0				; Was there an error when reading?
	bmi	.header_error			; Yes, there was an error.
	cmp.l	d0,d3				; No error, but did we read the correct number of bytes?
	bne	.read_error			; bytes read was
       
; Check the RNC header
	lea	amgRncHeaderBuffer(a6),a0		; Get pointer to the read header space
	move.l	(a0),d0
	lsr.l	#8,d0
	cmp.l	#"RNC",d0			; Is it RNC?
	bne	.rnc_error

	move.l	a0,-(a7)
	lea	.txtDbgAllocMem(pc),a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	
	nop
	nop
	
; Allocate ram based on RNC header	
	move.l	4(a0),d0			; address[d0] = LVOAllocMem(buffsize[d0],MEM_TYPE[d1])
	move.l	8(a0),d7			; d7=Packed size
	add.l	#$20,d0
	add.l	#$20,d7
	bclr	#0,d7
	
	move.l	a0,-(a7)
	lea	.txtDbgRequesting(pc),a0
	bsr	agdPrintString
	move.l	(a7)+,a0	
	
	move.l	d0,-(a7)
	move.l	a0,-(a7)
	bsr	Binary2Decimal
	bsr	agdPrintString
	move.l	(a7)+,a0
	move.l	(a7)+,d0
	
	move.l	a0,-(a7)
	lea	.txtDbgBytes(pc),a0
	bsr	agdPrintString
	move.l	(a7)+,a0	
	
;d6=unpack size
;d7=pack size
	move.l	d0,d6				; Get unpack length
	move.l	d5,d1
	
	move.l	a6,-(a7)
        move.l  ExecBase,a6
        jsr     _LVOAllocMem(a6)
	move.l	(a7)+,a6
	tst.l	d0
	beq	.alloc_error
						; Save the allocated buffer origin into d5
	ADDSEG_SIZE_D6

	move.l	d0,.alloc_addr
	
	move.l	a0,-(a7)
	lea	.txtDbgSeekToStart(pc),a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	
	move.l	a6,-(a7)
	move.l	d4,d1				; Get file handle for seek 
	move.l	#0,d2				; To 0 byte offset
	move.l	#OFFSET_BEGINNING,d3		; Return to start of file
	move.l  DOSBASE(a6),a6 
	jsr	_LVOSeek(a6)			
	move.l	(a7)+,a6
	
	move.l	a0,-(a7)
	lea	.txtDbgReadFile(pc),a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	
; Read the entire file	
	move.l	d4,d1				; Get file handle for seek 
	move.l	.alloc_addr,d2			; Buffer to read into
	add.l	d6,d2				; Add the unpack size
	sub.l	d7,d2				; then subtract the pack size 
	move.l	d2,.pack_addr
; File is read at the end of the buffer

	move.l	d7,d3				; Read packed length of file
	move.l	a6,-(a7)
	move.l  DOSBASE(a6),a6 
	jsr     _LVORead(a6)        		; bytes[d0] = LVORead(handle[d1],buffer[d2],size[d3]) 	
	move.l	(a7)+,a6
	tst.l	d0
	bmi	.read_error
	move.l	d0,d3
	
	move.l	a0,-(a7)
	lea	.txtDbgCloseFile(pc),a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	
; Close the file
	move.l	d4,d1				; result = LVOClose(handle[d1])      
	move.l	a6,-(a7)
	move.l  DOSBASE(a6),a6 
        jsr     _LVOClose(a6)        
	move.l	(a7)+,a6
	
	move.l	a0,-(a7)
	lea	.txtDbgUnpack,a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	
; Unpack the file.
	movem.l	a0-a1,-(a7)
	move.l	.pack_addr,a0
	move.l	.alloc_addr,a1				; UnpackSize[d0] = Unpack[source[a0],dest[a0]
	bsr	Unpack
	movem.l	(a7)+,a0-a1
	
	move.l	a0,-(a7)
	lea	.txtDbgCreateHandle(pc),a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	
; Create an asset resource
	move.l	#tUnpackedAsset,d0
	bsr	agdCreateNewHandle
	move.l	.alloc_addr,hAddress(a0)			; Save address of asset
	move.l	#tUnpackedAsset,hType(a0)		; Save type of resource
	move.l	d0,hIndex(a0)			; Save handle for this type
	move.l	d6,hSize(a0)			; Save Length of asset
	move.l	a0,d0
	bra	.exit				; All done.
	      
.stop:	bra.s	.stop

      
.open_error:
	move.l	a0,-(a7)
	lea	.txt_open_error(pc),a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	moveq	#ERROR_HANDLE_FILE_OPEN,d0
	bra	.stop
.txt_open_error:	
	dc.b	13,10,"Open() Error",0
	even

.header_error:
	move.l	a0,-(a7)
	lea	.txt_header_error(pc),a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	moveq	#ERROR_HANDLE_HEADER_NOT_FOUND,d0
	bra	.stop
.txt_header_error:	
	dc.b	13,10,"Header() Error",0
	even	
	
.alloc_error:
	move.l	a0,-(a7)
	lea	.txt_alloc_error(pc),a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	moveq	#ERROR_HANDLE_ALLOCATE_FAIL,d0
	bra	.stop
.txt_alloc_error:	
	dc.b	13,10,"Alloc() Error",0
	even	
	
.read_error:
	move.l	a0,-(a7)
	lea	.txt_read_error(pc),a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	moveq	#ERROR_HANDLE_FILE_READ,d0
	bra	.stop
.txt_read_error:	
	dc.b	13,10,"Read() Error",0
	even
	
.rnc_error:
	move.l	a0,-(a7)
	lea	.txt_rnc_error(pc),a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	moveq	#ERROR_HANDLE_RNC,d0
	bra	.stop
.txt_rnc_error:	
	dc.b	13,10,"rnc() Error",0
	even
	
.unpack_error:
	move.l	a0,-(a7)
	lea	.txt_unpack_error(pc),a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	moveq	#ERROR_HANDLE_UNPACK,d0
	bra	.stop
.txt_unpack_error:	
	dc.b	13,10,"Unpack() Error",0
	even
	nop
.txtDbgOpenDos:
	dc.b	13,10,"Calling Open() on DosLib",0
	even
.txtDbgReadHeader:
	dc.b	13,10,"Calling Read() on RNC Header",0
	even
.txtDbgAllocMem:	
	dc.b	13,10,"Calling AllocMem()",0
	even
.txtDbgSeekToStart:
	dc.b	13,10,"Calling Seek() to Beginning of File",0
	even
.txtDbgReadFile:	
	dc.b	13,10,"Calling Read() on all file",0
	even
.txtDbgCloseFile:
	dc.b	13,10,"Calling Close() on file",0
	even
.txtDbgUnpack:
	dc.b	13,10,"Calling Unpack()",0
	even
.txtDbgCreateHandle:
	dc.b	13,10,"Creating handle for asset()",0
	even
.txtDbgRequesting:
	dc.b	13,10,"Requesting ",0
	even
.txtDbgBytes:	
	dc.b	" Bytes",0
	even	
.exit:	
	movem.l	(a7)+,d1-d7/a0-a1
	move.l	a0,-(a7)
	lea	txtDbgOK,a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	move.l	(a7)+,a6
	rts
	
	data
	
.alloc_addr:	dc.l	0
.pack_addr:	dc.l	0
.pack_size:	dc.l	0
.unpack_size:	dc.l	0
	
	code

; hRes = agdAllocateResource(size, memtype)
;    d0                         d0     d1
agdAllocateResource:
	movem.l	d5-d6/a0/a6,-(a7)			; Save Registers	
	move.l	d0,d6				; Get alloc Size
	move.l	a6,-(a7)
        move.l  ExecBase,a6
        jsr     _LVOAllocMem(a6)
	move.l	(a7)+,a6
	tst.l	d0
	beq.s	.alloc_error
	
	ADDSEG_SIZE_D6
	
	move.l	d0,d5				; Save the allocated buffer origin into d5
	
; Create an asset resource
	move.l	#tRes,d0
	bsr	agdCreateNewHandle		
	move.l	#tRes,hType(a0)			; Save type of resource
	move.l	d0,hIndex(a0)			; Save handle for this type
	move.l	d5,hAddress(a0)			; Save address of asset
	move.l	d6,hSize(a0)			; Save Length of asset
	move.l	a0,d0
	bra	.exit				; All done.
	        	
.alloc_error:
	moveq	#ERROR_HANDLE_ALLOCATE_FAIL,d0	
.exit:	movem.l	(a7)+,d5-d6/a0/a6
	rts
	
	
; a0=Pointer to RNC Packed asset
agdCreatePackedAsset:
	movem.l	d0-d7/a1,-(a7)
	move.l	(a0),d0
	lsr.l	#8,d0
	cmp.l	#"RNC",d0			; Is it RNC?
	bne	.rnc_error

	move.l	a0,d5				; d5=Address
	move.l	4(a0),d6			; d6=Unpacked size
	move.l	8(a0),d7			; d7=Packed size

	move.l	#tPackedAsset,d0
	bsr	agdCreateNewHandle
	move.l	d5,hAddress(a0)			; Save address of asset
	move.l	#tUnpackedAsset,hType(a0)	; Save type of resource
	move.l	d0,hIndex(a0)			; Save handle for this type
	move.l	d7,hSize(a0)			; Save Length of asset
	move.l	d6,hPackedAssetUnpackSize(a0)	; Get unpack size
	move.l	a0,d0
	bra.s	.exit
	
.rnc_error:
	moveq	#-1,d0
.exit:	movem.l	(a7)+,d0-d7/a1	
	rts
	

; In
; a0=VRAM Pointer, a1=Packed Asset Pointer,  	
; Out
; a0=Unpacked asset pointer
agdUnpackAssetToVRAM:
	move.l	a0,a2
	move.l	a1,a3
; Request space
	move.l	hPackedAssetUnpackSize(a1),d0
	beq.s	.exit
	moveq	#-1,d1
	bsr	agdCreateScreen
	tst.l	d0
	bmi	mainAllocRamFail
	move.l	d0,a0
	move.l	hAddress(a0),a1
	move.l	(a3),a0
	bsr	Unpack
	move.l	a2,d0
.exit:	rts
	

	
; Here we load using Amiga DOS
; a0=Filename
; a1=Destination buffer
agdLoadBox:
	move.l	a6,-(a7)
	move.l	a0,d1
	move.l	a1,a2
        move.l  #MODE_OLDFILE,d2
	move.l  DOSBASE(a6),a6 
        jsr     _LVOOpen(a6)         		; handle[d0] = LVOOpenFile(filename[d1],mode[d2])
	move.l	d0,d7
	move.l	(a7)+,a6

.open_handle_fail:
	move.w	#$700,$dff180
	tst.l	d0
	beq	.open_handle_fail
	
	move.l	a6,-(a7)
	move.l	d7,d1
	move.l	hAddress(a2),d2
	move.l	#$ffffff,d3
	move.l  DOSBASE(a6),a6 
	jsr     _LVORead(a6)        		; bytes[d0] = LVORead(handle[d1],buffer[d2],size[d3]) 	
	move.l	(a7)+,a6
	
	move.l	a6,-(a7)
	move.l	d7,d1
	move.l  DOSBASE(a6),a6 
        jsr     _LVOClose(a6)        
	move.l	(a7)+,a6	
	rts
	

; hAsset = agdLoadAndUnpackAsset(asset number, memtype)
;    d0                                  d0     d1
agdLoadBoxedAsset:
	move.l	a6,-(a7)
	
	movem.l	d1-d7/a0-a1,-(a7)		; Save Registers
	move.l	d1,d5				; Save Requested Memory Type
	
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	hAddress(a0),a0
	add.l	(a0,d0*4),a0			; Pointer to asset

; Check the RNC header
	move.l	(a0),d0
	lsr.l	#8,d0
	cmp.l	#"RNC",d0			; Is it RNC?
	bne	.rnc_error
	move.l	a0,.pack_addr

; Allocate ram based on RNC header	
	move.l	4(a0),d0			; address[d0] = LVOAllocMem(buffsize[d0],MEM_TYPE[d1])
	move.l	8(a0),d7			; d7=Packed size
	add.l	#$20,d0
	add.l	#$20,d7
	bclr	#0,d7
		
;d6=unpack size
;d7=pack size
	move.l	d0,d6				; Get unpack length
	move.l	d5,d1
	
	move.l	a6,-(a7)
        move.l  ExecBase,a6
        jsr     _LVOAllocMem(a6)
	move.l	(a7)+,a6
	tst.l	d0
	beq	.alloc_error
						; Save the allocated buffer origin into d5
	ADDSEG_SIZE_D6

	move.l	d0,.alloc_addr
	
; Unpack the file.
	movem.l	a0-a1,-(a7)
	move.l	.pack_addr,a0
	move.l	.alloc_addr,a1				; UnpackSize[d0] = Unpack[source[a0],dest[a0]
	bsr	Unpack
	movem.l	(a7)+,a0-a1
	
; Create an asset resource
	move.l	#tUnpackedAsset,d0
	bsr	agdCreateNewHandle
	move.l	.alloc_addr,hAddress(a0)			; Save address of asset
	move.l	#tUnpackedAsset,hType(a0)		; Save type of resource
	move.l	d0,hIndex(a0)			; Save handle for this type
	move.l	d6,hSize(a0)			; Save Length of asset
	move.l	a0,d0
	bra	.exit				; All done.
	      
.stop:	bra.s	.stop

.header_error:
	move.l	a0,-(a7)
	lea	.txt_header_error(pc),a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	moveq	#ERROR_HANDLE_HEADER_NOT_FOUND,d0
	bra	.stop
.txt_header_error:	
	dc.b	13,10,"Header() Error",0
	even	
	
.alloc_error:
	move.l	a0,-(a7)
	lea	.txt_alloc_error(pc),a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	moveq	#ERROR_HANDLE_ALLOCATE_FAIL,d0
	bra	.stop
.txt_alloc_error:	
	dc.b	13,10,"Alloc() Error",0
	even	
	
.rnc_error:
	move.l	a0,-(a7)
	lea	.txt_rnc_error(pc),a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	moveq	#ERROR_HANDLE_RNC,d0
	bra	.stop
.txt_rnc_error:	
	dc.b	13,10,"rnc() Error",0
	even
	
.unpack_error:
	move.l	a0,-(a7)
	lea	.txt_unpack_error(pc),a0
	bsr	agdPrintString
	move.l	(a7)+,a0
	moveq	#ERROR_HANDLE_UNPACK,d0
	bra	.stop
.txt_unpack_error:	
	dc.b	13,10,"Unpack() Error",0
	even
	nop

.exit:	
	movem.l	(a7)+,d1-d7/a0-a1

	move.l	(a7)+,a6
	rts
	
	data
	
.alloc_addr:	dc.l	0
.pack_addr:	dc.l	0
.pack_size:	dc.l	0
.unpack_size:	dc.l	0
	
	code
	
ssLoadSaveSetLoadText:
	move.l	SCRPTR_LOADSAVE(a6),a1
	move.l	(a1),a1
	moveq	#1,d3
	move.l	#0,d0
	move.l	#0,d1	
	lea	.textload(pc),a0
	bsr	agdLoadSaveFont
	bra	ssLoadSaveStartCopper
			;0123456789012345678901234567890123456789012345678901234567890123
.textload:	dc.b	"               PLEASE WAIT . LOADING NEXT TRACK                 ",0
	even
	
ssLoadSaveSetSaveText:
	move.l	SCRPTR_LOADSAVE(a6),a1
	move.l	(a1),a1
	moveq	#1,d3
	move.l	#0,d0
	move.l	#0,d1	
	lea	.textsave(pc),a0
	bsr	agdLoadSaveFont
	bra	ssLoadSaveStartCopper
		;0123456789012345678901234567890123456789
.textsave:	dc.b	"               PLEASE WAIT . SAVING HISCORE TABLE               ",0
		even
		
ssLoadSaveSetSupport:
	move.l	SCRPTR_LOADSAVE(a6),a1
	move.l	(a1),a1
	moveq	#1,d3
	move.l	#0,d0
	move.l	#0,d1	
	lea	.textsupport(pc),a0
	bsr	agdLoadSaveFont
	bra	ssLoadSaveStartCopper
		;0123456789012345678901234567890123456789
.textsupport:	dc.b	"      SUPPORT AMIGA DEVS     WINNERS DONT PIRATE GAMES           ",0
		even
	
	
ssLoadSaveStartCopper:
	lea	$dff000,a5	
	IFEQ	ENABLE_DEBUG
	INIT_DMA_INT
	move.l	COPPTR_LOADSAVE(a6),a1		; Get copper structure
	move.l	(a1),d1				; Address of copper list
	move.l	d1,COP1LCH(a5)			; 
	move.l	d1,COP2LCH(a5)
	move.w	#0,COPJMP1(a5)
	move.w	#0,COPJMP2(a5)
	move.w	#(DMAF_SETCLR!DMAF_MASTER!DMAF_RASTER!DMAF_COPPER),DMACON(a5)
	ENDC
	
	rts

; d0=8x8 x
; d1=8x8 y
; a0=text
; a1= Direct pointer to screen address
agdLoadSaveFont:
        movem.l d0-d1/a0-a2,-(a7)

	move.l	BMPPTR_SMALL_FONT(a6),a2
	move.l	hBitmapBody(a2),a2		; Get to font.
	addq.w	#8,a2
	move.l	a2,a3

.loop:	move.l	a3,a2
        moveq   #0,d0
	
        move.b  (a0)+,d0
	beq	.exit
	sub.b	#$20,d0				; Is it $30 = Space?  'A' = $41
	beq.s	.calc				; 
	addq.w	#6,a2				; Go to 012345679 in Font.
	sub.b	#16,d0				; 0-9?
	cmp.b	#10,d0				; 9 or less?  
	ble.s	.calc				; Yes
	sub.b	#7,d0				; Index to alpha.
	
.calc:  add.l   d0,a2           			; index into character

        move.b  (a2),(a1)
        move.b  SmallFontWidth*1(a2),64*1(a1)
        move.b  SmallFontWidth*2(a2),64*2(a1)
        move.b  SmallFontWidth*3(a2),64*3(a1)
        move.b  SmallFontWidth*4(a2),64*4(a1)
        move.b  SmallFontWidth*5(a2),64*5(a1)
        move.b  SmallFontWidth*6(a2),64*6(a1)
        move.b  SmallFontWidth*7(a2),64*7(a1)
        addq.w  #1,a1
        bra.s     .loop
.exit:  movem.l (a7)+,d0-d1/a0-a2
        rts

