WaitVbl:
raceWaitVbl:
.frame:
.loop	move.l	$dff004,d0
	and.l	#$1ff00,d0
	cmp.l	#220<<8,d0
	bne.b	.loop

.loop2	move.l	$dff004,d0
	and.l	#$1ff00,d0
	cmp.l	#220<<8,d0
	beq.b	.loop2
	
	rts


WaitEOF:				;wait for end of frame
	WAIT_FOR_BLITTER
	move.w	#200,d0
WaitRaster:
	move.l	d0,-(a7)
				;Wait for scanline d0. Trashes d1.
.vpos:  move.l  VPOSR(a5),d0
        and.l   #$1ff00,d0
        cmp.l   #200<<8,d0              ; Wait for line 303
        bne.s   .vpos
	
.vposn: move.l  VPOSR(a5),d0
        and.l   #$1ff00,d0
        cmp.l   #200<<8,d0              ; Wait till line 303 finished.
        beq.s   .vposn
        
	move.l	(a7)+,d0
	rts


; void agdClearScreen(*ptr pScreen)
; d0=Source Bitmap 
; d1=Dest Screen Structure
agdCopyBitmapToScreen:
	movem.l	d0/a0-a3,-(a7)
	move.l	d0,a0
	move.l	d1,a1
	
	move.l	hBitmapBody(a0),a2
	move.l	hScreenPointers(a1),a3
	move.l	4(a2),d0
	
	addq.w	#8,a2
	
	lsr.l	#2,d0
.loop:	move.l	(a2)+,(a3)+
	dbf	d0,.loop
	movem.l	(a7)+,d0/a0-a3
	rts
	
	
;  void agdClearScreen(*ptr pScreen)
; d0=Source Bitmap 
; d1=Dest Screen Structure
; d2=Line to copy from
agdCopyBitmapToScreenFromLine:
	movem.l	d0-d2/a0-a3,-(a7)
	move.l	d0,a0
	move.l	d1,a1
	
	move.l	hBitmapBody(a0),a2
	move.l	hScreenPointers(a1),a3
	move.l	4(a2),d0
	addq.w	#8,a2

	moveq	#0,d1
	move.w	hBitmapScanLength(a0),d1	; Scanline length
	mulu.l	d2,d1				; multiply by line number
	
	add.l	d1,a2				; Index into bitmap
	add.l	d1,a3				; Index into screen
	sub.l	d1,d0				; reduce copy size bytes
	
	
	lsr.l	#2,d0
.loop:	move.l	(a2)+,(a3)+
	dbf	d0,.loop
	movem.l	(a7)+,d0-d2/a0-a3
	rts
	
; *pVideoRam = agdCreateVideoRam(uLong size)
;       d0                      d0          
agdCreateVideoRam:
	movem.l	d1-d7/a0,-(a7)	
	move.l	d0,d7				; Save size
; Allocate Chip ram
	move.l	#(MEMF_CHIP!MEMF_CLEAR),d1
	move.l	a6,-(a7)
	move.l  ExecBase,a6
        jsr     _LVOAllocMem(a6)
	move.l	(a7)+,a6
	tst.l	d0
	beq.s	.error
	ADDSEG_SIZE_D7
	move.l	d0,d6				; Save the allocated buffer origin into d6	
	
; Create a new handle
	move.l	#tVideoRam,d0
	bsr	agdCreateNewHandle
	move.l	#tVideoRam,hType(a0)		; Save type of resource
	move.l	d0,hIndex(a0)			; Save handle for this type
	move.l	d6,hAddress(a0)			; Save the Address
	move.l	d7,hSize(a0)			; Save the Size
	clr.l	hVramNumScreens(a0)
	move.l	d7,hVramRemainingRam(a0)
	move.l	a0,d0
	bra.s	.exit
.error:	moveq	#-1,d0
.exit:	movem.l	(a7)+,d1-d7/a0
	rts
	
;a0=VRAM Pointer
agdDestroyAllVramScreens:
	movem.l	d0-d1/a0-a1,-(a7)	

	move.l	hAddress(a0),a1
	move.l	hSize(a0),d1
	subq.l	#2,d1
	lsr.l	#4,d1
	
.clear:	clr.l	(a1)+			
	clr.l	(a1)+
	clr.l	(a1)+
	clr.l	(a1)+
	;rept	4	
	;move.l	#"BEEF",(a1)+
	;endr
	dbf	d1,.clear

	move.l	hVramNumScreens(a0),d0		; exit if no screens configured.
	beq.s	.exit
	subq.l	#1,d0
	clr.l	hVramNumScreens(a0)
	move.l	hSize(a0),hVramRemainingRam(a0)
	
.loop:	movem.l	d0/a0/a2,-(a7)
	move.l	hVramScreens(a0,d0*4),a0
	bsr	agdDestroyScreen
	movem.l	(a7)+,d0/a0/a2
	
	move.l	#-1,hVramScreens(a0,d0*4)	

;destroy each screen 
; need to check each double buffered screen and kill them.
	dbf	d0,.loop
	moveq	#0,d0
	bra.s	.exit
.error:	moveq	#-1,d0
	bra.s	.error
.exit:	movem.l	(a7)+,d0-d1/a0-a1
	rts
	
; a0=Screen Structure
; if Screen is part of a double buffer then
; Double buffer is destroyed too.
agdDestroyScreen:
; Traverse all double buffers first and check for the screen.
	move.l	#tDbuffScreen,d0
	bsr	.param
	bsr	.dbuff_loop
	
	move.l	#tPseudoScreen,d0
	bsr	.param
	bsr	.pseudo_loop
	
	move.l	#tScreen,d0
	bsr	.param
	bsr	.screen_loop
	
	move.l	#tBitmap,d0
	bsr	.param
	bsr	.generic_loop	

	move.l	#tBitmapMask,d0
	bsr	.param
	bsr	.generic_loop

	move.l	#tSpriteSheet,d0
	bsr	.param
	bsr	.generic_loop
	
	bra	.exit
	
	
.param:	lea	RESOURCE_TABLE(a6),a1
	lsl.l	#4,d0
	add.l	d0,a1
	move.l	a1,a2
	move.l	8(a1),d7
	move.l	4(a1),d2			; Struct Size
	move.l	(a1),a1				; Double Buffer structs
	subq.w	#1,d7
	bra	.exit

.generic_loop:
	tst.w	(a1)
	bmi.s	.generic_next
	move.l	d2,d6
	cmp.l	a1,a0
	beq.s	.4
	bra.s	.generic_next
.4:	bsr	.destroy
	subq.l	#1,12(a2)
.generic_next:
	add.l	d2,a1					; Next struct
	dbf	d7,.generic_loop
	bra	.exit
	
.dbuff_loop:	
	tst.w	(a1)
	bmi.s	.dbuff_next
	move.l	d2,d6
	cmp.l	hDbuffScreenPost(a1),a0
	beq.s	.1
	cmp.l	hDbuffScreen1(a1),a0
	beq.s	.1
	cmp.l	hDbuffScreen2(a1),a0
	beq.s	.1
	bra.s	.dbuff_next
.1:	bsr	.destroy
	subq.l	#1,12(a2)
.dbuff_next:	
	add.l	d2,a1					; Next struct
	dbf	d7,.dbuff_loop
	bra	.exit
	
.pseudo_loop:	
	tst.w	(a1)
	bmi.s	.pseudo_next
	move.l	d2,d6
	cmp.l	hPseudoScreenPost(a1),a0
	beq.s	.2
	cmp.l	hPseudoScreen1(a1),a0
	beq.s	.2
	cmp.l	hPseudoScreen2(a1),a0
	beq.s	.2
	bra.s	.pseudo_next	
.2:	bsr	.destroy
	subq.l	#1,12(a2)
.pseudo_next:
	add.l	d2,a1					; Next struct
	dbf	d7,.pseudo_loop
	bra	.exit
	
.screen_loop:	
	tst.w	(a1)
	bmi.s	.screen_next
	move.l	d2,d6
	cmp.l	a1,a0
	beq.s	.3
	bra.s	.screen_next
.3:	bsr	.destroy
	subq.l	#1,12(a2)
.screen_next:
	add.l	d2,a1					; Next struct
	dbf	d7,.screen_loop
	bra	.exit

.destroy:
	move.b	#-1,(a1,d6)
	dbf	d6,.destroy
.exit:	rts
	
; *pScreen = agdCreateScreen(uWord SizeX ,uWord SizeY, uWord Bitplanes, ptr vRam)
;       d0                      d0           d1           d2		a0
agdCreateScreen:
	movem.l	d1-d7/a0-a2,-(a7)
	tst.l	d1
	bmi.s	.x
	
	lsr.w	#3,d0				; Divide width by 8
	move.l	d0,d3				; Save width
	move.l	d1,d4				; Save depth
	move.l	d2,d5				; Save planes

	mulu	d2,d0				; Get size to allocate
	mulu	d1,d0				; 
	bra.s	.y
	
.x:	moveq	#1,d2				; Fake Bitplanes
.y:	add.l	#$10,d0				; make sure we keep aligned. 
	move.l	d0,d7				; Save size

	;move.l	(a0),a0				; Get VRAM Struct
	
	cmp.l	hVramRemainingRam(a0),d0	; Check enough bytes in VRAM	
	bgt	.error				; Not enough ram
; Enough...
	move.l	hAddress(a0),d6			; Start of Video Ram in d6
	add.l	hSize(a0),d6			; Go to end of Video RAM
	sub.l	hVramRemainingRam(a0),d6	; Go to end of last screen
	and.l	#$fffffff0,d6			; Align 
; d6 is now start of new screen

	addq.l	#1,hVramNumScreens(a0)		; Increase number of screens
	sub.l	d0,hVramRemainingRam(a0)	; Decrease Available Bytes 
	move.l	a0,a2
	
; Create a new handle
	move.l	#tScreen,d0
	bsr	agdCreateNewHandle
	tst.l	d0
	bmi	.error
	move.l	#tScreen,hType(a0)		; Save type of resource
	move.l	d0,hIndex(a0)			; Save handle for this type
	move.l	d6,hAddress(a0)			; Save the Address
	move.l	d7,hSize(a0)			; Save the Size
; a0 has pointer to Screen Handle
	
	move.l	d6,a1
	lsr.l	#2,d7
	subq.l	#1,d7
.clear:	clr.l	(a1)+
	dbf	d7,.clear
	
; d0=Pointer to new handle
	move.w	d3,hScreenWidth(a0)		; Save Width
	move.w	d4,hScreenDepth(a0)		; Save Depth
	move.w	d5,hScreenPlanes(a0)		; Save num planes
	
	move.l	hVramNumScreens(a2),d1
	subq.l	#1,d1
	bmi.s	.error
	move.l	a0,hVramScreens(a2,d1*4)			; Save screen address in vram


; Get number of colours
	moveq	#0,d4				; Number of colours
	bset	d2,d4	
	move.w	d4,hScreenColours(a0)		

	mulu	d3,d5				; Scanline width
	move.w	d5,hScreenScanline(a0)		
	sub.w	d3,d5
	move.w	d5,hScreenModulo(a0)		; Save modulo
	
	clr.w	hScreenOffset(a0)		; Clear Offset
	clr.w	hScreenHScroll(a0)		; Clear HScroll Position
	
	subq.w	#1,d2
	lea	hScreenPointers(a0),a1		; Get screen pointers
.loop:	move.l	d6,(a1)+
	add.l	d3,d6
	dbf	d2,.loop
	
	move.l	a0,d0
	bra.s	.exit
.error:	moveq	#-1,d0
.exit:	movem.l	(a7)+,d1-d7/a0-a2
	rts
	
	
; *pScreen = agdCreateScreenFromBitmap(ptr vRam, hBitmap)
;       d0                             a0	 a1
agdCreateScreenFromBitmap:
	movem.l	d1-d7/a0-a2,-(a7)
	
	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	move.w	hBitmapMaskWidth(a1),d0
	move.w	hBitmapMaskDepth(a1),d1
	move.w	hBitmapPlanes(a1),d2	
	
	lsr.w	#3,d0				; Divide width by 8
	move.l	d0,d3				; Save width
	move.l	d1,d4				; Save depth
	move.l	d2,d5				; Save planes

	mulu	d2,d0				; Get size to allocate
	mulu	d1,d0				; 
	 
	move.l	d0,d7				; Save size

	move.l	hAddress(a0),d6			; Start of Video Ram in d6
	add.l	hSize(a0),d6			; Go to end of Video RAM
	sub.l	hVramRemainingRam(a0),d6	; Go to end of last screen
	and.l	#$fffffff0,d6			; Align 
	
	;move.l	#$20,d0				; Totally fake size!
	addq.l	#1,hVramNumScreens(a0)		; Increase number of screens
	
	move.l	hVramRemainingRam(a0),d0
	sub.l	d7,d0
	bmi	.exit
	move.l	d0,hVramRemainingRam(a0)	; Decrease Available Bytes 
	
	
	move.l	a0,a2
	
; Create a new handle
	move.l	#tScreen,d0
	bsr	agdCreateNewHandle
	move.l	#tScreen,hType(a0)		; Save type of resource
	move.l	d0,hIndex(a0)			; Save handle for this type
	move.l	d6,hAddress(a0)			; Save the Address
	move.l	d7,hSize(a0)			; Save the Size
; a0 has pointer to Screen Handle
	
; d0=Pointer to new handle
	move.w	d3,hScreenWidth(a0)		; Save Width
	move.w	d4,hScreenDepth(a0)		; Save Depth
	move.w	d5,hScreenPlanes(a0)		; Save num planes
	
	move.l	hVramNumScreens(a2),d1
	subq.l	#1,d1
	;bmi.s	.error
	move.l	a0,hVramScreens(a2,d1*4)			; Save screen address in vram

; Get number of colours
	moveq	#0,d4				; Number of colours
	bset	d2,d4	
	move.w	d4,hScreenColours(a0)		

	mulu	d3,d5				; Scanline width
	move.w	d5,hScreenScanline(a0)		
	sub.w	d3,d5
	move.w	d5,hScreenModulo(a0)		; Save modulo
	
	clr.w	hScreenOffset(a0)		; Clear Offset
	clr.w	hScreenHScroll(a0)		; Clear HScroll Position
	
	subq.w	#1,d2
	lea	hScreenPointers(a0),a1		; Get screen pointers
.loop:	move.l	d6,(a1)+
	add.l	d3,d6
	dbf	d2,.loop
	
	move.l	a0,d0
	bra.s	.exit
.error:	moveq	#-1,d0
.exit:	movem.l	(a7)+,d1-d7/a0-a2
	rts
	
	
	
; In
;
;d0=POST SCreen Struct
;d1=Screen 1 Struct
;d2=Screen 2 Struct
;d3=Screen 3 Struct
; Out
;
agdCreateDbuffScreen:
	agdSerialEntry #$37dc26e9
	move.l	a0,-(a7)
; Create a new handle
	exg.l	d0,d4
	move.l	#tDbuffScreen,d0
	bsr	agdCreateNewHandle
	move.l	#tDbuffScreen,hType(a0)		; Save type of resource
	move.l	d0,hIndex(a0)			; Save handle for this type
	move.l	#0,hAddress(a0)			; Save the Address
	move.l	#0,hSize(a0)			; Save the Size
	clr.w	hDbuffXPos(a0)
	clr.w	hDbuffYPos(a0)
	
	tst.l	d4
	beq.s	.done
	move.l	d4,hDbuffScreenPost(a0)
	tst.l	d1
	beq.s	.done
	move.l	d1,hDbuffScreen1(a0)
	tst.l	d2
	beq.s	.done
	move.l	d2,hDbuffScreen2(a0)
	tst.l	d3
	beq.s	.done
	;move.l	d3,hDbuffScreen3(a0)	
	nop
.done:	move.l	a0,d0
	move.l	(a7)+,a0
	agdSerialLeave #$37dc26e9
	rts


; void agdClearScreen(*ptr pScreen)
; d0=Screen Structure
agdClearScreen:
	movem.l	d0/a0-a1,-(a7)
	move.l	d0,a0
	move.l	hAddress(a0),a1
	move.l	hSize(a0),d0
	lsr.l	#2,d0
.loop:	clr.l	(a1)+
	dbf	d0,.loop
	movem.l	(a7)+,d0/a0-a1
	rts
	
	
; d0=Source Bitmap 
; d1=Dest Screen Structure	
agdTransitionBitmapToScreen:
	lea	$dff000,a5
	moveq	#0,d2
	moveq	#9,d6
.wait:	movem.l	d0-d1,-(a7)
.loop:	bsr	WaitRaster
	movem.l	(a7)+,d0-d1
	bsr	agdCopyBitmapToScreenTransition
	addq.l	#1,d2
	dbf	d6,.wait
	rts
	
	
;d0=Dest screen structure
agdTransitionBitmapFromScreen:
	move.l	d0,d1				;source is destination
	lea	$dff000,a5
	moveq	#9,d2				; Start transition
	moveq	#9,d6
.wait:	movem.l	d0-d1,-(a7)
.loop:	bsr	WaitRaster
	movem.l	(a7)+,d0-d1
	bsr	agdCopyBitmapToScreenTransition
	subq.l	#1,d2				; Decrease
	dbf	d6,.wait
	rts
	
; a0=Lower Track Double Buffer
; a1=Upper Track Double Buffer

	near	a6
	
agdTranstionFromDoubleBuffer:
	movem.l	d0-d7/a0-a5,-(a7)
	clr.w	.xpos(a6)
	
	move.l	hDbuffScreen1(a0),a2
	move.l	hDbuffScreen2(a0),a3
	move.l	hDbuffScreen1(a1),a0
	move.l	hDbuffScreen2(a1),a1
	move.l	(a0),a0
	move.l	(a1),a1
	move.l	(a2),a2
	move.l	(a3),a3

.loop_x:	
	bsr	raceWaitVbl
	moveq	#0,d0
	moveq	#64,d1

	moveq	#0,d5				; X Position
	move.w	.xpos(a6),d5
	
	cmp.w	#64*2,d5
	beq.s	.exit
	
	moveq	#0,d6				; Y Position
	moveq	#0,d2
	
.loop_y:
	movem.l	a0-a3,-(a7)
	move.l	d5,d3				; d3=x
	
	sub.l	d2,d3
	bpl.s	.plus
	moveq	#0,d3

.plus:	move.l	d6,d4				; d4=y
	
	lsl.l	#3,d4				; Multiply by 8
	lsl.l	#8,d4				; Mutliply by scan lines
	add.l	d3,d4				; X Position
	
	moveq	#(4*8)-1,d7
	
	add.l	d4,a0
	add.l	d4,a1
	add.l	d4,a2
	add.l	d4,a3
	
; Clear the block
.clear:	move.b	d0,(a0)
	move.b	d0,(a1)
	move.b	d0,(a2)
	move.b	d0,(a3)
	add.l	d1,a0
	add.l	d1,a1
	add.l	d1,a2
	add.l	d1,a3
	dbf	d7,.clear
	
	movem.l	(a7)+,a0-a3
	
	addq.w	#1,d2
	
	addq.w	#1,d6
	cmp.w	#48,d6			; All the way to bottom
	bne	.loop_y
	addq.w	#1,.xpos(a6)			; Next X
	bra.s	.loop_x
.exit:	movem.l	(a7)+,d0-d7/a0-a5
	rts

	data
	
.xpos:	dc.w	0

	code

	
; a0=Lower Track Double Buffer
; a1=Upper Track Double Buffer
; a2=Lower Bitmap Pointer
; a3=Upper Bitmap Pointer

	near	a6
	
agdTranstionBitmapToDoubleBuffers:
	movem.l	d0-d7/a0-a5,-(a7)
	clr.w	.xpos(a6)
	
	move.l	hBitmapBody(a2),a4
	addq.w	#8,a4
	move.l	hBitmapBody(a3),a5
	addq.w	#8,a5
	
	move.l	hDbuffScreen1(a0),a2
	move.l	hDbuffScreen2(a0),a3
	move.l	hDbuffScreen1(a1),a0
	move.l	hDbuffScreen2(a1),a1
	move.l	(a0),a0
	move.l	(a1),a1
	move.l	(a2),a2
	move.l	(a3),a3
	
.loop_x:	
	bsr	raceWaitVbl
	movem.l	d0-d7/a0-a5,-(a7)
	bsr	ssRaceGetReady
	movem.l	(a7)+,d0-d7/a0-a5
	
	moveq	#0,d0
	moveq	#64,d1

	moveq	#0,d5				; X Position
	move.w	.xpos(a6),d5
	
	cmp.w	#64,d5
	beq.s	.exit
	
	moveq	#0,d6				; Y Position
	moveq	#0,d2
	
.loop_y:
	movem.l	a0-a5,-(a7)
	move.l	d5,d3				; d3=x
	
	sub.l	d2,d3
	bpl.s	.plus
	moveq	#0,d3

.plus:	move.l	d6,d4				; d4=y
	
	lsl.l	#3,d4				; Multiply by 8
	lsl.l	#8,d4				; Mutliply by scan lines
	add.l	d3,d4				; X Position
	
	moveq	#(4*8)-1,d7
	
	add.l	d4,a0
	add.l	d4,a1
	add.l	d4,a2
	add.l	d4,a3
	add.l	d4,a4
	add.l	d4,a5
	
; Clear the block
.clear:	move.b	(a4),(a0)
	move.b	(a4),(a1)
	move.b	(a5),(a2)
	move.b	(a5),(a3)
	add.l	d1,a0
	add.l	d1,a1
	add.l	d1,a2
	add.l	d1,a3
	add.l	d1,a4
	add.l	d1,a5
	dbf	d7,.clear
	
	movem.l	(a7)+,a0-a5
	
	;addq.w	#1,d2
	
	addq.w	#1,d6
	cmp.w	#48,d6			; All the way to bottom
	bne	.loop_y
	addq.w	#1,.xpos(a6)			; Next X
	bra.s	.loop_x
.exit:	movem.l	(a7)+,d0-d7/a0-a5
	rts

	data
	
.xpos:	dc.w	0

	code

	
; void agdClearScreen(*ptr pScreen)
; d0=Source Bitmap 
; d1=Dest Screen Structure
; d2=8x8 Transition to apply (See Transition Table)
agdCopyBitmapToScreenTransition:
	movem.l	d0-d7/a0-a4,-(a7)
	lea	.table(pc),a4
	lsl.l	#3,d2
	add.l	d2,a4
	
	move.l	d0,a0
	move.l	d1,a1

	move.l	hScreenPointers(a1),a3
	cmp.l	d0,d1
	bne.s	.to
	move.l	a3,a2
	bra.s	.ok
.to:
	move.l	hBitmapBody(a0),a2
	move.l	4(a2),d0
	addq.w	#8,a2				; a2=src

.ok:	moveq	#0,d3
	moveq	#0,d4
	moveq	#0,d5
	moveq	#0,d6
	moveq	#0,d7				; 8 bytes each
	move.w	hScreenDepth(a1),d3
	subq.l	#1,d3
.height:
	move.w	hScreenScanline(a1),d6		; Bytes per line (256)
	subq.l	#1,d6				; 255

	lsr.w	#3,d6

.line:	move.b	(a4,d7),d5
	move.l	(a2)+,d2

	rept	4
	and.b	d5,d2
	rol.l	#8,d2
	endr
	
	move.l	(a2)+,d4
	rept	4
	and.b	d5,d4
	rol.l	#8,d4
	endr
	
	move.l	d2,(a3)+
	move.l	d4,(a3)+
	dbf	d6,.line			; Copy line of bytes and apply mask

	addq.b	#1,d7	
	and.l	#$7,d7			; only 0-7	
	
	dbf	d3,.height

.exit:	movem.l	(a7)+,d0-d7/a0-a4
	rts
	
.table:	
	dc.b	%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00001000,%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00001000,%00011100,%00001000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00001000,%00011100,%00111110,%00011100,%00001000,%00000000,%00000000
	dc.b	%00001000,%00011100,%00111110,%01111111,%00111110,%00011100,%00001000,%00000000
	dc.b	%00011100,%00111110,%01111111,%11111111,%01111111,%00111110,%00011100,%00001000
	dc.b	%00111110,%01111111,%11111111,%11111111,%11111111,%01111111,%00111110,%00011100
	dc.b	%01111111,%11111111,%11111111,%11111111,%11111111,%11111111,%01111111,%00111110
	dc.b	%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%01111111
	dc.b	%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
	even