


	
; a0=Screen  d0=X Pixel Position
; a1=Text    d1=Y Pixel Position
;            d3=Bitplane Placement eg.%00111 set MSB.L ($8000xxxx)
;						to clear background (faster) 
;	
SmallFontWidth:	equ	352/8
agdSmallFont:
	movem.l	d0-d7/a0/a3/a4,-(a7)
	move.l	a1,a3

	moveq	#0,d7
	move.w	hScreenPlanes(a0),d7
	subq.w	#1,d7
		
	move.l	hScreenPointers(a0),a2		; Get Screen address base address
	lsr.w	#3,d0				; d0= x offset in bytes.
	mulu	hScreenScanline(a0),d1		; d1= y Offset
	add.l	d0,a2
	add.l	d1,a2 
	moveq	#0,d1
	move.w	hScreenWidth(a0),d1
						; Font modulo
	moveq	#0,d4
	move.w	hScreenScanline(a0),d4		; Screen modulo

	move.l	BMPPTR_SMALL_FONT(a6),a1
	move.l	hBitmapBody(a1),a1		; Get to font.
	addq.w	#8,a1
	move.l	a1,d5
	move.l	a2,d6
	move.l	a3,a4
	
.bitplane:
	move.l	a4,a3
	moveq	#0,d2
	
	
.loop:	move.l	d5,a1				; Font address
	move.l	d6,a2
	add.l	d2,a2
	
	moveq	#0,d0
	move.b	(a3)+,d0
	beq	.next
	sub.b	#$20,d0				; Is it $30 = Space?  'A' = $41
	beq.s	.calc				; 
	addq.w	#6,a1				; Go to 012345679 in Font.
	sub.b	#16,d0				; 0-9?
	cmp.b	#10,d0				; 9 or less?  
	ble.s	.calc				; Yes
	sub.b	#7,d0				; Index to alpha.
	
.calc:	add.l	d0,a1
	addq.b	#1,d2
	
	btst	#0,d3
	beq	.clear_bitplane
	
.set:	tst.l	d3
	bmi	.set_copy
	
	rept	8
	move.b	(a1),d0				; Remove background bitplane bits
	or.b	d0,(a2)
	add.l	#SmallFontWidth,a1
	add.l	d4,a2
	endr
	bra	.loop
	
; Copy the 
.set_copy:
	rept	8
	move.b	(a1),(a2)			; Remove background bitplane bits
	add.l	#SmallFontWidth,a1
	add.l	d4,a2
	endr
	bra	.loop	

.clear_bitplane:
	tst.l	d3
	bmi	.clear_copy
	
	rept	8
	move.b	(a1),d0
	not.b	d0
	and.b	d0,(a2)
	add.l	#SmallFontWidth,a1
	add.l	d4,a2
	endr
	bra	.loop

.clear_copy:
	rept	8
	clr.b	(a2)			; Remove background bitplane bits
	add.l	d4,a2
	endr
	bra	.loop
	
.next:	lsr.w	#1,d3
	add.l	d1,d6			; next plane
	dbf	d7,.bitplane
	
.exit:	move.l	a3,a1
	movem.l	(a7)+,d0-d7/a0/a3/a4
	rts

;agdDisplayCharacter(Screen_PTR, Sprite_Font_PTR, X, Y)

; a0=Screen  d0=X
; a1=Font    d1=Y
;            d2=Bitplane placement index
;		d3=ascii character

agdLargeFont:
	movem.l	d0-d7/a0-a4,-(a7)
	move.l	SPRPTR_LARGE_FONT(a6),a1
	move.l	hScreenPointers(a0),a2			; Get Screen address
	lsr.w	#3,d0				; d0= x offset in bytes.
	mulu	hScreenScanline(a0),d1		; d1= y Offset
	add.l	d0,a2
	add.l	d1,a2				; Get screen offset
; x/y now complete
	
	move.l	hAddress(a1),a3
	cmp.b	#"$",d3
	bne.s	.space
	moveq	#" ",d3
.space:	sub.b	#$20,d3				; Is it $30 = Space?
	beq.s	.calc				; Yes.
	sub.b	#15,d3
	cmp.b	#10,d3				; 9 or less?  
	ble.s	.calc				; Yes
	subq.b	#7,d3				; Index to alpha.
	
.calc:
	lsl.w	#3,d3				; Multiply by 8
	add.l	d3,a3				; Index 

	
	move.l	4(a3),a4				; Mask address in A4
	move.l	(a3),a3					; Bitmap address in a3
	
	moveq	#0,d3					; Get Font/Sprite Depth
	move.w	hSpriteSizeDepth(a1),d3
	subq.w	#1,d3
	
	moveq	#0,d4
	moveq	#0,d5
	moveq	#0,d6
	
;----------------------------------------------
	move.w	hScreenWidth(a0),d4			; Screen width 
	move.w	hSpriteSheetCols(a1),d5			; Sprite sheet modulo
	add.w	d5,d5
	
	move.w	hScreenPlanes(a0),d6
	subq.w	#1,d6
	
	move.w	d6,d0
	
.line:	move.w	d2,d1
	tst.l	d2				; If minus then make sure we clear.
	bpl.s	.clear
	moveq	#0,d7
	bra.s	.set
	
.clear:	move.w	(a4),d7
	not.w	d7
	
.set:	and.w	d7,(a2)				; Create mask
	btst	#0,d1				; Do this bitplane
	beq.s	.skip
	swap	d7	
	move.w	(a3),d7
	add.l	d5,a3				; Next font bitplane	
	add.l	d5,a4
	or.w	d7,(a2)				; copy word
	swap	d7
	
.skip:	add.l	d4,a2				; Next screen bitpane	
	lsr.w	#1,d1
	dbf	d6,.set			; Screen plane
	
	move.w	d0,d6
	dbf	d3,.line

	movem.l	(a7)+,d0-d7/a0-a4
	rts
	

