INTB_SETCLR    equ   15  ;Set/Clear control bit. Determines if bits
			   ;written with a 1 get set or cleared. Bits
			   ;written with a zero are allways unchanged.
INTB_INTEN     equ   14  ;Master interrupt enable only 
INTB_EXTER     equ   13  ;External interrupt
INTB_DSKSYNC   equ   12  ;Disk re-SYNChronized
INTB_RBF       equ   11  ;serial port Receive Buffer Full
INTB_AUD3      equ   10  ;Audio channel 3 block finished
INTB_AUD2      equ   9   ;Audio channel 2 block finished
INTB_AUD1      equ   8   ;Audio channel 1 block finished
INTB_AUD0      equ   7   ;Audio channel 0 block finished
INTB_BLIT      equ   6   ;Blitter finished
INTB_VERTB     equ   5   ;start of Vertical Blank
INTB_COPER     equ   4   ;Coprocessor
INTB_PORTS     equ   3   ;I/O Ports and timers
INTB_SOFTINT   equ   2   ;software interrupt request
INTB_DSKBLK    equ   1   ;Disk Block done
INTB_TBE       equ   0   ;serial port Transmit Buffer Empty



INTF_SETCLR    equ   $8000
INTF_INTEN     equ   $4000
INTF_EXTER     equ   $2000
INTF_DSKSYNC   equ   $1000
INTF_RBF       equ   $800
INTF_AUD3      equ   $400
INTF_AUD2      equ   $200
INTF_AUD1      equ   $100
INTF_AUD0      equ   $80
INTF_BLIT      equ   $40
INTF_VERTB     equ   $20
INTF_COPER     equ   $10
INTF_PORTS     equ   $8
INTF_SOFTINT   equ   $4
INTF_DSKBLK    equ   $2
INTF_TBE       equ   $1
