ssCheckSum MACRO
	lea	ssControlCar+20(pc),a0
	moveq	#20,d7
	moveq	#0,d0
.sum:	add.l	(a0)+,d0
	ror.l	d0
	dbf	d7,.sum
	ENDM
	
ADDSEG_SIZE_D6	MACRO
	movem.l	d1/a1,-(a7)
	move.l	MEMORY_INDEX(a6),d1
	lea	MEMORY_RELEASE_TAB(a6),a1
	lsl.l	#3,d1
	add.l	d1,a1
	move.l	d0,(a1)
	move.l	d6,4(a1)
	addq.l	#1,MEMORY_INDEX(a6)
	movem.l	(a7)+,d1/a1
	ENDM
	
ADDSEG_SIZE_D7	MACRO
	movem.l	d1/a1,-(a7)
	move.l	MEMORY_INDEX(a6),d1
	lea	MEMORY_RELEASE_TAB(a6),a1
	lsl.l	#3,d1
	add.l	d1,a1
	move.l	d0,(a1)
	move.l	d7,4(a1)
	addq.l	#1,MEMORY_INDEX(a6)
	movem.l	(a7)+,d1/a1
	ENDM
	
WAKE_SYSTEM	MACRO
	IFEQ	ENABLE_DEBUG
	bsr	RemoveScreenInterrupt
	bsr	RemoveKeyboardInterrupt		
	RESTORE_SYSTEM_STATE
	RESTORE_COPPER			; Disable this to stop showing WB screen (must replace though).
	INIT_PERMIT_OS
	OS_WAITBLIT
	DISOWN_BLITTER
	
	lea	CHIPBASE,a5	
	move.w	#0,BEAMCON0(a5)
	move.w #$8000,VPOSW(a5)			; Set LOF Auto Toggle
	ENDC
	ENDM
		
SLEEP_SYSTEM	MACRO
	IFEQ	ENABLE_DEBUG
	OS_WAITBLIT
	OWN_BLITTER			; Take Blitter
	INIT_FORBID_OS			; Forbid()
	WAIT_FOR_BLITTER
	SAVE_SYSTEM_STATE
	INIT_DMA_INT
	bsr	InstallScreenInterrupt
	bsr	InstallKeyboardInterrupt
	ENDC
	ENDM
	
; Turn off motor
STOP_DRIVE_MOTOR	MACRO
        lea     $bfd100,a0
        or.b    #$f8,(a0)
        nop
        and.b   #$87,(a0)
        nop
        or.b    #$78,(a0)
        nop
	ENDM
		


GET_CAR_CONTEXT	MACRO
	lea	carStruct(a6),a4
	lsl.l	#carStructShiftSize,d1
	add.l	d1,a4	
	lsr.l	#carStructShiftSize,d1
	ENDM
	

COMPENSATE_HWSPRX	MACRO
	sub.w	#127,d0
	add.w	d0,d0
	add.w	#188,d0
	ENDM
	
COMPENSATE_HWSPRY	MACRO
	sub.w	#22,d1
	add.w	d1,d1				; Multiply by two for interlace.
	ENDM
	
WAIT_FOR_BLITTER        MACRO
        tst.b   DMACONR(a5)
.1\@    btst    #6,DMACONR(a5)
        bne.s   .1\@
        ENDM	
	
agdSerialInit MACRO
	IFNE	DEBUG_SERIAL
	move.w	#$8000,$dff032		;SERPER set bit 9
	ENDC
	ENDM

agdSerialEntry MACRO
	IFNE	DEBUG_SERIAL
	move.b	#"+",$dff030
	agdSerial \1
	ENDC
	ENDM
	
agdSerialLeave MACRO
	IFNE	DEBUG_SERIAL
	move.b	#"-",$dff030
	agdSerial \1
	ENDC
	ENDM

;\1
agdSerial MACRO
	movem.l	d0-d1/a0,-(a7)
	lea	HEXASCII(pc),a0
	move.l	\1,d0
	moveq	#0,d1
	
	rept	8
	move.b	d0,d1
	and.b	#$f,d1
	lsr.l	#4,d0
	move.b	(a0,d1),$dff030
	endr

	move.b	#$0a,$dff030
	movem.l	(a7)+,d0-d1/a0
	ENDM

	
; d1=car number for inputs
GET_CAR_INPUTS	MACRO
	
	ENDM
	
SET_PARALLEL_PORT	MACRO
	lea 	$bfe101,a0 ; parallel port data
	lea 	$bfe301,a1 ; parallel port ddr
	move.b 	#$00,(a1) ; all bits to input
	move.b 	#$00,(a0) ; set all lines to low/zero	
	ENDM
	
	
END_SCENE	MACRO
	move.w	#(INTF_INTEN!INTF_VERTB!INTF_COPER!INTF_PORTS),INTENA(a5)	
	move.w	#(INTF_INTEN!INTF_VERTB!INTF_COPER!INTF_PORTS),INTENA(a5)
	move.w	#(DMAF_MASTER!DMAF_RASTER!DMAF_COPPER!DMAF_SPRITE),DMACON(a5)
	move.w	#$0201,BPLCON0(a5)						; Clear all bitplanes
	move.w	#$000,COLOR00(a5)
	ENDM
	
INIT_DMA_INT	MACRO
	lea	$dff000,a5
	IFEQ	ENABLE_DEBUG
	move.w	#$7fff,DMACON(a5)		;in DMACON,
	move.w	#$7fff,INTENA(a5)		;INTENA,
	move.w	#$7fff,INTREQ(a5)		;and INTREQ
	move.w	#$7fff,INTREQ(a5)		;twice 
	move.w	#$ff00,POTGO(a5)
	ENDC
	ENDM
		
	
OPEN_LIBS	MACRO
	move.l	a6,-(a7)
	move.l	ExecBase,a6
	lea	GFXNAME(pc),a1
	moveq	#0,d0
	jsr	_LVOOpenLibrary(a6)
	move.l	d0,GFXBASE
	move.l	(a7)+,a6
	ENDM
	
CLOSE_LIBS MACRO
	move.l	GFXBASE,a1
	move.l	ExecBase,a6
	jsr 	_LVOCloseLibrary(a6)
	move.l	DOSBASE,a1
	move.l	ExecBase,a6
	jsr 	_LVOCloseLibrary(a6)	
	ENDM

INIT_FORBID_OS	MACRO
	IFEQ	ENABLE_DEBUG
	lea	$dff000,a5	
	bsr	WaitEOF				; Wait until this frame is complete
	move.l	a6,-(a7)
	move.l	ExecBase,a6
	jsr	_LVOForbid(a6)			; FORBID
	move.l	(a7)+,a6
	ENDC
	ENDM
	
INIT_PERMIT_OS MACRO
	IFEQ	ENABLE_DEBUG
	lea	$dff000,a5	
	;bsr	WaitEOF				
	move.l	a6,-(a7)
	move.l	ExecBase,a6
	jsr	_LVOPermit(a6)			
	move.l	(a7)+,a6
	ENDC
	ENDM

	
SAVE_SYSTEM_STATE	MACRO
	lea	$dff000,a5
	move.w	DMACONR(a5),sysDMACON		
	or.w	#$8000,sysDMACON
	move.w	INTENAR(a5),sysINTENA
	or.w	#$8000,sysINTENA	
	move.w	INTREQR(a5),sysINTREQ
	or.w	#$8000,sysINTREQ
	move.w	ADKCONR(a5),sysADKCON
	or.w	#$8000,sysADKCON
	ENDM
	
RESTORE_SYSTEM_STATE	MACRO
	IFEQ	ENABLE_DEBUG
	lea	$dff000,a5
	move.w	sysDMACON,DMACON(a5)		
	move.w	sysINTENA,INTENA(a5)		
	move.w	sysINTREQ,INTREQ(a5)		
	move.w	sysINTREQ,INTREQ(a5)	
	move.w	sysADKCON,ADKCON(a5)
	ENDC
	ENDM

OS_WAITBLIT	MACRO
	move.l	a6,-(a7)
	move.l	GFXBASE,a6
	jsr	_LVOWaitBlit(a6)
	move.l	(a7)+,a6	
	ENDM
	
OWN_BLITTER	MACRO
	move.l	a6,-(a7)
	move.l	GFXBASE,a6
	jsr	_LVOOwnBlitter(a6)
	move.l	(a7)+,a6
	ENDM
	
DISOWN_BLITTER	MACRO
	move.l	a6,-(a7)
	move.l	GFXBASE,a6
	jsr	_LVODisownBlitter(a6)
	move.l	(a7)+,a6
	ENDM
	
DISABLE MACRO
	move.l	a6,-(a7)
	move.l	ExecBase,a6
	jsr	_LVODisable(a6)
	move.l	(a7)+,a6	
	ENDM

ENABLE MACRO
	move.l	a6,-(a7)
	move.l	ExecBase,a6
	jsr	_LVOEnable(a6)
	move.l	(a7)+,a6	
	ENDM	

	
SAVE_COPPER MACRO
	move.l	a6,-(a7)	
	move.l	GFXBASE,a6
	IFEQ	ENABLE_DEBUG
	jsr	_LVOWaitTOF(a6)
	move.l	gb_ActiView(a6),sysView
	move.l	gb_copinit(a6),sysCopper1
	sub.l	a1,a1
	jsr	_LVOLoadView(a6)
	jsr	_LVOWaitTOF(a6)
	ENDC
	move.l	(a7)+,a6
	ENDM
	
; Restore copper
RESTORE_COPPER	MACRO
	IFEQ	ENABLE_DEBUG

	move.l	a6,-(a7)
	lea	CHIPBASE,a5
	move.l	sysCopper1,COP1LCH(a5)
	move.l	GFXBASE,a6
	jsr	_LVOWaitTOF(a6)
	move.l	sysView,a1
	jsr	_LVOLoadView(a6)
	jsr	_LVOWaitTOF(a6)
	move.l	(a7)+,a6
	ENDC
	ENDM
		

	
START_COPPER	MACRO
	move.l	COPPTR_COPPER_1(a6),a1		; Get copper structure
	move.l	(a1),d1				; Address of copper list
	move.l	d1,COP1LCH(a5)			; 
	move.l	d1,COP2LCH(a5)
	move.w	#0,COPJMP1(a5)
	move.w	#0,COPJMP2(a5)
	ENDM
	
CARXYPOS_TO_OBJECT MACRO	
		lea	TRACK_LAYERS(a6),a0
		move.l	carLevel(a4),d3
		cmp.w	hBobSpriteTrackLevel(a3),d3		; Match levels
		bne	.next
		lsl.w	#4,d3
		move.l	(a0,d3),a0
		
	IFEQ	TRACK_BUILD_MODE		
		move.l	(a0),a0
		move.l	(a0),a0
	ENDC
		
		moveq	#0,d3
		move.w	carXpos(a4),d3			; xpos
		sub.w	#127,d3
		add.w	d3,d3
		add.w	#188+16,d3
		lsr.w	#3,d3
	
		moveq	#0,d4	
		move.w	carYpos(a4),d4			; ypos
		sub.w	#16,d4
		add.w	d4,d4				; Multiply by two for interlace.
		lsr.w	#3,d4			
		lsl.l	#6,d4				; Yposition

		add.w	d3,a0
		add.w	d4,a0
		ENDM
	
; a2=source
; a3=destination
; d2=src mod
; d3=dest mod
; d0=Blit Size
agdBlitCopy MACRO
	WAIT_FOR_BLITTER
	move.l	#$09f00000,BLTCON0(a5)
	move.l	#-1,BLTAFWM(a5)
	move.w	d2,BLTAMOD(a5)
	move.w	d3,BLTDMOD(a5)
	move.l	a2,BLTAPTH(a5)
	move.l	a3,BLTDPTH(a5)
	move.w	d0,BLTSIZE(a5)
	ENDM
	
; a2=source
; a3=destination
; d2=src mod
; d3=dest mod
; d0=Blit Size
agdBlitCopy MACRO
	WAIT_FOR_BLITTER
	move.l	#$09f00000,BLTCON0(a5)
	move.l	#-1,BLTAFWM(a5)
	move.w	d2,BLTAMOD(a5)
	move.w	d3,BLTDMOD(a5)
	move.l	a2,BLTAPTH(a5)
	move.l	a3,BLTDPTH(a5)
	move.w	d0,BLTSIZE(a5)
	ENDM
	
agdBlitMaskedSprite MACRO
	WAIT_FOR_BLITTER
	move.l	#$0fca0000,BLTCON0(a5)
	move.l	#-1,BLTAFWM(a5)
	move.w	d2,BLTAMOD(a5)
	move.w	d3,BLTDMOD(a5)
	move.l	a2,BLTAPTH(a5)
	move.l	a3,BLTDPTH(a5)
	move.w	d0,BLTSIZE(a5)

	ENDM
	
WORKBENCH_BOOT	MACRO			
	movea.l ExecBase,a6
	lea 	DOSNAME(pc),a1
	jsr 	_LVOOldOpenLibrary(a6)
	movea.l d0,a5           ; dosbase

	movea.l ThisTask(a6),a3
	move.l  pr_CLI(a3),d3   ; d3 = CLI or WB (NULL)
	bne.s   _from_cli

_from_wb:
; Get startup message if we started from Workbench

	lea 	pr_MsgPort(a3),a0
	jsr 	_LVOWaitPort(a6)    ; wait for a message
	lea 	pr_MsgPort(a3),a0
	jsr 	_LVOGetMsg(a6)      ; then get it
	movea.l d0,a3           ; a3 = WBStartup message
	movea.l sm_ArgList(a3),a0
	move.l	(a0),d5         ; (wa_Lock) FileLock on program dir
	exg	a5,a6               ; _dos
	bsr.s	_common

; Reply to the startup message

	jsr 	_LVOForbid(a6)      ; it prohibits WB to unloadseg me
	lea 	(a3),a1
	jmp 	_LVOReplyMsg(a6)    ; reply to WB message and exit

_from_cli:
; Get FileLock via command name if we started from CLI

	link    a3,#-256

; Copy BCPL string to C-style string

	lea 	(sp),a1
	lsl.l   #2,d3
	movea.l d3,a0
	move.l  cli_CommandName(a0),a0
	adda.l  a0,a0
	adda.l  a0,a0
	move.b  (a0)+,d0

.c:	move.b  (a0)+,(a1)+
	subq.b  #1,d0
	bne.b   .c
	clr.b   (a1)

; Get a lock on the program and its parent

	exg 	a5,a6               ; _dos
	move.l  sp,d1           ; d1 = STRPTR name (command string)
	moveq   #SHARED_LOCK,d2 ; d2 = accessMode
	jsr 	_LVOLock(a6)
	move.l  d0,d7
	move.l  d0,d1
	jsr 	_LVOParentDir(a6)
	move.l  d7,d1
	move.l  d0,d3           ; d3 = Lock on CLI program dir
	move.l  d0,d5           ; d5 = common Lock
	jsr 	_LVOUnLock(a6)

	unlk    a3

_common:	
	move.l  d5,d1
	jsr 	_LVOCurrentDir(a6)  ; CD to the program dir
	move.l  d0,d4           ; d4 = initial launch directory

	lea 	infodata(pc),a0
	lea 	id_UnitNumber(a0),a2
	move.l  d5,d1
	move.l  a0,d2
	jsr 	_LVOInfo(a6)
	tst.l   d0
	beq.b   _rts

	move.l  (a2),d0         ; d0 = current floppy device for the main exe

	movem.l d3/d4/a3/a5/a6,-(sp)
	bsr	START
	movem.l (sp)+,d3/d4/a3/a5/a6
	move.l  d3,d1           ; UnLock program dir or zero (from WB)
	jsr 	_LVOUnLock(a6)

	move.l  d4,d1           ; CD to the initial directory
	jsr 	_LVOCurrentDir(a6)

	lea 	(a6),a1
	lea 	(a5),a6
	jsr 	_LVOCloseLibrary(a6)
	moveq   #0,d0
_rts:	rts

	cnop	0,4
	
infodata:    	ds.l    12

	ENDM


COL0_RED        MACRO
        move.w  #$0000,$dff106
        move.w  #$0f00,$dff180
        move.w  #$0200,$dff106
        move.w  #$0f00,$dff180
        ENDM

COL0_LIGHT_GREY MACRO
        move.w  #$0000,$dff106
        move.w  #$0ddd,$dff180
        move.w  #$0200,$dff106
        move.w  #$0000,$dff180
        ENDM

COL0_GREY       MACRO
        move.w  #$0000,$dff106
        move.w  #$0888,$dff180
        move.w  #$0200,$dff106
        move.w  #$0000,$dff180
        ENDM

COL0_DARK_GREY  MACRO
        move.w  #$0000,$dff106
        move.w  #$0333,$dff180
        move.w  #$0200,$dff106
        move.w  #$0000,$dff180
        ENDM

COL0_BLUE       MACRO
        move.w  #$0000,$dff106
        move.w  #$000f,$dff180
        move.w  #$0200,$dff106
        move.w  #$000f,$dff180
        ENDM

COL0_YELLOW     MACRO
        move.w  #$0000,$dff106
        move.w  #$0ff0,$dff180
        move.w  #$0200,$dff106
        move.w  #$0ff0,$dff180
        ENDM

COL0_GREEN      MACRO
        move.w  #$0000,$dff106
        move.w  #$00f0,$dff180
        move.w  #$0200,$dff106
        move.w  #$00f0,$dff180
        ENDM

COL0_PURPLE     MACRO
        move.w  #$0000,$dff106
        move.w  #$0f0f,$dff180
        move.w  #$0200,$dff106
        move.w  #$0f0f,$dff180
        ENDM

COL0_BLACK      MACRO
        move.w  #$0000,$dff106
        move.w  #$0000,$dff180
        move.w  #$0200,$dff106
        move.w  #$0000,$dff180
        ENDM

