
; a0=Screen Pointer
; d2=Bits to set ..... must be two bits set. (i.e. d2=%00011 for first two bitplanes).
	dc.l	-1
	dc.l	-1
	dc.l	-1
	dc.l	-1
	
OSD_UPDATE_INIT:	equ	0

DISPLAY_BLANK_PR:	equ	0	
DISPLAY_PREPARE_RACE:	equ	1
DISPLAY_PRESS_BUTTON:	equ	2
DISPLAY_COUNTDOWN:	equ	3
DISPLAY_OUTOFRACE:	equ	4
DISPLAY_BLANK_TS:	equ	5
DISPLAY_PRESS_BUTTON_TS:	equ	6

ssDisplayScorePanel:
	subq.w	#1,.blink_timer(a6)
	bpl.s	.flash
	clr.l	OSD_SCREEN_UPDATE(a6)
	not.w	.blink(a6)
	move.w	#16,.blink_timer(a6)
	
.flash:
	tst.l	OSD_SCREEN_UPDATE(a6)
	bmi	.exit
	
	cmp.w	#sceneTrackSelect,CURRENT_SCENE(a6)			; Chance to enter race
	beq.s	.show
	cmp.w	#scenePrepareRace,CURRENT_SCENE(a6)			; Chance to re-enter race
	beq.s	.show	
	bra	.exit
	
.show:	
; Get countdown character
	lea	.countdown(pc),a2
	move.l	COUNTDOWN(a6),d3
	lsr.l	#6,d3
	and.l	#$f,d3
	move.b	(a2,d3),COUNTDOWN_CHAR(a6)
	
	moveq	#maxCars-1,d1
	
; Loop through each car and display relevant text
.car_loop:
	GET_CAR_CONTEXT
	lea	.text_cars(pc),a1
	move.l	(a1,d1*4),a1
	bsr	.car_logic
	dbf	d1,.car_loop
	bra	.exit
	

; Here we work out what needs to be displayed
; If a car is a player in the race then "PREPARE TO RACE" is displayed
; If a car is a drone in the race then "PRESS FIRE TO RACE" is displayed
; If a car was just in the race then but got beat then...
; ..."HOLD FIRE TO RESUME RACE"
.car_logic:
	move.l	d1,-(a7)

	moveq	#DISPLAY_OUTOFRACE,d0
	bsr	.hiscore_entry
	tst.b	carOutOfRace(a4)			
	bmi.s	.1
	
; Is the car a drone
	moveq	#DISPLAY_PRESS_BUTTON_TS,d0
	cmp.w	#sceneTrackSelect,CURRENT_SCENE(a6)			
	beq.s	.3
	moveq	#DISPLAY_PRESS_BUTTON,d0
.3:		
	tst.w	carIsDrone(a4)
	bmi	.1

	moveq	#DISPLAY_PREPARE_RACE,d0
	tst.w	.blink(a6)
	beq.s	.0
	moveq	#DISPLAY_BLANK_TS,d0
	cmp.w	#sceneTrackSelect,CURRENT_SCENE(a6)			
	beq.s	.0
	moveq	#DISPLAY_BLANK_PR,d0	
.0:

.1:	move.l	a1,-(a7)
	move.l	(a1,d0*4),a1
	bsr	.print_text_block
	move.l	(a7)+,a1
	
; Display counter if is a drone and on prep race screen
	tst.w	carIsDrone(a4)
	beq	.2
	cmp.w	#sceneTrackSelect,CURRENT_SCENE(a6)			; Chance to re-enter race
	beq.s	.2	
	
	move.l	a1,-(a7)	
	moveq	#DISPLAY_COUNTDOWN,d0
	move.l	(a1,d0*4),a1
	move.l	a1,a3
	move.b	COUNTDOWN_CHAR(a6),8(a3)
	cmp.b	#" ",8(a3)
	beq.s	.5
	bsr	.print_text_block
.5:	move.l	(a7)+,a1
	
.2:
	move.l	(a7)+,d1	
	bra	.exit
	

; Hiscore entry code here...
.hiscore_entry:	
	tst.b	carHiscoreInitials+3(a4)
	bpl.s	.h0
	move.l	#$41202000,carHiscoreInitials(a4)

.h0:	moveq	#0,d5
	move.l	a1,a2
	move.l	(a2,d0*4),a2	
	move.l	carHiscoreInitials(a4),d6		; Initials and counter in d6 (dl has counter)
	move.b	d6,d5					; Initial position
	tst.w	.blink(a6)
	bmi.s	.hi
	move.l	#$20202000,d6
	
.hi:						; Byte in d5 has index for hiscore initial (0-3)	
	lsr.l	#8,d6
	move.b	d6,10(a2)					; 8 = Z 9= "0" 10=Z
	lsr.l	#8,d6
	move.b	d6,9(a2)
	lsr.l	#8,d6
	move.b	d6,8(a2)
		
	;move.b	#" "+1,9(a2,d5)
	move.b	#" ",9(a2,d5)
	bra	.exit
	
	
; a1 points to text string block
.print_text_block:	
.new_line_loop:
	move.l	a1,d0
	btst	#0,d0
	beq.s	.align
	addq.l	#1,a1
.align:	move.l	a1,a2	
	moveq	#0,d0
	tst.w	(a2)+
	bmi.s	.large
	
	
.small:
	move.w	(a2)+,d0		; xpos
	moveq	#0,d1
	move.w	(a2)+,d1		; ypos
	addq.l	#2,a2

	moveq	#0,d3
	;move.w	(a2)+,d3		; different between track select and prep race
	move.w	#$8002,d3
	
	cmp.w	#sceneTrackSelect,CURRENT_SCENE(a6)			; Chance to enter race
	bne.s	.pr
	move.w	#$8001,d3
	
.pr:	ext.l	d3
	bsr	.wrap_small
	tst.b	(a1)+
	bmi.s	.new_line_loop
	bra	.exit
	
.large:
	move.w	(a2)+,d0		; xpos
	moveq	#0,d1
	move.w	(a2)+,d1		; ypos
	addq.w	#2,a2
	move.l	d3,-(a7)
	bsr	.wrap_large
	move.l	(a7)+,d3
	tst.b	(a1)+		
	bmi.s	.new_line_loop
	bra	.exit	

.wrap_small:
	nop
	nop
	move.l	a2,a1			; Text pointer
	bsr	agdSmallFont
	bra	.exit

.wrap_large:

	move.l	a2,a1			; Text Pointer
	moveq	#0,d3
.wl:	move.b	(a1)+,d3			
	beq	.exit
	bsr	agdLargeFont
	add.w	#16,d0
	bra.s	.wl
	
	
.countdown:		dc.b	" ","9","8","7","6","5","4","3","2","1","0","0","$$$$$$$$"
			even
	


SMALL_FONT:		equ	0
LARGE_FONT:		equ	-1

.text_cars:		dc.l	.text_car1_table
			dc.l	.text_car2_table
			dc.l	.text_car3_table
			dc.l	.text_car4_table

; Blue Car (1) Text Definitions	
.text_car1_table:	dc.l	.text_car1_blank
			dc.l	.text_car1_prep
			dc.l	.text_car1_push
			dc.l	.text_car1_countdown
			dc.l	.text_car1_outofrace
			dc.l	.text_car1_blank_ts
			dc.l	.text_car1_push_ts
			
.text_car1_blank:	dc.w	LARGE_FONT,0,0,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,0,16,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,0,32,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,0,48,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,0,64,%11
			dc.b	"         ",0,$00
			even
			
.text_car1_blank_ts:	dc.w	LARGE_FONT,0,0,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,0,16,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,0,32,%11
			dc.b	"         ",0,$00
			even
			
.text_car1_prep:	dc.w	LARGE_FONT,0,0,%11
			dc.b	" PREPARE ",0,$ff
			even
			dc.w	LARGE_FONT,0,18,%11
			dc.b	" TO RACE ",0,$00
			even

.text_car1_push_ts:	dc.w	SMALL_FONT,0,0,$8002
			dc.b	"    PRESS BUTTON",0,$ff
			even
			dc.w	SMALL_FONT,0,16,$8002
			dc.b	"    TO JOIN RACE",0,$00
			even
			
.text_car1_push:	dc.w	SMALL_FONT,0,0,$8002
			dc.b	"    PRESS BUTTON",0,$ff
			even
			dc.w	SMALL_FONT,0,16,$8002
			dc.b	"    TO JOIN RACE",0,$ff
			even
			dc.w	LARGE_FONT,0,32,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,0,48,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,0,64,%11
			dc.b	"         ",0,0
			even

.text_car1_countdown:	dc.w	LARGE_FONT,16*5,36,%11
			dc.b	" ",0,$00
			even
			
.text_car1_outofrace:	dc.w	LARGE_FONT,16*3,64,%11
			dc.b	"ZZZ      ",0,$ff
			even
			dc.w	SMALL_FONT,0,0,$8002
			dc.b	"    HOLD BUTTON  ",0,$ff
			even
			dc.w	SMALL_FONT,0,16,$8002
			dc.b	"   TO ENTER RACE ",0,$ff
			even
			dc.w	SMALL_FONT,0,32,$8002
			dc.b	"         OR      ",0,$ff
			even
			dc.w	SMALL_FONT,0,48,$8002
			dc.b	"   ENTER INITIALS",0,$00
			even	


			
; Red Car (2) Text Definitions				
.text_car2_table:	dc.l	.text_car2_blank
			dc.l	.text_car2_prep
			dc.l	.text_car2_push
			dc.l	.text_car2_countdown
			dc.l	.text_car2_outofrace
			dc.l	.text_car2_blank_ts
			dc.l	.text_car2_push_ts	
			
.text_car2_blank:	dc.w	LARGE_FONT,16*11,0,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,16*11,16,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,16*11,32,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,16*11,48,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,16*11,64,%11
			dc.b	"         ",0,$00
			even

.text_car2_blank_ts:	dc.w	LARGE_FONT,16*11,0,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,16*11,16,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,16*11,32,%11
			dc.b	"         ",0,$00
			even
			
.text_car2_prep:	dc.w	LARGE_FONT,16*11,0,%11
			dc.b	" PREPARE ",0,$ff
			even
			dc.w	LARGE_FONT,16*11,18,%11
			dc.b	" TO RACE ",0,$00
			even

.text_car2_push:	dc.w	SMALL_FONT,16*11,0,$8002
			dc.b	"    PRESS BUTTON",0,$ff
			even
			dc.w	SMALL_FONT,16*11,16,$8002
			dc.b	"    TO JOIN RACE",0,$ff
			even	
			dc.w	LARGE_FONT,16*11,32,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,16*11,48,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,16*11,64,%11
			dc.b	"         ",0,0
			even
			
.text_car2_push_ts:	dc.w	SMALL_FONT,16*11,0,$8002
			dc.b	"    PRESS BUTTON",0,$ff
			even
			dc.w	SMALL_FONT,16*11,16,$8002
			dc.b	"    TO JOIN RACE",0,0
			even	
			
.text_car2_countdown:	dc.w	LARGE_FONT,16*16,36,%11
			dc.b	" ",0,$00
			even

.text_car2_outofrace:	
			dc.w	LARGE_FONT,16*14,64,%11
			dc.b	"ZZZ      ",0,$ff
			even
			dc.w	SMALL_FONT,16*11,0,$8002
			dc.b	"    HOLD BUTTON  ",0,$ff
			even
			dc.w	SMALL_FONT,16*11,16,$8002
			dc.b	"   TO ENTER RACE ",0,$ff
			even
			dc.w	SMALL_FONT,16*11,32,$8002
			dc.b	"         OR      ",0,$ff
			even
			dc.w	SMALL_FONT,16*11,48,$8002
			dc.b	"   ENTER INITIALS",0,$00
			even	


; Yellow Car (3) Text Definitions
.text_car3_table:	dc.l	.text_car3_blank
			dc.l	.text_car3_prep
			dc.l	.text_car3_push
			dc.l	.text_car3_countdown
			dc.l	.text_car3_outofrace
			dc.l	.text_car3_blank_ts
			dc.l	.text_car3_push_ts
			
.text_car3_blank:	dc.w	LARGE_FONT,16*22,0,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,16*22,16,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,16*22,32,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,16*22,48,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,16*22,64,%11
			dc.b	"         ",0,$00
			even

.text_car3_blank_ts:	dc.w	LARGE_FONT,16*22,0,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,16*22,16,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,16*22,32,%11
			dc.b	"         ",0,$00
			even
			
.text_car3_prep:	dc.w	LARGE_FONT,16*22,0,%11
			dc.b	" PREPARE ",0,$ff
			even
			dc.w	LARGE_FONT,16*22,18,%11
			dc.b	" TO RACE ",0,$00
			even

.text_car3_push:	dc.w	SMALL_FONT,16*22,0,$8002
			dc.b	"    PRESS BUTTON",0,$ff
			even
			dc.w	SMALL_FONT,16*22,16,$8002
			dc.b	"    TO JOIN RACE",0,$ff
			even
			dc.w	LARGE_FONT,16*22,32,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,16*22,48,%11
			dc.b	"         ",0,$ff
			even
			dc.w	LARGE_FONT,16*22,64,%11
			dc.b	"         ",0,0
			even
			
.text_car3_push_ts:	dc.w	SMALL_FONT,16*22,0,$8002
			dc.b	"    PRESS BUTTON",0,$ff
			even
			dc.w	SMALL_FONT,16*22,16,$8002
			dc.b	"    TO JOIN RACE",0,0
			even

.text_car3_countdown:	dc.w	LARGE_FONT,16*27,36,%11
			dc.b	" ",0,$00
			even

.text_car3_outofrace:	
			dc.w	LARGE_FONT,16*25,64,%11
			dc.b	"ZZZ      ",0,$ff
			even	
			dc.w	SMALL_FONT,16*22,0,$8002
			dc.b	"    HOLD BUTTON  ",0,$ff
			even
			dc.w	SMALL_FONT,16*22,16,$8002
			dc.b	"   TO ENTER RACE ",0,$ff
			even
			dc.w	SMALL_FONT,16*22,32,$8002
			dc.b	"         OR      ",0,$ff
			even
			dc.w	SMALL_FONT,16*22,48,$8002
			dc.b	"   ENTER INITIALS",0,$00
			even	


; Green Car (3) Text Definitions			
		
.text_car4_table:	dc.l	.text_car4_blank
			dc.l	.text_car4_prep
			dc.l	.text_car4_push
			dc.l	.text_car4_countdown
			dc.l	.text_car4_outofrace
			dc.l	.text_car4_blank
			dc.l	.text_car4_push
			
.text_car4_blank:	dc.w	LARGE_FONT,0,SCREEN_SIZE_Y-22,%11
			dc.b	"                                      ",0,0
			even

.text_car4_prep:	dc.w	LARGE_FONT,16*8,SCREEN_SIZE_Y-22,%11
			dc.b	" PREPARE TO RACE ",0,0
			even

.text_car4_push:	dc.w	LARGE_FONT,0,SCREEN_SIZE_Y-22,%11
			dc.b	"                                       ",0,$ff
			even
			dc.w	SMALL_FONT,16*8,SCREEN_SIZE_Y-20,2
			dc.b	"    PRESS BUTTON TO JOIN RACE",0,0
			even

.text_car4_countdown:	dc.w	SMALL_FONT,8*32,SCREEN_SIZE_Y-9,$8002
			dc.b	" ",0,$00
			even
			
.text_car4_outofrace:	
			dc.w	SMALL_FONT,8*52,SCREEN_SIZE_Y-16,$8002
			dc.b	"ZZZ      ",0,$ff
			even
			dc.w	SMALL_FONT,8*6,SCREEN_SIZE_Y-16,$8002
			dc.b	"HOLD BUTTON TO ENTER RACE OR ENTER INITIALS",0,$00
			even	
			
.exit:	rts

	data
	
.blink_timer:		dc.w	0
.blink:			dc.w	0

	code

;a0=source screen (start of buffer not struct!)
;a1=dest dest screen (start of buffer not struct!)
ssRaceGetReadyUpdateScreen:
	move.l	#(SCREEN_SIZE_Y/2)-8,d0
	lsl.l	#8,d0
	add.l	d0,a0
	add.l	d0,a1
	WAIT_FOR_BLITTER
	move.l	#$09f00000,BLTCON0(a5)
	move.l	#-1,BLTAFWM(a5)
	move.w	#0,BLTAMOD(a5)
	move.w	#0,BLTDMOD(a5)
	move.l	a0,BLTAPTH(a5)
	move.l	a1,BLTDPTH(a5)
	move.w	#(32<<6)+64,BLTSIZE(a5)	; 16 height + 128 words wide.
	rts


ssRaceGetReady:
	lea	CHIPBASE,a5
	move.l	#16*11,d0				
	move.l	#(SCREEN_SIZE_Y/2)-8,d1				
	move.l	DBSPTR_UPPER_TRACK(a6),a2
	move.l	hDbuffScreen1(a2),a0
	moveq	#0,d2
	move.w	#%1100,d2
	lea	.text(pc),a2
	bsr	.get_ready_text

	move.l	DBSPTR_UPPER_TRACK(a6),a2
	move.l	hDbuffScreen1(a2),a0
	move.l	hDbuffScreen2(a2),a1
	move.l	hAddress(a0),a0
	move.l	hAddress(a1),a1
	bsr	ssRaceGetReadyUpdateScreen
	bra	.exit
	
.get_ready_text:
	moveq	#0,d3
	move.l	SPRPTR_LARGE_FONT(a6),a1	
.loop1:	move.b	(a2)+,d3			
	beq.s	.exit
	bsr	agdLargeFont
	add.w	#16,d0
	bra.s	.loop1

.text:	dc.b	"GET READY",0
	even
	
.exit:	rts




; Update all car OSD status...
; Needs to be called every frame, very efficient.
ssUpdateOSD:
	move.l	d0,d7
	moveq	#CAR_1,d1
	bsr	ssUpdateCarOSD
	
	move.l	d7,d0
	moveq	#CAR_2,d1
	bsr	ssUpdateCarOSD

	move.l	d7,d0
	moveq	#CAR_3,d1
	bsr	ssUpdateCarOSD

	move.l	d7,d0
	moveq	#CAR_4,d1
	bsr	ssUpdateCarOSD
	rts


FONT_PLOT:	equ	%0011

; Scene number needs to be determined

;d0=0-5 0=Init all, 1=Update Score, 2=Spanners, 3=Lap, 4="PUSH BUTTON FOR RACE", 5="PLEASE STANDBY" 
;d1=Car number		(0=Blue, 1=Red, 2=Yellow, 3=Green Drone)
;a0=Screen
ssUpdateCarOSD:
	move.l	d2,d5				
	move.l	d1,d2

	GET_CAR_CONTEXT	 			
	
.ingame:
	tst.l	d0				; If set to 0 then update all OSD
	beq.s	.init
	tst.w	carUpdateScore(a4)		; Update the score 
	bpl	.update_score
	tst.w	carUpdateSpanners(a4)		; Update number of spanners
	bpl	.update_spanners
	tst.w	carUpdateLap(a4)		; Update lap number
	bpl	.update_lap

	cmp.l	#CAR_1,carNumber(a4)		; Latch timer update to first car only.
	bne	.exit
	cmp.w	#4,INGAME_PLAYERS(a6)		; Only if 4 players update timer
	beq	.update_timer
	bra	.exit
	
	
;0 Display "Blue Car" & "Lap"
.init:
; Display Traction Level
	tst.l	d0				; If Car 0 then update track number
	bne.s	.init1
	movem.l	d0-d7/a0-a4,-(a7)
	bsr	.update_track		
	movem.l	(a7)+,d0-d7/a0-a4
	
.init1:
	move.l	d2,-(a7)			; Update car text
	tst.w	carIsDrone(a4)
	bpl.s	.drone_text
	addq.w	#4,d2				; Drone text
.drone_text:
	lea	.cars(pc),a1
	move.l	(a1,d2*4),a1
	moveq	#0,d0
	moveq	#0,d1
	move.w	(a1)+,d0
	move.w	(a1)+,d1
	moveq	#-1,d3
	move.w	#$1,d3
	bsr	agdSmallFont
	move.l	(a7)+,d2
	
	move.l	d2,-(a7)			; update lap test
	lea	.laps(pc),a1
	move.l	(a1,d2*4),a1
	moveq	#0,d0
	moveq	#0,d1
	move.w	(a1)+,d0
	move.w	(a1)+,d1
	moveq	#-1,d3
	move.w	#$1,d3
	bsr	agdSmallFont	
	move.l	(a7)+,d2
	
	move.l	d2,-(a7)			; dynamic update spanners
	bsr	.update_spanners
	move.l	(a7)+,d2
	
	move.l	d2,-(a7)			; dynamic update score
	bsr	.update_score
	move.l	(a7)+,d2	
	
	move.l	d2,-(a7)			; dynamic update lap
	bsr	.update_lap
	move.l	(a7)+,d2
	
	cmp.w	#4,INGAME_PLAYERS(a6)
	bne	.exit
	
	bsr	.update_txt_time
	
	bra	.exit


.cars:	dc.l	.blue_car
	dc.l	.red_car
	dc.l	.yellow_car
	dc.l	.green_car
	dc.l	.blue_drone
	dc.l	.red_drone
	dc.l	.yellow_drone
	dc.l	.green_drone


.blue_car:	dc.w	16,0
		dc.b	"BLUE CAR",0
		even
.blue_drone:	dc.w	16,0
		dc.b	"DRONE",0
		even
.red_car:	dc.w	184,0
		dc.b	"RED CAR",0
		even
.red_drone:	dc.w	184,0
		dc.b	"DRONE",0
		even
.yellow_car:	dc.w	352,0
		dc.b	"YELLOW CAR",0
		even
.yellow_drone:	dc.w	352,0
		dc.b	"DRONE",0
		even
.green_car:	dc.w	120,(SCREEN_SIZE_Y-16)-1
		dc.b	"GREEN CAR",0
		even
.green_drone:	dc.w	152,(SCREEN_SIZE_Y-16)-1
		dc.b	"DRONE",0
		even
		
.laps:		dc.l	.blue_lap
		dc.l	.red_lap
		dc.l	.yellow_lap
		dc.l	.green_lap
		
.blue_lap:	dc.w	128,0
		dc.b	"LAP",0
		even
.red_lap:	dc.w	296,0
		dc.b	"LAP",0
		even
.yellow_lap:	dc.w	464,0
		dc.b	"LAP",0
		even
.green_lap:	dc.w	320,383-16
		dc.b	"LAP",0
		even		

;1

.update_score:
		subq.w	#1,carUpdateScore(a4)
		move.l	carScore(a4),d0
		move.l	a0,-(a7)
		bsr	Binary2Decimal
		subq.b	#1,d0
		lea	.score_temp(pc),a1
.strcopy:	move.b	(a0)+,(a1)+
		dbf	d0,.strcopy
		move.l	(a7)+,a0
		clr.b	(a1)

		moveq	#0,d0
		moveq	#0,d1
		lea	.score_pos(pc),a1
		move.w	(a1,d2*4),d0
		move.w	2(a1,d2*4),d1

		moveq	#-1,d2
		move.w	#FONT_PLOT,d2
			
		move.l	SPRPTR_LARGE_FONT(a6),a1
		lea	.score_temp(pc),a2
		moveq	#0,d3
.update_score1:	move.b	(a2)+,d3
		beq	.exit
		bsr	agdLargeFont
		add.w	#16,d0
		bra.s	.update_score1
		
.score_pos:	dc.w	16,16
		dc.w	184,16
		dc.w	352,16
		dc.w	200,(SCREEN_SIZE_Y-16)-1
		
.score_temp:	dc.b 	"000000",0
		even

;2
.update_spanners:
		subq.w	#1,carUpdateSpanners(a4)
		moveq	#0,d0
		moveq	#0,d1
		lea	.spanners_pos(pc),a1
		move.w	(a1,d2*4),d0
		move.w	2(a1,d2*4),d1
		lea	.spanners_temp(pc),a1
		move.l	#$20202020,(a1)
		move.l	#$20200000,4(a1)
		
		moveq	#0,d4				; Get number of spanners
		move.w	carSpanners(a4),d4
		beq.s	.span_zero
		
		cmp.w	#3,d4
		blt.s	.span_max
		moveq	#3,d4
		
.span_max:	subq.w	#1,d4
		
		move.l	a1,a3
.span_loop:	move.w	#$5b5c,(a1)+
		dbf	d4,.span_loop
		move.l	a3,a1
		
.span_zero:	moveq	#-1,d3
		move.w	#$1,d3
		bsr	agdSmallFont	
		
		bra	.exit
		
.spanners_pos:	dc.w	16,8
		dc.w	184,8
		dc.w	352,8
		dc.w	152,(SCREEN_SIZE_Y-8)-1

.spanners_temp:	dc.l	0,0		

;3
.update_lap:
		subq.w	#1,carUpdateLap(a4)
		moveq	#0,d0
		moveq	#0,d1
		lea	.lap_pos(pc),a1
		move.w	(a1,d2*4),d0
		move.w	2(a1,d2*4),d1

		move.l	SPRPTR_LARGE_FONT(a6),a1
		lea	.lap_temp(pc),a2
		moveq	#-1,d2
		move.w	#FONT_PLOT,d2
		moveq	#0,d3
		
		move.w	carOnLap(a4),d3
		;addq.w	#1,d3
		move.b	(a2,d3),d3
		bsr	agdLargeFont
		bra	.exit
		
.lap_pos:	dc.w	136,16
		dc.w	304,16
		dc.w	472,16
		dc.w	354,383-16
		
.lap_temp:	dc.b 	"012345",0
		even


.update_track:	
		moveq	#16,d0
		move.l	#(SCREEN_SIZE_Y-8)-2,d1
		moveq	#0,d2				; Track number
		move.w	CURRENT_TRACK(a6),d2
		lea	.tracks(pc),a1
		lsl.l	#3,d2
		add.l	d2,a1
		moveq	#-1,d3
		move.w	#$1,d3
		bsr	agdSmallFont	
		bra	.exit

.tracks:	
.track1:	dc.b	"TRACK 1",0
.track2:	dc.b	"TRACK 2",0
.track3:	dc.b	"TRACK 3",0
.track4:	dc.b	"TRACK 4",0
.track5:	dc.b	"TRACK 5",0
.track6:	dc.b	"TRACK 6",0
.track7:	dc.b	"TRACK 7",0
.track8:	dc.b	"TRACK 8",0
.track9:	dc.b	"TRACK 9",0
		even
	


.update_txt_time:
		move.l	#8*51,d0
		move.l	#(SCREEN_SIZE_Y-16)-2,d1
		lea	.txt_time(pc),a1
		moveq	#-1,d3
		move.w	#$1,d3
		bsr	agdSmallFont	
		bra	.exit
		
.txt_time:	dc.b	"TIME",0
		even


.update_timer:	tst.w	RACE_OVER(a6)
		bmi	.exit
		
		move.l	INGAME_TIMER(a6),d1
		and.l	#%111111,d1
		cmp.w	#62,d1
		beq.s	.digits
		cmp.w	#63,d1
		beq.s	.digits
		
		lea	.txt_msec(pc),a1		
		add.l	d1,a1
		add.l	d1,a1
		move.w	(a1),txtMsecTimer(a6)
	
		lea	txtMsecTimer(a6),a1
		move.l	#8*60,d0
		move.l	#(SCREEN_SIZE_Y-16)-2,d1
		moveq	#-1,d3
		move.w	#$1,d3
		bsr	agdSmallFont	
		bra	.exit
		
.digits:	
		move.l	INGAME_TIMER(a6),d1

		lsr.l	#6,d1
		and.l	#%111111,d1
		
		lea	.txt_msec(pc),a1		
		add.l	d1,a1
		add.l	d1,a1
		
		moveq	#0,d3
		move.b	(a1),d3
		move.b	1(a1),d5
		move.l	#28*16,d0
		move.l	#(SCREEN_SIZE_Y-16)-2,d1
		moveq	#-1,d2
		move.w	#FONT_PLOT,d2
		move.l	SPRPTR_LARGE_FONT(a6),a1
		movem.l	d0-d3/a0-a1,-(a7)
		bsr	agdLargeFont
		movem.l	(a7)+,d0-d3/a0-a1	
	
		add.w	#16,d0
		move.b	d5,d3
		bsr	agdLargeFont		
		
		bra	.exit
				
.txt_msec:	dc.b	"00010203040506070809"
		dc.b	"10111213141516171819"
		dc.b	"20212223242526272829"
		dc.b	"30313233343536373839"
		dc.b	"40414243444546474849"
		dc.b	"50515253545556575859"
		dc.b	"59595959595959595959"
		even
	
.exit:		rts

	data

txtSecTimer:	dc.l	0
txtMsecTimer:	dc.l	0
ingameTimer:	dc.w	0

	code