
PLACE_1:	equ	0
PLACE_2:	equ	1
PLACE_3:	equ	2
PLACE_4:	equ	3

RECORD_LAP_BONUS:	equ	300
RECORD_TRACK_BONUS:	equ	400

FIRST_PLACE_BEST_BONUS:	equ	500
FIRST_PLACE_AVERAGE_BONUS:	equ	500
FIRST_PLACE_ALL_BONUS:	equ	FIRST_PLACE_BEST_BONUS+FIRST_PLACE_AVERAGE_BONUS

SECOND_PLACE_BEST_BONUS:	equ	250
SECOND_PLACE_AVERAGE_BONUS:	equ	250
SECOND_PLACE_ALL_BONUS:	equ	SECOND_PLACE_BEST_BONUS+SECOND_PLACE_AVERAGE_BONUS

THIRD_PLACE_BEST_BONUS:	equ	150
THIRD_PLACE_AVERAGE_BONUS:	equ	100
THIRD_PLACE_ALL_BONUS:	equ	THIRD_PLACE_BEST_BONUS+THIRD_PLACE_AVERAGE_BONUS

FOURTH_PLACE_BEST_BONUS:	equ	30
FOURTH_PLACE_AVERAGE_BONUS:	equ	20
FOURTH_PLACE_ALL_BONUS:	equ	FOURTH_PLACE_BEST_BONUS+FOURTH_PLACE_AVERAGE_BONUS

; ^^^^^^^^^^^^^^^^  Packed assets are done at load time.
ssWinningCarsInitialise:
	lea	RNC_WINNING_CARS_FLAGS,a0
	bsr	agdCreatePackedAsset
	move.l	a0,RNCPTR_WINNING_CARS_FLAGS(a6)
	
	lea	RNC_WINNING_CARS_SCENE,a0
	bsr	agdCreatePackedAsset
	move.l	a0,RNCPTR_WINNING_CARS(a6)
	
	lea	RNC_WINNING_CARS_MECHANIC(a6),a0
	bsr	agdCreatePackedAsset
	move.l	a0,RNCPTR_WINNING_CARS_MECHANIC(a6)
	rts



ssWinningCarsInitHandles:
; Destroy all Vram chunks
	move.l	VRMPTR_SCREENS(a6),a0	
	bsr	agdDestroyAllVramScreens	
	move.l	SCRPTR_WINNING_CARS(a6),a0
	bsr	agdDestroyHandle
	clr.l	SCRPTR_WINNING_CARS(a6)
	move.l	PALPTR_WINNING_CARS(a6),a0
	bsr	agdDestroyHandle
	clr.l	PALPTR_WINNING_CARS(a6)
	move.l	SPSPTR_WINNING_CARS_MECHANIC(a6),a0
	bsr	agdDestroyHandle
	clr.l	SPSPTR_WINNING_CARS_MECHANIC(a6)
	move.l	MSKPTR_WINNING_CARS_MECHANIC(a6),a0
	bsr	agdDestroyHandle
	clr.l	MSKPTR_WINNING_CARS_MECHANIC(a6)
	move.l	BMPPTR_WINNING_CARS_MECHANIC(a6),a0
	bsr	agdDestroyHandle
	clr.l	BMPPTR_WINNING_CARS_MECHANIC(a6)
	move.l	BMPPTR_WINNING_CARS(a6),a0
	bsr	agdDestroyHandle
	clr.l	BMPPTR_WINNING_CARS(a6)
	move.l	UNPPTR_WINNING_CARS_MECHANIC(a6),a0
	bsr	agdDestroyHandle
	clr.l	UNPPTR_WINNING_CARS_MECHANIC(a6)
	move.l	UNPPTR_WINNING_CARS(a6),a0
	bsr	agdDestroyHandle
	clr.l	UNPPTR_WINNING_CARS(a6)
	move.l	UNPPTR_WINNING_CARS_FLAGS,a0
	bsr	agdDestroyHandle
	clr.l	UNPPTR_WINNING_CARS_FLAGS(a6)
	rts	
	

ssWinningCarsCreateHandles:
; Unpack Flag Sprites into VRAM	
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	RNCPTR_WINNING_CARS_FLAGS(a6),a1
	bsr	agdUnpackAssetToVRAM
	move.l	d0,a0
	move.l	hVramNumScreens(a0),d0
	beq	.exit
	subq.l	#1,d0
	move.l	hVramScreens(a0,d0*4),UNPPTR_WINNING_CARS_FLAGS(a6)

; Unpack Background scene file into VRAM
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	RNCPTR_WINNING_CARS(a6),a1
	bsr	agdUnpackAssetToVRAM
	move.l	d0,a0
	move.l	hVramNumScreens(a0),d0
	beq	.exit
	subq.l	#1,d0
	move.l	hVramScreens(a0,d0*4),UNPPTR_WINNING_CARS(a6)

; Unpack mechanics Sprite Sheet to VRAM
	move.l	VRMPTR_SCREENS(a6),a0				; Unpack to VRAM
	move.l	RNCPTR_WINNING_CARS_MECHANIC(a6),a1
	bsr	agdUnpackAssetToVRAM
	move.l	d0,a0
	move.l	hVramNumScreens(a0),d0
	beq	.exit
	subq.l	#1,d0
	move.l	hVramScreens(a0,d0*4),UNPPTR_WINNING_CARS_MECHANIC(a6)

; Create a Bitmap Handle and work out dimensions
	move.l	UNPPTR_WINNING_CARS(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_WINNING_CARS(a6)	
	
; Create a Bitmap Handle and work out dimensions
	move.l	UNPPTR_WINNING_CARS_MECHANIC(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdCreateBitmap			
	move.l	d0,BMPPTR_WINNING_CARS_MECHANIC(a6)
	
; Create a mask of the mechanic sprites in VRAM
	move.l	VRMPTR_SCREENS(a6),a0				; Create in VRAM
	move.l	BMPPTR_WINNING_CARS_MECHANIC(a6),d0
	bsr	agdCreateBitmapSingleMask
.crash1:	
	tst.l	d0
	bmi.s	.crash1
	move.l	d0,MSKPTR_WINNING_CARS_MECHANIC(a6)
	
	move.l	VRMPTR_SCREENS(a6),a0				; Create in VRAM
	move.l	BMPPTR_WINNING_CARS_MECHANIC(a6),d0
	move.l	MSKPTR_WINNING_CARS_MECHANIC(a6),d1
	move.l	#$4040,d2					; 48x20 Font
	moveq	#0,d3
	bsr	agdCreateSpriteSheet
	move.l	d0,SPSPTR_WINNING_CARS_MECHANIC(a6)
	
; Get the palette of the Bitmap
	move.l	UNPPTR_WINNING_CARS(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdGetBitmapPalette			
	move.l	d0,PALPTR_WINNING_CARS(a6)
	
; Create Screen Pointers from Unpacked Bitmap in VRAM
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	BMPPTR_WINNING_CARS(a6),a1
	bsr	agdCreateScreenFromBitmap
	tst.l	d0
	bmi.s	ssWinningCarsCrash
	move.l	d0,SCRPTR_WINNING_CARS(a6)
	move.l	d0,a0
	move.l	PALPTR_WINNING_CARS(a6),hScreenPalette(a0)
.exit:	rts
	
ssWinningCarsCrash:	
	lea	txtNoVram(a6),a0
	bsr	agdPrintString		
.1:	bra.s	.1

ssWinningCars:

	move.w	#-1,WINNING_CARS_UPDATE(a6)
	move.w	#sceneWinningCars,CURRENT_SCENE(a6)
ssWinningCarsLoop:
	bsr	ssWinningCarsInitHandles
	bsr	ssWinningCarsCreateHandles
	tst.l	d0
	bmi.s	ssWinningCarsCrash
	
; Set default bonus values.
	move.l	#FIRST_PLACE_BEST_BONUS,first_best_bonus
	move.l	#FIRST_PLACE_AVERAGE_BONUS,first_avg_bonus
	move.l	#FIRST_PLACE_ALL_BONUS,first_all_bonus
	
	move.l	#SECOND_PLACE_BEST_BONUS,second_best_bonus
	move.l	#SECOND_PLACE_AVERAGE_BONUS,second_avg_bonus
	move.l	#SECOND_PLACE_ALL_BONUS,second_all_bonus
		
	move.l	#THIRD_PLACE_BEST_BONUS,third_best_bonus
	move.l	#THIRD_PLACE_AVERAGE_BONUS,third_avg_bonus
	move.l	#THIRD_PLACE_ALL_BONUS,third_all_bonus

	move.l	#FOURTH_PLACE_BEST_BONUS,fourth_best_bonus
	move.l	#FOURTH_PLACE_AVERAGE_BONUS,fourth_avg_bonus
	move.l	#FOURTH_PLACE_ALL_BONUS,fourth_all_bonus	
			
	move.l	SCRPTR_WINNING_CARS(a6),a0
	move.l	COPPTR_COPPER_1(a6),a1
	bsr	ssUniCopper
	
	bsr	ssWinningCarsOrder

	lea	$dff000,a5
	
	move.b  $bfe801,d1
	move.b  $bfd800,d0
	eor.b	d1,d0
	and.w	#%11,d0
	move.w	d0,MECH_NUMBER(a6)

	IFEQ	ENABLE_DEBUG
	;INIT_DMA_INT	
	START_COPPER
	SET_PARALLEL_PORT
	move.w	#(DMAF_SETCLR!DMAF_MASTER!DMAF_RASTER!DMAF_COPPER!DMAF_BLITTER!DMAF_SPRITE),DMACON(a5)
	move.w	#(INTF_SETCLR!INTF_EXTER!INTF_COPER!INTF_VERTB),INTENA(a5)
	ENDC


; Copy a bitmap to a screen
	move.l	BMPPTR_WINNING_CARS(a6),d0
	move.l	SCRPTR_WINNING_CARS(a6),d1
	bsr	agdTransitionBitmapToScreen
	
	move.l	SCRPTR_WINNING_CARS(a6),a0
	moveq	#OSD_UPDATE_INIT,d0
	bsr	ssUpdateOSD
	
	moveq	#0,d0
	bsr	ssWinningCarsBonus
	clr.l	FRAME_COUNT(a6)

	moveq	#63,d0
	bsr	agdSetVolume
	
	moveq	#-1,d0
	bsr	ssWinningCarsResults

	move.w	#60*6,WINNING_CARS_UPDATE(a6)
	
.frame:	
	;IFNE	ENABLE_DEBUG
	bsr	WaitVbl
	bsr	ssWinningCarsUpdate
	;ENDC
	
	IFNE	DEBUG_COLOURS
	move.w	#$700,$dff180
	ENDC
	
	IFNE	DEBUGGING_OSD
	bsr	agdDebugWindow
	ENDC
	
	cmp.w	#256,WINNING_CARS_UPDATE(a6)
	bgt.s	.fadeout
	moveq	#0,d0
	move.w	WINNING_CARS_UPDATE(a6),d0
	bmi.s	.fadeout
	lsr.w	#2,d0
	bsr	agdSetVolume	

.fadeout:	
	tst.w	WINNING_CARS_UPDATE(a6)
	bpl	.frame

.fade:	
	
.stop:	clr.b	_mt_Enable
	moveq	#63,d0
	bsr	agdSetVolume
	bra.s	.done

.vol:	btst	#7,$bfe001
	bne	.frame
	
.done:

	lea	CHIPBASE,a5
	clr.b	_mt_Enable
	move.w	#$700f,DMACON(a5)	;Disable Audio DMA
	moveq	#0,d0
	bsr	agdSetVolume

	bsr	ssWinningCarsResetPlayers

	; Turn off copper and sprites
	;move.l	COPPTR_COLOR00(a6),a1
	;clr.w	10(a1)
	;clr.w	22(a1)
	;clr.w	34(a1)
	;clr.w	46(a1)
	;clr.w	58(a1)

.close:
	
	move.l	SCRPTR_WINNING_CARS(a6),d0
	bsr	agdTransitionBitmapFromScreen
	
; Wake up
;	IFEQ	ENABLE_DEBUG
;	bsr	RemoveScreenInterrupt
;	bsr	RemoveKeyboardInterrupt		
;	RESTORE_SYSTEM_STATE
;	IFEQ	ENABLE_DEBUG_MESSAGES
;	RESTORE_COPPER			; Disable this to stop showing WB screen (must replace though).
;	ENDC
;	INIT_PERMIT_OS
;	OS_WAITBLIT
;	DISOWN_BLITTER
	
;	lea	CHIPBASE,a5	
;	move.w	#0,BEAMCON0(a5)
;	move.w #$8000,VPOSW(a5)			; Set LOF Auto Toggle
;	ENDC
;------------
	

	
	IFNE	ENABLE_PROTECTION
	ssCheckSum

	moveq	#0,d2
	
	moveq	#CAR_1,d1
	GET_CAR_CONTEXT
	move.b	carProtectionByte(a4),d2	; 81
	lsl.l	#8,d2

	moveq	#CAR_2,d1
	GET_CAR_CONTEXT
	move.b	carProtectionByte(a4),d2	; 04
	lsl.l	#8,d2

	moveq	#CAR_3,d1
	GET_CAR_CONTEXT
	move.b	carProtectionByte(a4),d2	; 6a
	lsl.l	#8,d2

	moveq	#CAR_4,d1
	GET_CAR_CONTEXT
	move.b	carProtectionByte(a4),d2	; b0
	
	cmp.l	d2,d0
	bne	agdSetVolume
	ENDC
	
; Set volume to 0
	moveq	#0,d0
	bsr	agdSetVolume
	
	clr.b	_mt_Enable
	
	move.l	#sceneLoad,CURRENT_SCENE(a6)
	
; Kill VBL

	IFEQ	ENABLE_DEBUG
		END_SCENE
	ENDC
	
	bsr	ssWinningCarsInitHandles
	moveq	#0,d0
.exit:	
.error:	rts



; Mark all losing cars to be out of the race.	
ssWinningCarsResetPlayers:

	
	moveq	#maxCars-1,d7
	move.l	CAR_WIN_ORDER(a6),d2
	and.l	#%00000011000000110000001100000011,d2
	moveq	#0,d0
	
	cmp.w	#4,INGAME_PLAYERS(a6)
	beq.s	.4players
	
.loop:	moveq	#0,d1
	move.b	d2,d1
		
	GET_CAR_CONTEXT

	tst.w	carIsDrone(a4)			; Is this car a drone?
	beq.s	.next				; Nope
; This car is a drone so mark all cars now as out of the race.
	moveq	#-1,d0				; Yes, Mark it is out of the race.
	
.next:	tst.w	carIsDrone(a4)
	bmi.s	.next1
	move.b	d0,carOutOfRace(a4)
.next1:	lsr.l	#8,d2
	dbf	d7,.loop
	bra	.exit
.4players:
	rol.l	#8,d2				; knock out 4th place	
	and.l	#3,d2
	moveq	#0,d1
	move.b	d2,d1
	GET_CAR_CONTEXT
	move.b	#-1,carOutOfRace(a4)
.exit:	rts
	

ssWinningCarsUpdate:
	tst.w	WINNING_CARS_UPDATE(a6)
	bmi.s	.exit
	subq.w	#1,WINNING_CARS_UPDATE(a6)
	
; Update hardware sprites

	move.l	#$3c,d2
	moveq	#0,d4
	move.l	COPPTR_SPRITE_FLAGS_1(a6),a1
	bsr	ssWinningCarsFlags

	moveq	#1,d4
	move.l	#$4c,d2
	move.l	COPPTR_SPRITE_FLAGS_2(a6),a1
	bsr	ssWinningCarsFlags

	moveq	#-1,d0
	bsr	ssWinningCarsBonus
	
; Blit car mechanic
	tst.w	SHOW_MECHANIC(a6)
	beq.s	.fourth_place_drone
	
	move.l	SPSPTR_WINNING_CARS_MECHANIC(a6),a0	
	move.l	SCRPTR_WINNING_CARS(a6),a1
	move.l	BMPPTR_WINNING_CARS(a6),a2
	
	moveq	#0,d0				; Mech animation to show.
	move.w	MECH_NUMBER(a6),d0
	bsr	ssWinningCarsMechanic

.fourth_place_drone:	
	move.l	SCRPTR_WINNING_CARS(a6),a0
	moveq	#-1,d0
	bsr	ssUpdateOSD
.exit:	rts
	

;d2=Ypos
;a1=Copper Pointer
ssWinningCarsFlags:
	move.l	UNPPTR_WINNING_CARS_FLAGS(a6),a0
	move.l	(a0),d0					; Flags data
	
	subq.w	#1,.timer(a6)
	bpl.s	.reset
	move.w	#10,.timer(a6)
	addq.w	#1,.pos(a6)
	cmp.w	#4,.pos(a6)
	bne.s	.reset
	clr.w	.pos(a6)
.reset:	
	moveq	#0,d1

	moveq	#0,d3
	move.w	.pos(a6),d3
	mulu.w	#(4*9),d3
	add.l	d3,d0
	
	add.w	#127+32,d1			; xpos
	
        lea     HWSPR_TAB_YPOS(a6),a2
        move.l  (a2,d2*4),d2
        lea     HWSPR_TAB_XPOS(a6),a2
        or.l    (a2,d1*4),d2
	add.w	#$0800,d2	
	lea	.xpostab(pc),a3
	lea	.ypostab(pc),a4
	lsl.l	#3,d4
	add.l	d4,a3
	add.l	d4,a4
	;d4

	moveq	#7,d7	
.loop:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	addq.w	#8,a1

	swap	d2
	add.b	(a3)+,d2		; 32 pixels right
	swap	d2
	
	rol.l	#8,d2
	add.b	(a4),d2
	ror.l	#8,d2
	ror.l	#8,d2
	add.b	(a4)+,d2
	ror.l	#8,d2
	
	move.w	d2,2(a1)		; Control word
	swap	d2
	move.w	d2,6(a1)		; Position

	addq.w	#8,a1
	swap	d0

	dbf	d7,.loop
.exit:	rts

.xpostab:	dc.b	4,11,5,16,62,4,10,8
		dc.b	7,10,5,11,58,2,12,14
.ypostab:	dc.b	0,8,-8,8,-8,8,0,-8
		dc.b	8,-8,8,8,-8,8,0,-8
	
	data
	
.pos:	dc.w	0	
.timer:	dc.w	0

	code


	near	a6
	
ssWinningCarsResults:
		move.l	#"00.0",.first_best(a6)
		move.l	#"00.0",.second_best(a6)
		move.l	#"00.0",.third_best(a6)
		move.l	#"00.0",.fourth_best(a6)	
		move.l	#"00.0",.first_avg(a6)
		move.l	#"00.0",.second_avg(a6)
		move.l	#"00.0",.third_avg(a6)
		move.l	#"00.0",.fourth_avg(a6)	
		
		move.w	#"  ",.first_best+4(a6)
		move.w	#"  ",.second_best+4(a6)
		move.w	#"  ",.third_best+4(a6)
		move.w	#"  ",.fourth_best+4(a6)	
		move.w	#"  ",.first_avg+4(a6)
		move.w	#"  ",.second_avg+4(a6)
		move.w	#"  ",.third_avg+4(a6)
		move.w	#"  ",.fourth_avg+4(a6)	
		
; Calculate times.... here.

; Get Lap times
.main:
; add World Record Bonus
		move.l	CAR_WIN_ORDER(a6),d2
; First car results

		move.l	a5,-(a7)
		lea	.first_best(a6),a2
		lea	.first_avg(a6),a3
		lea	first_best_bonus,a5
		bsr	.get_laptime
		move.l	(a7)+,a5

		move.l	a5,-(a7)		
		lea	.second_best(a6),a2
		lea	.second_avg(a6),a3
		lea	second_best_bonus,a5
		bsr	.get_laptime
		move.l	(a7)+,a5

		move.l	a5,-(a7)
		lea	.third_best(a6),a2
		lea	.third_avg(a6),a3
		lea	third_best_bonus,a5
		bsr	.get_laptime
		move.l	(a7)+,a5

		move.l	a5,-(a7)
		lea	.fourth_best(a6),a2
		lea	.fourth_avg(a6),a3
		lea	fourth_best_bonus,a5
		bsr	.get_laptime		
		move.l	(a7)+,a5

; 1st place position
		move.l	#31*8,d0
		move.l	#19*8,d1
		moveq	#%11111,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.first_best(a6),a1
		bsr	agdSmallFont
		
		move.l	#31*8,d0
		move.l	#21*8,d1
		moveq	#%11111,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.first_avg(a6),a1
		bsr	agdSmallFont

; 2nd place position
		move.l	#15*8,d0
		move.l	#30*8,d1
		moveq	#%11111,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.second_best(a6),a1
		bsr	agdSmallFont
		
		move.l	#15*8,d0
		move.l	#32*8,d1
		moveq	#%11111,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.second_avg(a6),a1
		bsr	agdSmallFont

; 3rd place position
		move.l	#46*8,d0
		move.l	#30*8,d1
		moveq	#%11111,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.third_best(a6),a1
		bsr	agdSmallFont
		
		move.l	#46*8,d0
		move.l	#32*8,d1
		moveq	#%11111,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.third_avg(a6),a1
		bsr	agdSmallFont

; 4th place position
		move.l	#12*8,d0
		move.l	#42*8,d1
		moveq	#%11111,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.fourth_best(a6),a1
		bsr	agdSmallFont
		
		move.l	#12*8,d0
		move.l	#44*8,d1
		moveq	#%11111,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.fourth_avg(a6),a1
		bsr	agdSmallFont
		
		bra	.exit
		;		move.l	CAR_WIN_ORDER,d2 a2 a3
.get_laptime:	moveq	#0,d1
		move.b	d2,d1
		cmp.b	#4,d1
		blt.s	.no_drone1
		subq.w	#4,d1
.no_drone1:	lsr.l	#8,d2
		GET_CAR_CONTEXT	
		
		cmp.w	#0,carOnLap(a4)
		bne.s	.zero_lap
		clr.l	(a2)
		clr.l	(a3)
		bra	.exit
		
		
.zero_lap:	lea	.lap_time_order(a6),a0
		clr.l	(a0)
		clr.l	4(a0)
		clr.l	8(a0)
		
		lea	carTimeLap1(a4),a1
		moveq	#0,d6
		move.w	carOnLap(a4),d6
		subq.w	#1,d6
		bmi.s	.no_lap
		
.lap:		move.l	(a1,d6*4),(a0,d6*4)
		dbf	d6,.lap
	
.no_lap:	moveq	#2,d7
		bsr	ssWinningCarsSortTimes

		move.l	8(a0),d0			; If 3rd lap was 0
		bne.s	.l1				; then get the lap before
		move.l	4(a0),d0
		bne.s	.l1
		move.l	0(a0),d0			; If all laps are 0 then what???

.l1:		
		tst.w	carIsDrone(a4)
		bmi.s	.rec_best
; Insert best lap time.
		moveq	#0,d5
		move.w	CURRENT_LEVEL(a6),d5
		lsl.l	#3,d5
		lea	RECORD_TABLE,a0
		add.l	d5,a0

		moveq	#0,d3
		clr.w	$100
		cmp.w	4(a0),d0  
		blt.s	.rec_best
		move.b	carNumber+3(a4),3(a0)		; Car number got the World Record
		move.w	d0,4(a0)
		move.w	#"WR",4(a2)
		add.l	#RECORD_LAP_BONUS,0(a5)
		add.l	#RECORD_LAP_BONUS,8(a5)	
		moveq	#-1,d3

.rec_best:	bsr	ssWinningCarsGetLapTime

		move.l	d0,(a2)				; BEST LAP TIME
		lea	.lap_time_order(a6),a0
		move.l	(a0),d0
		add.l	4(a0),d0
		add.l	8(a0),d0

		move.w	carOnLap(a4),d6
		beq.s	.l2
		divu	d6,d0				; Divide by number of completed laps.
.l2:		and.l	#$ffff,d0			; AVERAGE LAP TIME

		tst.w	carIsDrone(a4)
		bmi.s	.rec_average
	
		moveq	#0,d5
		move.w	CURRENT_LEVEL(a6),d5
		lsl.l	#3,d5
		lea	RECORD_TABLE,a0
		add.l	d5,a0
		
		clr.w	$100
		cmp.w	6(a0),d0
		blt.s	.rec_average
		tst.l	d3				; Only check average if best WR lap achieved 
		beq.s	.rec_average
		move.b	carNumber+3(a4),3(a0)		; Car number got the World Record
		move.w	d0,6(a0)
		move.w	#"WR",4(a3)
		add.l	#RECORD_TRACK_BONUS,4(a5)
		add.l	#RECORD_TRACK_BONUS,8(a5)	

.rec_average:	bsr	ssWinningCarsGetLapTime		
		move.l	d0,(a3)
.exit:		rts
		
		data
		
.lap_time_order:	
		dc.l	0,0,0,0
		even
.first_best:	dc.b	"00.0  ",0			; Needs to be generated
		even
.second_best:	dc.b	"00.0  ",0
		even
.third_best:	dc.b	"00.0  ",0
		even
.fourth_best:	dc.b	"00.0  ",0
		even

.first_avg:	dc.b	"00.0  ",0
		even
.second_avg:	dc.b	"00.0  ",0
		even
.third_avg:	dc.b	"00.0  ",0
		even
.fourth_avg:	dc.b	"00.0  ",0
		even
	
		code

		near	a6
		
ssWinningCarsBonus:
		move.l	CAR_WIN_ORDER(a6),d6
		tst.l	d0
		bmi	.1
		clr.l	.first_best_bonus_temp(a6)
		clr.l	.second_best_bonus_temp(a6)	
		clr.l	.third_best_bonus_temp(a6)	
		clr.l	.fourth_best_bonus_temp(a6)
		clr.l	.first_avg_bonus_temp(a6)
		clr.l	.second_avg_bonus_temp(a6)	
		clr.l	.third_avg_bonus_temp(a6)	
		clr.l	.fourth_avg_bonus_temp(a6)
		clr.l	.first_all_bonus_temp(a6)
		clr.l	.second_all_bonus_temp(a6)	
		clr.l	.third_all_bonus_temp(a6)	
		clr.l	.fourth_all_bonus_temp(a6)
		move.l	#$20202020,.score_temp(a6)
		bra	.exit
		
; 1st place increment score display
.1:		move.l	.first_best_bonus_temp(a6),d0
		cmp.l	first_best_bonus,d0
		bgt.s	.2
		add.l	#10,.first_best_bonus_temp
		lea	.temp(a6),a0
		bsr	.calc
		move.l	#37*8,d0
		move.l	#19*8,d1
		moveq	#%11111,d3
		or.l	#$80000000,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.score_temp(a6),a1
		bsr	agdSmallFont
		
.2:		move.l	.first_avg_bonus_temp,d0
		cmp.l	first_avg_bonus,d0
		bgt	.3
		add.l	#10,.first_avg_bonus_temp
		lea	.temp(a6),a0
		bsr	.calc
		move.l	#37*8,d0
		move.l	#21*8,d1
		moveq	#%11111,d3
		or.l	#$80000000,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.score_temp(a6),a1
		bsr	agdSmallFont
		
.3:		
		move.l	.first_all_bonus_temp,d0
		add.l	#10,d0
		cmp.l	first_all_bonus,d0
		bgt	.4
		add.l	#10,.first_all_bonus_temp
		lea	.temp(a6),a0
		bsr	.calc
		move.l	#37*8,d0
		move.l	#17*8,d1
		moveq	#%11111,d3
		or.l	#$80000000,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.score_temp(a6),a1
		bsr	agdSmallFont

; 1st place increment OSD score		
.1update	moveq	#0,d1
		move.b	d6,d1
		cmp.b	#4,d1
		blt.s	.1score
		subq.w	#4,d1
.1score:	lsr.l	#8,d6
		GET_CAR_CONTEXT	
		add.l	#10,carScore(a4)
		clr.w	carUpdateScore(a4)
		
		
;--------------------
; 2nd place best bonus
.4:		move.l	.second_best_bonus_temp(a6),d0
		cmp.l	second_best_bonus,d0
		bgt.s	.5
		add.l	#10,.second_best_bonus_temp(a6)
		lea	.temp(a6),a0
		bsr	.calc
		move.l	#21*8,d0
		move.l	#30*8,d1
		moveq	#%11111,d3
		or.l	#$80000000,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.score_temp(a6),a1
		bsr	agdSmallFont

; 2nd place avg bonus
.5:		move.l	.second_avg_bonus_temp(a6),d0
		cmp.l	second_avg_bonus,d0
		bgt	.6
		add.l	#10,.second_avg_bonus_temp(a6)
		lea	.temp(a6),a0
		bsr	.calc
		move.l	#21*8,d0
		move.l	#32*8,d1
		moveq	#%11111,d3
		or.l	#$80000000,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.score_temp(a6),a1
		bsr	agdSmallFont
		
; 2nd place all bonus
.6:		move.l	.second_all_bonus_temp(a6),d0
		add.l	#10,d0
		cmp.l	second_all_bonus,d0
		bgt	.7
		add.l	#10,.second_all_bonus_temp(a6)
		lea	.temp(a6),a0
		bsr	.calc
		move.l	#21*8,d0
		move.l	#28*8,d1
		moveq	#%11111,d3
		or.l	#$80000000,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.score_temp(a6),a1
		bsr	agdSmallFont
		
; 2nd place increment OSD score			
.2update:	moveq	#0,d1
		move.b	d6,d1
		cmp.b	#4,d1
		blt.s	.score2
		subq.w	#4,d1
.score2:	lsr.l	#8,d6
		GET_CAR_CONTEXT	
		add.l	#10,carScore(a4)
		clr.w	carUpdateScore(a4)	

.7:		move.l	.third_best_bonus_temp(a6),d0
		cmp.l	third_best_bonus,d0
		bgt.s	.8
		add.l	#10,.third_best_bonus_temp(a6)
		lea	.temp(a6),a0
		bsr	.calc
		move.l	#52*8,d0
		move.l	#30*8,d1
		moveq	#%11111,d3
		or.l	#$80000000,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.score_temp(a6),a1
		bsr	agdSmallFont	

.8:		move.l	.third_avg_bonus_temp(a6),d0
		cmp.l	third_avg_bonus,d0
		bgt	.9
		add.l	#10,.third_avg_bonus_temp(a6)
		lea	.temp(a6),a0
		bsr	.calc
		move.l	#52*8,d0
		move.l	#32*8,d1
		moveq	#%11111,d3
		or.l	#$80000000,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.score_temp(a6),a1
		bsr	agdSmallFont
		
;  place all bonus
.9:		move.l	.third_all_bonus_temp(a6),d0
		add.l	#10,d0
		cmp.l	third_all_bonus,d0
		bgt	.10
		add.l	#10,.third_all_bonus_temp(a6)
		lea	.temp(a6),a0
		bsr	.calc
		move.l	#52*8,d0
		move.l	#28*8,d1
		moveq	#%11111,d3
		or.l	#$80000000,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.score_temp(a6),a1
		bsr	agdSmallFont
		
.3update:	moveq	#0,d1
		move.b	d6,d1
		cmp.b	#4,d1
		blt.s	.score3
		subq.w	#4,d1
.score3:	lsr.l	#8,d6
		GET_CAR_CONTEXT	
		add.l	#10,carScore(a4)
		clr.w	carUpdateScore(a4)

.10:
		move.l	.fourth_best_bonus_temp(a6),d0
		cmp.l	fourth_best_bonus,d0
		bgt.s	.11
		add.l	#10,.fourth_best_bonus_temp(a6)
		lea	.temp(a6),a0
		bsr	.calc
		move.l	#18*8,d0
		move.l	#40*8,d1
		moveq	#%11111,d3
		or.l	#$80000000,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.score_temp(a6),a1
		bsr	agdSmallFont

; 2nd place avg bonus
.11:		move.l	.fourth_avg_bonus_temp(a6),d0
		cmp.l	fourth_avg_bonus,d0
		bgt	.12
		add.l	#10,.fourth_avg_bonus_temp(a6)
		lea	.temp(a6),a0
		bsr	.calc
		move.l	#18*8,d0
		move.l	#42*8,d1
		moveq	#%11111,d3
		or.l	#$80000000,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.score_temp(a6),a1
		bsr	agdSmallFont
		
;  place all bonus
.12:		move.l	.fourth_all_bonus_temp(a6),d0
		add.l	#10,d0
		cmp.l	fourth_all_bonus,d0
		bgt.s	.13
		add.l	#10,.fourth_all_bonus_temp(a6)
		lea	.temp(a6),a0
		bsr	.calc
		move.l	#18*8,d0
		move.l	#44*8,d1
		moveq	#%11111,d3
		or.l	#$80000000,d3
		move.l	SCRPTR_WINNING_CARS(a6),a0
		lea	.score_temp(a6),a1
		bsr	agdSmallFont
		
.4update:	moveq	#0,d1
		move.b	d6,d1
		cmp.b	#4,d1
		blt.s	.score4
		subq.w	#4,d1
.score4:	lsr.l	#8,d6
		GET_CAR_CONTEXT	
		add.l	#10,carScore(a4)
		clr.w	carUpdateScore(a4)

.13:
		bra	.exit
		
		
.calc:
; In:	D0.L = Hex / Binary
;
; Out:	A0.L = Ptr to null-terminated String
;	D0.L = String Length (Zero if null on input)

		move.l	a0,-(a7)
		bsr	Binary2Decimal
		lea	.score_temp+4(a6),a1
		add.w	d0,a0
		subq.b	#1,d0
.strcopy:	move.b	-(a0),-(a1)
		dbf	d0,.strcopy
		move.l	(a7)+,a0
		;clr.b	(a1)
.exit:		rts



		data
		
.first_best_bonus_temp:	dc.l	0
.first_avg_bonus_temp:	dc.l	0
.first_all_bonus_temp:	dc.l	0


.second_best_bonus_temp:	dc.l	0
.second_avg_bonus_temp:	dc.l	0
.second_all_bonus_temp:	dc.l	0


.third_best_bonus_temp:	dc.l	0
.third_avg_bonus_temp:	dc.l	0
.third_all_bonus_temp:	dc.l	0


.fourth_best_bonus_temp:	dc.l	0
.fourth_avg_bonus_temp:	dc.l	0
.fourth_all_bonus_temp:	dc.l	0

.temp:		dc.b	"        ",0
		even
.score_temp:	dc.b	"    ",0,0,0,0,0,0,0,0
		even
		
		code

; d0=Microseconds
ssWinningCarsGetLapTime:
	movem.l	d1/a0,-(a7)
	divu	#60,d0
	move.l	d0,d1
	clr.w	d1
	swap	d1
	and.l	#$ffff,d0

.rem:	
	divu	#6,d1			; 10th of a second.
	and.l	#$ffff,d1

	lea	SECONDS_TAB(a6),a0
	lsl.l	#2,d0
	add.l	d0,a0
	or.l	(a0),d1
	move.l	d1,d0
	movem.l	(a7)+,d1/a0	
	rts
		
		

; d0=Car to colour
	near	a6
	
ssWinningCarsOrder:
	moveq	#maxCars-1,d7
	moveq	#CAR_1,d1
.loop_order:
	GET_CAR_CONTEXT
	
	moveq	#0,d2
	moveq	#0,d3
	move.b	d1,d2
	tst.w	carIsDrone(a4)
	beq.s	.player
	addq.w	#4,d2
.player:
	lsl.w	#4,d2
	or.w	carOnLap(a4),d2				; d3=000
	lsl.w	#8,d2					; d2=0300
	or.b	carLastCheckPoint(a4),d2		; Store Last Checkpoint reached					
	swap	d2
	move.w	carTimeSinceLastCheckPoint(a4),d2	; Store frames since last checkpoint
							; d2=030806766
	lea	.places(a6),a0
	move.l	d2,(a0,d1*4)				; Store place.
	addq.w	#1,d1
	dbf	d7,.loop_order

;Order by highest lap 
;then order by highest checkpoint
;then order by highest checkpoint time.
	
	moveq	#maxCars-1,d7
	lea	.places(a6),a0
	bsr	ssWinningCarsSortTimes
	
; Generate order
	moveq	#0,d3
;------------------------

	moveq	#0,d7
	
	lea	.places(a6),a0	
	move.b	12(a0),d7
	lsr.b	#4,d7
	lsl.l	#8,d7
	move.b	8(a0),d7
	lsr.b	#4,d7
	lsl.l	#8,d7
	move.b	4(a0),d7
	lsr.b	#4,d7
	lsl.l	#8,d7
	move.b	(a0),d7
	lsr.b	#4,d7

	move.l	d7,CAR_WIN_ORDER(a6)			; 01020300 4th (Red), 3rd (Yellow), 2nd (Green), 1st (Blue)

;-----------------------

	moveq	#3,d7
	
.colour:
	move.l	(a0)+,d2
	rol.l	#4,d2
	and.l	#$f,d2
	or.b	d2,d3
	lsl.l	#4,d3
	dbf	d7,.colour

	
; I need to determine order of cars first then loop through each one.

; First determine the winner.
	
	lsr.l	#4,d3
	moveq	#PLACE_4,d0			
	moveq	#0,d1
	move.b	d3,d1
	and.l	#$f,d1			; Car colour 		
	bsr.s	.set_colour

	lsr.l	#4,d3
	moveq	#PLACE_3,d0			
	moveq	#0,d1
	move.b	d3,d1
	and.l	#$f,d1			; Car colour 		
	bsr.s	.set_colour	

	lsr.l	#4,d3
	moveq	#PLACE_2,d0			
	moveq	#0,d1
	move.b	d3,d1
	and.l	#$f,d1			; Car colour 		
	bsr.s	.set_colour
	
	lsr.l	#4,d3
	moveq	#PLACE_1,d0			
	moveq	#0,d1
	move.b	d3,d1
	and.l	#$f,d1			; Car colour 		
	bsr.s	.set_colour
	bra	.exit
	
.set_colour: 
	cmp.w	#PLACE_4,d0
	bne.s	.fourth
	clr.w	SHOW_MECHANIC(a6)
	cmp.w	#DroneColourBlue,d1
	bge.s	.fourth
	move.w	#-1,SHOW_MECHANIC(a6)
	
.fourth:
	move.l	d0,d2
	
	lea	.order(a6),a1
	move.b	(a1,d0),d0
	
	mulu.w	#20,d0
	lea	.coltable(pc),a1
	mulu.w	#28,d1
	add.l	d1,a1
	
	cmp.w	#PLACE_1,d2
	bne.s	.flag
	move.l	COPPTR_WINCARS_FLAGS(a6),a0
	move.w	8(a1),2(a0)
	move.w	8(a1),6(a0)
	move.w	8(a1),10(a0)
	move.w	8(a1),14(a0)	
	
.flag:
; a1=index to correct colour
; d0=4
	move.l	COPPTR_WINCARS_PAL(a6),a0
	addq.w	#4,a0			; $180
	
.mechanic:
	addq.l	#8,a1
	
	add.l	#16,a0			; $188
	add.l	d0,a0

; a1 must point to $186
	rept	5
	move.w	(a1),2(a0)
	addq.l	#4,a1
	addq.w	#4,a0
	endr
	
.exit:	rts
	
.coltable:	; Col 1     Col 2     Col 3      Text     Wing
.cblue:	dc.l	$045a0000,$057d0000,$000a0000,$003f0000,$09af0000,$088f0000,$06cf0000
.cred:	dc.l	$0a540000,$0d750000,$0b000000,$0f000000,$0f550000,$0e660000,$0e900000
.cyell:	dc.l	$0aa50000,$0dd60000,$0bb00770,$0ee00000,$0eea0000,$0ff30000,$0e900000
.cgreen	dc.l	$05a50000,$06d60000,$00a00000,$03f00000,$0afe0000,$03f30000,$0ce60000
.dblue:	dc.l	$045a0000,$057d0000,$09980000,$0ccb0000,$0aa90000,$088f0000,$06cf0000
.dred:	dc.l	$0a540000,$0d750000,$09980000,$0ccb0000,$0aa90000,$0e220000,$0f000000
.dyell:	dc.l	$0aa50000,$0dd60000,$09980000,$0ccb0000,$0aa90000,$0ee20000,$0ff00000
.dgreen	dc.l	$05a50000,$06d60000,$09980000,$0ccb0000,$0aa90000,$03f30000,$00e00000

	data
	
.order:	dc.b	$02,$01,$03,$00			; car 1=th

.places:	dc.l	$12100234		; Blue last
		dc.l	$33070234		; Yellow winner
		dc.l	$03140234		; Green 2nd
		dc.l	$22120234		; Red 3rd
		dc.l	0

	code



;d7=number of long words to sort
;a0=ptr to long words
ssWinningCarsSortTimes:
	movem.l	d0-d7/a0-a1,-(a7)
	move.l	d7,d6
	move.l	a0,a1
.reload:
	move.l	d6,d7
	move.l	a1,a0
	
.l1:	move.l	(a0),d2
	move.l	d2,d4
	move.l	4(a0),d3
	and.l	#$fffffff,d2
	and.l	#$fffffff,d3
	cmp.l	d3,d2
	bge.s	.s1
	move.l	4(a0),0(a0)
	move.l	d4,4(a0)
	bra.s	.reload

.s1:	addq.w	#4,a0
	dbf	d7,.l1
	movem.l	(a7)+,d0-d7/a0-a1
	rts



;a0=Sprite sheet
;a1=Screen
;a2=Source screen [post]
;d0=Mechanic Animation to display [0-2] 
ssWinningCarsMechanic:
		move.l	a2,d3
		lea	.table(pc),a2
		move.l	(a2,d0*4),a2		; frames pointer
		moveq	#0,d0
		moveq	#0,d1
		move.w	(a2)+,d0		; xpos
		move.w	(a2)+,d1		; ypos
		mulu.w	hScreenScanline(a1),d1
		
		lsr.w	#3,d0
		move.l	hScreenPointers(a1),a1
		moveq	#0,d2
		add.l	d1,d2
		add.l	d0,d2
		add.l	d2,a1			; d2=Screen offset
						; a1=Screen Address
.reset:		moveq	#0,d0
		move.w	(a2),d0			;Get frame number

.change:	move.b	4(a2,d0),d0		;Get anim frame
		bpl.s	.plus
		clr.l	(a2)
		bra.s	.reset
		
.plus:		and.l	#$ff,d0
		add.l	#$2000,(a2)+		; Animation speed
		move.l	hAddress(a0),a0		; Address of Sprite Sheet
		move.l	4(a0,d0*8),a2		; a2=Source Mask BLTAPTH
		move.l	(a0,d0*8),a0		; a0=Bitmap Address BLTBPTH
						; a1=Screen Address BLTDPTH

		move.l	d3,a3
		move.l	hBitmapBody(a3),a3	
		addq.w	#8,a3			; a3=Source screen BLTCPTH
		add.l	d2,a3			; add offset
		
		moveq	#6-1,d7			; Number of bitplanes
.blit:
		WAIT_FOR_BLITTER
		move.w	#$0fca,BLTCON0(a5)
		move.w	#0,BLTCON1(a5)
		move.l	a2,BLTAPTH(a5)
		move.l	a0,BLTBPTH(a5)
		move.l	a3,BLTCPTH(a5)
		move.l	a1,BLTDPTH(a5)
		
		move.l	#$-1,BLTAFWM(a5)
		
		move.w	#(256/8)-8,BLTAMOD(a5)			; mask
		move.w	#((256/8)*6)-8,BLTBMOD(a5)		; bob
		move.w	#((SCREEN_SIZE_X/8)*6)-8,BLTCMOD(a5)		; screen
		move.w	#((SCREEN_SIZE_X/8)*6)-8,BLTDMOD(a5)		; screen
		move.w	#(63<<6)+4,BLTSIZE(a5)		96x40	
	
		add.l	#32,a0
		add.l	#64,a3
		add.l	#64,a1
		dbf	d7,.blit
.exit:		rts
	
.table:		dc.l	.hammer_xypos
		dc.l	.explode_xypos
		dc.l	.scratch_xypos
		dc.l	.saw_xypos
		even

.hammer_xypos:	dc.w	256,264
.hammer_pointer:	dc.l	0
.hammer_frames:	
		rept	8
		dc.b	0
		endr
		dc.b	0,1,2,3,$ff
		even
		
		
.explode_xypos:	dc.w	256,264
.explode_pointer:	dc.l	0
.explode_frames:	
		rept	10
		dc.b	4
		endr
		dc.b	5,6,7,7,7,7,6,5,4,4,4,5,6,7,7,7,7,7,8,9,10,11,12,13,$ff
		even
		
		
.scratch_xypos:	dc.w	256,264
.scratch_pointer	dc.l	0
.scratch_frames:	
		dc.b	14,14,14,15,15,15,14,14,14,15,15,15,16,17,18,19,19,18,17,16,$ff
		even

.saw_xypos:	dc.w	256,264
.saw_pointer	dc.l	0
.saw_frames:	
		dc.b	20,21,22,23,$ff
		even
		
first_best_bonus:	dc.l	FIRST_PLACE_BEST_BONUS
first_avg_bonus:	dc.l	FIRST_PLACE_AVERAGE_BONUS
first_all_bonus:	dc.l	FIRST_PLACE_BEST_BONUS+FIRST_PLACE_AVERAGE_BONUS

second_best_bonus:	dc.l	SECOND_PLACE_BEST_BONUS
second_avg_bonus:	dc.l	SECOND_PLACE_AVERAGE_BONUS
second_all_bonus:	dc.l	SECOND_PLACE_BEST_BONUS+SECOND_PLACE_AVERAGE_BONUS
		
third_best_bonus:	dc.l	THIRD_PLACE_BEST_BONUS
third_avg_bonus:	dc.l	THIRD_PLACE_AVERAGE_BONUS
third_all_bonus:	dc.l	THIRD_PLACE_ALL_BONUS

fourth_best_bonus:	dc.l	FOURTH_PLACE_BEST_BONUS
fourth_avg_bonus:	dc.l	FOURTH_PLACE_AVERAGE_BONUS
fourth_all_bonus:	dc.l	FOURTH_PLACE_BEST_BONUS+FOURTH_PLACE_AVERAGE_BONUS




		data
		
FLAG_POSITIONS:	dc.w	0,100,30,0			; sprite number, xpos, y pos, current anim.
		dc.w	-1
		
		data
		
MECH_NUMBER:	dc.w	0
WINNING_CARS_UPDATE:	dc.w	0
		
SHOW_MECHANIC:		dc.w	0
SHOW_FLAGS:		dc.w	0

COPPTR_SPRITE_FLAGS_1:		dc.l	0
COPPTR_SPRITE_FLAGS_2:		dc.l	0
;COPPTR_COLOR00:			dc.l	0

COPPTR_WINCARS_FLAGS:		dc.l	0


RNCPTR_WINNING_CARS_FLAGS:	dc.l	0
UNPPTR_WINNING_CARS_FLAGS:	dc.l	0

RNCPTR_WINNING_CARS:	dc.l	0
SCRPTR_WINNING_CARS:	dc.l	0		
UNPPTR_WINNING_CARS:	dc.l	0
BMPPTR_WINNING_CARS:	dc.l	0
PALPTR_WINNING_CARS:	dc.l	0		

RNCPTR_WINNING_CARS_MECHANIC:	dc.l	0
UNPPTR_WINNING_CARS_MECHANIC:	dc.l	0
BMPPTR_WINNING_CARS_MECHANIC:	dc.l	0
MSKPTR_WINNING_CARS_MECHANIC:	dc.l	0		
SPSPTR_WINNING_CARS_MECHANIC:	dc.l	0
		
COPPTR_WINCARS_PAL:	dc.l	0




		code