TORNADO_SPIN_FRAMES:	equ	60

hdlTornado:

.event:		
		move.l	hBobSpriteCarNumber(a3),d1
		GET_CAR_CONTEXT

		tst.w	hBobSpriteState(a3)		
		bmi	.construct
		beq	.frame
		bra	.destruct

; Construct variables 
.construct:	clr.w	hBobSpriteState(a3)
		bsr	.update
		bra	.exit
		
.update:	
		moveq	#0,d1
		moveq	#0,d2
		move.w	hBobSpriteXpos(a3),d1
		move.w	hBobSpriteYpos(a3),d2
		
		lsr.w	#3,d1				; divide by 8   8=1
		lsr.w	#3,d2				; divide by 8   8=1
		
		IFNE 	ENABLE_SPRITE_TRACKING
		moveq	#0,d4
		moveq	#0,d5
		
		move.w	d1,d4
		move.w	d2,d5
		addq.w	#1,d4				; 65
		addq.w	#1,d5
		bsr	ssDbgPlotLowerBlock
		
		move.w	d1,d4
		move.w	d2,d5		
		addq.w	#1,d4				; 129
		addq.w	#2,d5
		bsr	ssDbgPlotLowerBlock
		
		move.w	d1,d4
		move.w	d2,d5		
		addq.w	#1,d4				; 193
		addq.w	#3,d5		
		bsr	ssDbgPlotLowerBlock
		
		move.w	d1,d4
		move.w	d2,d5
		addq.w	#2,d4				; 66
		addq.w	#1,d5
		bsr	ssDbgPlotLowerBlock
		
		move.w	d1,d4
		move.w	d2,d5		
		addq.w	#2,d4
		addq.w	#2,d5				; 130
		bsr	ssDbgPlotLowerBlock
		
		move.w	d1,d4
		move.w	d2,d5		
		addq.w	#2,d4
		addq.w	#3,d5				; 194
		bsr	ssDbgPlotLowerBlock

		ENDC
		
		lsl.w	#6,d2				; multiply by 64  1=64
		
		move.l	MEMPTR_COLLISION_RAM(a6),a0
		move.l	hAddress(a0),a0
		add.l	d1,a0
		add.l	d2,a0
		move.l	a0,hBobSpriteTerrainPtr(a3)
		bra	.exit

; If state = 1 then run destruct.
.destruct:	bra	.exit

.tornspeed:	dc.l	$4000,$4800,$5000,$5800,$6000,$6800,$7000,$7800
		dc.l	$8000,$8800,$9000,$9800,$a000,$a800,$b000,$b800
		rept	24
		dc.l	$c000
		endr
		
.frame:		moveq	#0,d3
		move.w	CURRENT_LEVEL(a6),d3
		lea	.tornspeed(pc),a0
		move.l	(a0,d3*4),d3
		

		move.w	#LEVEL_UPPER_BITMAP,hBobSpriteBitmapLevel(a3)
		tst.w	hBobSpriteYpos(a3)
		bpl.s	.ey
; must be minus - fail safe for error

		move.w	#35,hBobSpriteYpos(a3)
		bra.s	.xcheck
		
.ey:		cmp.w	#34,hBobSpriteYpos(a3)
		bge.s	.xcheck
		move.w	#LEVEL_LOWER_BITMAP,hBobSpriteBitmapLevel(a3)
		
	
.xcheck:	
		tst.w	hBobSpriteXpos(a3)
		bpl.s	.ex
; must be minus - fail safe for error

		move.w	#5,hBobSpriteXpos(a3)

.ex:		cmp.w	#4,hBobSpriteXpos(a3)
		ble.s	.swap_x
		cmp.w	#SCREEN_SIZE_X-48,hBobSpriteXpos(a3)
		blt.s	.ycheck
.swap_x:	not.w	hBobSpriteMoveX(a3)
.ycheck:	cmp.w	#4,hBobSpriteYpos(a3)
		ble.s	.swap_y
		
		cmp.w	#SCREEN_SIZE_Y-72,hBobSpriteYpos(a3)
		ble.s	.move	
		
.swap_y:	not.w	hBobSpriteMoveY(a3)
		
.move:
.move_x:	move.l  VPOSR(a5),d0
		and.l	#$7fff,d0
		tst.w	hBobSpriteMoveX(a3)
		bpl.s	.right
		bmi.s	.left
		nop
.left:		add.l	d3,d0

		sub.l	d0,hBobSpriteXpos(a3)
		bra.s	.move_y
.right:		add.l	d3,d0
		add.l	d0,hBobSpriteXpos(a3)

.move_y:	move.l  VPOSR(a5),d0
		and.l	#$3fff,d0
		tst.w	hBobSpriteMoveY(a3)
		bpl.s	.down
		bmi.s	.up
		nop
.up:		add.l	d3,d0
		sub.l	d0,hBobSpriteYpos(a3)
		bra.s	.checks
.down:		add.l	d3,d0
		add.l	d0,hBobSpriteYpos(a3)
		
.checks:
		IFNE	TORNADO_TOPRIGHT
		move.w	#512-32,hBobSpriteXpos(a3)
		move.w	#0,hBobSpriteYpos(a3)
		
		move.w	#18*8,hBobSpriteXpos(a3)
		move.w	#31*8,hBobSpriteYpos(a3)
		ENDC
		
		bsr	.update
		bsr	.collision_check
		bra.s	.exit

.collision_check:
		moveq	#maxCars-1,d7
		
		moveq	#CAR_1,d1
.loop:
		move.l	hBobSpriteTerrainPtr(a3),a0		; Water pointer
		GET_CAR_CONTEXT
		
		tst.w	carIsDrone(a4)
		bmi.s	.next
		
		tst.w	carSpinTimer(a4)
		bmi.s	.check
		subq.w	#4,carSpinTimer(a4)			; Decrement timer
		addq.l	#4,carCurrentThrottle(a4)
		cmp.l	#$100,carCurrentThrottle(a4)
		bgt.s	.next
		move.l	#$100,carCurrentThrottle(a4)
		bra.s	.next
		
.check:		
		move.b	65(a0),d0
		btst	d1,d0			
		bne.s	.slow
		move.b	66(a0),d0
		btst	d1,d0			
		bne.s	.slow
		
		move.b	129(a0),d0
		btst	d1,d0			
		bne.s	.slow
		move.b	130(a0),d0
		btst	d1,d0			
		bne.s	.slow

		move.b	193(a0),d0
		btst	d1,d0			
		bne.s	.slow
		move.b	194(a0),d0
		btst	d1,d0			
		bne.s	.slow
		
.next:		addq.w	#1,d1				; next car
		dbf	d7,.loop
		bra	.exit
		
.slow:		
		move.w	#(TORNADO_SPIN_FRAMES*8),carSpinTimer(a4)		; spin for 2 seconds as collision here.
		moveq	#sampleSpin,d0
		bsr	agdPlayIngameSample
.exit:		rts
