	processor	6502
	org		$080D


	; Create "alternate" VRAM with the random -- jubatian text
	; Clear area
	lda #$A0	; Inverted Space
	ldy #$7C
lp1:	ldx #0
	sty vrhi
lp2:	hex 9D		; STA absolute,X
	hex 00
vrhi:	hex 00
	inx
	bne lp2
	iny
	bpl lp1
	
	; Add the RANDOM text to line 11; pos 17 (X is 0 here)
lprn:	lda rand,X
	sta $7DC9,X
	inx
	cpx #6
	bne lprn
	
	; Add the BY text
	lda #$82
	sta $7E1B
	lda #$99
	sta $7E1C
	
	; Add the JUBATIAN text to line 15; pos 16 (X is 6 here)
	inx
lpjb:	lda juba,X
	sta $7E68,X
	dex
	bpl lpjb

	
	; Start the job: Run 4 random generators to fill screen block by
	; block	with the generated video ram in dark blue on light blue
	; fashion. (X is 255 here)
	
	inx
lp0:	hex A9		; LDA immediate
rn1:	hex 00
	asl
	adc #$03
	eor #$45
	sta rn1
	tay
	lda $7C00,Y
	sta $0400,Y
	jsr wait
	hex A9		; LDA immediate
rn2:	hex 00
	asl
	adc #$0D
	eor #$4D
	sta rn2
	tay
	lda $7D00,Y
	sta $0500,Y
	jsr wait
	hex A9		; LDA immediate
rn3:	hex 00
	asl
	adc #$23
	eor #$33
	sta rn3
	tay
	lda $7E00,Y
	sta $0600,Y
	jsr wait
	hex A9		; LDA immediate
rn4:	hex 00
	asl
	adc #$3B
	eor #$3F
	sta rn4
	tay
	lda $7F00,Y
	sta $0700,Y
	jsr wait
	inx
	bne lp0


	; Add the greeting text to line 23; pos 5 (X is 0 here)
lpgt:	lda gret,X
	sta $079D,X
	jsr wait
	inx
	cpx #30
	bne lpgt
		
	
	; Wait a little... (X is 30)
lp3:	jsr wait
	inx
	bne lp3
	
	
	; Recover to BASIC (X is 0)
	lda #$20
lp4:	sta $0400,X
	sta $0500,X
	sta $0600,X	
	sta $0700,X
	jsr wait
	inx
	bne lp4


	; Home cursor
	jsr $e566
		

	rts



wait:	bit $d011	; Delay a frame
	bpl wait
wait1:	bit $d011
	bmi wait1
	rts



rand:	hex 92 81 8E 84 8F 8D		; RANDOM
juba:	hex 8A 95 82 81 94 89 81 8E	; JUBATIAN

gret:			; "Greets to all who love the C64" (30 letters)
	hex 87 92 85 85 94 93 A0 94
	hex 8F A0 81 8C 8C A0 97 88
	hex 8F A0 8C 8F 96 85 A0 94
	hex 88 85 A0 83 B6 B4
