/*****************************************************************/
/*                                                               */
/*                  The "mADDness" demo                          */
/*                      /Mic, 2001                               */
/*                                                               */
/* Originally planned as an ADD '01 entry, but things didn't     */
/* work out as planned (the compo got postponed by another two   */
/* months). So here it is...                                     */
/*                                                               */
/* Everything you see is mine, except:                           */
/*  + The brid8x16 font, wich was taken from a font-pack by Jiri */
/*    Babor.                                                     */
/*  + The concrete texture, taken from TexPack #6.               */
/*                                                               */
/* This demo runs just fine in igba 0.8, and (probably) in       */
/* vgba 1.0. The best thing of course would be to run it on the  */
/* actual hardware.                                              */
/*                                                               */
/*****************************************************************/


#include <math.h>
#include <stdlib.h>
#include <string.h>

#include "gbal.h"
#include "utils.h"

// Display-order for optimized charset bozo8.chr
#include "bozo8.h"


#define FIXED(a)     ((int)(a*256))
#define FIXMUL(a,b)  ((a*b)>>8)
#define FIXDIV(a,b)  ((a<<8)/b)



extern u16 sosick;
extern char serif8_set,serif8_data;
extern char serif8_256;

extern char brid8x16_chr;
extern char crete;
extern u16 crete_pal;
extern char sphere_chr;
extern u16 sphere_pal;
extern char bozo_chr;
extern u16 bozo_pal;

extern char tunnel_texture;
extern u16 tunnel_pal,tunnel_table;


extern int sin_table_fixed;
int *sin_table = (int *)&sin_table_fixed;


extern u8 *BACK;

int scroll_pos;
float sine[256];

int CAM_X, CAM_Y, CAM_Z;

float quad3D[24] =
{
 -32.0f,-32.0f,-32.0f,
 32.0f,-32.0f,-32.0f,
 32.0f,32.0f,-32.0f,
 -32.0f,32.0f,-32.0f,
 -32.0f,-32.0f,32.0f,
 32.0f,-32.0f,32.0f,
 32.0f,32.0f,32.0f,
 -32.0f,32.0f,32.0f
};
float quad3D2[24];
long quad2D[16];
u8 vball_order[8];

float scale_inverse = 1.0f,
      scale_delta = 0.0016f;


u8 ball_angle = 30;

char dev_text[] = "Code gfx and whatnot by Mic";
char irc_text[] = "Visit #gbadev at EFNet";
char scrolly[] = "Whatcha looking at Bub!?  Code, gfx and whatnot by Mic"\
                 "  Thanks to Exoticorn and Dovoto for testing.   Don\'t "\
                 "forget to visit #gbadev at EFNet.   They might even be"\
                 " helpful if they feel like it ^_^  ................   ";
char sites[] = "WWW.GBADEV.ORGWWW.ZOPHAR.NETWWW.GBAEMU.COM";

font_struct serif8;





/* Load a number of 16-color tiles */
void Load16x16Tiles(char *dest, char *src, int start_tile, int num_tiles)
{
  dest += (start_tile<<5);
  DMACopyInstant(dest, src, num_tiles<<5);
}


/* Load a number of 256-color tiles */
void Load256x1Tiles(char *dest, char *src, int start_tile, int num_tiles)
{
  dest += (start_tile<<6);
  DMACopyInstant(dest, src, num_tiles<<6);
}


/* Clear screen block #wichblock (multiples of 2048) */
void ClearBGScreenBlock(int wichblock, u8 c)
{
 int i;
 u32 c32;

 c32 = c;
 c32 = (c32<<8)|c32;
 c32 = (c32<<16)|c32;
 for (i=0; i<2048; i+=4)
   *(u32 *)(VRAM + (wichblock<<11) + i) = c32;
}


// Yeah I'm using floats, so bleh!.. 
//
void Rotate(float *src, float *dest, int rx, int ry, int rz, int num_points)
{
int i, offs;
float xsa,xca, ysa,yca, zsa,zca;
float xr,yr,zr,f1;

 xsa = sine[rx&255];
 xca = sine[(rx+64)&255];
 ysa = sine[ry&255];
 yca = sine[(ry+64)&255];
 zsa = sine[rz&255];
 zca = sine[(rz+64)&255];

 offs = 0;
 for (i=0; i<num_points; i++)
 {
  xr = src[offs];
  yr = src[offs+1];
  zr = src[offs+2];
  if (rx)
  { 
    f1 = yr;
    yr = ((xca*yr)-(xsa*zr));
    zr = ((xsa*f1)+(xca*zr));
  }
  if (ry)
  { 
    f1 = xr;
    xr = ((yca*xr)-(ysa*zr));
    zr = ((ysa*f1)+(yca*zr));
  }
  if (rz)
  { 
    f1 = xr;
    xr = ((zca*xr)-(zsa*yr));
    yr = ((zsa*f1)+(zca*yr));
  }
  dest[offs] = xr;
  dest[offs+1] = yr;
  dest[offs+2] = zr;
  offs += 3;
 }
}



void Project(float *src, long *dest, int num_points)
{
int i,si,di;
float sx,sy,sz;
float f1;

  si = 0;
  di = 0;
  for (i=0; i<num_points; i++)
  {
    sx = src[si]; 
    sy = src[si+1];
    sz = src[si+2];
    si += 3;

    // Used for scaling the vectors (to get proper projection)
    f1 = (((sz+32.0f)/256.0f)+0.25f)*4.0f;

    sz += (float)(CAM_Z);
    if (sz!=0)
    {

      dest[di] = (long)((FOCAL*sx*f1)/sz) + CAM_X;
      dest[di+1] = (long)((FOCAL*sy*f1)/sz) + CAM_Y;
    }else
    {
      dest[di] = CAM_X;
      dest[di+1] = CAM_Y;
    }
    di += 2;
  }
}


// Rotate & project the vectorballs
//
void TransformBalls()
{
  Rotate(&quad3D[0], &quad3D2[0],
              ball_angle, ball_angle, ball_angle, 8);
  Project(&quad3D2[0], (long *)&quad2D[0], 8);
  ball_angle++;
}


// Sort the vectorballs; closest last
// (Shellsort is used)
//
void SortBalls()
{
 int i,j,gap,first,last;
 float tempi,tempj;
 u8 tempi2,tempj2;

  for (i=0; i<8; i++) vball_order[i] = (u8)i;

  last = 8;
  gap = (last/3)+1;
 
  while (1)
  {
    first = gap;
    for (i=first; i<last; i++)
    {
      tempi = quad3D2[(i<<1)+i+2];
      tempi2 = vball_order[i];
      j = i - gap;
      while (1) 
      {
         tempj = quad3D2[(j<<1)+j+2];
         tempj2 = vball_order[j];
         if (tempi<tempj) 
         {
            j += gap;
            break; 
         }
         quad3D2[((j+gap)<<1)+j+gap+2] = tempj;
         vball_order[j + gap] = tempj2;
         if (j<gap) 
            break;  
         j -= gap;
      }
      quad3D2[(j<<1)+j+2] = tempi;
      vball_order[j] = tempi2;
    }
    if (gap==1)
       return;
    else
       gap = (gap/3)+1;
  }
}



// Draw the vectorballs
//
void DrawBalls()
{
 int i;
 u8 j;
 float scale_inv;
 int ca,sa;
 int i1,i2,i3;
 short s1;
 
  for (i=0; i<8; i++)
  {
    j = vball_order[i];
    scale_inv = ((quad3D2[(i<<1)+i+2]+32.0f)/256.0f)+0.25f;
    scale_inv = 1.0f/scale_inv;

    sa = sin_table[(ball_angle<<2)&1023];
    ca = sin_table[((ball_angle<<2)+256)&1023];

    i3 = FIXED(scale_inv);
    i1 = FIXMUL(i3, ca);
    i2 = FIXMUL(i3, sa);
    s1 = f1_23_8_to_f1_7_8(i1);

    // BIT8 = enable rot/scale, BIT13 = 256 color obj
    OAM[i].Attrib0 = ((char)quad2D[j+j+1]) | BIT8 | BIT13;

    // BIT15 = 32x32 size obj, set rot/scale param# to i
    OAM[i].Attrib1 = ((char)quad2D[j+j]) | BIT15 | (i<<9);

    OAM[i].Attrib2 = 8;

    OAM[i*4].RotateScale = s1; 
    OAM[(i*4)+1].RotateScale = f1_23_8_to_f1_7_8(i2);
    OAM[(i*4)+2].RotateScale = f1_23_8_to_f1_7_8(-i2);
    OAM[(i*4)+3].RotateScale = s1; 
  }
}
 




void TunnelDraw(int pos)
{
 u32 *pTable = (u32 *)&tunnel_table;
 char *pTexture = &tunnel_texture;
 u16 *dest = (u16 *)BACK;

  dest += 1948;     // 1948 = ((16 * 240) + 56) / sizeof(short int)

  __asm 
  {
    mov r0,pTable
    mov r1,pTexture
    mov r2,dest
    mov r6,#128             // height of tunnel
    y_loop:
      mov r7,#64            // width of tunnel / 2
      x_loop:
        ldr r3,[r0],#4      // load a table entry (4 bytes)
        mov r4,r3,lsr #16   // put lower hword in r4
        mov r5,pos           
        add r3,r3,r5        // add 'pos' 
        add r4,r4,r5        // ...
        and r3,r3,#0x3FFF   // put the values in range
        and r4,r4,#0x3FFF
        ldrb r5,[r1, r4]    // load a pixel (or texel)
        mov r4,r5,lsl #8    // put it in the upper byte
        ldrb r5,[r1, r3]    
        add r4,r4,r5
        strh r4,[r2],#2     // store the 2 pixels
        subs r7,r7,#1
      bne x_loop
      add r2,r2,#112        // 112 = (240-128)
      subs r6,r6,#1
    bne y_loop
  }
}


// Nothing important. Just draws an xor'ed pattern to the backbuffer
//
void TunnelDrawBG()
{
 int x,y;
 u16 pixel;
 int offs = 0;

  for (y=0; y<160; y++)
    for (x=0; x<240; x+=2)
    {
      pixel = ((((x&31)+1)<<8)|(x&31))^y;
      *(u16 *)(BACK + offs) = pixel;
      offs += 2;
    }
}


// Rotate & scale bg2
//
void ScaleBG(int an)
{
 int i1,i2,i3,i4,i5,i6,i7;
 short s1,s2,s3,s4;

    i1 = sin_table[an&1023];
    i2 = sin_table[(an+256)&1023];

    i3 = FIXMUL(FIXED(scale_inverse),i2);
    i4 = FIXMUL(FIXED(scale_inverse),i1);
    i5 = -i4;  
    i6 = i3;   

    i7 = i1;
    i1 = FIXMUL(i3, FIXED(0-128)) - FIXMUL(i4, FIXED(0-128)) + FIXED(128);
    i2 = FIXMUL(i4, FIXED(0-128)) + FIXMUL(i3, FIXED(0-128)) + FIXED(128);
    i1 = f1_23_8_to_f1_19_8(i1);
    i2 = f1_23_8_to_f1_19_8(i2);

    *(int *)(&BG2X_L) = i1;   
    *(int *)(&BG2Y_L) = i2; 

    s1 = f1_23_8_to_f1_7_8(i3);
    s2 = f1_23_8_to_f1_7_8(i4);
    s3 = f1_23_8_to_f1_7_8(i5);
    s4 = f1_23_8_to_f1_7_8(i6);

    BG2PA = s1;	
    BG2PB = s2;
    BG2PC = s3;
    BG2PD = s4;
			
    /* Move the bg "away" from the viewer */
    scale_inverse += scale_delta;
    if ((scale_inverse>2.0f)||(scale_inverse<0.25f))
      scale_delta = -scale_delta;
}



int DrawScroller()
{
 int i,j;
 int x,y;
 int ca,sa;
 int i1,i2,i3,i4;
 
  x = scroll_pos;
  i = 0;
  if (x<0)
    { i += (x/-10); x-=((x/10)*10); }

  j = 0;
  for (; i<strlen(scrolly); i++)
  {
     if ((scrolly[i]==' '))
     {
       x += 10;
       continue;
     }else if (x>239) return j;
 
     sa = sin_table[((x+16)<<3)&1023];
     y = (sa*11)>>8;
     sa = sin_table[((x+16)<<3)&511];
     ca = sin_table[(((x+16)<<3)+256)&1023];
     y += 116;

     i1 = sa; 
     i2 = ca;
     i3 = -i2;  
     i4 = i1;

     OAM[j].Attrib0 = (y&255) | BIT8|BIT9|BIT13|BIT15;
     OAM[j].Attrib1 = (x&255) | (j<<9);
     OAM[j].Attrib2 = ((scrolly[i]-31)<<2);

     OAM[(j<<2)+0].RotateScale = f1_23_8_to_f1_7_8(i1);
     OAM[(j<<2)+1].RotateScale = f1_23_8_to_f1_7_8(i2);
     OAM[(j<<2)+2].RotateScale = f1_23_8_to_f1_7_8(i3);
     OAM[(j<<2)+3].RotateScale = f1_23_8_to_f1_7_8(i4);

     x += 10;
     j++;
  }
  return j;
}



void ShowSiteName(int a, int b)
{
 int i,j,x;
 char c;

  i = (a/432)%3;
  i = (i<<3)+(i<<2)+i+i;

  x = 14;

  for (j = 0; j < 14; j++)
  {
     c = serif8.ascii2local[sites[i+j]];
     OAM[j+b].Attrib0 = (28)|BIT13;
     OAM[j+b].Attrib1 = (x&255);
     OAM[j+b].Attrib2 = (c+c)+388;
     x += 8;
  }
  OAM[b+14].Attrib0 = 240;
  OAM[b+14].Attrib1 = 160;
  OAM[b+14].Attrib2 = 0;
}




//!!!! Entrypoint !!!!
//
int GBA_main()
{
 int i,j,k;
 float f;
 u16 oldC;
 u8 move_scrolly = 1;
 u8 rot_colors=0;


  f = 0.0f;
  for (i=0; i<256; i++)
  {
    sine[i] = (float)sin(f*3.1415926f/128.0f);
    f += 1.0f;
  }
  
  DISPCNT = (BG_MODE_3 | BG2_ENABLE);
  gbalVSync();
  DMACopyInstant((char *)VRAM, (char *)&sosick, 76800);
  gbalWait(2000);
  FadeToBlack(2);

  gbalVSync();
  DISPCNT = (BG_MODE_0 | BG0_ENABLE);
  BG0CNT = (BG_COLOR_MODE_16x16 | BG_CHR_BASE_1);
  ClearBGScreenBlock(0, 0);

  gbalVSync();
  LoadFont((char *)(VRAM+0x4000), &serif8, &serif8_set, &serif8_data, 72);

  gbalVSync();
  gbalSetColor(BACKGROUND, 0, 0);
  gbalSetColor(BACKGROUND, 0xD1, gbalMakeColor(80,50,255));
  gbalSetColor(BACKGROUND, 0xD2, gbalMakeColor(80,120,255));
  gbalSetColor(BACKGROUND, 0xD3, gbalMakeColor(80,210,255));
  gbalSetColor(BACKGROUND, 0xE1, gbalMakeColor(180,180,180));
  gbalSetColor(BACKGROUND, 0xE2, gbalMakeColor(210,210,210));
  gbalSetColor(BACKGROUND, 0xE3, gbalMakeColor(240,240,240));
  gbalSetColor(BACKGROUND, 0xF0, 0);
  gbalSetColor(BACKGROUND, 0xF1, gbalMakeColor(160,109,30));
  gbalSetColor(BACKGROUND, 0xF2, gbalMakeColor(220,220,20));
  gbalSetColor(BACKGROUND, 0xF3, gbalMakeColor(240,240,240));
  serif8.palette = 0xD;
  PutsxyBG(5, 4, "SoSoSick Productions", &serif8, 0);
  serif8.palette = 0xE;
  PutsxyBG(11, 6, "presents", &serif8, 0);
  PutsxyBG(4, 8, "a", &serif8, 0);
  serif8.palette = 0xF;
  PutsxyBG(6, 8, "Fake Of The Art", &serif8, 0);
  serif8.palette = 0xE;
  PutsxyBG(22, 8, "demo", &serif8, 0);

  gbalWait(1600);

  FadeToBlack(BIT0);
  gbalVSync();
  ClearBGScreenBlock(0, 0);

  gbalVSync();  
  DISPCNT |= BG1_ENABLE;
  BG0CNT = (BG_COLOR_MODE_256x1 | BG_CHR_BASE_1 | BG_SCREEN_BASE_0);
  BG1CNT = (BG_COLOR_MODE_256x1 | BG_CHR_BASE_1 | BG_SCREEN_BASE_1);

  gbalVSync();
  LoadFont((char *)(VRAM+0x4000), &serif8, &serif8_set, &serif8_256, 144);
  BLDMOD = (BIT0 | CFX_ABLEND | BIT1);
  COLEV = 8|(8<<8);

  gbalVSync(); 
  ClearBGScreenBlock(0, 0);
  ClearBGScreenBlock(1, 0);

  BG0VOFS = 88;
  PutsxyBG256(11, 9, "MADDNESS", &serif8, 0);
  PutsxyBG256(11, 20, "MADDNESS", &serif8, 1);

  for (i=1; i<89; i++)
  {
    for (j=0; j<1000; j++) gbalVSync();
    BG0VOFS = 88-i;
    BG1VOFS = i;
    gbalVSync();
  }

  for (i=8; i<17; i++)
  {
    for (j=0; j<1000; j++) gbalVSync();
    COLEV = i|(i<<8);
  }
  for (i=16; i>7; i--)
  {
    for (j=0; j<1000; j++) gbalVSync();
    COLEV = i|(i<<8);
  }

  gbalWait(1200);
  FadeToBlack(BIT0|BIT1);


/******************************************************************/
/* Vector balls + rotating floor                                  */
/******************************************************************/

  gbalVSync();
  ClearBGScreenBlock(0, 0);
  ClearBGScreenBlock(1, 0);
  BG1VOFS = 0;
  BLDMOD = CFX_NONE;
  gbalVSync();
  DISPCNT = (BG_MODE_2 | BG2_ENABLE | OBJ_ENABLE|BIT6);
  BG2CNT = (BG_COLOR_MODE_256x1 | BG_CHR_BASE_1 | BG_SCREEN_BASE_1 | BIT13|BIT14);
  gbalSetPalette(BACKGROUND, &crete_pal, 256);
  Load256x1Tiles((char *)(VRAM+0x4000), &crete, 0, 256);

  gbalVSync();
  gbalSetPalette(OBJECT, &sphere_pal, 256);
  Load256x1Tiles((char *)&OBJDATA, (char *)&sphere_chr, 4, 16);
  for (i=0; i<32; i++) *(&OBJDATA+i) = 0;
  ClearOAM();

  gbalVSync();
  k = 0; 
  for (i=0; i<16; i++)
   for (j=0; j<8; j++)
   {
     *(u16 *)(VRAM + 0x800 + (i<<5) + (j+j))         = k|((k+1)<<8);
     *(u16 *)(VRAM + 0x800 + ((i+16)<<5) + (j+j))    = k|((k+1)<<8);
     *(u16 *)(VRAM + 0x800 + (i<<5) + (j+j+16))      = k|((k+1)<<8);
     *(u16 *)(VRAM + 0x800 + ((i+16)<<5) + (j+j+16)) = k|((k+1)<<8);
     k += 2;
   }

  CAM_X = 100;
  CAM_Y = 65;
  CAM_Z = 300;

  for (i=0; i<2100; i++)
  {
    TransformBalls();
    SortBalls(); 
    gbalVSync();
    ScaleBG(i);
    DrawBalls();

    if (i==2035) { BLDMOD = (CFX_LUM_DEC|BIT2|BIT4); COLY=0; }
    else if (i>2035) COLY = (i-2035)>>2;
  }



/******************************************************************/
/* Textured "tunnel"                                              */
/******************************************************************/

  gbalVSync();
  *(int *)(&BG2X_L) = 0;   
  *(int *)(&BG2Y_L) = 0; 
  BG2PA = 256;	
  BG2PB = 0;
  BG2PC = 0;
  BG2PD = 256;


  BLDMOD = CFX_NONE; 
  gbalSetMode(4);
  DISPCNT ^= BG2_ENABLE;
  gbalSetPalette(BACKGROUND, &tunnel_pal, 256);

  gbalVSync();

  gbalVSync();
  for( i=0; i < 128; i++ )
    OAM[i].Attrib2 = 512;

  TunnelDrawBG();
  gbalVSync();
  gbalSwapBuffers();
  TunnelDrawBG();
  DISPCNT |= BG2_ENABLE;

  i = 0;
  j = 159;
  k = 219;

  for (j=0; j<300; j++)
  {
    gbalVSync();
    TunnelDraw(i);
    gbalSwapBuffers();
    i = (i+131)&0x3FFF;
  }
  for (j=0; j<200; j++)
  {
    gbalVSync();
    TunnelDraw(i);
    gbalSwapBuffers();
    i = (i-134)&0x3FFF;
  }
 


/******************************************************************/
/* Scroller with rotation + background piccy                      */
/******************************************************************/

  gbalVSync();
  DISPCNT = (BG_MODE_0 | BG0_ENABLE | OBJ_ENABLE|BIT6);
  BG0CNT = (BG_COLOR_MODE_256x1 | BG_CHR_BASE_1);

  Load256x1Tiles((char *)(VRAM+0x4000), (char *)&bozo_chr, 0, 154);

  gbalVSync();
  Load256x1Tiles((char *)&OBJDATA, &brid8x16_chr, 2, 192);
  for (i=0; i<8; i++)
  {
   gbalSetColor(OBJECT, 16+i, (i<<7)|30);
   gbalSetColor(OBJECT, 24+i, ((7-i)<<7)|30);
  }

  // Load some font data
  gbalVSync();
  Load256x1Tiles((char *)&OBJDATA, &serif8_256, 194, 40);

  gbalSetColor(OBJECT, 240, 0);
  gbalSetColor(OBJECT, 241, gbalMakeColor(30,30,160));
  gbalSetColor(OBJECT, 242, gbalMakeColor(80,80,224));
  gbalSetColor(OBJECT, 243, gbalMakeColor(160,160,255));

  gbalVSync();
  gbalSetPalette(BACKGROUND, &bozo_pal, 256);
  BLDMOD = CFX_NONE;
  ClearBGScreenBlock(0, 0);

  // Display the background picture
  gbalVSync();
  for (i=0; i<20; i++)
    for (j=0; j<30; j++)
      *(u16 *)(VRAM + (i<<6) + j+j) = bozo8_order[(i*30)+j];


  rot_colors = 7;
  scroll_pos = 240;

  for (i=1; i<4810; i++)
  {
    gbalVSync();
    k = DrawScroller();
    ShowSiteName(i, k);
    rot_colors--;
    if (!rot_colors)
    { 
      oldC = gbalGetColor(OBJECT, 16); 
      for (j=0; j<15; j++)
        gbalSetColor(OBJECT, 16+j, gbalGetColor(OBJECT, 17+j));
      gbalSetColor(OBJECT, 31, oldC);
      rot_colors = 7;
    }
    if (move_scrolly) scroll_pos -= 1;
    move_scrolly = !move_scrolly; 
  }

  
  while (1) {
   gbalVSync();
   OAM[0].Attrib0 = 124|BIT13|BIT15;
   OAM[0].Attrib1 = 92;
   OAM[0].Attrib2 = ('T'-31)<<2;
   OAM[1].Attrib0 = 124|BIT13|BIT15;
   OAM[1].Attrib1 = 100;
   OAM[1].Attrib2 = ('h'-31)<<2;
   OAM[2].Attrib0 = 124|BIT13|BIT15;
   OAM[2].Attrib1 = 108;
   OAM[2].Attrib2 = ('e'-31)<<2;
   OAM[3].Attrib0 = 124|BIT13|BIT15;
   OAM[3].Attrib1 = 124;
   OAM[3].Attrib2 = ('E'-31)<<2;
   OAM[4].Attrib0 = 124|BIT13|BIT15;
   OAM[4].Attrib1 = 132;
   OAM[4].Attrib2 = ('n'-31)<<2;
   OAM[5].Attrib0 = 124|BIT13|BIT15;
   OAM[5].Attrib1 = 140;
   OAM[5].Attrib2 = ('d'-31)<<2;
   ShowSiteName(i>>4, 6);
   rot_colors--;
   if (rot_colors)
   { 
     oldC = gbalGetColor(OBJECT, 16); 
     for (j=0; j<15; j++)
       gbalSetColor(OBJECT, 16+j, gbalGetColor(OBJECT, 17+j));
     gbalSetColor(OBJECT, 31, oldC);
     rot_colors = 7;
   }
   i++;
  }

  return 0;
}
