/*
twotw.cpp by Michael Lynn (07/09/2002).
Requirements: 640*480, 8 bit color.
Developed using DirectX 8 runtime and DirectX 8 MiniSDK headers
and libraries using Visual Studio 6 SP5 on Windows 98.

{History}
*/

#define SZ_NAME		"twotw"
#define SZ_TITLE	"twotw"

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <ddraw.h>

#include <conio.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "ddutil.h"
#include "resource.h"

#include <mmsystem.h>
#include "stsound\YmEnginePublic.h"
#include "stsound\SoundServer.h"

#define BUFFERS 1		// number of BACK BUFFERS
#define DOUBLEBUFF		// define for the Double Buffered version

char szAppPath[_MAX_PATH+1];

#define width		640
#define height		480
#define outbits		8

#define OFFSCREEN_WIDTH		width
#define OFFSCREEN_HEIGHT	height
#define MASKCOL				1

LPDIRECTDRAW            lpDD;           // DirectDraw object
LPDIRECTDRAWSURFACE     lpDDSPrimary;   // DirectDraw primary surface
#ifdef DOUBLEBUFF
	LPDIRECTDRAWSURFACE lpDDSBack;
	LPDIRECTDRAWSURFACE	lpDDSBackground;
	LPDIRECTDRAWSURFACE	lpDDSText;
	LPDIRECTDRAWSURFACE	lpDDSFont;
	LPDIRECTDRAWSURFACE	lpDDSScrollArea;
	LPDIRECTDRAWSURFACE	lpDDSLogo;
#endif

// prototypes
void drawSurface(void);
void clearSurfaceArea(LPDIRECTDRAWSURFACE lpdds,COLORREF rgb,int left,int top,int right,int bottom);
BOOL LoadImages( HWND hwnd );
void dumpPalette(HWND hwnd);
BOOL LoadPalette( HWND hwnd );
void doscroll();
void getpos(char c,int *px,int *py);
void playit(LPARAM lParam);

// strings and constants
char szLoadProblem[_MAX_PATH];

#define WALL_WIDTH		640
#define WALL_HEIGHT		1024
#define WALLTEXT_WIDTH	320
#define WALLTEXT_HEIGHT	480
#define FONT_WIDTH		320
#define FONT_HEIGHT		200
#define CHARWIDTH		32
#define CHARHEIGHT		32
#define SCROLL_WIDTH	640
#define SCROLL_HEIGHT	32
#define LOGO_WIDTH		288
#define LOGO_HEIGHT		96
#define SCROLL_STEP		4

// global variables
char buf[256],err=0;
BOOL bActive=TRUE;		// is it faster to count timer count diff in FULLSCREEN mode? 30/6/98?
BOOL gExclusive=TRUE;

int ypos=0;
int xip,yip,xsp=CHARWIDTH;
//char *str="ABCDEFGHIJKLMNOPQRSTUVWXYZ!?:;012345 .         ",*strpos=str;
char *str="                    OF COURSE THERE IS A SCROLLER... THIS SCREEN IS A CONVERSION OF SCREEN NUMBER EIGHT BY A CLOCKWORK ORANGE FROM THE CUNNING DEMOS FROM THE ATARI ST. THIS ONE HAS MORE COLOURS BUT I THINK THAT IT CAPTURES THE CHARM OF THE ORIGINAL. WRAP!",*strpos=str;

int sine_ix=0,sine_ix2=90;
#define MAX_SINE	180
int sineTab[MAX_SINE];

// all sound code
CSoundServer *pServer=NULL;
void mySoundProc(void *pSoundBuffer,long bufferLen);
void startSTsound(HINSTANCE hInst,char *szID);
void stopSTsound();
void stopAllMusic();

//-----------------------------------------------------------------------------
// Your sound server call back !
// Call what you want here !! An MP3 decoder, a classic MOD player
// or the YM-Engine library ! :-)
//
//-----------------------------------------------------------------------------
void mySoundProc(void *pSoundBuffer,long bufferLen)
{
	// Convert params, assuming we create a 16 bit, mono waveform.
	short *pSample = (signed short*)pSoundBuffer;
	long nbSample = bufferLen / sizeof(signed short);
	ymMusicCompute((short*)pSoundBuffer,nbSample);
}

bool bTune=false;

void startSTsound(HINSTANCE hInst,char *szID)
{
	int nResult;

	bTune=false;
	HRSRC hRes = FindResource(hInst, szID, RT_RCDATA); 
	if (hRes == NULL)
	{
		int n=GetLastError();
		return;
	}
	
	HGLOBAL hGlob=LoadResource(hInst,hRes);
	if(hGlob==NULL)
		return;

	unsigned long len=SizeofResource(hInst,hRes);

	void *lpBuff = LockResource(hGlob);
	// use lpBuff to access the resource contents

	char *x=(char*)malloc(len);
	if(x==NULL)
	{
		nResult = UnlockResource(hRes);
		nResult = FreeResource(hRes);
		return;
	}
	memcpy(x,lpBuff,len);

	nResult = UnlockResource(hRes);
	nResult = FreeResource(hRes);

	if(ymMusicLoadMemory((void*)x,len))
	{
		ymMusicSetLoopMode(YM_TRUE);
		bTune=true;
	}
	free(x);
}


void stopSTsound()
{
	if(bTune==true)
	{
		ymMusicUnload();
		bTune=false;
	}
}

void stopAllMusic()
{
	if(pServer)
	{
		pServer->close();
		delete pServer;
		pServer=NULL;
	}
	stopSTsound();
}
// end of all sound code

// main display update
HWND gHwnd;

void update_display()
{
	drawSurface();
}

void getpos(char c,int *px,int *py)
{
	int x,y;
	if(c=='A') {x=8;y=0;}
	else if(c=='B') {x=56;y=0;}
	else if(c=='C') {x=104;y=0;}
	else if(c=='D') {x=152;y=0;}
	else if(c=='E') {x=200;y=0;}
	else if(c=='F') {x=248;y=0;}

	else if(c=='G') {x=8;y=32;}
	else if(c=='H') {x=56;y=32;}
	else if(c=='I') {x=104;y=32;}
	else if(c=='J') {x=152;y=32;}
	else if(c=='K') {x=200;y=32;}
	else if(c=='L') {x=248;y=32;}

	else if(c=='M') {x=8;y=64;}
	else if(c=='N') {x=56;y=64;}
	else if(c=='O') {x=104;y=64;}
	else if(c=='P') {x=152;y=64;}
	else if(c=='Q') {x=200;y=64;}
	else if(c=='R') {x=248;y=64;}

	else if(c=='S') {x=8;y=96;}
	else if(c=='T') {x=56;y=96;}
	else if(c=='U') {x=104;y=96;}
	else if(c=='V') {x=152;y=96;}
	else if(c=='W') {x=200;y=96;}
	else if(c=='X') {x=248;y=96;}
	
	else if(c=='Y') {x=8;y=128;}
	else if(c=='Z') {x=56;y=128;}
	else if(c=='!') {x=104;y=128;}
	else if(c=='?') {x=152;y=128;}
	else if(c==':') {x=200;y=128;}
	else if(c=='.') {x=248;y=128;}

	else if(c=='0') {x=8;y=160;}
	else if(c=='1') {x=56;y=160;}
	else if(c=='2') {x=104;y=160;}
	else if(c=='3') {x=152;y=160;}
	else if(c=='4') {x=200;y=160;}
	else if(c==' ') {x=248;y=160;}

	else {x=248;y=160;}
	*px=x; *py=y;
}


void doscroll()
{
	RECT r;
	HRESULT hr;
	int x,y;

	if(xsp==CHARWIDTH)
	{
back:
		char c=*strpos++;
		if(c==0)
		{
			strpos=str;
			goto back;
		}
		getpos(c,&x,&y);

		xip=x;
		yip=y;
		xsp=0;
	}

	// scroll left
	r.bottom=SCROLL_HEIGHT; r.top=0;
	r.left=SCROLL_STEP; r.right=SCROLL_WIDTH;
	lpDDSScrollArea->BltFast(0,0,lpDDSScrollArea,&r,DDBLTFAST_WAIT);

	// copy edge
	r.bottom=yip+SCROLL_HEIGHT; r.top=yip;
	r.left=xip+xsp; r.right=r.left+SCROLL_STEP;
	lpDDSScrollArea->BltFast(SCROLL_WIDTH-SCROLL_STEP,0,lpDDSFont,&r,DDBLTFAST_WAIT);
	xsp+=SCROLL_STEP;

	// copy to screen
	r.bottom=CHARHEIGHT; r.top=0; r.right=SCROLL_WIDTH; r.left=0;
	hr=lpDDSBack->BltFast(0,height-40,lpDDSScrollArea,&r,
		DDBLTFAST_SRCCOLORKEY|DDBLTFAST_WAIT);
}


BOOL LoadPalette( HWND hwnd )
{
	IDirectDrawPalette *p=DDLoadPalette(lpDD,MAKEINTRESOURCE(IDB_PALETTE));
	if(p==NULL)
		return FALSE;

	if(FAILED(lpDDSPrimary->SetPalette( p )))
	{
		MessageBox(hwnd,"Set palette failed",SZ_TITLE,MB_OK);
		return FALSE;
	}
	return true;
}

// update wall graphics, scroller and sprites
void drawSurface()
{
	// wall graphics
	RECT r;
	r.top=ypos; r.bottom=ypos+480; r.left=0; r.right=640;
	lpDDSBack->BltFast(0,0,lpDDSBackground,&r,DDBLTFAST_WAIT);
	ypos+=2;
	if(ypos>=512)
		ypos=0;

	// scroll
	doscroll();

	// sprites
	r.top=0; r.bottom=LOGO_HEIGHT; r.left=0; r.right=LOGO_WIDTH;
	lpDDSBack->BltFast(24,sineTab[sine_ix2],lpDDSLogo,&r,DDBLTFAST_SRCCOLORKEY|DDBLTFAST_WAIT);
	lpDDSBack->BltFast(640-LOGO_WIDTH-24,sineTab[sine_ix],lpDDSLogo,&r,DDBLTFAST_SRCCOLORKEY|DDBLTFAST_WAIT);
	sine_ix++;
	if(sine_ix==MAX_SINE)
		sine_ix=0;
	sine_ix2++;
	if(sine_ix2==MAX_SINE)
		sine_ix2=0;
}

void clearSurfaceArea(LPDIRECTDRAWSURFACE lpdds,COLORREF rgb,int left,int top,int right,int bottom)
{
	DDBLTFX ddbltfx;
	RECT rc;

	ZeroMemory(&ddbltfx,sizeof(ddbltfx));
	ddbltfx.dwSize=sizeof(ddbltfx);
	ddbltfx.dwFillColor=rgb;

	rc.top=top; rc.left=left; rc.bottom=bottom; rc.right=right;
	lpdds->Blt(&rc,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&ddbltfx);
}

void dumpPalette(HWND hwnd)
{
	LPDIRECTDRAWPALETTE ddp;
	if(FAILED(lpDDSPrimary->GetPalette(&ddp)))
		MessageBox(hwnd,"Get palette failed",SZ_TITLE,MB_OK);

	PALETTEENTRY ape[255];
	ddp->GetEntries(0,0,256,&ape[0]);

	char szBig[1024];
	strcpy(szBig,"{");
	for(int n=0;n<36;n++)
	{
		char szMsg[32];
		sprintf(szMsg,"[%d]->RGB(%d %d %d)",n,ape[n].peRed,ape[n].peGreen,ape[n].peBlue);
		if(n!=36-1)
			strcat(szMsg,", ");
		if(n!=0&&n%10==0)
			strcat(szMsg,"\r\n");
		strcat(szBig,szMsg);
	}
	strcat(szBig,"}");
	MessageBox(hwnd,szBig,"Palette",MB_OK);
}

BOOL LoadImages( HWND hwnd )
{
	DDReLoadBitmap(lpDDSBackground,MAKEINTRESOURCE(IDB_BRICK));
	DDReLoadBitmap(lpDDSText,MAKEINTRESOURCE(IDB_TWOTW));
	DDReLoadBitmap(lpDDSFont,MAKEINTRESOURCE(IDB_FONT));
	DDReLoadBitmap(lpDDSLogo,MAKEINTRESOURCE(IDB_LOGO));

	// tile
	RECT r;
	int x,y;
	r.top=0; r.bottom=128;
	r.left=0; r.right=128;

	for(x=0;x<WALL_WIDTH;x+=128)
	{
		for(y=0;y<WALL_HEIGHT;y+=128)
		{
			lpDDSBackground->BltFast(x,y,lpDDSBackground,&r,DDBLTFAST_WAIT);
		}
	}

	// layer
	r.top=0; r.left=0; r.right=WALLTEXT_WIDTH; r.bottom=WALLTEXT_HEIGHT;
	lpDDSBackground->BltFast((640-WALLTEXT_WIDTH)/2,16,lpDDSText,&r,DDBLTFAST_SRCCOLORKEY|DDBLTFAST_WAIT);

	lpDDSBackground->BltFast((640-WALLTEXT_WIDTH)/2,WALLTEXT_HEIGHT+48,lpDDSText,&r,DDBLTFAST_SRCCOLORKEY|DDBLTFAST_WAIT);
	return true;
}

static void ReleaseObjects( void )
{
    if ( lpDD != NULL )
    {
        if ( lpDDSPrimary != NULL )
        {
            lpDDSPrimary->Release();
            lpDDSPrimary = NULL;
        }
        lpDD->Release();
        lpDD = NULL;
	}

	if(err==1)
	{
		MessageBox(::GetDesktopWindow(),buf,SZ_TITLE,MB_OK);
		err=0;
	}
}

void playit(LPARAM lParam)
{
	CSoundServer *pServer = (CSoundServer*)lParam;
	if (pServer) pServer->fillNextBuffer();
}

long FAR PASCAL WindowProc( HWND hWnd, UINT message, 
                            WPARAM wParam, LPARAM lParam )
{
    switch ( message )
    {
		case WM_MUSIC:
			playit(lParam);
			break;

		case WM_SETCURSOR:
			SetCursor(NULL);	// Turn off the mouse cursor
			return TRUE;

		case WM_KEYDOWN:
			switch ( wParam )
			{
				case VK_ESCAPE:
					stopAllMusic();
					SendMessage ( hWnd, WM_CLOSE, 0, 0 );
					break;
			}
			break;

		case WM_DESTROY:
			//setcolor(0,0,0,0);
			ReleaseObjects();
			PostQuitMessage(0);
			break;
		
		default:

			break;
	}
	
    return DefWindowProc( hWnd, message, wParam, lParam );
}

static BOOL doInit( HINSTANCE hInstance, int nCmdShow )
{
    WNDCLASS            wc;
    DDSURFACEDESC       ddsd;
	HRESULT				hr;

    // Set up and register window class
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = WindowProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon( hInstance, IDI_APPLICATION );
    wc.hCursor = LoadCursor( NULL, IDC_ARROW );
    wc.hbrBackground = NULL;
    wc.lpszMenuName = SZ_NAME;
    wc.lpszClassName = SZ_NAME;
    RegisterClass( &wc );

 
    // Create a fullscreen window
    gHwnd = CreateWindowEx(
        WS_EX_TOPMOST,
        SZ_NAME,
        SZ_TITLE,
        WS_POPUP,
        0, 0,
        GetSystemMetrics( SM_CXSCREEN ),
        GetSystemMetrics( SM_CYSCREEN ),
        NULL,
        NULL,
        hInstance,
        NULL );

	// Create the DirectDraw object -- we just need an IDirectDraw
    // interface so we won't bother to query an IDirectDraw2
	hr=DirectDrawCreate( NULL, &lpDD, NULL );
	if(hr!=DD_OK)
	{
		sprintf(buf,"Couldn't create DirectDraw object. Error = 0x%x",hr);
		return FALSE;
	}

	// Set exclusive mode
	hr=lpDD->SetCooperativeLevel( gHwnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN );//| DDSCL_ALLOWREBOOT);
	if(hr!=DD_OK)
	{
		sprintf(buf,"Couldn't set cooperative level. Error = 0x%x",hr);
		return FALSE;
	}

    // Set the display mode.
	hr=lpDD->SetDisplayMode( width, height, outbits );
	if ( FAILED( hr ) )
	{
		sprintf(buf, "Couldn't set display mode. Error = 0x%x",hr);
		return FALSE;
	}

	// check caps
	DDCAPS ddcaps;
	ZeroMemory(&ddcaps,sizeof( DDCAPS ));
	ddcaps.dwSize = sizeof( DDCAPS );
	hr=lpDD->GetCaps( &ddcaps, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf, "Couldn't get video card capabilities. Error = 0x%x",hr);
		return FALSE;
    }

	// hope this covers it
	if ( ddcaps.dwSVBCaps & DDCAPS_BLT == 0)
	{
		sprintf(buf, "Cannot blit system-to-video memory. Flags are 0x%x. Need 0x%x",ddcaps.dwSVBCaps,DDCAPS_BLT);
		return FALSE;
	}

	// Create the primary surface
#ifdef DOUBLEBUFF
	ZeroMemory(&ddsd, sizeof(ddsd));
	
	ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_CAPS|DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|DDSCAPS_COMPLEX|DDSCAPS_VIDEOMEMORY;
	ddsd.dwBackBufferCount = BUFFERS;
	ddsd.dwWidth=width;
	ddsd.dwHeight=height;
    
	// a single call to CreateSurface creates back and front buffers
	// using COMPLEX flag set above! By ML (11-12/7/98) page 123 in book.
	hr = lpDD->CreateSurface( &ddsd, &lpDDSPrimary, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf, "Couldn't create primary surface. Error = 0x%x",hr);
		return FALSE;
	}

	ddsd.ddsCaps.dwCaps = DDSCAPS_BACKBUFFER;
	hr = lpDDSPrimary->GetAttachedSurface(&ddsd.ddsCaps,&lpDDSBack);
	if ( FAILED( hr ) )
	{
		sprintf(buf, "Couldn't find the back buffer. Error = 0x%x",hr);
		return FALSE;
	}

#else
	ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_CAPS;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
    
	hr = lpDD->CreateSurface( &ddsd, &lpDDSPrimary, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf, "Couldn't create primary surface.");
		return FALSE;
	}
#endif

	// Friday 24/7/98 : Much slower than solid fill blitting!
	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags =	DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;

	// Create the 1st offscreen surface.
    ddsd.dwWidth = WALL_WIDTH;
	ddsd.dwHeight = WALL_HEIGHT;
	hr = lpDD->CreateSurface( &ddsd, &lpDDSBackground, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf,"Couldn't create offscreen background.\nError = 0x%x",hr);
		return FALSE;
	}

	// create wall text
    ddsd.dwFlags =	DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH | DDSD_CKSRCBLT;
    ddsd.dwWidth = WALLTEXT_WIDTH;
	ddsd.dwHeight = WALLTEXT_HEIGHT;

	// set mask color for SOURCE blitting
    ddsd.ddckCKSrcBlt.dwColorSpaceLowValue = MASKCOL;
    ddsd.ddckCKSrcBlt.dwColorSpaceHighValue = MASKCOL;
	hr = lpDD->CreateSurface( &ddsd, &lpDDSText, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf,"Couldn't create offscreen text background.\nError = 0x%x",hr);
		return FALSE;
	}

	// create font
	ddsd.dwWidth = FONT_WIDTH;
	ddsd.dwHeight = FONT_HEIGHT;
	hr = lpDD->CreateSurface( &ddsd, &lpDDSFont, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf,"Couldn't create offscreen font.\nError = 0x%x",hr);
		return FALSE;
	}

	// create scroll area
	ddsd.dwWidth = SCROLL_WIDTH;
	ddsd.dwHeight = CHARHEIGHT;
	hr = lpDD->CreateSurface( &ddsd, &lpDDSScrollArea, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf,"Couldn't create offscreen font.\nError = 0x%x",hr);
		return FALSE;
	}
	clearSurfaceArea(lpDDSScrollArea,MASKCOL,0,0,SCROLL_WIDTH,CHARHEIGHT);

	// create scroll area
	ddsd.dwWidth = LOGO_WIDTH;
	ddsd.dwHeight = LOGO_HEIGHT;
	hr = lpDD->CreateSurface( &ddsd, &lpDDSLogo, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf,"Couldn't create offscreen logo.\nError = 0x%x",hr);
		return FALSE;
	}

	// start
	ShowWindow( gHwnd, nCmdShow );

	if ( !LoadPalette( gHwnd ))
	{
		sprintf(buf,"Couldn't load palette.");
		return FALSE;
    }

	// loading palette first doesn't set it on XP, was also unreliable on NT4
    if ( !LoadImages( gHwnd ))
	{
		sprintf(buf,"Couldn't load %s",szLoadProblem);
		return FALSE;
    }

	for(int n=0;n<MAX_SINE;n++)
	{
		double theta=(n*6.28)/360;
		sineTab[n]=(short)(cos(theta*2)*130+200);
	}

	return TRUE;
}

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpCmdLine, int nCmdShow )
{
    MSG         msg;

	if(!_fullpath(&szAppPath[0],".",_MAX_PATH))
	{
		MessageBox(0,"Invalid path",SZ_TITLE,MB_OK);
		return -1;
	}

    lpCmdLine = lpCmdLine;
    hPrevInstance = hPrevInstance;

	err=0;
    if ( !doInit( hInstance, nCmdShow ) )
    {
		err=1; SendMessage(gHwnd,WM_DESTROY,0,0);
        return FALSE;
    }

	// start the music
	pServer = new CSoundServer;
	if (pServer->open(mySoundProc))
	{
		SetCursor(NULL);
		startSTsound(hInstance,"#113");
		Sleep(3000);
	}

	while( 1 )
    {
		//setcolor(0,255,0,0);

		if( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) )
		{
			if( !GetMessage( &msg, NULL, 0, 0 ) )
			{
				return msg.wParam;
			}
			TranslateMessage(&msg); 
			DispatchMessage(&msg);
		}
		else if( !gExclusive || bActive )
		{

#ifdef DOUBLEBUFF

		update_display();
		//setcolor(0,0,0,0);

		// automatically waits for vbl
		if(FAILED(lpDDSPrimary->Flip(NULL,DDFLIP_WAIT)))
		{
			err=1; sprintf(buf,"Unable to flip video buffers");
			return 1;
		}
#else
		update_display();
#endif

		}
		else
		{
			WaitMessage();
		}
	}
    return msg.wParam;
}
