#include <gb/gb.h>
#include <gb/drawing.h>

extern const unsigned char uniTiles[];
extern const unsigned char uniMap[];
extern const unsigned char uniMap1[];

const USIN[] = 
{
0, 1, 3, 5, 6, 8, 10, 12, 13, 15,
17, 19, 20, 22, 24, 25, 27, 29, 30, 32,
34, 35, 37, 39, 40, 42, 43, 45, 46, 48,
50, 51, 52, 54, 55, 57, 58, 60, 61, 62,
64, 65, 66, 68, 69, 70, 71, 73, 74, 75,
76, 77, 78, 79, 80, 81, 82, 83, 84, 85,
86, 87, 88, 89, 89, 90, 91, 92, 92, 93,
93, 94, 95, 95, 96, 96, 97, 97, 97, 98,
98, 98, 99, 99, 99, 99, 99, 99, 99, 99,
100, 99, 99, 99, 99, 99, 99, 99, 99, 98,
98, 98, 97, 97, 97, 96, 96, 95, 95, 94,
93, 93, 92, 92, 91, 90, 89, 89, 88, 87,
86, 85, 84, 83, 82, 81, 80, 79, 78, 77,
76, 75, 74, 73, 71, 70, 69, 68, 66, 65,
64, 62, 61, 60, 58, 57, 55, 54, 52, 51,
50, 48, 46, 45, 43, 42, 40, 39, 37, 35,
34, 32, 30, 29, 27, 25, 24, 22, 20, 19,
17, 15, 13, 12, 10, 8, 6, 5, 3, 1,
0, -2, -4, -6, -7, -9, -11, -13, -14, -16,
-18, -20, -21, -23, -25, -26, -28, -30, -31, -33,
-35, -36, -38, -40, -41, -43, -44, -46, -47, -49,
-50, -52, -53, -55, -56, -58, -59, -61, -62, -63,
-65, -66, -67, -69, -70, -71, -72, -74, -75, -76,
-77, -78, -79, -80, -81, -82, -83, -84, -85, -86,
-87, -88, -89, -90, -90, -91, -92, -93, -93, -94,
-94, -95, -96, -96, -97, -97, -98, -98, -98, -99,
-99, -99, -100, -100, -100, -100, -100, -100, -100, -100,
-100, -100, -100, -100, -100, -100, -100, -100, -100, -99,
-99, -99, -98, -98, -98, -97, -97, -96, -96, -95,
-94, -94, -93, -93, -92, -91, -90, -90, -89, -88,
-87, -86, -85, -84, -83, -82, -81, -80, -79, -78,
-77, -76, -75, -74, -72, -71, -70, -69, -67, -66,
-65, -63, -62, -61, -59, -58, -56, -55, -53, -52,
-51, -49, -47, -46, -44, -43, -41, -40, -38, -36,
-35, -33, -31, -30, -28, -26, -25, -23, -21, -20,
-18, -16, -14, -13, -11, -9, -7, -6, -4, -2,
-1, 1, 
};

extern int Scene;
extern int v;
extern int Program;
extern int Frame;
extern int F2;
extern int YS2;
extern int TIMER;
extern int exitloop;

int UCount = 0;

extern int TIMER;
extern int Y;
extern int Y1;

extern const UWORD GrayScale[];


void UNI() {
  switch (Scene){
   case 0:
    wait_vbl_done();
	DISPLAY_OFF;
	delay(50);
    
	  HIDE_WIN;
	  SCY_REG = -144;
	  Y = 0;
	  set_bkg_data(0, 256, uniTiles);
      set_bkg_tiles(0, 0, 20, 32, uniMap);	
	  if (_cpu == 0x11){ 
	    set_bkg_palette(0, 2, GrayScale);
	    VBK_REG = 1;
		   set_bkg_tiles(0, 0, 20, 32, uniMap1);
	    VBK_REG = 0;
	  }
	  F2 = 260;
	  YS2 = 260;
	  Scene = 1;
	  TIMER = 0;
	  delay(50);
	  DISPLAY_ON;
	 break;
	 case 1:
	 
		 if (SCY_REG == 0) Scene = 2; 
         SCY_REG--;
		 wait_vbl_done();
	 break;
	 case 2:
	   if (Y == 360) Y = 0;
	   if (F2 == 360) F2 = 0;
	   if (YS2 == 360) YS2 = 0;
	   if (UCount == 80) {
	     TIMER++;
	     UCount = 0; 
		 YS2++; 
		 Y++; 
		 if (TIMER > 89) Y1+=2;
	   }
	   SCY_REG = USIN[F2]-USIN[Y]+80-Y1;

	   if (TIMER == 162) {Scene = 3; TIMER = 0;}
	   UCount++;
	   F2++;	  
	 break;
	 case 3:
	  SCX_REG = 0; 
	  SCY_REG = 0;		  
	  F2 = 0;
	  YS2 = 0;
      Y = 0;
	  Y1 = 0;
	  if (TIMER == 120) {exitloop = 1; Scene = 0; Program = 45;}
	  wait_vbl_done();
	  TIMER++;
	 break;
	 }
}
	
const unsigned char uniMap[] =
{
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
  0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,0xFF,0xFF,
  0xFF,0xFF,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
  0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0xFF,0xFF,
  0xFF,0xFF,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
  0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,0xFF,0xFF,
  0xFF,0xFF,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
  0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0xFF,0xFF,
  0xFF,0xFF,0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,
  0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0xFF,0xFF,
  0xFF,0xFF,0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,
  0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,0xFF,0xFF,
  0xFF,0xFF,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,
  0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0xFF,0xFF,
  0xFF,0xFF,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,
  0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0xFF,0xFF,
  0xFF,0xFF,0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,
  0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,0xFF,0xFF,
  0xFF,0xFF,0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,
  0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,0xFF,0xFF,
  0xFF,0xFF,0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,
  0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,0xFF,0xFF,
  0xFF,0xFF,0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,
  0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,0xFF,0xFF,
  0xFF,0xFF,0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,
  0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,0xFF,0xFF,
  0xFF,0xFF,0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,
  0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,0xFF,0xFF,
  0xFF,0xFF,0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,
  0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,0xFF,0xFF,
  0xFF,0xFF,0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,
  0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
};

const unsigned char uniMap1[] =
{
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

const unsigned char uniTiles[] =
{
0xFD,0xFC,0xFC,0xFD,0xFD,0xFC,0xFC,0xFD,0xFD,0xFC,0xFD,0xFC,0xFD,0xFC,0xFD,0xFC,
0x5A,0xA0,0xB5,0x40,0x52,0xA8,0xAD,0x50,0x5D,0xA2,0xBF,0x40,0xDF,0x20,0xFF,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xEA,0x00,0xD5,0x00,0xEA,0x00,0xD5,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xEF,0x00,0x35,0x40,0xEF,0x00,0x75,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xEA,0x00,0x37,0xC0,0xDF,0x20,0xAF,0x50,
0xBF,0x00,0x5F,0x00,0xBF,0x00,0x5F,0x00,0xAE,0x00,0x55,0x00,0xEA,0x00,0xF7,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xEE,0x00,0xDD,0x00,0xAA,0x00,0x55,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xFE,0x00,0xFD,0x00,0xEE,0x00,0x55,0x00,0xAA,0x00,0x54,0x00,0xA8,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0x88,0x00,0x11,0x00,0x88,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x54,0x00,0xA8,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x08,0x00,0x55,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,0x2A,0x00,0x15,0x00,0xAA,0x00,0x55,0x00,
0x0F,0x0F,0x4F,0x0F,0xAF,0x0F,0x4F,0x0F,0xAF,0x0F,0x4F,0x0F,0xAF,0x0F,0x4F,0x0F,
0xFD,0xFC,0xFD,0xFC,0xFD,0xFC,0xFC,0xFD,0xFD,0xFC,0xFD,0xFC,0xFD,0xFC,0xFC,0xFD,
0xFF,0x00,0xFF,0x00,0xDF,0x20,0xBF,0x40,0x77,0x88,0xEE,0x11,0x77,0x88,0xFE,0x01,
0xEB,0x00,0xF6,0x01,0xF1,0x0E,0xE7,0x18,0x8F,0x70,0x8C,0x73,0x1E,0xA0,0xB8,0x45,
0x6F,0x80,0x9F,0x60,0x9F,0x60,0x06,0xD9,0x0D,0xE2,0x60,0xF7,0xF3,0xF8,0xFF,0xFC,
0xD7,0x28,0xE9,0x14,0x53,0xAC,0xAB,0x54,0x5C,0xA3,0xAF,0x50,0x57,0xA8,0xCB,0x34,
0xFE,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0x5F,0xA0,0x8F,0x70,
0xEA,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xAB,0x00,0xFF,0x00,0xF7,0x08,0xF7,0x08,0xF7,0x08,0xF7,0x08,0xF7,0x08,0xFB,0x04,
0xAA,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xAA,0x00,0x55,0x00,0xEA,0x00,0xF5,0x00,0xFF,0x00,0xFF,0x00,0xFE,0x00,0xFE,0x00,
0xA2,0x00,0x41,0x00,0x8A,0x00,0x45,0x00,0x8A,0x00,0x15,0x00,0x2A,0x00,0x55,0x00,
0x02,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x77,0x00,
0x08,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x77,0x00,
0xAF,0x0F,0x4F,0x0F,0xAF,0x0F,0x4F,0x0F,0xAF,0x0F,0x4F,0x0F,0xAF,0x0F,0x6F,0x0F,
0xFD,0xFC,0xFC,0xFD,0xFD,0xFC,0xFC,0xFD,0xFD,0xFC,0xFC,0xFD,0xFD,0xFC,0xFC,0xFD,
0x7D,0x82,0xAA,0x55,0x55,0xAA,0xAB,0x54,0x54,0xAA,0xAB,0x54,0x55,0xAA,0xAA,0x55,
0x92,0x6D,0xA0,0x5F,0x08,0xFF,0x05,0xFB,0x44,0xBB,0x04,0xFB,0x44,0xBB,0x80,0x7F,
0xFE,0xFF,0x57,0xFF,0x07,0xFF,0x47,0x9F,0x74,0x8B,0x02,0xDD,0x77,0x88,0xE0,0x1F,
0xD4,0x2B,0x2A,0xD5,0xD5,0xEA,0xCA,0xF5,0xE1,0xFE,0x70,0xFF,0xF1,0xFE,0x78,0xF7,
0xE7,0x18,0x61,0x9E,0x79,0x86,0x14,0xE3,0x1B,0xE0,0x0C,0xF1,0x47,0xB8,0x0F,0xF0,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xF9,0x06,0xFD,0x06,0xF9,0x06,0xF9,0x06,0xFF,0x02,0xFC,0x03,0xFC,0x03,0xFF,0x01,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0x3F,0x80,0x75,0x80,
0xFC,0x02,0xF9,0x04,0xF1,0x08,0xE6,0x19,0xDB,0x26,0xDC,0x27,0xD9,0x2E,0x2D,0x5E,
0xAB,0x00,0x77,0x00,0xBF,0x00,0x7F,0x00,0x3F,0x80,0xFF,0x00,0xFF,0x00,0x7F,0x00,
0xEE,0x00,0xFF,0x00,0xFE,0x00,0xFF,0x00,0xFB,0x00,0xFD,0x00,0xFA,0x00,0xFD,0x00,
0xAA,0x00,0x55,0x00,0xAE,0x00,0x5D,0x00,0xAB,0x00,0x57,0x00,0xAB,0x00,0x57,0x00,
0xAB,0x00,0x5D,0x00,0xBF,0x00,0xDD,0x00,0xEE,0x00,0xF7,0x00,0xAA,0x00,0x55,0x00,
0xBF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0x7D,0x00,0xAE,0x00,0x55,0x00,
0xEF,0x0F,0xEF,0x0F,0xEF,0x0F,0xEF,0x0F,0xEF,0x0F,0xCF,0x0F,0xEF,0x0F,0x4F,0x0F,
0xFD,0xFC,0xFC,0xFD,0xFD,0xFC,0xFC,0xFD,0xFD,0xFC,0xFC,0xFD,0xFD,0xFC,0xFC,0xFD,
0x54,0xAB,0xA9,0x56,0x50,0xAF,0xA8,0x55,0x50,0xAB,0xA6,0x59,0x44,0xBB,0xA8,0x57,
0x01,0xFE,0x02,0xFD,0x11,0xEE,0x08,0xF7,0x40,0xBF,0x81,0x7F,0x03,0xFF,0x17,0xFF,
0x61,0x9E,0x22,0xDD,0x1C,0xE3,0x01,0xFF,0x4A,0xBF,0x28,0xD7,0x14,0xEB,0x1A,0xE5,
0xF1,0xFE,0xF2,0xFD,0xE0,0xFF,0xC8,0xF7,0xE2,0xFF,0x5B,0xF7,0xEA,0xFF,0xC5,0xFF,
0x46,0xB8,0xC3,0x3C,0x44,0xBA,0x21,0xDE,0x94,0xEA,0x6B,0xF4,0x5C,0xBA,0x03,0x7C,
0x7E,0x80,0xFD,0x00,0x6A,0x80,0xD5,0x00,0xAB,0x00,0xF7,0x00,0xFF,0x00,0xFE,0x01,
0xBA,0x01,0x54,0x01,0xAA,0x01,0x54,0x01,0xEF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xEB,0x80,0x16,0xC1,0xA9,0xC2,0x3E,0xC1,0x18,0xE7,0xC8,0x77,0xA4,0x7B,0x81,0x7F,
0xCA,0x3C,0x17,0xF8,0x35,0xFA,0x6B,0xF4,0xF7,0xE8,0xEF,0xD0,0xDF,0xA0,0xCE,0xF1,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xEE,0x11,
0xFA,0x00,0xFD,0x00,0xFA,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xBF,0x40,
0xAB,0x00,0x57,0x00,0xAB,0x00,0xF7,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xAA,0x00,0xF7,0x00,0xFE,0x00,0xFF,0x00,0xFB,0x00,0xFD,0x00,0xFB,0x00,0xFD,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0xF5,0x00,
0xAF,0x0F,0x4F,0x0F,0xAF,0x0F,0x4F,0x0F,0xAF,0x0F,0x4F,0x0F,0xAF,0x0F,0x4F,0x0F,
0xFD,0xFC,0xFC,0xFD,0xFD,0xFC,0xFC,0xFD,0xFD,0xFC,0xFC,0xFD,0xFD,0xFC,0xFC,0xFD,
0x50,0xAF,0xA4,0x5F,0x52,0xAF,0xA3,0x59,0x5A,0xBF,0x94,0x7F,0x26,0xF8,0xED,0x70,
0x2E,0xFF,0x7D,0xC7,0xB0,0xFF,0x1C,0xFF,0xEB,0x37,0x40,0x3F,0xC4,0x3B,0xD8,0x77,
0x14,0xEB,0x22,0xDD,0xD1,0xEE,0x40,0xFF,0x09,0xFE,0x95,0x7F,0x02,0xBF,0x81,0x7F,
0xEC,0xFF,0x44,0xFF,0x08,0xFF,0xD1,0x3F,0x66,0xBB,0x4A,0xF7,0x25,0xFE,0x47,0xFC,
0x41,0xBE,0x50,0xFF,0xFF,0xFE,0xDE,0xFF,0x77,0x8E,0x65,0x1E,0xAE,0x1F,0x67,0x1F,
0xFE,0x01,0xEE,0x11,0x55,0xAA,0xAA,0x55,0x95,0xEA,0x68,0xD7,0x0A,0xFF,0x81,0x7F,
0xFD,0x02,0xBA,0x45,0x54,0xAB,0x29,0xD7,0x0F,0xFF,0x7C,0xFF,0xBA,0xFE,0xD3,0xFD,
0xC6,0x3B,0x83,0x7F,0x0F,0xFF,0xC2,0xFF,0xFB,0xFE,0x81,0x7E,0x5C,0xA2,0x03,0xFC,
0xD7,0xA8,0x2A,0xD5,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xD0,0x00,0xBA,0x00,0xD4,0x00,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x63,0x80,0x05,0x00,0x00,0x00,0x05,0x00,
0x5D,0xA2,0xAA,0x55,0x55,0xAA,0xBA,0x45,0x0B,0xE0,0x05,0x00,0x08,0x00,0x62,0x1C,
0xFF,0x00,0xBB,0x44,0x55,0xAA,0xAA,0x55,0x8D,0x02,0xC1,0x00,0xD6,0x28,0x00,0x00,
0xFF,0x00,0xBF,0x40,0x77,0x88,0xAA,0x55,0x5A,0xA1,0x55,0x00,0x2F,0x00,0x30,0x00,
0xFA,0x00,0xED,0x10,0x4A,0xBC,0xB3,0x7C,0x04,0xFB,0x9A,0x75,0xC1,0x3E,0x74,0x1F,
0xAF,0x0F,0x4F,0x0F,0xAF,0x0F,0x6F,0x0F,0xEF,0x0F,0x6F,0x0F,0x4F,0xAF,0x2F,0xCF,
0xFD,0xFC,0xFC,0xFD,0xFD,0xFC,0xFC,0xFD,0xFD,0xFC,0xFC,0xFD,0xFC,0xFD,0xFC,0xFD,
0x7A,0xE0,0xE4,0x79,0x67,0xF8,0x92,0x6D,0x5B,0xBE,0x1D,0xE7,0x34,0xEB,0x13,0xFC,
0x02,0xFF,0x56,0xFF,0x82,0xFC,0x51,0xFC,0x66,0xF8,0x1D,0xF0,0x66,0xF8,0x7D,0xF0,
0xC8,0x3F,0xE7,0x1F,0xAC,0x03,0x56,0x01,0x0B,0x00,0x56,0x01,0x2F,0x00,0x56,0x01,
0xAF,0xFC,0x3F,0xFC,0xB2,0xFC,0x83,0x7C,0xF5,0x0A,0xD2,0x0D,0x60,0x8F,0x32,0xC5,
0xB0,0x0F,0x56,0x01,0xAB,0x00,0x55,0x00,0x83,0x00,0xD7,0x00,0x2B,0x80,0x3E,0xC1,
0x0C,0xF3,0x06,0xF9,0x18,0xE3,0x08,0xF7,0x02,0xFF,0x77,0xFF,0xFC,0xFF,0x4A,0xF5,
0xE3,0xFF,0x7C,0xFF,0x22,0xFF,0x55,0xFF,0xF8,0xFF,0xD9,0xFF,0x4B,0xFF,0x3C,0xD7,
0x88,0xF2,0x91,0x7E,0xA4,0xFB,0xFA,0xF5,0xD5,0xEA,0xAB,0xD4,0x55,0xAA,0xAA,0x55,
0xE8,0x00,0x40,0x00,0xE8,0x00,0x50,0x00,0xA8,0x00,0xD4,0x00,0x6A,0x80,0xEC,0x10,
0x0A,0x00,0x01,0x00,0x0A,0x00,0x06,0x01,0x26,0x08,0x55,0x00,0x2B,0x00,0x55,0x00,
0x85,0x7A,0x58,0x07,0xCD,0x3A,0x02,0xFC,0xAA,0x00,0x7D,0x00,0xAF,0x00,0x55,0x00,
0x80,0x00,0x31,0xC0,0xAA,0x00,0x14,0x00,0xA0,0x00,0x51,0x00,0xA0,0x00,0x54,0x00,
0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x80,0x00,0x80,0x40,
0x2C,0x1F,0x23,0x1C,0x38,0x00,0x70,0x01,0x85,0x02,0x10,0x0F,0x05,0x3A,0x01,0x76,
0x8F,0xEF,0xAF,0x4F,0x0F,0x2F,0x6F,0x0F,0xCF,0x2F,0x2F,0x4F,0xCF,0x2F,0xAF,0x4F,
0xFC,0xFD,0xFC,0xFD,0xFC,0xFD,0xFC,0xFD,0xFC,0xFD,0xFD,0xFD,0xFC,0xFD,0xFD,0xFD,
0x49,0xBE,0x60,0x9F,0x44,0xBB,0x89,0x77,0x33,0xEF,0xFF,0xFF,0x0E,0xFF,0xFD,0xFF,
0xB0,0x78,0xCD,0x70,0xE2,0xF8,0xC5,0xF8,0xA6,0xF8,0x31,0xFC,0x13,0xFC,0x14,0xFF,
0xBC,0x03,0x3A,0x45,0xD0,0x2F,0xA1,0x5F,0x03,0xFF,0x95,0x7F,0x2F,0xFF,0x17,0xFF,
0x1C,0xE3,0x44,0xF3,0x8C,0xF3,0xC8,0xF7,0xED,0xF2,0xE8,0xF7,0xE2,0xFF,0xCC,0xFF,
0x80,0xFF,0x55,0xFF,0xEF,0xFF,0xFF,0xFF,0x7E,0xFF,0xFF,0x7E,0xCF,0xBE,0x67,0xFE,
0xD5,0xEA,0xEA,0xD5,0x9D,0xE2,0x2E,0xD1,0xF7,0x08,0xFE,0x01,0xFC,0x03,0xF8,0x07,
0x57,0xAE,0x85,0x7E,0x08,0xFF,0x1B,0xFD,0xB7,0xF8,0x6F,0xF0,0x75,0xEA,0x4A,0xF5,
0xEA,0x00,0xF5,0x00,0xFC,0x03,0x6E,0x91,0xF3,0x88,0xBD,0x40,0x96,0x68,0x89,0x74,
0xAE,0x00,0x55,0x00,0x0A,0xE0,0x75,0xF8,0xAA,0x7C,0x63,0x1C,0xAE,0x18,0x2D,0x50,
0xAA,0x00,0x54,0x00,0xA8,0x00,0x44,0x00,0xA0,0x00,0x50,0x00,0xA0,0x00,0x40,0x00,
0xAA,0x00,0x11,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,
0xA8,0x00,0x51,0x00,0xA0,0x00,0x50,0x00,0x28,0x03,0x5B,0x04,0xA2,0x09,0x56,0x03,
0xC0,0x20,0x46,0x31,0x83,0x3E,0xC2,0x3D,0x82,0xEF,0xAD,0x56,0x69,0x9E,0xF5,0x1F,
0x0A,0xE0,0x45,0xB0,0x8F,0x60,0x34,0xCB,0x02,0xFD,0x25,0x48,0x67,0xC8,0x61,0x90,
0x8F,0x6F,0x0F,0xEF,0x0F,0xEF,0x0F,0xEF,0x0F,0xEF,0x0F,0xEF,0x4F,0xAF,0xAF,0x4F,
0xFD,0xFD,0xFD,0xFD,0xFC,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFC,0xFD,0xFD,0xFD,
0xBF,0xFF,0xF9,0x7F,0x98,0xFF,0x5D,0xFF,0xFF,0xFF,0xDF,0xFF,0x8F,0xFF,0x1F,0xFF,
0xEA,0xFF,0xF5,0xFF,0xFE,0xFF,0xF7,0xFF,0xF3,0xFF,0xF3,0xFF,0xF3,0xFF,0xF1,0xFF,
0x0F,0xFF,0x15,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0xFF,0xBB,0xFF,0xD7,0xFD,
0xC8,0xFF,0xF0,0xFF,0xA0,0xFF,0xD1,0xFF,0xE3,0xFF,0xD5,0xFF,0xEB,0xFF,0xFF,0xFF,
0x9B,0x7E,0x99,0x7E,0x4D,0xBE,0x1D,0xFE,0xBB,0xFC,0x7B,0xFC,0xFB,0xFC,0xFB,0xFC,
0xF4,0x0B,0xF9,0x07,0xF7,0x0B,0xF5,0x03,0xF0,0x0F,0xF3,0x0C,0xFE,0x00,0xFD,0x00,
0x95,0xEA,0xAA,0xD5,0x55,0xAA,0xAF,0x50,0xEA,0x00,0xD5,0x00,0xAB,0x00,0x45,0x1E,
0x7D,0x82,0xF6,0x01,0xAB,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0x1B,0xA0,0x16,0x41,
0xAA,0x00,0xD6,0x01,0x13,0xEE,0x5D,0xFE,0x38,0xFE,0xDB,0x7C,0x00,0xFE,0x03,0xFC,
0xA0,0x00,0xD0,0x00,0x22,0x80,0xD5,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0x02,0x00,0x45,0x00,0x2A,0x00,0x55,0x00,0xAB,0x00,0x57,0x01,0xAA,0x07,0x42,0x1D,
0xA9,0x0E,0x49,0x16,0x8F,0x32,0x31,0x4F,0x04,0xEB,0x0B,0xF7,0x14,0xEE,0xE0,0x9F,
0xEE,0x3F,0x4D,0x30,0x86,0x38,0x7B,0x14,0x3C,0xE2,0x95,0x60,0xAE,0xC0,0x3B,0xC4,
0x42,0x80,0x05,0x00,0xAA,0x00,0x16,0x01,0xAB,0x00,0x56,0x01,0xAD,0x02,0x5A,0x05,
0x4F,0xAF,0xAF,0x4F,0x4F,0xAF,0x8F,0x6F,0x0F,0xEF,0x0F,0xEF,0x0F,0xEF,0x0F,0xEF,
0xFC,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,
0xFF,0xFF,0xFF,0xFF,0xCE,0xBF,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFD,0xFF,
0xF5,0xFB,0xF9,0xF7,0xF4,0xFB,0xFA,0xF5,0xF5,0xFA,0xF2,0xFD,0xE8,0xFF,0xDF,0xFF,
0xBC,0xFB,0x27,0xDF,0xAF,0xFF,0xFF,0xFF,0x1A,0xFF,0x97,0x7F,0x3F,0xFF,0xF4,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x82,0xFF,0x80,0x7F,
0xFB,0xFC,0xFB,0xFC,0xFE,0xFF,0xF5,0xFF,0xFE,0xFF,0xC5,0xFF,0x02,0xFF,0x07,0xFF,
0xFC,0x03,0x9E,0x7D,0x49,0xBE,0x14,0xFF,0x5F,0xA0,0x2B,0xD4,0x1A,0xE0,0x3E,0xC1,
0xCB,0xE0,0x0F,0xF0,0xE3,0xF8,0xD7,0x00,0xFB,0x00,0x55,0x00,0xFB,0x00,0xB7,0x40,
0xA8,0x03,0xD4,0x03,0xAC,0x03,0xD6,0x01,0xAF,0x00,0xD5,0x00,0xAA,0x00,0xD5,0x00,
0x10,0xEE,0x09,0xF6,0x5D,0xA2,0xF4,0x03,0xA8,0x03,0x56,0x01,0xAB,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0xD5,0x03,0x66,0x8C,0x25,0xDB,0x33,0xFF,0xCD,0x7F,
0x82,0x3F,0x45,0x7E,0x98,0xBF,0x61,0x7F,0x8A,0xFF,0x16,0xFF,0x6E,0xFF,0xDD,0xFE,
0x7C,0xB3,0x40,0xF7,0xB4,0xCB,0xA5,0xD3,0x21,0xCE,0x6D,0x90,0x1A,0xA0,0x37,0x40,
0x4E,0xA0,0x5F,0xC0,0xF8,0x82,0xD3,0x04,0xAE,0x00,0xE9,0x14,0x46,0xB8,0x85,0x78,
0xB5,0x0A,0x6A,0x15,0xD0,0x2F,0x60,0x1F,0xC4,0x3B,0x0A,0x75,0xC5,0x3A,0x80,0x7F,
0x0F,0xEF,0x0F,0xEF,0x0F,0xEF,0x0F,0xEF,0x4F,0xAF,0xAF,0x4F,0x4F,0xAF,0x8F,0x6F,
0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,
0xFB,0xFF,0xFD,0xFF,0xFF,0xFF,0xFF,0xFF,0xEF,0xFF,0xFF,0xFF,0xFE,0xFF,0xFE,0xFF,
0xE9,0xFE,0xF2,0xFD,0xF5,0xFA,0xEA,0xF5,0xA5,0xFA,0x3E,0xDD,0x57,0xAF,0xAB,0x57,
0x78,0xBF,0xB0,0x7F,0x6C,0xFB,0x70,0xFF,0x0A,0xFF,0x45,0xFF,0x10,0xEF,0xA1,0xDF,
0x40,0xBF,0x00,0xFF,0x05,0xFA,0x00,0xFF,0xA0,0xFF,0x75,0xFF,0x3F,0xFF,0x7F,0xFF,
0x46,0xBF,0xA7,0x5F,0x0E,0xFF,0x16,0xFF,0x0E,0xFF,0x5E,0xFF,0xFE,0xFF,0xFC,0xFF,
0x17,0xE8,0x4E,0xF1,0x27,0xF8,0x12,0xFD,0x0B,0xFC,0x03,0xFC,0x07,0xF8,0x0F,0xF0,
0x6F,0x80,0xD7,0x00,0xEF,0x00,0xD7,0x00,0xAB,0x00,0xD7,0x00,0xAB,0x00,0xD7,0x00,
0xAA,0x00,0xD5,0x00,0xAA,0x00,0xD5,0x00,0xAA,0x00,0xD4,0x01,0xAE,0x03,0xDD,0x0C,
0xAA,0x01,0x56,0x03,0xAE,0x04,0x57,0x19,0x2C,0xE6,0xDD,0xF9,0x8F,0xF2,0x75,0xFC,
0xBF,0xBF,0x67,0x7F,0xED,0xCE,0x57,0xB0,0xEB,0x40,0xD6,0x81,0xEB,0x00,0xD6,0x01,
0xFB,0xFC,0xF6,0xF9,0x1D,0xE2,0xBB,0x44,0x26,0x98,0xCF,0x30,0x9E,0x60,0xBD,0x40,
0x69,0x82,0xD7,0x00,0xAF,0x00,0x5E,0x01,0xB8,0x03,0x74,0x03,0xAC,0x03,0x50,0x07,
0x07,0xF8,0x0D,0xF0,0x07,0xF8,0x0E,0xF1,0x1C,0xE3,0x3E,0xC1,0x55,0xAA,0xB8,0x47,
0x00,0xFF,0x80,0x7F,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x02,0xFD,0x11,0xEE,0xAA,0x55,
0x4F,0xAF,0x0F,0xEF,0x0F,0xEF,0x0F,0xEF,0x0F,0xEF,0x2F,0xCF,0x4F,0xAF,0xAF,0x4F,
0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFC,0xFD,
0xFA,0xFF,0xF4,0xFF,0xE0,0xFF,0xD8,0xFF,0xA1,0xFE,0xC0,0xFF,0x80,0xFF,0x00,0xFF,
0x54,0xAB,0xA9,0x57,0x52,0xAF,0xA6,0x5F,0x56,0xAF,0x25,0xDF,0x1D,0xEE,0x2E,0xDD,
0xE0,0xFF,0x3D,0xDF,0x23,0xFF,0x95,0x7F,0x0B,0xFF,0x95,0xFF,0xAB,0xFF,0x7F,0xFF,
0xEF,0xFF,0xF5,0xFF,0xFB,0xFF,0xFC,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,0xC4,0xFF,
0xF8,0xFF,0xD0,0xFF,0xA1,0xFE,0x10,0xFF,0xE5,0xFA,0x04,0xFF,0x38,0xFF,0x75,0xFE,
0x47,0xB8,0xEA,0x15,0x8D,0x32,0x87,0x70,0x13,0xEF,0x12,0xFD,0xED,0xFE,0x9F,0x7F,
0xAA,0x00,0xD4,0x01,0xAA,0x07,0x5C,0x39,0x3C,0x8E,0xD5,0xE3,0x9A,0x3C,0x15,0xC0,
0xE9,0x33,0xD5,0xCC,0xB9,0x33,0x57,0xCC,0xAA,0x70,0xD5,0x80,0xAA,0x00,0x55,0x00,
0xEB,0x70,0x35,0xC0,0x2A,0x80,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xA9,0x02,0xD7,0x00,0xAD,0x02,0xDE,0x01,0xB5,0x0A,0xFB,0x04,0xFC,0x02,0xFB,0x04,
0x4A,0xA0,0x9D,0x40,0x3A,0x80,0xF5,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0xD5,0x00,
0xAC,0x03,0xD8,0x07,0xAD,0x02,0x7A,0x05,0xBD,0x02,0x2A,0x55,0xB5,0x4A,0xA2,0x5D,
0x51,0xAE,0xAA,0x55,0x55,0xAA,0xEA,0x15,0x55,0xAA,0xAA,0x55,0x05,0xFA,0x22,0xDD,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0x2A,0xD5,
0x4F,0xAF,0xAF,0x4F,0x4F,0xAF,0xAF,0x4F,0x4F,0xAF,0xAF,0x4F,0x4F,0xAF,0xAF,0x4F,
0xFC,0xFD,0xFC,0xFD,0xFC,0xFD,0xFC,0xFD,0xFC,0xFD,0xFC,0xFD,0xFC,0xFD,0xFC,0xFD,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0x08,0xFF,0x08,0xFF,0x08,0xFF,0x10,0xFF,0x18,0xFF,0x11,0xFF,0x13,0xFF,0x05,0xFF,
0x3F,0xFF,0x7F,0xFF,0xEE,0xFF,0x7E,0xFF,0xFA,0xFF,0xFC,0xFF,0xB8,0xFF,0x71,0xFF,
0xB1,0xFE,0x0A,0xF5,0x05,0xFA,0x23,0xDC,0x44,0xBB,0x05,0xFF,0x20,0xFF,0xC0,0xFF,
0xAE,0x01,0xE5,0x18,0x5B,0xA0,0xD6,0x01,0x00,0xFF,0x00,0xFF,0x50,0xAF,0xF8,0x07,
0x9D,0xE2,0x14,0xC3,0x2D,0xC2,0x38,0xC7,0x3C,0xC3,0x08,0xF7,0x70,0x8F,0x20,0xDF,
0xAA,0x00,0x55,0x00,0xAA,0x00,0xD5,0x00,0xEA,0x00,0xF5,0x00,0x5A,0xA0,0x23,0xDC,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAB,0x00,0xEF,0x10,
0xAB,0x00,0x56,0x01,0xAD,0x02,0x5E,0x01,0xBD,0x02,0x7E,0x01,0xBD,0x02,0x7B,0x04,
0x56,0xA8,0xAD,0x50,0x76,0x88,0x9D,0x40,0x3B,0x80,0xFF,0x00,0xFB,0x00,0xEF,0x10,
0xAB,0x00,0xD4,0x01,0xAA,0x01,0x52,0x05,0xA8,0x07,0x58,0x07,0xB0,0x0F,0x7C,0x07,
0x74,0x8B,0x28,0xD7,0x40,0xBF,0x20,0xDF,0x40,0xBF,0xA0,0x5F,0x44,0xBB,0xC8,0x37,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x55,0xAA,0x0A,0xF5,0x05,0xFA,0x08,0xF7,0x15,0xEA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x4F,0xAF,0xAF,0x4F,0x4F,0xAF,0xAF,0x4F,0x4F,0xAF,0xAF,0x4F,0x4F,0xAF,0xAF,0x4F,
0xFC,0xFD,0xFC,0xFD,0xFC,0xFD,0xFC,0xFD,0xFC,0xFD,0xFC,0xFD,0xFC,0xFD,0xFC,0xFD,
0x00,0xFF,0x00,0xFF,0x04,0xFB,0x00,0xFF,0x40,0xBF,0x21,0xDF,0x45,0xBB,0xA1,0x5F,
0x3F,0xFF,0x7F,0xFF,0xFF,0xFF,0xCF,0xFF,0xFE,0xFF,0xF5,0xFF,0xFA,0xFF,0xD0,0xFF,
0xE2,0xFF,0xD5,0xFF,0xAA,0xFF,0x54,0xFF,0xA9,0xFE,0x50,0xFF,0x05,0xFA,0x0B,0xF4,
0x85,0xFA,0x0F,0xF0,0x1F,0xE0,0xBF,0x40,0xEA,0x00,0xD5,0x00,0xEA,0x00,0xD5,0x00,
0xEC,0x03,0xFA,0x05,0xEC,0x03,0x78,0x07,0xBC,0x03,0x58,0x07,0xBD,0x02,0x5A,0x05,
0x00,0xFF,0xA0,0x5F,0x7C,0x83,0xFE,0x01,0x7D,0x82,0xFA,0x05,0xFD,0x02,0xFC,0x03,
0x17,0xE8,0x3A,0xC5,0x17,0xE8,0x3A,0xC5,0x5F,0xA0,0xAF,0x50,0x5B,0xA0,0xAD,0x50,
0xFB,0x00,0xBB,0x44,0xFE,0x00,0xFA,0x05,0xDF,0x20,0xFF,0x00,0xFA,0x00,0xF5,0x00,
0x77,0x88,0x7D,0x00,0xFB,0x00,0xD5,0x00,0xAF,0x00,0x57,0x00,0xAF,0x00,0x7E,0x01,
0xDE,0x20,0xED,0x10,0xDA,0x20,0xB7,0x40,0xFB,0x00,0x95,0x40,0x6B,0x80,0xD7,0x00,
0xF0,0x0F,0x6C,0x17,0xF0,0x0F,0xE0,0x1F,0xF4,0x0B,0xE2,0x1D,0xE0,0x1F,0xE2,0x1D,
0x45,0xBA,0x8A,0x75,0x55,0xAA,0x2A,0xD5,0x15,0xEA,0xA2,0x5D,0x00,0xFF,0x80,0x7F,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0x20,0xDF,0x00,0xFF,0x00,0xFF,
0x55,0xAA,0xBB,0x44,0xFF,0x00,0xAA,0x55,0x55,0xAA,0x0A,0xF5,0x00,0xFF,0x00,0xFF,
0x4F,0xAF,0xAF,0x4F,0xEF,0x0F,0xAF,0x4F,0x4F,0xAF,0xAF,0x4F,0x4F,0xAF,0x0F,0xEF,
0xFD,0xFC,0xFC,0xFD,0xFD,0xFC,0xFC,0xFD,0xFD,0xFC,0xFD,0xFC,0xFD,0xFC,0xFC,0xFD,
0x54,0xAB,0xB9,0x47,0x03,0xFF,0xAE,0x57,0x5E,0xA7,0xEC,0x17,0x58,0xAF,0xB8,0x5F,
0x80,0xFF,0x00,0xFF,0x00,0xFF,0x0A,0xF5,0x15,0xEA,0x2B,0xD4,0x57,0xA8,0xBF,0x40,
0x16,0xE8,0x2F,0xD0,0x5E,0xA0,0xB7,0x40,0x7A,0x80,0xD5,0x00,0xFA,0x00,0xD5,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAB,0x00,0x57,0x00,
0xBD,0x02,0x5A,0x05,0xBC,0x03,0x7E,0x01,0xFF,0x00,0xFE,0x01,0xFF,0x00,0xDE,0x01,
0xFC,0x03,0xFE,0x01,0xFD,0x02,0xFE,0x01,0x7D,0x82,0xFE,0x01,0xFF,0x00,0xFF,0x00,
0x5E,0xA0,0xED,0x10,0xF7,0x08,0xEF,0x10,0xF7,0x08,0xFF,0x00,0xFF,0x00,0xEF,0x10,
0xAA,0x00,0x55,0x00,0xAA,0x00,0xD5,0x00,0xEE,0x00,0xFF,0x00,0xFF,0x00,0x7F,0x00,
0xBD,0x02,0x7B,0x04,0xFE,0x00,0x7F,0x00,0xFA,0x00,0xFD,0x00,0xFB,0x00,0xFD,0x00,
0xAF,0x00,0x5E,0x01,0xAD,0x02,0x5E,0x01,0xBC,0x03,0x7A,0x05,0xF4,0x0B,0xF8,0x07,
0xE8,0x1F,0xF0,0x1F,0xC9,0x3E,0xF0,0x1F,0x41,0xBE,0x88,0x77,0x79,0xA6,0x8C,0x77,
0x40,0xBF,0xE2,0x1D,0x74,0x8B,0xFA,0x05,0x7F,0x80,0xFF,0x00,0xFE,0x00,0xFB,0x04,
0x04,0xFB,0x2A,0xD5,0x14,0xEB,0x20,0xDF,0x00,0xFF,0x80,0x7F,0xC0,0x3F,0xE0,0x1F,
0x04,0xFB,0xA8,0x57,0x54,0xAB,0x08,0xF7,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0x0F,0xEF,0x8F,0x6F,0x4F,0xAF,0x8F,0x6F,0x0F,0xEF,0x0F,0xEF,0x0F,0xEF,0x0F,0xEF,
0xFD,0xFC,0xFD,0xFC,0xFC,0xFD,0xFD,0xFD,0xFC,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,
0x11,0xFE,0xF0,0x7F,0xED,0xFA,0x72,0xFD,0xE5,0xFA,0x72,0xFD,0xE5,0xFA,0xEA,0xF5,
0x7F,0x80,0xBF,0x40,0x7E,0x80,0xBD,0x40,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xAA,0x00,0xD5,0x00,0xAA,0x00,0xD5,0x00,0xAA,0x00,0x57,0x00,0xAE,0x00,0x57,0x00,
0xBB,0x00,0x77,0x00,0xBF,0x00,0x7F,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFE,0x01,
0xFF,0x00,0xDF,0x00,0x7F,0x80,0xF7,0x00,0x7B,0x80,0xFF,0x00,0x7F,0x80,0xF7,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFD,0x00,
0xF6,0x08,0xEF,0x10,0xF6,0x08,0xE7,0x18,0xF7,0x08,0xE7,0x18,0xF7,0x08,0xEF,0x10,
0xFF,0x00,0x7F,0x00,0xFF,0x00,0x7F,0x00,0xFF,0x00,0xEF,0x10,0xDF,0x20,0xFF,0x00,
0xFB,0x00,0xDF,0x00,0xBF,0x00,0xDF,0x00,0xFF,0x00,0x7F,0x00,0xFF,0x00,0x7F,0x00,
0xF2,0x0F,0xF9,0x07,0xF2,0x0F,0xE0,0x1F,0xD2,0x2F,0xE4,0x1F,0xD2,0x2F,0xA4,0x5F,
0x19,0xE6,0xDC,0x67,0x11,0xEE,0x26,0xDD,0x48,0xBF,0x00,0xFF,0x43,0xBE,0x02,0xFD,
0xFF,0x00,0xAA,0x55,0x28,0xFF,0x0A,0xF5,0x7F,0x80,0x3F,0xC0,0x57,0xA8,0x00,0xFF,
0xF0,0x0F,0x78,0x07,0xFC,0x03,0x5E,0x81,0x2F,0xC0,0x9E,0x61,0x5F,0xA0,0xAF,0x50,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x80,0x7F,0x00,0xFF,0x80,0x7F,
0x0F,0xEF,0x0F,0xEF,0x0F,0xEF,0x0F,0xEF,0x0F,0xEF,0x0F,0xEF,0x0F,0xEF,0x0F,0xEF,
0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFC,0xFD,
0xC5,0xFA,0xCA,0xF5,0xB5,0xEA,0xC2,0xFD,0x85,0xFA,0x8A,0xF5,0x84,0xFA,0x0A,0xF5,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0x7F,0x80,0xFF,0x00,0xAB,0x00,0xBF,0x40,
0xEF,0x00,0x77,0x00,0xFF,0x00,0x7F,0x00,0xFF,0x00,0xFF,0x00,0xDF,0x00,0xFF,0x00,
0xFF,0x00,0xFA,0x05,0xF5,0x0A,0xFA,0x05,0xDD,0x22,0xEA,0x15,0xD5,0x2A,0xEA,0x15,
0x6A,0x80,0xF5,0x00,0xEA,0x00,0xD7,0x00,0xBB,0x00,0xDF,0x00,0xBF,0x00,0xFF,0x00,
0xFE,0x00,0xFD,0x00,0xFA,0x00,0xFD,0x00,0xFA,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xF7,0x08,0xEF,0x10,0xFF,0x00,0xFE,0x01,0xFD,0x02,0x7B,0x04,0xFD,0x02,0xEB,0x14,
0xFF,0x00,0xBB,0x44,0x3D,0x82,0xD6,0x01,0xEF,0x00,0x57,0x00,0xAB,0x00,0x57,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFE,0x01,0x77,0x88,0xAE,0x51,0xD4,0x2B,0xAA,0x55,
0xC8,0x3F,0x84,0x7F,0x48,0xBF,0x90,0x7F,0x20,0xFF,0x10,0xFF,0x22,0xFF,0x40,0xFF,
0x28,0xFF,0xD4,0x7F,0x58,0xBF,0x20,0xFF,0x81,0xFE,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0x80,0xFF,0x2A,0xD5,0x77,0x88,0xBE,0x41,0x55,0xAA,0xA2,0x5D,0x00,0xFF,0x04,0xFF,
0x17,0xE8,0xAF,0x50,0x57,0xA8,0x8F,0x70,0x05,0xFA,0x82,0x7D,0x05,0xFA,0x02,0xFD,
0xC0,0x3F,0xC0,0x3F,0xC0,0x3F,0xE0,0x1F,0xF0,0x0F,0xE0,0x1F,0x70,0x8F,0xB0,0x4F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};