#include "core/core.h"
#include "window_manager/wmanager.h"

typedef struct 
{
    unsigned char bits[ 16 ];
    unsigned char hval[ 256 ];
    unsigned char size[ 256 ];
    unsigned short code[ 256 ];
} jpeg_huffman_table_t;

typedef struct 
{
    unsigned char *ptr;
    V3_FILE file;
    int width;
    int height;
    unsigned char *data;
    int data_precision;
    int num_components;
    int restart_interval;
    struct 
    {
        int     id;
        int     h;
        int     v;
        int     t;
        int     td;
        int     ta;
    } component_info[ 3 ];
    jpeg_huffman_table_t hac[ 4 ];
    jpeg_huffman_table_t hdc[ 4 ];
    int qtable[ 4 ][ 64 ];
    struct 
    {
        int     ss,se;
        int     ah,al;
    } scan;
    int dc[ 3 ];
    int curbit;
    unsigned char curbyte;
} jpeg_file_desc;

int jpeg_readmarkers();
void jpeg_ycbcr2rgb();
void jpeg_decompress();

int jpeg_read_byte();
int jpeg_read_word();
int jpeg_read_bit();
int jpeg_read_bits( int );
int jpeg_bit2int( int bit, int i );
int jpeg_huffmancode( jpeg_huffman_table_t *table );

extern long jpg_xsize;
extern long jpg_ysize;

unsigned char* load_jpeg_rgb24( const UTF8_CHAR *name );
COLORPTR load_jpeg( const UTF8_CHAR *name );
