;                                            _____
;                                           / ___ \
; nikhotmsk sessions logo v0.2 by nikhotmsk  /_o_\
;
; use this command to compile this thing:
; wine ../../sjasmplus-1.18.3.win/sjasmplus.exe nikhotmsk_sessions.asm --lst=nikhotmsk_sessions.lst --sym=nikhotmsk_sessions.sym && ../bas2tap/bas2tap -a10 loader.bas && cat loader.tap nikhotmsk_sessions_code.tap > nikhotmsk_sessions.tap
;
; run in emulator:
; wine ../../../unreal_speccy/us0.38.1/unreal.exe nikhotmsk_sessions.tap
;

;
; message for humans. If you want to learn Z80 assembly language, try
; this tutorial: https://www.chibiakumas.com/z80
;

	DEVICE ZXSPECTRUM128
	org $a000
	;
	; This is a fischinger engine, it is used to draw multiple objects
	; at many places using precompiled drawing code. Ask nikhotmsk if you
	; want to understand how it works.
	;
code_start:
	di
	ld (saved_iy), iy ; save IY register, because it is needed for rst #10
	
	; find the page that was active at boot and place it to player_page
	ld a, (stored_paging_byte_address) ; which is $5b5c (23388)
	and 0b00000111
	ld (player_page), a
	
code_again:
	di
	ld hl, machine_stack_end
	ld sp, hl
	
	; TODO make sure keyboard keys are released
	
	
	ld hl, 0
	ld (frame_counter), hl
	ld hl, draw_text_empty_byte
	ld (draw_text_pointer), hl
	ld hl, draw_polyline_empty
	ld (polyline_pointer), hl
	ld hl, $4000
	ld (draw_text_screen_address), hl
	; turbo sound setting should survive
	; TODO cancel pause
	
	ld a, 0
	out (#FE),A      ; border black
	ld HL, #5800
	ld BC, 768       ; set background to black
	ld D, 0b01000111 ; set ink to white
	call fill_mem
	
	ld hl, vars
	ld bc, erase_queue_end - vars
	ld d, 0
	call fill_mem ; clear variables and shedule
	
	;ld ix, vars     ; put four dots
	;ld de, 0x0202	;
	;ld (ix+0), de	;    A-------B
	;ld de, 0x0214	;    |       |
	;ld (ix+2), de	;    |       |
	;ld de, 0x1414	;    |       |
	;ld (ix+4), de	;    D-------C
	;ld de, 0x1402	;
	;ld (ix+6), de
	
	ld a,2
	call $1601 ; select S channel for text
	
	di
	ld hl, im2_interrupt_block ; prepare interrupt mode 2
	ld a, h
	ld i, a
	;ld bc, 257 ; size of interrupt block
interrupt_setup_loop:
	;ld (hl), $80
	;inc hl
	;dec bc
	;ld a, b
	;or c
	;jr nz, interrupt_setup_loop
	im 2
	
stored_paging_byte_address: EQU $5b5c
	
	; initSong
	ld a, (flip_mask)
	ld l, a
	ld a, (player_page)
	or l
	or 16 ; always select basic48 ROM
	ld bc, #7ffd
	ld (stored_paging_byte_address), a
	; always store this byte, so interrupt can restore it back
	; interrupts are not enabled yet, but still lets save it
	out (c),a
	
	ld a, (no_music)
	or a
	call z, initSong
	
	
	jp code_main
saved_iy:	WORD 0
	
	; ORG ahead, do not put extra code here, because not much space

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt routine
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	org #a0a0 ; interrupt routine here
	push af
	;ld a, 0b00000111 ; debug border white
	;out (#fe), a
	push bc
	push de
	push hl
	push ix
	push iy
	
	; frame counter here
	ld hl, (frame_counter)
	inc hl ; normal flow
	ld (frame_counter), hl ; TODO pause
	
	jp interrupt_routine_continue

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt table
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	ALIGN 2 ; hardcoded interrupt table here
im2_interrupt_block:
	.257 BYTE #a0 ; this is an interrupt table (size 257 bytes)
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt_routine_continue
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
no_music: BYTE 0
flip_mask: BYTE 0
flip_override: BYTE 0
flip_override_storage: BYTE 0
paging_available: BYTE 0
player_page: BYTE 0
interrupt_choosen_file: WORD 0
interrupt_chosen_erase_queue: WORD 0
interrupt_chosen_queue: WORD 0
draw_polyline_empty: BYTE 0,0,0,0
interrupt_routine_continue:
	; do flip
	ld a, (flip_override)
	or a
	jp z, interrupt_no_override
	ld a, (flip_mask)
	and 0b11110111 ; if flip override, then always display screen 0
	ld (flip_override_storage), a ; save flip_mask for later recovery
interrupt_no_override:
	
	ld hl, (frame_counter)
	ld a, l
	and 0b00000010
	jr z, interrupt_frame_is_0
	; set active file to IY
	ld iy, asm_file_for_screen_1
	ld a, 0
	ld (flip_mask), a ; and show screen 0
	jr interrupt_frame_is_not_0_skip
interrupt_frame_is_0:
	; set active file IY
	ld iy, asm_file_for_screen_0 ; writing to screen 0, displayng 1
	ld a, 8
	ld (flip_mask), a ; frame 1 is displayed
interrupt_frame_is_not_0_skip:
	ld a, (flip_override)
	or a
	jp z, interrupt_no_override_2
	ld a, (flip_override_storage) ; recover
	ld (flip_mask), a
interrupt_no_override_2:
	ld a, (flip_mask)
	ld l, a
	ld a, (iy+7) ; [memory page]
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	; do not save a byte, because it is for interrupt only
	out  (c),a	; flip shadow screen
	ld (interrupt_choosen_file), iy

	ld a, (no_music)
	or a
	jr nz, interrupt_routine_no_music
	; page in a player
	ld a, (flip_mask)
	ld l, a
	ld a, (player_page)
	and 0b00000111
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	out  (c),a ; page into player page (probably it is a page 0)
	call player+5 ; run music ; TODO implement pause
	
interrupt_routine_no_music:
	
	call interrupt_page_set_7
	call fischinger_draw_polyline
	
	; read keyboard
	ld bc, #7ffe ; keys b,n,m,sym,space
	in a, (c)
	and 0b00000001
	jr nz, interrupt_routine_no_break_key
interrupt_routine_goto_code_again:
	; reset program back to the beginning
	ld de, code_again
	push de
	; ei
	reti ; start the program from the beginning
interrupt_routine_no_break_key:
	ld bc, #fdfe ; keys g,f,d,s,a
	in a, (c)
	ld b, a
	and 0b00000010 ; the 's' key
	jr nz, interrupt_routine_no_s_key
	ld a, (turbosound_setting_byte)
	and 0b11101111 ; disable turbosound, thus making normal AY
	ld (turbosound_setting_byte), a
	ld a, 0
	ld (turbosound_flip_modules), a
	jr interrupt_routine_goto_code_again
interrupt_routine_no_s_key:
	ld a, b
	and 0b00000001 ; the 'a' key
	jr nz, interrupt_routine_no_a_key
	ld a, (turbosound_setting_byte)
	and 0b11101111 ; disable turbosound, thus making normal AY
	ld (turbosound_setting_byte), a
	ld a, 1
	ld (turbosound_flip_modules), a
	jr interrupt_routine_goto_code_again
interrupt_routine_no_a_key:

	; draw text here
	ld a, (flip_mask)
	or 7  ; select page 7 for text drawing
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	out  (c),a
	
	ld hl, (draw_text_pointer)
	ld a, (hl)
	cp '$'
	jr z, interrupt_no_draw_text
	ld b, 15 ; speed of text drawing here
interrupt_draw_text_cycle:
	ld a, (hl)
	cp '$'
	jr z, interrupt_draw_text_end
	; catch a ctl_at byte here
	cp ctl_at
	jr nz, interrupt_draw_text_to_ctl_at
	inc hl
	ld c, (hl)
	inc hl
	ld b, (hl)
	inc hl
	or a ; drop carry
	rl c
	rl c
	rl c
	call get_video_pos ; returns de
	ld (draw_text_screen_address), de
	jr interrupt_draw_text_cycle
	
interrupt_draw_text_to_ctl_at:
	
	push bc
	push hl
	
	ld hl, 0
	sub 32 ; substract non-printable chars
	ld l, a
	or a ; drop carry bit
	rl l
	rl h
	rl l
	rl h
	rl l
	rl h ; multiply by eight
	ld de, $3d00 ; Character set
	add hl, de
	ld b, 8
	ld de, (draw_text_screen_address)
	push de
interrupt_draw_text_cycle_cycle:
	ld a, (hl)
	ld (de), a ; write to screen
	ld ixl, a
	ld a, (paging_available)
	or a
	jr z, interrupt_draw_text_no_shadow_screen
	push de
	set 7, d ; extended instruction, set bit 7 in register d
	ld a, ixl
	ld (de), a ; write the same thing to shadow screen
	pop de
	
interrupt_draw_text_no_shadow_screen:
	inc d      ; step down
	inc hl
	dec b
	jr nz, interrupt_draw_text_cycle_cycle
	pop de
	inc e ; step right
	ld (draw_text_screen_address), de
	
	pop hl
	pop bc
	inc hl
	dec b
	jr nz, interrupt_draw_text_cycle
interrupt_draw_text_end:
	ld (draw_text_pointer), hl
interrupt_no_draw_text:


	; page in a screen file & shedule & erase shedule
	ld iy, (interrupt_choosen_file)
	ld hl, (iy+12) ; [erase_queue]
	ld (interrupt_chosen_erase_queue), hl
	ld hl, (iy+10)
	ld (interrupt_chosen_queue), hl
	
	ld a, (flip_mask)
	ld l, a
	ld a, (iy+7) ; [memory page]
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	; interrupt, do not save the byte
	out  (c),a
	
	
	; the engine makes flip and then erases shapes, on next frame it draws shapes
	ld hl, (frame_counter)
	ld a, l
	and 1
	jp nz, interrupt_routine_no_erase_this_time
	
	
	; erase thing on even frames
	ld b, erase_queue_size
	ld ix, (interrupt_chosen_erase_queue)
	ld a, (iy+6) ; [asm enable]
	or a
	jr z, interrupt_routine_no_erase_this_time
	
interrupt_c0:
	ld hl, (ix+0) ; [hl register] [drawing code] [ret patch]
	ld a, h
	or l
	jr z, interrupt_skip0
	ld de, (ix+2) ; drawing code pointer
	push bc
	ld b, 0 ; draw black
	call call_de
	pop bc
	ld hl, 0
	ld (ix+0), hl ; mark this entry as empty
	
interrupt_skip0:
	ld de, 6 ; [hl register] [drawing code] [ret patch]
	add ix, de
	dec b
	jr nz, interrupt_c0
	jp do_not_draw_this_time_wait_for_next_interrupt

interrupt_routine_no_erase_this_time:

	; draw some figurines
	ld b, shedule_size
	ld hl, (interrupt_chosen_queue) ; [shedule]
	ld ix, hl
interrupt_c1:
	ld hl, (ix+0) ; [hl register] [drawing code] [ret patch] [enable] [frame number]
	ld a, h
	or l
	jp z, interrupt_skip1 ; FIXME enable byte
	ld de, (ix+7) ; target frame number
	ld hl, (frame_counter) ; i will restore hl back
	or a ; clear carry flag
	sbc hl, de
	add hl, de ; compare two numbers
	jp c, interrupt_skip1
	ld hl, (ix+0) ; restore hl back
	ld de, (ix+2) ; load drawing code
	push bc
	ld b, #ff
	call call_de ; run drawing code

	pop bc
	
	push bc
	ld b, erase_queue_size ; move iy to empty entry in erase_queue
	ld iy, (interrupt_chosen_erase_queue)
interrupt_find_empty_c1:
	ld de, (iy+0)
	ld a, d
	or e
	jr z, interrupt_find_empty_skip1 ; found empty slot
	ld de, 6
	add iy, de ; move to next entry
	dec b
	jr nz, interrupt_find_empty_c1
	ld iy, (interrupt_chosen_erase_queue) ; no space left, use first entry
interrupt_find_empty_skip1:
	pop bc
	
	ld de, (ix+0) ; [hl register] [drawing code] [ret patch]
	ld (iy+0), de
	ld de, (ix+2)
	ld (iy+2), de
	ld de, (ix+4)
	ld (iy+4), de ; put entry into erase_queue to be erased on next frame
	
	ld a, 0
	ld (ix+6), a ; drop enable byte
	ld (ix+0), a
	ld (ix+1), a ; mark this entry empty
	
interrupt_skip1:
	; TODO check frame number
	ld de, shedule_entry_size
	add ix, de
	dec b
	jp nz, interrupt_c1
	
do_not_draw_this_time_wait_for_next_interrupt:
	
	ld a, (flip_mask)
	ld l, a
	ld a, (stored_paging_byte_address)
	and 0b11110111
	or l
	or 16 ; basic48
	ld bc, #7ffd
	out (c),a ; restore page as it was before interrupt
	
	;ld a, 0b00000000 ; border black again
	;out (#fe), a
	; .6 call busy_wait
	pop iy
	pop ix
	pop hl
	pop de
	pop bc
	pop af
	ei
	reti

;;;;;;;;;;;;;;;;;
; rewind_music
;;;;;;;;;;;;;;;;;
rewind_frame: EQU 950
rewind_music:
	ld a, (no_music)
	or a
	ret nz
	ld bc, rewind_frame
	ld hl, (frame_counter)
	ld de, rewind_frame
	add hl, de
	ld (frame_counter), hl
rewind_music_loop:
	push bc
	call player+5
	pop bc
	dec bc
	ld a, b
	or c
	jr nz, rewind_music_loop
	ret
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; main code
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;test_figurine_asm:	WORD 0
code_main:
	
	; WANTFIX the loader of music is probably to be located here, make user
	; able to cancel music loading on device that does not
	; support AY sound, by pressing a key
	
	; check if paging available
	ld a, 1
	ld (paging_available), a
	
	ld a, (flip_mask)
	ld h, a
	ld a, 4
	or h
	or 16 ; select basic rom
	ld (stored_paging_byte_address), a
	ld bc, #7ffd
	out (c),a ; set page 4
	ld a, 16
	ld ($ffff), a
	
	ld a, 7
	or h
	or 16 ; select basic rom
	ld (stored_paging_byte_address), a
	ld bc, #7ffd
	out (c),a ; set page 7
	ld a, 17
	ld ($ffff), a
	
	ld a, 4
	or h
	or 16 ; select basic rom
	ld (stored_paging_byte_address), a
	ld bc, #7ffd
	out (c),a ; set page 4
	ld a, ($ffff)
	cp 17
	jr nz, code_main_paging_ok
	ld a, 0
	ld (paging_available), a
	
	ld a, 2
	out (#FE),A ; border red means that paging is failed (48k compatibility mode)
	
	; change asm_file so it assembles into $6000 and drop even frames
	ld ix, asm_file_for_screen_0
	ld (ix+6), 0 ; [enable asm] screen 0 does not compile
	ld hl, shedule_6000
	ld (ix+10), hl
	ld hl, erase_queue_6000
	ld (ix+12), hl
	
	ld ix, asm_file_for_screen_1
	ld hl, 0
	ld (ix+8), hl ; [screen file offset]
	
	
	jr code_main_paging_not_available_skip_music_check
code_main_paging_ok:
	; player page should not be 4 or 7, if so, disable music
	; it would probably always be 0 at load, but I put a check to be sure
	ld a, (player_page)
	and 0b00000111
	cp 7
	jr z, code_main_disable_music
	cp 4
	jr z, code_main_disable_music
	jr code_main_music_ok
code_main_disable_music:
	ld a, 1
	ld (no_music), a
	
code_main_music_ok:
	
	ld hl, vault_c000
	ld bc, erase_queue_c000_end - vault_c000 ; page 4
	ld d, 0
	call fill_mem ; clear shedule at c000
	
	ld a, (flip_mask)
	or 7  ; page 7
	or 16 ; select basic rom
	ld (stored_paging_byte_address), a
	ld bc, #7ffd
	out (c),a ; set page 7
	ld HL, #d800
	ld BC, 768       ; set background to black
	ld D, 0b01000111 ; set ink to white
	call fill_mem
	
code_main_paging_not_available_skip_music_check:
	
	ei
	call clear_slow
	
	; set player page, so the code has access to shapes
	ld a, (player_page)
	ld l, a
	di
	ld a, (flip_mask)
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set player page (where shapes are stored)
	ei
	
	jp frame_0_program_start ; program moved to $c000 at page 0




;;;;;;;;;;;;;;;;;;;;;;;;;;;
; on screen display text
;;;;;;;;;;;;;;;;;;;;;;;;;;;
ctl_paper:	EQU $11
ctl_ink:	EQU $10
ctl_at:		EQU $16
ctl_bright:	EQU $13
text_nikhotmsk_presents: ; BYTE ctl_paper,0,ctl_ink,7,ctl_bright,1
	BYTE ctl_at,8, 6,'       _____'
	BYTE ctl_at,9, 6,'      / ___ \'
	BYTE ctl_at,10,6,'       /   \'
	BYTE ctl_at,11,6,'      /__O__\'
	BYTE ctl_at,14,6,'nikhotmsk  presents', '$'
text_tiny_little_demo:
	BYTE ctl_at,6, 1,'     a tiny little demo'
	BYTE ctl_at,8, 1,'for ZX Spectrum retrocomputer'
	BYTE ctl_at,12,3,'       special for:'
	BYTE ctl_at,14,3,'    SESSIONS DEMOPARTY'
	BYTE ctl_at,16,3,'        Japan 2023'
	BYTE '$'

	
place_single:
	BYTE 1, 0, 0, 0, 0 ; [enable] [dY dX] [dFrame]
	BYTE 0 ; terminator

shape_bar_slow_right:
	BYTE 128+0,40,128+0,8*13
	BYTE 128+2,40,128+2,8*13
	BYTE 128+4,40,128+4,8*13
	BYTE 128+6,40,128+6,8*13
	BYTE 128+8,40,128+8,8*13
	BYTE 0,0,0,0
	
shape_bar_slow_left:
	BYTE 128+8,40,128+8,8*13
	BYTE 128+6,40,128+6,8*13
	BYTE 128+4,40,128+4,8*13
	BYTE 128+2,40,128+2,8*13
	BYTE 128+0,40,128+0,8*13
	BYTE 0,0,0,0

shape_bar_slow_up:
	BYTE 10,8,230,8
	BYTE 10,6,230,6
	BYTE 10,4,230,4
	BYTE 10,2,230,2
	BYTE 10,0,230,0
	BYTE 0,0,0,0

place_bar_slow_up:
	BYTE 1,0,22
	WORD 0 * 8
	BYTE 1,0,21
	WORD 1 * 8
	BYTE 1,0,20
	WORD 2 * 8
	BYTE 1,0,19
	WORD 3 * 8
	BYTE 1,0,18
	WORD 4 * 8
	BYTE 1,0,17
	WORD 5 * 8
	BYTE 1,0,16
	WORD 6 * 8
	BYTE 1,0,15
	WORD 7 * 8
	BYTE 1,0,14
	WORD 8 * 8
	BYTE 1,0,13
	WORD 9 * 8
	BYTE 1,0,12
	WORD 10* 8
	BYTE 1,0,11
	WORD 11* 8
	BYTE 1,0,10
	WORD 12* 8
	BYTE 1,0,9
	WORD 13* 8
	BYTE 1,0,8
	WORD 14* 8
	BYTE 1,0,7
	WORD 15* 8
	BYTE 1,0,6
	WORD 16* 8
	BYTE 1,0,5
	WORD 17* 8
	BYTE 1,0,4
	WORD 18* 8
	BYTE 1,0,3
	WORD 19* 8
	BYTE 1,0,2
	WORD 20* 8
	BYTE 1,0,1
	WORD 21* 8
	BYTE 1,0,0
	WORD 22* 8
	BYTE 0
	
shape_bar_slow_down:
	BYTE 10,0,230,0
	BYTE 10,2,230,2
	BYTE 10,4,230,4
	BYTE 10,6,230,6
	BYTE 10,8,230,8
	BYTE 0,0,0,0

place_bar_slow_down:
	BYTE 1,0,0
	WORD 0 * 8
	BYTE 1,0,1
	WORD 1 * 8
	BYTE 1,0,2
	WORD 2 * 8
	BYTE 1,0,3
	WORD 3 * 8
	BYTE 1,0,4
	WORD 4 * 8
	BYTE 1,0,5
	WORD 5 * 8
	BYTE 1,0,6
	WORD 6 * 8
	BYTE 1,0,7
	WORD 7 * 8
	BYTE 1,0,8
	WORD 8 * 8
	BYTE 1,0,9
	WORD 9 * 8
	BYTE 1,0,10
	WORD 10* 8
	BYTE 1,0,11
	WORD 11* 8
	BYTE 1,0,12
	WORD 12* 8
	BYTE 1,0,13
	WORD 13* 8
	BYTE 1,0,14
	WORD 14* 8
	BYTE 1,0,15
	WORD 15* 8
	BYTE 1,0,16
	WORD 16* 8
	BYTE 1,0,17
	WORD 17* 8
	BYTE 1,0,18
	WORD 18* 8
	BYTE 1,0,19
	WORD 19* 8
	BYTE 1,0,20
	WORD 20* 8
	BYTE 1,0,21
	WORD 21* 8
	BYTE 1,0,22
	WORD 22* 8
	BYTE 0

place_bar_slow_right:
	BYTE 1,-15, 0
	WORD -8
	BYTE 1,-14, 0 ; [enable] [dY dX] ; wrong, it is [dX dY]
	WORD 0       ; [dFrame]
	BYTE 1,-13, 0
	WORD 8
	BYTE 1,-12, 0
	WORD 16
	BYTE 1,-11, 0
	WORD 24
	BYTE 1,-10, 0
	WORD 32
	BYTE 1,-9, 0
	WORD 40
	BYTE 1,-8, 0
	WORD 48
	BYTE 1,-7, 0
	WORD 56
	BYTE 1,-6, 0
	WORD 64
	BYTE 1,-5, 0
	WORD 72
	BYTE 1,-4, 0
	WORD 80
	BYTE 1,-3, 0
	WORD 88
	BYTE 1,-2, 0
	WORD 96
	BYTE 1,-1, 0
	WORD 104
	BYTE 1, 0, 0
	WORD 112
	BYTE 1, 1, 0
	WORD 120
	BYTE 1, 2, 0
	WORD 128
	BYTE 1, 3, 0
	WORD 136
	BYTE 1, 4, 0
	WORD 144
	BYTE 1, 5, 0
	WORD 152
	BYTE 1, 6, 0
	WORD 160
	BYTE 1, 7, 0
	WORD 168
	BYTE 1, 8, 0
	WORD 176
	BYTE 1, 9, 0
	WORD 184
	BYTE 1,10, 0
	WORD 192
	BYTE 1,11, 0
	WORD 200
	BYTE 1,12, 0
	WORD 208
	BYTE 1,13, 0
	WORD 216
	
	BYTE 0


place_bar_slow_left:
	; and back
	BYTE 1, 13, 0
	WORD 8
	BYTE 1, 12, 0
	WORD 16
	BYTE 1, 11, 0
	WORD 24
	BYTE 1, 10, 0
	WORD 32
	BYTE 1, 9, 0
	WORD 40
	BYTE 1, 8, 0
	WORD 48
	BYTE 1, 7, 0
	WORD 56
	BYTE 1, 6, 0
	WORD 64
	BYTE 1, 5, 0
	WORD 72
	BYTE 1, 4, 0
	WORD 80
	BYTE 1, 3, 0
	WORD 88
	BYTE 1, 2, 0
	WORD 96
	BYTE 1, 1, 0
	WORD 104
	BYTE 1, 0, 0
	WORD 112
	BYTE 1,-1, 0
	WORD 120
	BYTE 1,-2, 0
	WORD 128
	BYTE 1,-3, 0
	WORD 136
	BYTE 1,-4, 0
	WORD 144
	BYTE 1,-5, 0
	WORD 152
	BYTE 1,-6, 0
	WORD 160
	BYTE 1,-7, 0
	WORD 168
	BYTE 1,-8, 0
	WORD 176
	BYTE 1,-9, 0
	WORD 184
	BYTE 1,-10, 0
	WORD 192
	BYTE 1,-11, 0
	WORD 200
	BYTE 1,-12, 0
	WORD 208
	BYTE 1,-13, 0
	WORD 216
	BYTE 1,-14, 0
	WORD 224
	
	BYTE 0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; FRAME 0 PROGRAM START
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
frame_0_program_start:
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	; testing area
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	; nikhotmsk presents
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	ld de, 30
	call wait_for_frame
	
	ld a, 0
	out (#FE),A ; border black (cancel red border on boot)
	
	call clear_slow
	
	ld hl, text_nikhotmsk_presents
	ld (draw_text_pointer), hl
	
	ld de, 256 - 32
	call wait_for_frame
	
	call clear_slow
	
	ld hl, text_tiny_little_demo
	ld (draw_text_pointer), hl
	
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	; FRAME 410 TITLE
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	ld de, 512 - 32
	call wait_for_frame
	call clear_slow
	
	ld de, 512
	call wait_for_frame
	
	; flip disable
	ld a, 1
	ld (flip_override), a
	
	
	ld hl, the_logo_svg
	ld (polyline_pointer), hl ; interrupt now will draw the logo
	
	ld de, 768 - 32
	call wait_for_frame
	
	ld hl, 768
	call blink_border
	ld hl, 768 + 128
	call blink_border
	
	call fill_the_logo
	
	
	ld hl, place_bar_slow_right ; prepare for next scene
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_right
	ld de, 1024
	call shedule_add_shape
	
	ld hl, place_bar_slow_up
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_up
	ld de, 1024
	call shedule_add_shape
	
	ld hl, place_bar_slow_down
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_down
	ld de, 1024 + 128
	call shedule_add_shape
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	; frame 1024 scene 1
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	ld de, 1024
	call wait_for_frame

	; flip enable
	ld a, 0
	ld (flip_override), a ; start blinking
	
	ld de, 1024 + 16
	call wait_for_frame
	
	call clear_slow
	
	; figurines are already compiled and will fire here
	
	ld de, 1024 + 256 - 100
	call wait_for_frame
	
	ld hl, place_bar_slow_left
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_left
	ld de, 1024 + 256
	call shedule_add_shape
	
	ld hl, place_bar_slow_up
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_up
	ld de, 1024 + 256
	call shedule_add_shape
	
	ld hl, place_bar_slow_down
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_down
	ld de, 1024 + 256 + 128
	call shedule_add_shape
	
	ld de, 1536 - 100 ; prepare for next scene
	call wait_for_frame
	
	ld hl, place_bar_slow_right
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_right
	ld de, 1536
	call shedule_add_shape
	
	ld hl, place_bar_slow_left
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_left
	ld de, 1536
	call shedule_add_shape
	
	ld hl, place_bar_slow_up
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_up
	ld de, 1536 + 32
	call shedule_add_shape
	
	ld hl, place_bar_slow_down
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_down
	ld de, 1536 + 128
	call shedule_add_shape
	
	;;;;;;;;;;;;;;;;;;;;;;;;
	; frame 1536 scene 2
	;;;;;;;;;;;;;;;;;;;;;;;;
	
	ld hl, place_bar_slow_up
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_up
	ld de, 1536 + 256
	call shedule_add_shape
	
	ld hl, place_bar_slow_down
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_down
	ld de, 1536 + 256 + 128
	call shedule_add_shape
	
	;ld de, 1536 + 256 - 180
	;call wait_for_frame
	
	ld hl, place_bar_slow_left
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_left
	ld de, 1536 + 256
	call shedule_add_shape
	
	;ld hl, place_bar_slow_right
	;ld (add_shape_places_table), hl
	;ld hl, shape_bar_slow_right
	;ld de, 1536 + 256 + 100
	;call shedule_add_shape
	
	; prepare for next scene
	
	ld de, 2048 - 200
	call wait_for_frame
	
	ld hl, place_bar_slow_right
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_right
	ld de, 2048 - 64
	call shedule_add_shape
	
	ld hl, place_bar_slow_up
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_up
	ld de, 2048
	call shedule_add_shape
	
	ld hl, place_bar_slow_down
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_down
	ld de, 2048
	call shedule_add_shape
	
	ld hl, place_bar_slow_down
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_down
	ld de, 2048 + 128
	call shedule_add_shape
	
	ld hl, place_bar_slow_up
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_up
	ld de, 2048 + 128
	call shedule_add_shape
	
	;;;;;;;;;;;;;;;;;;;;;;;;
	; frame 2048 scene 3
	;;;;;;;;;;;;;;;;;;;;;;;;
	
	ld de, 2048 + 256 - 128
	call wait_for_frame
	
	ld hl, place_bar_slow_up
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_up
	ld de, 2048 + 256
	call shedule_add_shape
	
	ld hl, place_bar_slow_down
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_down
	ld de, 2048 + 256
	call shedule_add_shape
	
	ld hl, place_bar_slow_up
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_up
	ld de, 2048 + 256 + 40
	call shedule_add_shape
	
	ld hl, place_bar_slow_down
	ld (add_shape_places_table), hl
	ld hl, shape_bar_slow_down
	ld de, 2048 + 256 + 60
	call shedule_add_shape
	
	
	;;;;;;;;;;;;;;;;;;;;;;;;
	; frame 2560 scene ending
	;;;;;;;;;;;;;;;;;;;;;;;;
	ld de, 2560 - 10
	call wait_for_frame

	ld hl, 2560
	call blink_border
	
	ld de, 2560
	call wait_for_frame
	
	; more speed
	ld a, 12
	ld (polyline_speed + 1), a
	
	ld hl, the_logo_svg
	ld (polyline_pointer), hl ; interrupt will draw the logo now
	
	ld de, 2560 + 32
	call wait_for_frame
	
	call fill_the_logo
	
	ld de, 2560 + 128
	call wait_for_frame
	
	ld a, 1
	ld (flip_override), a
	
code_loop:
	halt
	jr code_loop
	; autorestart logic was here
	; jp interrupt_routine_goto_code_again

; main program ends here

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; fill_the_logo
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
fill_the_logo:
	ld de, (14 * 256) + 192-135 ; fill tiny stripes on the left
	call fill
	ld de, (3 * 256) + 192-135
	call fill
	ld de, (3 * 256) + 192-124
	call fill
	ld de, (3 * 256) + 192-112
	call fill
	ld de, (3 * 256) + 192-100
	call fill
	ld de, (3 * 256) + 192-88
	call fill
	ld de, (3 * 256) + 192-76
	call fill
	ld de, (3 * 256) + 192-66
	call fill
	ld de, (3 * 256) + 192-55
	call fill
	
	
	ld de, ( 34 * 256) + 196-112 ; fill big letters
	call fill
	ld de, ( 55 * 256) + 196-112
	call fill
	ld de, ( 87 * 256) + 196-112
	call fill
	ld de, (115 * 256) + 196-112
	call fill
	ld de, (137 * 256) + 196-112
	call fill
	ld de, (165 * 256) + 196-112
	call fill
	ld de, (193 * 256) + 196-112
	call fill
	ld de, (241 * 256) + 196-112
	call fill
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; blink_border
; hl - base frame number
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
blink_border_base_frame: WORD 0
blink_border:
	ld (blink_border_base_frame), hl

	call set_right_page_and_chosen_shedule
	
	ld hl, (blink_border_base_frame)
	ld de, 32
	add hl, de
	ld ix, hl
	
	ld hl, callback_set_border_white	; drawing code
	ld de, ix							; frame number
	ld bc, 0							; position shift
	call shedule_add_figurine
	
	ld hl, (blink_border_base_frame)
	ld de, 64
	add hl, de
	ld ix, hl
	
	ld hl, callback_set_border_black	; drawing code
	ld de, ix							; frame number
	ld bc, 0							; position shift
	call shedule_add_figurine
	
	ld hl, (blink_border_base_frame)
	ld de, 96
	add hl, de
	ld ix, hl
	
	ld hl, callback_set_border_white	; drawing code
	ld de, ix							; frame number
	ld bc, 0							; position shift
	call shedule_add_figurine
	
	ld hl, (blink_border_base_frame)
	ld de, 128
	add hl, de
	ld ix, hl
	
	ld hl, callback_set_border_black	; drawing code
	ld de, ix							; frame number
	ld bc, 0							; position shift
	call shedule_add_figurine
	ret

;;;;;;;;;;;;;;;
; call_de
;;;;;;;;;;;;;;;
call_de:
	push de
	ret
	
;;;;;;;;;;;;;;;;;;;;;;;
; callback_set_border_white
;;;;;;;;;;;;;;;;;;;;;;;
callback_set_border_white:
	ld a, 7
	out (#FE),A      ; border white
	ret
;;;;;;;;;;;;;;;;;;;;;;;
; callback_set_border_black
;;;;;;;;;;;;;;;;;;;;;;;
callback_set_border_black:
	ld a, 0
	out (#FE),A      ; border black
	ret


	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; set_right_page_and_chosen_shedule
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
set_right_page_and_chosen_shedule:
	ld hl, (asm_file_for_screen_0 + 10) ; [schedule]
	ld (asm_chosen_shedule), hl
	
	 ; do not forget to set right page for shedule_add_figurine
	ld iy, asm_file_for_screen_0
	ld a, (iy+7) ; [memory page]
	or 16 ; always select basic48 ROM
	ld l, a
	;di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a
	ei
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; a structure for shadow screen pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
asm_file_for_screen_0: WORD vault_c000	; [*assembler_running_w]
	WORD vault_c000						; [*vault]
	WORD vault_c000_wraparound			; [*wraparound]
	BYTE 1								; [enable asm]
	BYTE 4								; [memory page]
	WORD $0000							; [*screen file offset]
	WORD shedule_c000					; [*shedule]
	WORD erase_queue_c000				; [*erase queue]
	
asm_file_for_screen_1: WORD drawing_code_vault	; [*assembler_running_w]
	WORD drawing_code_vault						; [*vault]
	WORD wraparound_area				; [*wraparound]
	BYTE 1								; [enable asm]
	BYTE 7								; [memory page]
	WORD $8000							; [*screen file offset]
	WORD shedule_6000					; [*shedule]
	WORD erase_queue_6000				; [*erase queue]
; [*assembler_running_w] [*vault] [*wraparound] [enable asm] [memory page] [*screen file offset] [*screen file offset] [*shedule] [*erase queue]


vault_c000: EQU $c000 ; on page 4
	; size 13384
vault_c000_wraparound: EQU vault_c000 + 13384
vault_c000_end: EQU vault_c000_wraparound + 16
shedule_c000: EQU vault_c000_end
shedule_c000_end: EQU shedule_c000 + (shedule_entry_size * shedule_size)
erase_queue_c000: EQU shedule_c000_end
erase_queue_c000_end: EQU erase_queue_c000 + erase_queue_size * 6


;;;;;;;;;;;;;;;;;;;;;
; shedule_add_shape (sequence)
; hl - shape sequence
; de - base frame number
; add_shape_places_table - places sequence
;;;;;;;;;;;;;;;;;;;;;
shedule_prev_line_a: WORD 0 ; X Y (like in memory)
shedule_prev_line_b: WORD 0
shedule_base_frame_number: WORD 0
add_shape_places_table: WORD place_single
asm_chosen_shedule: WORD 0
asm_chosen_screen_offset: BYTE 0
shedule_add_shape:
	ld (shedule_base_frame_number), de
	ld ix, hl
	ld hl, 0
	ld (shedule_prev_line_a), hl ; reset prev_line
	ld (shedule_prev_line_b), hl
shedule_add_shape_cycle1:
	; decide where to put the drawing code, which shadow screen to use
	push hl
	ld iy, asm_file_for_screen_0
	ld hl, (shedule_base_frame_number)
	ld a, l ; choice the memory page here
	and 0b00000010
	jr z, shedule_add_shape_screen_0
	ld iy, asm_file_for_screen_1
shedule_add_shape_screen_0:
	ld hl, (iy+8)
	ld a, h
	ld (asm_chosen_screen_offset), a
	ld hl, (iy+10) ; [shedule]
	ld (asm_chosen_shedule), hl
	
	; select page with shapes, so IX will work
	ld a, (player_page)
	or 16 ; always select basic48 ROM
	ld l, a
	;di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set page
	ei
	
	pop hl
	
	ld bc, (ix+0)
	ld a, b
	or c
	ret z ; sequence ready
	ld bc, (shedule_prev_line_a)
	ld de, (shedule_prev_line_b)
	ld a, b
	or c
	or d
	or e ; check if prev line empty
	jr nz, shedule_add_shape_draw ; do not draw, just remember prev line
	ld bc, (ix+0) ; c = X, b = Y ??
	inc ix
	inc ix
	ld de, (ix+0)
	inc ix
	inc ix
	ld (shedule_prev_line_a), bc
	ld (shedule_prev_line_b), de
	
	jr shedule_add_shape_cycle1
shedule_add_shape_draw:
	
	ld a, (iy+6) ; [enable asm]
	or a
	jp z, shedule_add_shape_asm_disabled
	
	; silkscreen (do not forget to push ix)
	ld hl, vars
	ld bc, (ix+0) ; c = Y, b = X
	ld (hl), c
	inc hl
	ld (hl), b
	inc hl
	ld bc, (ix+2)
	ld (hl), c
	inc hl
	ld (hl), b ; fill vars with figurine parameters
	inc hl
	ld bc, (shedule_prev_line_b) ; c = Y, b = X
	ld (hl), c
	inc hl
	ld (hl), b
	inc hl
	ld bc, (shedule_prev_line_a)
	ld (hl), c
	inc hl
	ld (hl), b
	inc hl
	
	push ix
	
	push hl	; select page with drawing code vault
	ld a, (iy+7) ; [memory page]
	or 16 ; always select basic48 ROM
	ld l, a
	;di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a
	ei
	pop hl
	
	call silkscreen_figurine
	; call debug_lines
	; .8 call busy_wait
	
	; do not forget to set asm_file IY
	call silkscreen.silkscreen_assembler ; (returns HL)
	pop ix
shedule_add_shape_asm_disabled:
	; remember prev line
	push hl ; select page with shapes
	ld a, (player_page)
	ld l, a
	; di
	ld a, (flip_mask)
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set page
	ei
	pop hl
	ld bc, (ix+0)
	inc ix
	inc ix
	ld de, (ix+0)
	inc ix
	inc ix
	ld (shedule_prev_line_a), bc
	ld (shedule_prev_line_b), de ; also move ix forvard
	
	; put it in draw queue
	push ix
	
	push hl ; select page with shedule
	ld a, (iy+7) ; [memory page]
	or 16 ; always select basic48 ROM
	ld l, a
	; di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a
	ei
	pop hl
	
	ld a, (iy+6) ; [enable asm]
	or a
	call nz, shedule_add_figurine_many_places
	pop ix
	ld de, (shedule_base_frame_number)
	inc de
	inc de
	ld (shedule_base_frame_number), de
	
	jp shedule_add_shape_cycle1

	
;;;;;;;;;;;;;;;;;;;;;;;;;;
; shedule_add_figurine_many_places
; hl - drawing code
;;;;;;;;;;;;;;;;;;;;;;;;;;
shedule_add_figurine_many_places:
	ld ix, (add_shape_places_table)
shedule_add_figurine_many_places_cycle:
	ld a, (ix+0)
	or a
	ret z
	push hl
	ld hl, (shedule_base_frame_number)
	ld de, (ix+3) ; [enable] [dY dX] [dFrame]
	add hl, de ; frame number displacement
	ex de, hl
	ld bc, (ix+1) ; position displacement
	pop hl
	push ix
	call shedule_add_figurine
	pop ix
	inc ix
	inc ix
	inc ix
	inc ix
	inc ix
	jr shedule_add_figurine_many_places_cycle
	
	
	
	;call silkscreen_figurine
	;call debug_draw_silkscreen
	;call silkscreen.silkscreen_assembler ; returns hl
	;ld (test_figurine_asm), hl
	;call debug_lines
	
	;ld hl, (test_figurine_asm)
	;ld de, 41 ; frame number
	;ld a, 3   ; drawing mode flags
	;ld bc, #0404 ; shift (Y X)
	;call shedule_add_figurine
	
	;ld de, 47 ; frame number
	;ld a, 3   ; drawing mode flags
	;ld bc, #000c ; shift (Y X)
	;call shedule_add_figurine
	
	;ld de, 51 ; frame number
	;ld a, 3   ; drawing mode flags
	;ld bc, #060c ; shift (Y X)
	;call shedule_add_figurine


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; wait_for_frame
; de - frame number (function will hang if frame_counter is less then de)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
wait_for_frame:
	ld hl, (frame_counter)
	or a ; clear carry flag
	sbc hl, de
	add hl, de	; compare words
	ret nc		; carry is set if (hl < de)
	halt
	jr wait_for_frame

;;;;;;;;;;;;;;;;;;;;;
; shedule_add_figurine
; hl - drawing code
; de - frame numer (must not be even (because erase runs at 25 fps))
; bc - position shift
;;;;;;;;;;;;;;;;;;;;;
shedule_add_figurine:
	ld ix, (asm_chosen_shedule)
	push bc
	push de
	ld b, shedule_size
	; di
shedule_add_figurine_c1:
	; move ix to empty slot here
	ld de, (ix+0)
	ld a, d ; FIXME enable byte here and there
	or e
	jr z, shedule_add_figurine_found_slot1
	ld de, shedule_entry_size
	add ix, de
	dec b
	jr nz, shedule_add_figurine_c1
	ld ix, (asm_chosen_shedule) ; no space left, clobber the first entry
shedule_add_figurine_found_slot1:
	pop de
	pop bc
	
	ld a, e
	or 0b00000001 ; force odd number (bug fixed)
	; FIXME force right number depending on shadow screen
	ld e, a       ; frame number ready
	ld (ix+7), de ; [hl register] [drawing code] [ret patch] [enable] [frame number]
	
	
	push hl
	push bc
	sla b
	sla b
	sla b ; multiply by 8
	ld a, b
	ld hl, (upper_point_lower_point)
	add h
	ld b, a ; add vertical shift ; TODO add return path crop
	ld a, (upper_point_x)
	ld c, a
	call Get_Pixel_Address ; returns hl
debug_point_4:
	ld a, (asm_chosen_screen_offset)
	or h
	ld h, a ; 
	pop bc
	ld a, l      ; add horizontal shift value
	add c
	ld l, a
	ld (ix+0), l ; screen address ready
	ld (ix+1), h
	pop hl
	di
	ld (ix+2), l
	ld (ix+3), h ; drawing code address ready
	ei
	ld a, 1
	ld (ix+6), a ; enable byte
	ei
	ret


;;;;;;;;;;;;;;;;;;
; empty_routine
;;;;;;;;;;;;;;;;;;
empty_routine:
	
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;
; clear screen data
;;;;;;;;;;;;;;;;;;;;;;;;;
clear_slow:
	; di
	ld a, (flip_mask)
	or 7
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set page 7 (no op if it is spectrum48)
	ei
debug_point_6:
	ld a, (paging_available)
	or a
	jr nz, clear_slow_paging_ok
	ld a, $00 ; nop
	ld (clear_slow_mod1), a ; self modify code so it does not write to c000
clear_slow_paging_ok:

	ld HL, #4000
	ld de, #c000 ; on page 7
	ld BC, 6144      ; clear image data (slow and nice)
clear_slow_c1:
	xor a
	ld (hl), a ; draw on screen
clear_slow_mod1:
	ld (de), a ; draw on shadow screen
	inc hl
	inc de
	dec bc
	ld a, c
	or a
	jr nz, clear_slow_skip1
	halt
clear_slow_skip1:
	or b
	jr nz, clear_slow_c1
	
	ld a, (player_page)
	or 16 ; always select basic48 ROM
	ld l, a
	; di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set player page, because program is there
	ei
	ret
	
;
; fill memory with constant byte
;
; D  - byte
; HL - start address
; BC - size
;
fill_mem:
  ld A, D
  ld (HL), A
  inc HL
  dec BC
  ld A,B
  or C
  jr nz, fill_mem
  ret


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; silkscreen_figurine
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
silkscreen_figurine:
	; TODO clear the header
	ld h, 255
	ld l, 0
	ld (upper_point_lower_point), hl ; reset upper point
	
	; clear the buffer
	ld c, 192
	ld hl, silk_data
	ld b, 255 ; these are the shape coordinates
	ld a, 0   ; they are invalid, so drawing code will fix them
silkscreen_figurine_c1:
	ld (hl), b
	inc hl
	ld (hl), a ; set second point to zero to mark it as disabled
	inc hl
	dec c
	jr nz, silkscreen_figurine_c1
	
	; do silkscreen drawing
	ld ix, vars
	ld bc, (ix+0) ; AB
	ld de, (ix+2)
	call silkscreen.Draw_Line
	
	ld ix, vars
	ld bc, (ix+2) ; BC
	ld de, (ix+4)
	
	call silkscreen.Draw_Line
	
	ld ix, vars
	ld bc, (ix+4) ; CD
	ld de, (ix+6)
	
	call silkscreen.Draw_Line
	
	ld ix, vars
	ld bc, (ix+6) ; DA
	ld de, (ix+0)
	call silkscreen.Draw_Line
	
	
	ret
	

;;;;;;;;;;;;;;;;;;;;;;;;
; debug_draw_silkscreen
;;;;;;;;;;;;;;;;;;;;;;;;
;debug_draw_silkscreen:
;	ld hl, silk_data
;	ld c, 192 ; counter
;	ld b, 0   ; Y coordinate
;debug_draw_silkscreen_c1:
;	push bc
;	ld d, b ; make horisontal line
;	ld c, (hl) ; load X left
;	inc hl
;	ld e, (hl) ; load X right
;	inc hl
;	push hl
;	ld a, e ; check if the line is active
;	or a
;	jr z, debug_draw_silkscreen_s
;	ld a, e ; check if line is valid
;	cp c
;	jr c, debug_draw_silkscreen_s
;	jr z, debug_draw_silkscreen_s
;	dec e ; last point is not included
;	;call nz, Plot
;	;ld b, d
;	;ld c, e
;	;call nz, Plot
;	call Draw_Line
;debug_draw_silkscreen_s:
;	pop hl
;	pop bc
;	inc b
;	dec c
;	jr nz, debug_draw_silkscreen_c1
;	ret

;;;;;;;;;;;;;;;;;;;;;;;;
; debug_lines
;;;;;;;;;;;;;;;;;;;;;;;;
;debug_lines:
;	ld ix, vars
;	ld bc, (ix+0) ; AB
;	ld de, (ix+2)
;	call Draw_Line
;	
;	ld ix, vars
;	ld bc, (ix+2) ; BC
;	ld de, (ix+4)
;	call Draw_Line
;	
;	ld ix, vars
;	ld bc, (ix+4) ; CD
;	ld de, (ix+6)
;	call Draw_Line
;	
;	ld ix, vars
;	ld bc, (ix+6) ; DA
;	ld de, (ix+0)
;	call Draw_Line
;	ret
	
	
;
; this code comes from ChibiAkumas. Compute spectrum video address
;
; B  - X in bytes
; C  - Y
; return DE - mem pos in video memory
;;;;;;;;;;;;;;;;;;;;;;;;;
; get_video_pos
;;;;;;;;;;;;;;;;;;;;;;;;;
get_video_pos:
  ld a, c
  and %00111000
  rlca
  rlca
  or b
  ld e, a ; first byte is ready
  ld a, c
  and %00000111
  ld d, a
  ld a, c
  and %11000000
  rrca
  rrca
  rrca
  or d
  or #40
  ld d, a ; second byte is ready
  ret


;
; this code comes from ChibiAkumas too.
;
; DE - address in video mem
; returns DE - new address
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; get_next_line
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
get_next_line:
  inc d
  ld a, d
  and    %00000111 ; check bits Y5 Y4 Y3 overflow
  ret nz
  ld a, e
  add a, %00100000
  ld e, a
  ret c            ; check bits Y2 Y1 Y0 overflow
  ld a, d
  sub    %00001000 ; fix overflow bit Y6
  ld d, a
  ret


;;;;;;;;;;;;;;;;;;;;;;
; busy_wait
;;;;;;;;;;;;;;;;;;;;;;
busy_wait:
	push bc
	ld bc, 5000
busy_wait_loop:
	dec bc
	ld a, b
	or c
	jr nz, busy_wait_loop
	pop bc
	ret

the_logo_svg:
	; path
	.BYTE 13, 57, 11, 55
	.BYTE 11, 55, 13, 55
	.BYTE 13, 55, 16, 55
	.BYTE 16, 55, 16, 57
	.BYTE 16, 57, 16, 59
	.BYTE 16, 59, 13, 57
	; path
	.BYTE 9, 64, 2, 57
	.BYTE 2, 57, 2, 56
	.BYTE 2, 56, 2, 55
	.BYTE 2, 55, 4, 55
	.BYTE 4, 55, 5, 55
	.BYTE 5, 55, 11, 60
	.BYTE 11, 60, 16, 65
	.BYTE 16, 65, 16, 68
	.BYTE 16, 68, 16, 71
	.BYTE 16, 71, 9, 64
	; path
	.BYTE 9, 76, 2, 69
	.BYTE 2, 69, 2, 66
	.BYTE 2, 66, 2, 63
	.BYTE 2, 63, 9, 70
	.BYTE 9, 70, 16, 77
	.BYTE 16, 77, 16, 80
	.BYTE 16, 80, 16, 83
	.BYTE 16, 83, 9, 76
	; path
	.BYTE 9, 87, 2, 81
	.BYTE 2, 81, 2, 78
	.BYTE 2, 78, 2, 75
	.BYTE 2, 75, 9, 82
	.BYTE 9, 82, 16, 89
	.BYTE 16, 89, 16, 91
	.BYTE 16, 91, 16, 94
	.BYTE 16, 94, 9, 87
	; path
	.BYTE 9, 99, 2, 92
	.BYTE 2, 92, 2, 89
	.BYTE 2, 89, 2, 86
	.BYTE 2, 86, 9, 93
	.BYTE 9, 93, 16, 100
	.BYTE 16, 100, 16, 103
	.BYTE 16, 103, 16, 106
	.BYTE 16, 106, 9, 99
	; path
	.BYTE 9, 111, 2, 104
	.BYTE 2, 104, 2, 101
	.BYTE 2, 101, 2, 98
	.BYTE 2, 98, 9, 105
	.BYTE 9, 105, 16, 112
	.BYTE 16, 112, 16, 115
	.BYTE 16, 115, 16, 118
	.BYTE 16, 118, 9, 111
	; path
	.BYTE 9, 123, 2, 116
	.BYTE 2, 116, 2, 113
	.BYTE 2, 113, 2, 110
	.BYTE 2, 110, 9, 117
	.BYTE 9, 117, 16, 124
	.BYTE 16, 124, 16, 127
	.BYTE 16, 127, 16, 130
	.BYTE 16, 130, 9, 123
	; path
	.BYTE 7, 133, 2, 128
	.BYTE 2, 128, 2, 125
	.BYTE 2, 125, 2, 122
	.BYTE 2, 122, 9, 129
	.BYTE 9, 129, 16, 136
	.BYTE 16, 136, 16, 137
	.BYTE 16, 137, 16, 138
	.BYTE 16, 138, 14, 138
	.BYTE 14, 138, 12, 138
	.BYTE 12, 138, 7, 133
	; path
	.BYTE 2, 136, 2, 134
	.BYTE 2, 134, 6, 138
	.BYTE 6, 138, 4, 138
	.BYTE 4, 138, 2, 138
	.BYTE 2, 138, 2, 136
	; path
	.BYTE 31, 116, 27, 114
	.BYTE 27, 114, 23, 111
	.BYTE 23, 111, 22, 110
	.BYTE 22, 110, 23, 109
	.BYTE 23, 109, 24, 107
	.BYTE 24, 107, 25, 105
	.BYTE 25, 105, 26, 104
	.BYTE 26, 104, 28, 105
	.BYTE 28, 105, 30, 107
	.BYTE 30, 107, 34, 108
	.BYTE 34, 108, 37, 107
	.BYTE 37, 107, 39, 106
	.BYTE 39, 106, 38, 101
	.BYTE 38, 101, 32, 98
	.BYTE 32, 98, 26, 96
	.BYTE 26, 96, 24, 93
	.BYTE 24, 93, 23, 89
	.BYTE 23, 89, 24, 85
	.BYTE 24, 85, 26, 82
	.BYTE 26, 82, 28, 79
	.BYTE 28, 79, 31, 77
	.BYTE 31, 77, 36, 77
	.BYTE 36, 77, 41, 77
	.BYTE 41, 77, 47, 81
	.BYTE 47, 81, 46, 83
	.BYTE 46, 83, 44, 86
	.BYTE 44, 86, 43, 87
	.BYTE 43, 87, 41, 86
	.BYTE 41, 86, 38, 84
	.BYTE 38, 84, 35, 84
	.BYTE 35, 84, 32, 87
	.BYTE 32, 87, 33, 90
	.BYTE 33, 90, 39, 92
	.BYTE 39, 92, 45, 95
	.BYTE 45, 95, 48, 99
	.BYTE 48, 99, 48, 105
	.BYTE 48, 105, 47, 110
	.BYTE 47, 110, 40, 115
	.BYTE 40, 115, 35, 116
	.BYTE 35, 116, 31, 116
	; path
	.BYTE 52, 96, 52, 78
	.BYTE 52, 78, 62, 78
	.BYTE 62, 78, 73, 78
	.BYTE 73, 78, 73, 81
	.BYTE 73, 81, 73, 85
	.BYTE 73, 85, 67, 85
	.BYTE 67, 85, 60, 85
	.BYTE 60, 85, 60, 88
	.BYTE 60, 88, 60, 91
	.BYTE 60, 91, 60, 92
	.BYTE 60, 92, 66, 92
	.BYTE 66, 92, 72, 92
	.BYTE 72, 92, 72, 96
	.BYTE 72, 96, 72, 99
	.BYTE 72, 99, 66, 99
	.BYTE 66, 99, 60, 99
	.BYTE 60, 99, 60, 102
	.BYTE 60, 102, 61, 108
	.BYTE 61, 108, 73, 108
	.BYTE 73, 108, 73, 111
	.BYTE 73, 111, 73, 115
	.BYTE 73, 115, 62, 115
	.BYTE 62, 115, 52, 115
	.BYTE 52, 115, 52, 96
	; path
	.BYTE 84, 116, 78, 113
	.BYTE 78, 113, 75, 110
	.BYTE 75, 110, 76, 109
	.BYTE 76, 109, 77, 106
	.BYTE 77, 106, 78, 105
	.BYTE 78, 105, 79, 105
	.BYTE 79, 105, 79, 104
	.BYTE 79, 104, 81, 105
	.BYTE 81, 105, 86, 108
	.BYTE 86, 108, 91, 107
	.BYTE 91, 107, 92, 103
	.BYTE 92, 103, 92, 102
	.BYTE 92, 102, 91, 101
	.BYTE 91, 101, 88, 100
	.BYTE 88, 100, 84, 98
	.BYTE 84, 98, 79, 95
	.BYTE 79, 95, 77, 90
	.BYTE 77, 90, 77, 86
	.BYTE 77, 86, 78, 82
	.BYTE 78, 82, 81, 79
	.BYTE 81, 79, 84, 77
	.BYTE 84, 77, 94, 77
	.BYTE 94, 77, 99, 80
	.BYTE 99, 80, 98, 83
	.BYTE 98, 83, 97, 86
	.BYTE 97, 86, 96, 87
	.BYTE 96, 87, 95, 86
	.BYTE 95, 86, 88, 85
	.BYTE 88, 85, 85, 87
	.BYTE 85, 87, 86, 90
	.BYTE 86, 90, 92, 92
	.BYTE 92, 92, 97, 95
	.BYTE 97, 95, 100, 98
	.BYTE 100, 98, 101, 101
	.BYTE 101, 101, 101, 105
	.BYTE 101, 105, 100, 109
	.BYTE 100, 109, 98, 112
	.BYTE 98, 112, 92, 115
	.BYTE 92, 115, 84, 116
	; path
	.BYTE 112, 116, 106, 113
	.BYTE 106, 113, 103, 110
	.BYTE 103, 110, 104, 108
	.BYTE 104, 108, 106, 105
	.BYTE 106, 105, 107, 104
	.BYTE 107, 104, 108, 105
	.BYTE 108, 105, 111, 107
	.BYTE 111, 107, 113, 108
	.BYTE 113, 108, 116, 108
	.BYTE 116, 108, 118, 107
	.BYTE 118, 107, 120, 104
	.BYTE 120, 104, 119, 101
	.BYTE 119, 101, 113, 98
	.BYTE 113, 98, 107, 96
	.BYTE 107, 96, 105, 92
	.BYTE 105, 92, 105, 85
	.BYTE 105, 85, 108, 80
	.BYTE 108, 80, 112, 77
	.BYTE 112, 77, 121, 77
	.BYTE 121, 77, 127, 80
	.BYTE 127, 80, 128, 81
	.BYTE 128, 81, 126, 83
	.BYTE 126, 83, 125, 86
	.BYTE 125, 86, 124, 87
	.BYTE 124, 87, 122, 86
	.BYTE 122, 86, 120, 85
	.BYTE 120, 85, 115, 85
	.BYTE 115, 85, 113, 88
	.BYTE 113, 88, 119, 92
	.BYTE 119, 92, 125, 95
	.BYTE 125, 95, 128, 98
	.BYTE 128, 98, 129, 103
	.BYTE 129, 103, 128, 110
	.BYTE 128, 110, 125, 113
	.BYTE 125, 113, 120, 115
	.BYTE 120, 115, 112, 116
	; path
	.BYTE 133, 96, 133, 78
	.BYTE 133, 78, 137, 78
	.BYTE 137, 78, 141, 78
	.BYTE 141, 78, 141, 96
	.BYTE 141, 96, 141, 115
	.BYTE 141, 115, 137, 115
	.BYTE 137, 115, 133, 115
	.BYTE 133, 115, 133, 96
	; path
	.BYTE 161, 116, 154, 113
	.BYTE 154, 113, 148, 107
	.BYTE 148, 107, 145, 100
	.BYTE 145, 100, 145, 92
	.BYTE 145, 92, 147, 88
	.BYTE 147, 88, 150, 84
	.BYTE 150, 84, 157, 78
	.BYTE 157, 78, 164, 77
	.BYTE 164, 77, 171, 77
	.BYTE 171, 77, 180, 83
	.BYTE 180, 83, 184, 88
	.BYTE 184, 88, 185, 93
	.BYTE 185, 93, 185, 101
	.BYTE 185, 101, 181, 109
	.BYTE 181, 109, 174, 114
	.BYTE 174, 114, 166, 116
	.BYTE 166, 116, 161, 116
	; path
	.BYTE 169, 107, 173, 105
	.BYTE 173, 105, 175, 102
	.BYTE 175, 102, 177, 96
	.BYTE 177, 96, 175, 90
	.BYTE 175, 90, 171, 86
	.BYTE 171, 86, 162, 85
	.BYTE 162, 85, 159, 87
	.BYTE 159, 87, 156, 89
	.BYTE 156, 89, 154, 93
	.BYTE 154, 93, 154, 97
	.BYTE 154, 97, 155, 103
	.BYTE 155, 103, 159, 106
	.BYTE 159, 106, 163, 108
	.BYTE 163, 108, 169, 107
	; path
	.BYTE 189, 96, 189, 78
	.BYTE 189, 78, 193, 78
	.BYTE 193, 78, 197, 78
	.BYTE 197, 78, 198, 79
	.BYTE 198, 79, 202, 84
	.BYTE 202, 84, 205, 88
	.BYTE 205, 88, 208, 92
	.BYTE 208, 92, 212, 96
	.BYTE 212, 96, 214, 98
	.BYTE 214, 98, 216, 101
	.BYTE 216, 101, 217, 90
	.BYTE 217, 90, 217, 78
	.BYTE 217, 78, 221, 78
	.BYTE 221, 78, 225, 78
	.BYTE 225, 78, 225, 96
	.BYTE 225, 96, 225, 115
	.BYTE 225, 115, 221, 115
	.BYTE 221, 115, 218, 115
	.BYTE 218, 115, 217, 114
	.BYTE 217, 114, 213, 109
	.BYTE 213, 109, 210, 106
	.BYTE 210, 106, 207, 102
	.BYTE 207, 102, 202, 97
	.BYTE 202, 97, 199, 92
	.BYTE 199, 92, 198, 91
	.BYTE 198, 91, 197, 103
	.BYTE 197, 103, 197, 115
	.BYTE 197, 115, 193, 115
	.BYTE 193, 115, 189, 115
	.BYTE 189, 115, 189, 96
	; path
	.BYTE 238, 116, 234, 114
	.BYTE 234, 114, 230, 112
	.BYTE 230, 112, 228, 110
	.BYTE 228, 110, 232, 105
	.BYTE 232, 105, 233, 104
	.BYTE 233, 104, 234, 105
	.BYTE 234, 105, 239, 108
	.BYTE 239, 108, 244, 107
	.BYTE 244, 107, 246, 104
	.BYTE 246, 104, 245, 101
	.BYTE 245, 101, 238, 98
	.BYTE 238, 98, 233, 96
	.BYTE 233, 96, 230, 91
	.BYTE 230, 91, 231, 85
	.BYTE 231, 85, 233, 81
	.BYTE 233, 81, 236, 78
	.BYTE 236, 78, 239, 77
	.BYTE 239, 77, 243, 77
	.BYTE 243, 77, 247, 77
	.BYTE 247, 77, 251, 79
	.BYTE 251, 79, 253, 80
	.BYTE 253, 80, 253, 81
	.BYTE 253, 81, 251, 84
	.BYTE 251, 84, 250, 87
	.BYTE 250, 87, 248, 86
	.BYTE 248, 86, 244, 84
	.BYTE 244, 84, 239, 88
	.BYTE 239, 88, 240, 90
	.BYTE 240, 90, 242, 91
	.BYTE 242, 91, 246, 92
	.BYTE 246, 92, 253, 96
	.BYTE 253, 96, 255, 105
	.BYTE 255, 105, 254, 108
	.BYTE 254, 108, 252, 111
	.BYTE 252, 111, 250, 114
	.BYTE 250, 114, 246, 115
	.BYTE 246, 115, 242, 116
	.BYTE 242, 116, 238, 116
	; path
	.BYTE 47, 58, 43, 65
	.BYTE 43, 65, 38, 62
	.BYTE 38, 62, 34, 63
	.BYTE 34, 63, 32, 65
	.BYTE 32, 65, 33, 67
	.BYTE 33, 67, 41, 71
	.BYTE 41, 71, 46, 74
	.BYTE 46, 74, 27, 74
	.BYTE 27, 74, 23, 69
	.BYTE 23, 69, 24, 64
	.BYTE 24, 64, 26, 59
	.BYTE 26, 59, 32, 55
	.BYTE 32, 55, 38, 55
	.BYTE 38, 55, 45, 57
	.BYTE 45, 57, 47, 58
	; path
	.BYTE 51, 56, 51, 74
	.BYTE 51, 74, 72, 74
	.BYTE 72, 74, 72, 70
	.BYTE 72, 70, 60, 70
	.BYTE 60, 70, 60, 63
	.BYTE 60, 63, 73, 63
	.BYTE 73, 63, 73, 56
	.BYTE 73, 56, 51, 56
	; path
	.BYTE 100, 59, 95, 65
	.BYTE 95, 65, 90, 62
	.BYTE 90, 62, 86, 63
	.BYTE 86, 63, 85, 65
	.BYTE 85, 65, 85, 68
	.BYTE 85, 68, 93, 71
	.BYTE 93, 71, 98, 74
	.BYTE 98, 74, 79, 74
	.BYTE 79, 74, 76, 69
	.BYTE 76, 69, 76, 64
	.BYTE 76, 64, 78, 59
	.BYTE 78, 59, 84, 55
	.BYTE 84, 55, 91, 55
	.BYTE 91, 55, 97, 57
	.BYTE 97, 57, 100, 59
	; path
	.BYTE 127, 59, 123, 65
	.BYTE 123, 65, 118, 62
	.BYTE 118, 62, 114, 63
	.BYTE 114, 63, 112, 65
	.BYTE 112, 65, 113, 68
	.BYTE 113, 68, 121, 71
	.BYTE 121, 71, 126, 74
	.BYTE 126, 74, 107, 75
	.BYTE 107, 75, 104, 69
	.BYTE 104, 69, 104, 64
	.BYTE 104, 64, 106, 59
	.BYTE 106, 59, 112, 55
	.BYTE 112, 55, 119, 55
	.BYTE 119, 55, 125, 57
	.BYTE 125, 57, 127, 59
	; path
	.BYTE 133, 56, 133, 74
	.BYTE 133, 74, 141, 74
	.BYTE 141, 74, 141, 56
	.BYTE 141, 56, 133, 56
	; path
	.BYTE 145, 74, 146, 67
	.BYTE 146, 67, 150, 61
	.BYTE 150, 61, 157, 56
	.BYTE 157, 56, 164, 55
	.BYTE 164, 55, 170, 55
	.BYTE 170, 55, 177, 58
	.BYTE 177, 58, 182, 63
	.BYTE 182, 63, 185, 69
	.BYTE 185, 69, 185, 74
	.BYTE 185, 74, 176, 74
	.BYTE 176, 74, 176, 70
	.BYTE 176, 70, 175, 68
	.BYTE 175, 68, 173, 66
	.BYTE 173, 66, 171, 64
	.BYTE 171, 64, 168, 63
	.BYTE 168, 63, 165, 63
	.BYTE 165, 63, 162, 63
	.BYTE 162, 63, 158, 65
	.BYTE 158, 65, 155, 68
	.BYTE 155, 68, 154, 73
	.BYTE 154, 73, 153, 74
	.BYTE 153, 74, 145, 74
	; path
	.BYTE 189, 74, 198, 74
	.BYTE 198, 74, 198, 69
	.BYTE 198, 69, 203, 74
	.BYTE 203, 74, 213, 74
	.BYTE 213, 74, 197, 55
	.BYTE 197, 55, 189, 55
	.BYTE 189, 55, 189, 74
	; path
	.BYTE 217, 56, 217, 74
	.BYTE 217, 74, 225, 74
	.BYTE 225, 74, 225, 56
	.BYTE 225, 56, 217, 56
	; path
	.BYTE 253, 58, 249, 65
	.BYTE 249, 65, 244, 62
	.BYTE 244, 62, 240, 63
	.BYTE 240, 63, 238, 65
	.BYTE 238, 65, 239, 67
	.BYTE 239, 67, 247, 71
	.BYTE 247, 71, 252, 74
	.BYTE 252, 74, 233, 74
	.BYTE 233, 74, 230, 69
	.BYTE 230, 69, 230, 63
	.BYTE 230, 63, 232, 59
	.BYTE 232, 59, 238, 55
	.BYTE 238, 55, 245, 55
	.BYTE 245, 55, 251, 57
	.BYTE 251, 57, 253, 58
	; path
	.BYTE 22, 133, 27, 127
	.BYTE 27, 127, 34, 131
	.BYTE 34, 131, 38, 130
	.BYTE 38, 130, 39, 128
	.BYTE 39, 128, 40, 125
	.BYTE 40, 125, 33, 121
	.BYTE 33, 121, 26, 119
	.BYTE 26, 119, 47, 119
	.BYTE 47, 119, 48, 124
	.BYTE 48, 124, 48, 130
	.BYTE 48, 130, 46, 134
	.BYTE 46, 134, 40, 138
	.BYTE 40, 138, 33, 138
	.BYTE 33, 138, 27, 136
	.BYTE 27, 136, 22, 133
	; path
	.BYTE 52, 137, 52, 118
	.BYTE 52, 118, 72, 118
	.BYTE 72, 118, 72, 123
	.BYTE 72, 123, 61, 123
	.BYTE 61, 123, 61, 130
	.BYTE 61, 130, 73, 130
	.BYTE 73, 130, 73, 137
	.BYTE 73, 137, 52, 137
	; path
	.BYTE 75, 133, 79, 127
	.BYTE 79, 127, 86, 131
	.BYTE 86, 131, 90, 130
	.BYTE 90, 130, 92, 128
	.BYTE 92, 128, 92, 125
	.BYTE 92, 125, 85, 121
	.BYTE 85, 121, 78, 119
	.BYTE 78, 119, 99, 119
	.BYTE 99, 119, 101, 124
	.BYTE 101, 124, 100, 130
	.BYTE 100, 130, 98, 134
	.BYTE 98, 134, 92, 138
	.BYTE 92, 138, 86, 138
	.BYTE 86, 138, 79, 136
	.BYTE 79, 136, 75, 133
	; path
	.BYTE 102, 133, 107, 127
	.BYTE 107, 127, 114, 131
	.BYTE 114, 131, 118, 130
	.BYTE 118, 130, 119, 128
	.BYTE 119, 128, 120, 125
	.BYTE 120, 125, 113, 121
	.BYTE 113, 121, 106, 119
	.BYTE 106, 119, 127, 119
	.BYTE 127, 119, 128, 124
	.BYTE 128, 124, 128, 130
	.BYTE 128, 130, 126, 134
	.BYTE 126, 134, 120, 138
	.BYTE 120, 138, 113, 138
	.BYTE 113, 138, 107, 136
	.BYTE 107, 136, 102, 133
	; path
	.BYTE 133, 119, 133, 138
	.BYTE 133, 138, 141, 138
	.BYTE 141, 138, 141, 119
	.BYTE 141, 119, 133, 119
	; path
	.BYTE 145, 119, 146, 126
	.BYTE 146, 126, 150, 133
	.BYTE 150, 133, 157, 137
	.BYTE 157, 137, 164, 139
	.BYTE 164, 139, 170, 138
	.BYTE 170, 138, 177, 135
	.BYTE 177, 135, 182, 131
	.BYTE 182, 131, 185, 125
	.BYTE 185, 125, 185, 119
	.BYTE 185, 119, 176, 119
	.BYTE 176, 119, 176, 123
	.BYTE 176, 123, 175, 125
	.BYTE 175, 125, 173, 127
	.BYTE 173, 127, 171, 129
	.BYTE 171, 129, 168, 130
	.BYTE 168, 130, 165, 130
	.BYTE 165, 130, 162, 130
	.BYTE 162, 130, 158, 128
	.BYTE 158, 128, 155, 125
	.BYTE 155, 125, 154, 120
	.BYTE 154, 120, 153, 119
	.BYTE 153, 119, 145, 119
	; path
	.BYTE 189, 119, 189, 137
	.BYTE 189, 137, 197, 137
	.BYTE 197, 137, 197, 119
	.BYTE 197, 119, 189, 119
	; path
	.BYTE 226, 119, 216, 119
	.BYTE 216, 119, 216, 124
	.BYTE 216, 124, 212, 119
	.BYTE 212, 119, 202, 119
	.BYTE 202, 119, 218, 138
	.BYTE 218, 138, 225, 138
	.BYTE 225, 138, 226, 119
	; path
	.BYTE 228, 133, 233, 127
	.BYTE 233, 127, 240, 131
	.BYTE 240, 131, 244, 130
	.BYTE 244, 130, 246, 128
	.BYTE 246, 128, 246, 125
	.BYTE 246, 125, 239, 121
	.BYTE 239, 121, 232, 119
	.BYTE 232, 119, 253, 119
	.BYTE 253, 119, 254, 124
	.BYTE 254, 124, 254, 129
	.BYTE 254, 129, 252, 134
	.BYTE 252, 134, 246, 138
	.BYTE 246, 138, 239, 138
	.BYTE 239, 138, 233, 136
	.BYTE 233, 136, 228, 133
	.BYTE 0,0,0,0


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; shapes
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

shape_flyby_1:
	BYTE 10,115,14,119
	BYTE 40,82,44,87
	BYTE 118,51,119,59
	BYTE 189,66,185,70
	BYTE 198,114,192,112
	BYTE 160,132,162,125
	BYTE 126,113,134,110
	BYTE 130,83,135,88
	BYTE 199,71,201,63
	BYTE 224,105,234,107
	BYTE 186,149,187,154
	BYTE 120,137,112,143
	BYTE 114,100,108,96
	BYTE 143,64,141,54
	BYTE 211,71,219,66
	BYTE 212,128,220,132
	BYTE 164,148,160,156
	BYTE 151,111,142,114
	BYTE 177,55,172,50
	BYTE 225,23,218,17
	BYTE 0,0,0,0




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; scanline fill by John Metcalf
; call with d=x-coord, e=y-coord
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; set end marker

fill:
  ld l,255
  push hl

; calculate bit position of pixel

nextrun:
  ld a,d
  and 7
  inc a
  ld b,a
  ld a,1
bitpos:
  rrca
  djnz bitpos
  ld c,b
  ld b,a

; move left until hitting a set pixel or the screen edge

seekleft:
  ld a,d
  or a
  jr z,goright
  dec d
  rlc b
  call scrpos
  jr nz,seekleft

; move right until hitting a set pixel or the screen edge,
; setting pixels as we go. Check rows above and below and
; save their coordinates to fill later if necessary

seekright:  
  rrc b
  inc d
  jr z,rightedge
goright:
  call scrpos
  jr z,rightedge
  ld (hl),a
  inc e
  call checkadj
  dec e
  dec e
  call checkadj
  inc e
  jr seekright

; check to see if there's another row waiting to be filled

rightedge:
  pop de
  ld a,e
  inc a
  jr nz,nextrun
  ret  

; calculate the pixel address and whether or not it's set

scrpos:
  ld a,e
  and 248
  rra
  scf
  rra
  rra
  ld l,a
  xor e
  and 248
  xor e
  ld h,a
  ld a,l
  xor d
  and 7
  xor d
  rrca
  rrca
  rrca
  ld l,a
  ld a,b
  or (hl)
  cp (hl)
  ret

; check and save the coordinates of an adjacent row

checkadj:
  sla c
  ld a,e
  cp 192
  ret nc
  call scrpos+1
  ret z
  inc c
  bit 2,c
  ret nz
  pop hl
  push de
  jp (hl)

polyline_pointer: WORD draw_polyline_empty
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; fischinger_draw_polyline
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
fischinger_draw_polyline:
polyline_speed:
	ld b, 2 ; speed of drawing
draw_polyline_cycle: ; draw logo
	ld hl, (polyline_pointer)
	ld ix, hl
	ld a, (ix+0)
	or a ; check zero
	jr z, no_draw_polyline
	ld a, (ix+1)

	or a ; check zero
	jr z, no_draw_polyline
	ld a, (ix+2)
	ld e, a
	or a
	jr z, no_draw_polyline
	ld a, (ix+3)
	ld d, a
	or a
	jr z, no_draw_polyline
	
	push bc
	ld c, (ix+0)
	ld b, (ix+1)
	;
	; bc = Ya Xa
	; de = Yb Xb
	;
	; b = Ya c = Xa
	; d = Yb e = Xb
	;
	;call page_set_7
	call Draw_Line
	;call page_set_player_page
	pop bc
	
	ld hl, (polyline_pointer)
	inc hl
	inc hl
	inc hl
	inc hl
	ld (polyline_pointer), hl
	
	dec b
	jr nz, draw_polyline_cycle
no_draw_polyline:
	ret


;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt_page_set_7
;;;;;;;;;;;;;;;;;;;;;;;;
interrupt_page_set_7:
	push bc
	; di
	ld a, (flip_mask)
	or 7  ; page 7
	or 16 ; select basic rom
	; ld (stored_paging_byte_address), a ; its interrupt
	ld bc, #7ffd
	out (c),a ; set page 7
	; ei
	pop bc
	ret
	
;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt_page_set_player_page
;;;;;;;;;;;;;;;;;;;;;;;;
; this routine is not used
interrupt_page_set_player_page:
	push de
	push bc
	ld a, (player_page)
	or 16 ; select basic rom
	ld d, a
	;di
	ld a, (flip_mask)
	or d
	; ld (stored_paging_byte_address), a
	ld bc, #7ffd
	out (c),a ; set the page
	;ei
	pop bc
	pop de
	ret

;;;;;;;;;;;;;;;;;
; initSong
; hl,de - address of raw pt3 file
;;;;;;;;;;;;;;;;;
initSong:
	ld hl,music
	ld de,music
	ld a, (turbosound_flip_modules)
	or a
	jr z, initSong_noflip
	ex de, hl
initSong_noflip:
	ld a, (turbosound_setting_byte)
	ld (player+10),a
	     ;set bit0, if you want to play without looping
	     ;(optional);
	     ;set bit1 for PT2 and reset for PT3 before
	     ;calling INIT;
	     ;bits2-3: %00-ABC, %01-ACB, %10-BAC (optional);
	     ;bits4-5: %00-no TS, %01-2 modules TS, %10-
	     ;autodetect PT3 TS-format by AlCo (PT 3.7+);
	     ;Remark: old PT3 TS-format by AlCo (PT 3.6) is not
	     ;documented and must be converted to new standard.
	     ;bit6 is set each time, when loop point of 2nd TS
	     ;module is passed (optional).
	     ;bit7 is set each time, when loop point of 1st TS
	     ;or of single module is passed (optional).
	call player+3
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; vector.asm -- drawing routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	INCLUDE "vector.asm"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; vector_silkscreen.asm -- drawing routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	MODULE silkscreen
	INCLUDE "vector_silkscreen.asm"
	ENDMODULE


;;;;;;;;;;;;;;;;;;;;;;;;;
; prerecorded variables here
;;;;;;;;;;;;;;;;;;;;;;;;;

frame_counter: WORD 0
draw_text_pointer: WORD draw_text_empty_byte
draw_text_screen_address: WORD $4000
draw_text_empty_byte: BYTE '$'
turbosound_setting_byte: BYTE 00010001b ; turbosound enabled
turbosound_flip_modules: BYTE 0

;
; end of code
;
code_end:

; variables here (moved to 5ccb)
vars: EQU $5ccb
	; 8 bytes
upper_point_lower_point: EQU vars + 8
	; 2 bytes
upper_point_x: EQU upper_point_lower_point + 2
	; 1 byte
silk_header: EQU upper_point_x + 1
	; 2 bytes
silk_data: EQU silk_header + 2
	; 192*2 bytes
silk_end: EQU silk_data + 192*2
drawing_code_vault: EQU silk_end
	; 13384 bytes
wraparound_area: EQU drawing_code_vault + 13384
	; 16 bytes
drawing_code_vault_end: EQU wraparound_area + 16

shedule_6000: EQU drawing_code_vault_end
shedule_size: EQU 180
shedule_entry_size: EQU 9
	; 9 * 100 bytes ; [hl register] [drawing code] [ret patch] [enable] [frame number]
erase_queue_6000: EQU shedule_6000 + shedule_entry_size * shedule_size
erase_queue_size: EQU 32
	; 32 * 6 ; [hl register] [drawing code] [ret patch]
erase_queue_end: EQU erase_queue_6000 + erase_queue_size * 6
machine_stack: EQU erase_queue_end
	; stack size 128
machine_stack_end: EQU machine_stack + 128



;;;;;;;;;;;;;;;;;;;;;;;;
; music code here
;;;;;;;;;;;;;;;;;;;;;;;;
	ORG $c000 ; it will be loaded from tape by loader
	; loader will decide to load this big piece if RAM paging is available
	; TODO or just load it anyway and then wipe it
player:
	MODULE ptsplay
	include "PTSPlay.asm"
	ENDMODULE
music:
	incbin "m.pt3"

	
player_n_shapes_end:



  EMPTYTAP "nikhotmsk_sessions_code.tap"
  SAVETAP "nikhotmsk_sessions_code.tap",CODE,"usr40960",code_start,code_end - code_start,code_start
  SAVETAP "nikhotmsk_sessions_code.tap",CODE,"ptsplay",player,player_n_shapes_end - player, player
  
  ; basic loader will be concatenated later by make.sh script

	; debug messages to the console of compiler
	DISPLAY "variables free space before $a000: ", /A, $a000 - machine_stack_end
	DISPLAY "variables free space before $ffff page 4: ", /A, $ffff - erase_queue_c000_end
	DISPLAY "free space before $c000: ", /A, $c000 - code_end
	DISPLAY "free space before $ffff: ", /A, $ffff - player_n_shapes_end
	IF code_end < $c000
	; DISPLAY "boundary test succeed"
	ELSE
	DISPLAY "*** WARNING the boundary test failed, to much code ***"
	ENDIF

