format zx81
;labelusenumeric
;LISTOFF

	// hardware options to be set and change defaults in ZX81DEF.INC
	MEMAVL	   =	   MEM_32K	   // can be MEM_1K, MEM_2K, MEM_4K, MEM_8K, MEM_16K, MEM_32K, MEM_48K
	STARTMODE  EQU	   SLOW_MODE	   // SLOW or FAST
	DFILETYPE  EQU	   COLLAPSED	   // COLLAPSED or EXPANDED or AUTO

	include '..\..\SINCL-ZX\ZX81.INC'	 // definitions of constants
;LISTON
10 REM _hide _asm
scr_x_res	equ	32	;resolution in bytes
scr_y_res	equ	160	;nr of lines per field (because of interlace)
scr_start	equ	PICTURE//17*1024-64 ;start address of screen-buffer
PAL		equ	312
NTSC		equ	262
tv_std		equ	PAL//15700/75
vsync_lines	equ	4
top_blank_lines equ	(tv_std - scr_y_res - vsync_lines) / 2
bottom_blank_lines	equ	tv_std - scr_y_res - vsync_lines - top_blank_lines
VSYNC_DELAY	equ	0
VSYNC_NOPS	equ	207 * 233 / 400  //VSYNC ~2.33 rasters

ENABLE_HIRES:
	LD	HL,$4034	;FRAMES counter
	LD	A,(HL)		;get old FRAMES
SYNC1:
	CP	(HL)		;compare to new FRAMES
	JR	Z,SYNC1 	;exit after a change is detected
	LD	IX,WRX16I	;simple start of the hires mode
	//clear screen
	ld	hl,scr_start
	ld	bc,scr_x_res * scr_y_res * 3
.CLEAR_LOOP:
	ld	(hl),0
	inc	hl
	dec	bc
	ld	a,b
	add	a,c
	jp	nz,.CLEAR_LOOP
	//fill screen with steps
;        ld      hl,scr_start
;        ld      bc,scr_y_res * 3
;        ld      de, scr_x_res + 1
;.loop:
;        ld      a,255
;        ld      (hl),a
;        add     hl,de
;        dec     bc
;        ld      a,b
;        add     a,c
;        jp      nz,.loop
	//repeat forever
	jp	$

DISABLE_HIRES:
	LD	A,$1E		;SINCLAIR ROM pattern table MSB base address (1E00)
	LD	I,A		;pointer to I register
	LD	IX,$0281	;simple end of the hires mode
	RET

lbuf:	ld	r,a		;load hfile address lsb
	repeat 32
	    nop
	end repeat
	ret	nz

WRX16I:
gen_vsync0:
	repeat VSYNC_DELAY
	    nop
	end repeat		;syncronize the VSYNC-start
	in	a,($fe) 	;VSYNC on
vsync_delay0:
	repeat VSYNC_NOPS
	    nop
	end repeat
	out	($fe),a 	;VSYNC off, NMI-generator on
prepare_top_border0:
	ld	a,top_blank_lines
	neg
	inc	a
	ex	af,af'
	ld	ix,gen_hires0
	pop	hl
	pop	de
	pop	bc
	pop	af
	ret			;return to do some useful work, and generate bottom blank lines

gen_vsync1:
	repeat VSYNC_DELAY + 17 + 17
	    nop
	end repeat		;syncronize the VSYNC-start
	in	a,($fe) 	;VSYNC on
vsync_delay1:
	repeat VSYNC_NOPS
	    nop
	end repeat
	out	($fe),a 	;VSYNC off, NMI-generator on
prepare_top_border1:
	ld	a,top_blank_lines
	neg
	inc	a
	ex	af,af'
	ld	ix,gen_hires1
	pop	hl
	pop	de
	pop	bc
	pop	af
	ret			;return to do some useful work, and generate bottom blank lines

gen_vsync2:
	repeat VSYNC_DELAY + 17
	    nop
	end repeat		;syncronize the VSYNC-start
	in	a,($fe) 	;VSYNC on
vsync_delay2:
	repeat VSYNC_NOPS
	    nop
	end repeat
	out	($fe),a 	;VSYNC off, NMI-generator on
prepare_top_border2:
	ld	a,top_blank_lines
	neg
	inc	a
	ex	af,af'
	ld	ix,gen_hires2
	pop	hl
	pop	de
	pop	bc
	pop	af
	ret			;return to do some useful work, and generate bottom blank lines

gen_hires0:
	nop
	nop
	ld	b,7
hr_delay0:
	djnz	hr_delay0	;delay to synchronize picture-start
	dec	b		;reset Z-flag
	ld	hl,scr_start	;start of hires-screen
	ld	de,scr_x_res * 3
	ld	b,scr_y_res
hr10:
	ld	a,h
	ld	i,a
	ld	a,l
	call	lbuf+$8000	;start generating the hires-screen
	add	hl,de		;point to next hires-line
	dec	b
	jp	nz,hr10 	;repeat until last line is done
prepare_bottom_border0:
	ld	ix,gen_vsync1
field_set0:
	ld	a,bottom_blank_lines
	neg
	inc	a
	ex	af,af'
	out	($fe),a 	;NMI-generator on
	pop	hl
	pop	de
	pop	bc
	pop	af
	ret			;return to do some useful work, and generate bottom blank lines

gen_hires1:
	nop
	nop
	ld	b,7
hr_delay1:
	djnz	hr_delay1	;delay to synchronize picture-start
	dec	b		;reset Z-flag
	ld	hl,scr_start + scr_x_res    ;start of hires-screen
	ld	de,scr_x_res * 3
	ld	b,scr_y_res
hr11:
	ld	a,h
	ld	i,a
	ld	a,l
	call	lbuf+$8000	;start generating the hires-screen
	add	hl,de		;point to next hires-line
	dec	b
	jp	nz,hr11 	;repeat until last line is done
prepare_bottom_border1:
	ld	ix,gen_vsync2
field_set1:
	ld	a,bottom_blank_lines
	neg
	inc	a
	ex	af,af'
	out	($fe),a 	;NMI-generator on
	pop	hl
	pop	de
	pop	bc
	pop	af
	ret			;return to do some useful work, and generate bottom blank lines

gen_hires2:
	nop
	nop
	ld	b,7
hr_delay2:
	djnz	hr_delay2	;delay to synchronize picture-start
	dec	b		;reset Z-flag
	ld	hl,scr_start + scr_x_res + scr_x_res	;start of hires-screen
	ld	de,scr_x_res * 3
	ld	b,scr_y_res
hr12:
	ld	a,h
	ld	i,a
	ld	a,l
	call	lbuf+$8000	;start generating the hires-screen
	add	hl,de		;point to next hires-line
	dec	b
	jp	nz,hr12 	;repeat until last line is done
prepare_bottom_border2:
	ld	ix,gen_vsync0
field_set2:
	ld	a,bottom_blank_lines
	neg
	inc	a
	ex	af,af'
	out	($fe),a 	;NMI-generator on
	pop	hl
	pop	de
	pop	bc
	pop	af
	ret			;return to do some useful work, and generate bottom blank lines

PICTURE:
	file 'lena.bmp':146

	END _asm

AUTORUN:
	RAND USR #ENABLE_HIRES

	include '..\..\SINCL-ZX\ZX81POST.INC'	       ; include D_FILE and needed memory areas
assert ($-MEMST)<MEMAVL
// end of program