# -*- coding: utf-8 -*-
# Uses Python 3
# NollKollTroll December 2017

from PIL import Image
import numpy, random

# Change the name of the picture here
inputImageFile = Image.open('metropolis.png', 'r')
imageSize = inputImageFile.size
imageSizeX, imageSizeY = imageSize

print(str(imageSizeX) + 'x' + str(imageSizeY) + ':' + str(inputImageFile.mode))

idealImage = inputImageFile.load()

outputImage = Image.new('L', imageSize)

# Change ROM-size here
ROM_SIZE = 4096#8192
NR_OF_FONT_TABLES = ROM_SIZE / 512
# And which ROM to use here
romFile = open('ZX80.rom', 'rb')
romArray = numpy.ndarray(ROM_SIZE, numpy.uint8)
romArray = romFile.read(ROM_SIZE)
romFile.close()

romDataTable = numpy.zeros((NR_OF_FONT_TABLES, 256), numpy.uint8)
romIndexTable = numpy.zeros((NR_OF_FONT_TABLES, 256), numpy.uint8)
romBitFaultTable = numpy.zeros((NR_OF_FONT_TABLES, 256), numpy.uint8)

def bitCount(value):
    count = 0
    while (value > 0):
        if((value & 1) == 1):
            count += 1
        value >>= 1
    return count

def countSections(data):
    sections = 1
    for i in range(7):
        if((data >> i & 1) != (data >> (i + 1) & 1)):
            sections += 1
    return sections

charTable = list(range(64))
def getRomByteRaw(wantedByte, patternTable):
    errorBitsBest = 8
    random.shuffle(charTable)
    for z in charTable:
        romByte = romArray[patternTable + (z * 8)] ^ 255
        for i in range(2):
            romByte = romByte ^ (i * 255)
            if(wantedByte == romByte):   
                returnIndex = z | (i * 128)                
                return 0, wantedByte, returnIndex
            else:
                errorByte = romByte ^ wantedByte
                errorBits = bitCount(errorByte)
                if (errorBits < errorBitsBest):
                    errorBitsBest = errorBits
                    returnByte = romByte
                    returnIndex = z | (i * 128)
    return errorBitsBest, returnByte, returnIndex
                        
def generateRomTables(patternTable):
    for i in range(256):
        romBitFaultTable[patternTable / 512, i], romDataTable[patternTable / 512, i], romIndexTable[patternTable / 512, i] = getRomByteRaw(i, patternTable)
    return
                
def getRomByte(wantedByte, patternTable):
    return romBitFaultTable[patternTable / 512, wantedByte], romDataTable[patternTable / 512, wantedByte], romIndexTable[patternTable / 512, wantedByte]

#for patternTable in range(0, 8192, 512):
#    generateRomTables(patternTable)
#print('Patterntables generated')

# Use full range search to get ALL font-tables to decide which looks best
#for pictureTable in range(0, ROM_SIZE, 512): 
# Then insert the one table that looks best here to generate the final picture
for pictureTable in range(0x600, 0x601, 512):
    picByte = 0
    picError = numpy.zeros((imageSizeX + 2, 2), numpy.float64)
    
    tempData = numpy.zeros(10, numpy.uint8)
    tempError = numpy.zeros((10, 2), numpy.float64)
    totalErrors = 0
    totalCorrectBytes = 0
    pseudoPictureIndex = numpy.zeros((imageSizeX/8, imageSizeY), dtype=numpy.uint8)
    for y in range(imageSizeY):
        picError[:,0] = picError[:,1]
        picError[:,1] = 0
        for x in range(imageSizeX):
            tempX = (x & 7) + 1
            if (x & 7 == 0):
                tempData[:] = 0
                tempError[:, 0] = picError[x:x + 10, 0]
                tempError[:, 1] = picError[x:x + 10, 1]
            idealPixel = idealImage[x, y] + tempError[tempX, 0]
            if (idealPixel > 128):
                newPixel = 255
            else:
                newPixel = 0
            tempData[tempX] = newPixel
            quantError = idealPixel - newPixel
            tempError[tempX + 1, 0] += (quantError * 7 / 16)
            tempError[tempX + 1, 1] += (quantError * 1 / 16)
            tempError[tempX    , 1] += (quantError * 5 / 16)     
            tempError[tempX - 1, 1] += (quantError * 3 / 16)      
            if (x & 7 == 7):
                #create tempByte
                tempByte = 0
                for i in range(8):
                    if (tempData[i + 1] == 0):
                        tempByte = (tempByte << 1) & 254
                    else:
                        tempByte = (tempByte << 1) | 1    
                errorBits, romByte, romIndex = getRomByteRaw(tempByte, pictureTable)            
                if (errorBits == 0):
                    totalCorrectBytes += 1
                else:
                    totalErrors += errorBits
                    tempData[:] = 0
                    tempError[:, 0] = picError[x - 7:x + 3, 0]
                    tempError[:, 1] = picError[x - 7:x + 3, 1]
                    for pseudoX in range(x - 7, x + 1):
                        tempX = (pseudoX & 7) + 1
                        idealPixel = idealImage[pseudoX, y] + tempError[tempX, 0]
                        pseudoPixel = ((romByte >> (8 - tempX)) & 1) * 255
                        tempData[tempX] = pseudoPixel
                        quantError = idealPixel - pseudoPixel
                        tempError[tempX + 1, 0] += (quantError * 7 / 16)
                        tempError[tempX + 1, 1] += (quantError * 1 / 16)
                        tempError[tempX    , 1] += (quantError * 5 / 16)     
                        tempError[tempX - 1, 1] += (quantError * 3 / 16)                      
                for i in range(8):
                    outputImage.putpixel((x - 7 + i, y), int(tempData[i + 1]))
                picError[x - 7:x + 3, 0] = tempError[:, 0]
                picError[x - 7:x + 3, 1] = tempError[:, 1] 
                pseudoPictureIndex[x / 8, y] = romIndex
    print(hex(pictureTable) +  ': ' + str(totalCorrectBytes) + ' ' + str(totalErrors))    
    outputImage.show()
    
print(';pseudoHires picture data ##########')
for y in range(imageSizeY):
    print('\tdb\t', sep='', end='')
    for x in range(int(imageSizeX / 8)):
        print(str(pseudoPictureIndex[x, y]), sep=None, end=', ')
    print('LINE_256_END')
