//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

/////////////////////////////////////////////////////////////////////////////
// Based upon:
//
// Approximate Math Library for SSE / SSE2
//  Header File
//  Version 2.0
//  Author Alex Klimovitski, Intel GmbH
/////////////////////////////////////////////////////////////////////////////
#include <emmintrin.h>

#include "AMaths.h"
#include "AMaths_internal.h"

#ifdef AMATHS_ASM

__m128 __declspec(naked) __stdcall am_atan_ss(__m128 x)  // any x
{
	__asm
	{
		movss	xmm1, _ps_am_sign_mask
		rcpss	xmm4, xmm0
		orps	xmm1, xmm0
		movss	xmm6, xmm4
		comiss	xmm1, _ps_am_m1
		movss	xmm3, _ps_atan_t0
		jc		l_big  // 'c' is 'lt' for comiss

		movss	xmm2, xmm0
		mulss	xmm2, xmm2

		movss	xmm1, _ps_atan_s0
		addss	xmm1, xmm2

		movss	xmm7, _ps_atan_s1
		rcpss	xmm1, xmm1
		mulss	xmm1, xmm3
		movss	xmm3, _ps_atan_t1
		addss	xmm7, xmm2
		addss	xmm1, xmm7
			
		movss	xmm7, _ps_atan_s2
		rcpss	xmm1, xmm1
		mulss	xmm1, xmm3
		movss	xmm3, _ps_atan_t2
		addss	xmm7, xmm2
		addss	xmm1, xmm7

		movss	xmm7, _ps_atan_s3
		rcpss	xmm1, xmm1
		mulss	xmm1, xmm3
		movss	xmm3, _ps_atan_t3
		addss	xmm7, xmm2
		mulss	xmm0, xmm3
		addss	xmm1, xmm7

		rcpss	xmm1, xmm1
		mulss	xmm0, xmm1

		ret		16

l_big:
		mulss	xmm6, xmm6

		movss	xmm5, _ps_atan_s0
		addss	xmm5, xmm6

		movss	xmm7, _ps_atan_s1
		rcpss	xmm5, xmm5
		mulss	xmm5, xmm3
		movss	xmm3, _ps_atan_t1
		addss	xmm7, xmm6
		addss	xmm5, xmm7

		movss	xmm7, _ps_atan_s2
		rcpss	xmm5, xmm5
		mulss	xmm5, xmm3
		movss	xmm3, _ps_atan_t2
		addss	xmm7, xmm6
		addss	xmm5, xmm7

		movss	xmm7, _ps_atan_s3
		rcpss	xmm5, xmm5
		mulss	xmm5, xmm3
		movss	xmm3, _ps_atan_t3
		addss	xmm7, xmm6
		movss	xmm2, _ps_am_sign_mask
		mulss	xmm4, xmm3
		addss	xmm5, xmm7

		movss	xmm7, _ps_am_pi_o_2
		rcpss	xmm5, xmm5
		mulss	xmm5, xmm4

		andps	xmm0, xmm2
		orps	xmm0, xmm7
		subss	xmm0, xmm5

		ret		16
	}
}

#endif