//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

/////////////////////////////////////////////////////////////////////////////
// Based upon:
//
// Approximate Math Library for SSE / SSE2
//  Header File
//  Version 2.0
//  Author Alex Klimovitski, Intel GmbH
/////////////////////////////////////////////////////////////////////////////
#include <emmintrin.h>

#include "AMaths.h"
#include "AMaths_internal.h"

#ifdef AMATHS_ASM

__m128 __declspec(naked) __stdcall am_cos_eps(__m128 x)  // any x
{
	__asm
	{
		andps	xmm0, _ps_am_inv_sign_mask
		addps	xmm0, _ps_am_pi_o_2
		mulps	xmm0, _ps_am_2_o_pi

		pxor	xmm3, xmm3
		movdqa	xmm5, _epi32_1
		movaps	xmm4, _ps_am_1
		cvttps2dq	xmm2, xmm0
		pand	xmm5, xmm2
		pcmpeqd	xmm5, xmm3
		cvtdq2ps	xmm6, xmm2
		pand	xmm2, _epi32_2
		pslld	xmm2, (31 - 1)

		subps	xmm0, xmm6
		minps	xmm0, xmm4
		subps	xmm4, xmm0
		andps	xmm0, xmm5
		andnps	xmm5, xmm4
		orps	xmm0, xmm5

		movaps	xmm1, xmm0
		mulps	xmm0, xmm0
		orps	xmm1, xmm2
		movaps	xmm7, xmm0
		mulps	xmm0, _ps_sincos_p3
		addps	xmm0, _ps_sincos_p2
		mulps	xmm0, xmm7
		addps	xmm0, _ps_sincos_p1
		mulps	xmm0, xmm7
		addps	xmm0, _ps_sincos_p0
		mulps	xmm0, xmm1

		ret		16
	}
}

#endif