//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

/////////////////////////////////////////////////////////////////////////////
// Based upon:
//
// Approximate Math Library for SSE / SSE2
//  Header File
//  Version 2.0
//  Author Alex Klimovitski, Intel GmbH
/////////////////////////////////////////////////////////////////////////////
#include <emmintrin.h>

#include "AMaths.h"
#include "AMaths_internal.h"

#ifdef AMATHS_ASM

__m128 __declspec(naked) __stdcall am_cos_ps(__m128 x)  // any x
{
	__asm
	{
		andps	xmm0, _ps_am_inv_sign_mask
		mov		ecx, esp
		addps	xmm0, _ps_am_pi_o_2
		mulps	xmm0, _ps_am_2_o_pi
		and		ecx, ~15

		movhlps	xmm2, xmm0
		cvttps2pi	mm0, xmm0
		movq	mm2, mm0
		cvttps2pi	mm1, xmm2
		pslld	mm2, (31 - 1)
		movq	mm3, mm1
		pslld	mm3, (31 - 1)
		pand	mm2, _pi32_0x80000000
		movq	[ecx - 32], mm2
		pand	mm3, _pi32_0x80000000
		movq	[ecx - 32 + 8], mm3

		cvtpi2ps	xmm4, mm1
		pand	mm1, _pi32_1
		ASM_MOVE_L2H(xmm4)
		pxor	mm7, mm7
		movaps	xmm5, _ps_am_1
		cvtpi2ps	xmm4, mm0
		pand	mm0, _pi32_1
		pcmpeqd	mm1, mm7
		subps	xmm0, xmm4
		movq	[ecx - 16 + 8], mm1
		minps	xmm0, xmm5
		pcmpeqd	mm0, mm7
		subps	xmm5, xmm0
		movq	[ecx - 16], mm0

		movaps	xmm6, [ecx - 16]
		andps	xmm0, xmm6
		andnps	xmm6, xmm5
		movaps	xmm3, _ps_sincos_p3
		orps	xmm0, xmm6

		movaps	xmm5, _ps_sincos_p2
		movaps	xmm1, xmm0
		mulps	xmm0, xmm0
		movaps	xmm7, [ecx - 32]
		movaps	xmm2, xmm0
		mulps	xmm0, xmm3
		movaps	xmm3, _ps_sincos_p1
		addps	xmm0, xmm5
		movaps	xmm5, _ps_sincos_p0
		mulps	xmm0, xmm2
		addps	xmm0, xmm3
		mulps	xmm0, xmm2
		orps	xmm1, xmm7
		addps	xmm0, xmm5
		mulps	xmm0, xmm1

		ret		16
	}
}

#endif