//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

/////////////////////////////////////////////////////////////////////////////
// Based upon:
//
// Approximate Math Library for SSE / SSE2
//  Header File
//  Version 2.0
//  Author Alex Klimovitski, Intel GmbH
/////////////////////////////////////////////////////////////////////////////
#include <emmintrin.h>

#include "AMaths.h"
#include "AMaths_internal.h"

#ifdef AMATHS_ASM

__m128 __declspec(naked) __stdcall am_log_eps(__m128 x)
{
	__asm
	{
		maxps	xmm0, _ps_am_min_norm_pos  // cut off denormalized stuff
		movaps	xmm1, _ps_am_1
		movaps	xmm3, xmm0

		andps	xmm0, _ps_am_inv_mant_mask
		orps	xmm0, xmm1

		movaps	xmm4, xmm0
		subps	xmm0, xmm1
		addps	xmm4, xmm1
		psrld	xmm3, 23
		rcpps	xmm4, xmm4
		mulps	xmm0, xmm4
		psubd	xmm3, _epi32_0x7f
		addps	xmm0, xmm0

		movaps	xmm2, xmm0
		mulps	xmm0, xmm0

		movaps	xmm4, _ps_log_p0
		movaps	xmm6, _ps_log_q0

		mulps	xmm4, xmm0
		movaps	xmm5, _ps_log_p1
		mulps	xmm6, xmm0
		movaps	xmm7, _ps_log_q1

		addps	xmm4, xmm5
		addps	xmm6, xmm7

		movaps	xmm5, _ps_log_p2
		mulps	xmm4, xmm0
		movaps	xmm7, _ps_log_q2
		mulps	xmm6, xmm0

		addps	xmm4, xmm5
		movaps	xmm5, _ps_log_c0
		addps	xmm6, xmm7
		cvtdq2ps	xmm1, xmm3

		mulps	xmm0, xmm4
		rcpps	xmm6, xmm6

		mulps	xmm0, xmm6
		mulps	xmm0, xmm2

		mulps	xmm1, xmm5

		addps	xmm0, xmm2
		addps	xmm0, xmm1

		ret		16
	}
}

#endif