//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#ifndef _NULSTEIN_GFX_H_
#define _NULSTEIN_GFX_H_

class CRenderTarget;
class CViewport;
class CGfx;
class CLight;
class CMesh;

#include <d3d9.h>

#include "Misc/Defines.h"

#include "PSHBasic.h"
#include "VSHBasic.h"

class CGfx
{
public:
	CGfx();
	
	bool Open(HWND hWnd);
	bool Reset();
	void Close();
	
	bool BeginFrame();
	bool EndFrame();
	
	bool SelectRenderTarget(CRenderTarget* pRenderTarget);
	bool SelectViewport(CViewport* pViewport);
	bool SetLights(const CLight* Lights, unsigned Count);
	bool SelectAlpha(bool bAlphaEnable);
	
	bool GetRect(RECT* pRect)
	{
		*pRect = m_ClientRect;
		return true;
	}
	
	bool RegisterMesh(CMesh* pMesh)		{return true;}
	void UnregisterMesh(CMesh* pMesh)	{}
	
public:
	bool OnLostDevice();
	bool OnResetDevice();

public: /* internal use */ 
	bool CreateDevice();
	bool DeclareShaders();
	int	 TryMultisample(D3DPRESENT_PARAMETERS* pD3DPP, UINT Adapter, D3DDEVTYPE DeviceType, D3DMULTISAMPLE_TYPE MultiSampleType);
	
public:
	CComPtr<IDirect3D9>			m_spD3D;
	CComPtr<IDirect3DDevice9>	m_spDevice;
	
	CMatrix						m_MtxWorldToCamera;
	CMatrix						m_MtxCameraToScreen;
	CMatrix						m_MtxWorldToScreen;
	
	const CLight*				m_Light;
	unsigned					m_LightCount;
	
	CComPtr<IDirect3DVertexDeclaration9>	m_spVtxDclPN; 
	CPSHBasic					m_PSHBasic;
	CVSHBasic					m_VSHBasic;

	D3DPRESENT_PARAMETERS		m_D3DPP; 
	RECT						m_ClientRect;
	HWND						m_hWnd;
	ULONG						m_BehaviorFlags;
	bool						m_bNeedsReset;
	bool						m_bFullscreen;
};

#endif // _NULSTEIN_GFX_H_