//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#ifndef _NULSTEIN_RETVAL_H_
#define _NULSTEIN_RETVAL_H_

#ifdef _WIN32
typedef __int8                  int8_t;
typedef unsigned __int8         uint8_t;
typedef __int16                 int16_t;
typedef unsigned __int16        uint16_t;
typedef __int32                 int32_t;
typedef unsigned __int32        uint32_t;
typedef __int64                 int64_t;
typedef unsigned __int64        uint64_t;
#endif

//________________________________________________________________________________
inline bool _FAILED(bool b)		{return !b;}

#ifdef _DEBUG

#ifdef _WINBASE_ 
#define DEBUGBREAK DebugBreak();
#else
#define DEBUGBREAK 
#endif

#define STRINGIZE(_a_) #_a_
#define QUOTE(_a_) STRINGIZE(_a_)
#define __FILELINE__ __FILE__ "(" QUOTE(__LINE__) ")" 

void TRACE(const char * format, ...);
#define ASSERT(_condition)	if (_condition) {;} else do {TRACE(__FILELINE__ ": ASSERTION FAILED, %s\n", #_condition); DEBUGBREAK} while(0)

#define IF_FAILED_RETURN(_hr)			if (_FAILED(_hr)) do {TRACE(__FILELINE__ ": FAILED RESULT\n"); DEBUGBREAK return false;	} while(0)
#define IF_FAILED_RETURN_QUIETLY(_hr)	if (_FAILED(_hr)) return false

#else

inline void TRACE(...) {}
#define __FILELINE__
#define ASSERT(_condition) 

#define IF_FAILED_RETURN(_hr)			if (_FAILED(_hr)) return false
#define IF_FAILED_RETURN_QUIETLY(_hr)	if (_FAILED(_hr)) return false

#endif

#define IF_FAILED_ASSERT(_hr)			ASSERT( !_FAILED(_hr) )

#endif //_NULSTEIN_RETVAL_H_