//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#ifndef _NULSTEIN_ENTITYCAMERA_H_
#define _NULSTEIN_ENTITYCAMERA_H_

#include "Gfx/Gfx.h"
#include "Gfx/GfxCamera.h"

#include "Entity.h"

class CEntityCamera : public CEntity
{
public:
	CEntityCamera(CEntitySlot* pSlot);

public:
	virtual bool PreUpdate(CFrame* pFrame, float dt);
	virtual bool Update(CFrame* pFrame, float dt);
	
	virtual bool Draw(CDisplayListAdder* pDL, uint32_t EntityKey, int iView);

	virtual bool Render(CGfx* pGfx, const CDisplayItemKey &Key, uint32_t EntityKey, ULONG Param);
		
public:
	CCamera m_Camera;
};

#endif //_NULSTEIN_ENTITYCAMERA_H_