//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#include "StdAfx.h"
#include "Frame.h"
#include "Entity.h"
#include "EntitySimpleMesh.h"

CEntitySimpleMesh::CEntitySimpleMesh( CEntitySlot* pSlot)
:	CEntity(pSlot)
{
}

bool CEntitySimpleMesh::Init(const CMesh &Mesh, const CTransform &Transform)
{
	m_MeshInstance.m_pMesh	= &Mesh;
	m_Transform				= Transform;
	
	m_RotationSpeed = 0.0f;
	m_Velocity.Set(0.0f, 0.0f, 0.0f);
	
	return true;
}

bool CEntitySimpleMesh::PreUpdate(CFrame* pFrame, float dt)
{
	return true;
}

bool CEntitySimpleMesh::Update(CFrame* pFrame, float dt)
{
	m_Transform.Rot.Angle	+= m_RotationSpeed * dt;
	m_Transform.Pos			+= m_Velocity * dt;
	return true;
}

bool	CEntitySimpleMesh::Draw(CDisplayListAdder* pDL, uint32_t EntityKey, int iView)
{
	bool			bOk;
	
	/* Compute model to world matrix */ 
	m_MeshInstance.m_ModelToWorld.Set(m_Transform);
	
	/* draw instance */ 
	bOk = m_MeshInstance.AddToDisplayList(pDL, EntityKey, iView);
	IF_FAILED_RETURN(bOk);

	return true;
}

bool CEntitySimpleMesh::Render(CGfx* pGfx, const CDisplayItemKey &Key, uint32_t EntityKey, ULONG Param)
{
	bool bOk;
	
	bOk = m_MeshInstance.Render(pGfx, Key, Param);
	IF_FAILED_RETURN(bOk);
		
	return true;
}
