//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#include "StdAfx.h"
#include "Misc/Defines.h"
#include "SonoDLS.h"

CDLSFile::CDLSFile()
{
	m_hSamplesFile		= NULL;
	m_hSamplesMapping	= NULL;
	m_pSamplesMem		= NULL;
	m_Sample			= NULL;
	m_InstrumentCount	= 0;
}


bool CDLSFile::Open(const TCHAR* sPath)
{
	bool	bOk;

	m_InstrumentCount = 0;
	
	{	/* Find GM.DLS. (kudos to iq,  http://in4k.untergrund.net/index.php?title=Reading_gm.dls) */ 
		static char *paths[2] = { "drivers/gm.dls", "drivers/etc/gm.dls" };
		OFSTRUCT	ofs;

		m_hSamplesFile = INVALID_HANDLE_VALUE;
		for(int i=0; m_hSamplesFile==INVALID_HANDLE_VALUE; i++)
		{
			m_hSamplesFile  = (HANDLE)OpenFile( paths[i], &ofs, OF_READ );
		}
		
		if (INVALID_HANDLE_VALUE==m_hSamplesFile) return false;
	}
	
	/* map file in memory */ 
	m_hSamplesMapping = CreateFileMapping(m_hSamplesFile, NULL, PAGE_READONLY, 0,0, NULL);
	if (!m_hSamplesMapping) {Close(); return false;}

	m_pSamplesMem = MapViewOfFile(m_hSamplesMapping, FILE_MAP_READ, 0,0, 0);
	if (!m_pSamplesMem) {Close(); return false;}

	/* parse it */ 
	bOk = Parse( (BYTE*)m_pSamplesMem );
	IF_FAILED_RETURN(bOk);
	
	return true;
}

void CDLSFile::Close()
{
	/* free buffers */ 
	if (m_Sample)
	{
		free(m_Sample);
		m_Sample = NULL;
	}
	
	if (m_Instrument)
	{
		for(int i=0; i<m_InstrumentCount; i++)
		{
			m_Instrument[i].Free();
		}
		
		free(m_Instrument);
		m_Instrument = NULL;
	}
	
	/* unmap file from memory */ 
	UnmapViewOfFile(m_pSamplesMem);
	m_pSamplesMem		= NULL;

	if (m_hSamplesMapping) CloseHandle(m_hSamplesMapping);
	m_hSamplesMapping	= NULL;	

	/* close file */ 
	if (m_hSamplesFile) CloseHandle(m_hSamplesFile);
	m_hSamplesFile		= NULL;
}

int CDLSFile::FindInstrument(ULONG Bank, ULONG Id)
{
	for(int i=0; i<m_InstrumentCount; i++)
	{
		if (	Bank == m_Instrument[i].m_Bank
			&&	Id   == m_Instrument[i].m_Id   )
			return i;
	}
	
	return -1;
}