	NAME	pico
;
;  TCTINA.ASM - Tiny asm startup library for Turbo C. Freeware.
;
;  SEE: TCTINY.TXT for details.
;
;  v104  - Compiles "HELLOT2.C" to 125 bytes.

	INCLUDE RULES.ASI

;	Segment and Group declarations

_TEXT	SEGMENT BYTE PUBLIC 'CODE'
_TEXT	ENDS
_DATA	SEGMENT PARA PUBLIC 'DATA'
_DATA	ENDS
_EMUSEG SEGMENT WORD PUBLIC 'DATA'
_EMUSEG ENDS
_CVTSEG SEGMENT WORD PUBLIC 'DATA'
_CVTSEG ENDS
_SCNSEG SEGMENT WORD PUBLIC 'DATA'
_SCNSEG ENDS
_BSS	SEGMENT WORD PUBLIC 'BSS'
_BSS	ENDS
_BSSEND SEGMENT BYTE PUBLIC 'BSSEND'
_BSSEND ENDS
IFNDEF __TINY__
_STACK	SEGMENT STACK 'STACK'
_STACK	ENDS
ENDIF

IF	LDATA
DGROUP	GROUP	_DATA, _EMUSEG, _CVTSEG, _SCNSEG, _BSS, _BSSEND
ELSE
IFNDEF	__TINY__
DGROUP	GROUP	_DATA, _EMUSEG, _CVTSEG, _SCNSEG, _BSS, _BSSEND, _STACK
ELSE
DGROUP	GROUP	_TEXT, _DATA, _EMUSEG, _CVTSEG, _SCNSEG, _BSS, _BSSEND
ENDIF
ENDIF
	ASSUME	CS:_TEXT, DS:DGROUP

;	External References

ExtProc@	main,	__CDECL__
ExtProc@	exit,	__CDECL__

ExtSym@ _stklen, WORD,	__CDECL__
ExtSym@ _emufak, ABS,	__CDECL__

;
;  Start code
;
							
PSPHigh		equ	00002h
PSPEnv		equ	0002ch
PSPCmd		equ	00080h
MINSTACK	equ	128
;
;	At the start, DS and ES both point to the segment prefix.
;	SS points to the stack segment except in TINY model where
;	SS is equal to CS
;
_TEXT	SEGMENT
IFDEF	__TINY__
	ORG	100h
ENDIF
STARTX		PROC	NEAR

;	Sometimes the compiler needs to load the DS register with the
;	DGROUP value. In TINY model the DGROUP symbol cannot appear,
;	otherwise it becomes impossible to EXE2BIN the .EXE file. For this
;	reason, the DGROUP is saved in a variable of the code segment.

IFDEF	__TINY__
;		mov	dx, cs		; DX = GROUP Segment address
ELSE
;		mov	dx, DGROUP	; DX = GROUP Segment address
ENDIF
;                mov ds, dx
		jmp main@

STARTX		ENDP

;
; Misc Functions
;



;	The DGROUP@ variable is used to reaload DS with DGROUP

PubSym@ DGROUP@, <dw	?>, __PASCAL__
_TEXT	ENDS

;
; Start Data Seg
;
;


_DATA	SEGMENT


;	Miscellaneous variables

dPtrPub@	environ,	0,		__CDECL__
;PubSym@		_envLng,	<dw	0>,	__CDECL__
;PubSym@		_envseg,	<dw    0>,	__CDECL__
;PubSym@		_envSize,	<dw    0>,	__CDECL__
;PubSym@		_psp,		<dw    0>,	__CDECL__
;PubSym@		errno,		<dw    0>,	__CDECL__

;	Memory management variables

IF	LDATA EQ false
dPtrPub@	__brklvl,	DGROUP:edata@,	__CDECL__
ENDIF
PubSym@		_heapbase,	<dd   0>,	__CDECL__
PubSym@		_brklvl,	<dd   0>,	__CDECL__
PubSym@		_heaptop,	<dd   0>,	__CDECL__
_DATA	ENDS

_EMUSEG SEGMENT
__emu1st	label	word
__emuLast	equ	__emu1st + 2
_EMUSEG ENDS

_CVTSEG SEGMENT
PubSym@ _RealCvtVector, <label	word>,	__CDECL__
_CVTSEG ENDS

_SCNSEG SEGMENT
PubSym@ _ScanTodVector,	 <label word>,	__CDECL__
_SCNSEG ENDS

_BSS	SEGMENT
bdata@	label	byte
_BSS	ENDS

_BSSEND SEGMENT
edata@	label	byte
_BSSEND ENDS

IFNDEF	__TINY__
_STACK	SEGMENT
	dw	64 dup (?)
_STACK	ENDS
ENDIF
	END	STARTX
