Global SORT_SCALE#=0.2, SORT_TABLE_SIZE=4096,gwidth=GraphicsWidth(),gheight=GraphicsHeight()
Dim SORT_TABLE.face(SORT_TABLE_SIZE)


Function ShowStats()
	i=0 : For ve.vector=Each vector : i=i+1 : Next
	Text 0,0,"Vectors : "+i
	i=0 : For m.matrix=Each matrix : i=i+1 : Next
	Text 0,15,"Matrices : "+i
	i=0 : For c.Coord=Each Coord : i=i+1 : Next
	Text 0,30,"Coords : "+i
	i=0 : For v.Vertex=Each Vertex : i=i+1 : Next
	Text 0,45,"Vertices : "+i
	i=0 : For p.Polygon=Each Polygon : i=i+1 : Next
	Text 0,60,"Polygons : "+i
	i=0 : For re.face=Each face : i=i+1 : Next
	Text 0,75,"Faces:"+i
	i=0 : For o.obj=Each obj : i=i+1 : Next
	Text 0,90,"Objects : "+i
End Function
	

Function DeleteObj(o.obj)

	Select (o\FLAG)
		Case 0
			FreeBank o\Pallette
		Case 1
			FreeBank o\ENVMAP
		Case 2 
			FreeBank o\TEXTURE
		Case 3
			FreeBank o\ENVMAP
			FreeBank o\BUMPMAP
	End Select
	
	firstpass=True
	Repeat
		If firstpass=True
			p.polygon=o\firstpolygon
			firstpass=False
		Else
			p2.polygon=p
			p=p\nextpolygon
			Delete p2
		EndIf
		
		Delete p\N
		If p\v0<>Null
			If p\v0\c<>Null 
				Delete p\v0\c\o
				Delete p\v0\c\n
				Delete p\v0\c\c
				Delete p\v0\c\cn
				Delete p\v0\c
			EndIf
			Delete p\v0
		EndIf
		If p\v1<>Null
			If p\v1\c<>Null 
				Delete p\v1\c\o
				Delete p\v1\c\n
				Delete p\v1\c\c
				Delete p\v1\c\cn
				Delete p\v1\c
			EndIf
			Delete p\v1
		EndIf
		If p\v2<>Null
			If p\v2\c<>Null 
				Delete p\v2\c\o
				Delete p\v2\c\n
				Delete p\v2\c\c
				Delete p\v2\c\cn
				Delete p\v2\c
			EndIf
			Delete p\v2
		EndIf
	Until p\nextpolygon=Null
	Delete p
	
	Delete o\r : Delete o\c : Delete o\a
	Delete o\w : Delete o\t : Delete o\m
	
	Delete o
	
End Function


Function ImageToMaterial(o.obj,image=0,file$="",FLAG,free=True)
	If image=False Then image=LoadImage(file$)
	If (Not image)
		RuntimeError("Failed to load texture!")
		End
	EndIf
	HEIGHT=ImageHeight(IMAGE)
	BNK=CreateBank(256*HEIGHT*4)
	i=0
	SetBuffer ImageBuffer(image)
	LockBuffer
		For y=0 To HEIGHT-1
			For x=0 To 255
				RGB=ReadPixelFast(x,y)
				PokeFloat(BNK,i,RGB)
				i=i+4
			Next
		Next
	UnlockBuffer
	If free Then FreeImage image
	o\flag=FLAG
	If FLAG=1
		o\envmap=BNK
	Else If FLAG=2
		o\texture=BNK
	EndIf
	SetBuffer BackBuffer()
End Function

Function LoadBumpMap(o.obj,file$)
	IMG=LoadImage(file$)
	If (Not IMG) RuntimeError("Failed to load bumpmap '"+file$+"'") : End
	H=ImageHeight(IMG)
	bumpmap=CreateBank(256*H)
	SetBuffer ImageBuffer(IMG)
	LockBuffer
		For y=0 To (H-1)
			For x=0 To 255
				RGB=ReadPixelFast(x,y)
				PokeByte(bumpmap,(y*256)+x,(((RGB Shr 16) And $FF)+((RGB Shr 8) And $FF)+(RGB And $FF))/3)
			Next
		Next
	UnlockBuffer
	SetBuffer BackBuffer()
	o\bumpmap=CreateBank(256*H*2)
	o\FLAG=3
	yoffs=256
	For y=1 To (H-2)
		For x=1 To 254
			offs=yoffs+x
			nx=(PeekByte(bumpmap,offs+1)-PeekByte(bumpmap,offs-1))
			ny=(PeekByte(bumpmap,offs+256)-PeekByte(bumpmap,offs-256))
			PokeByte(o\bumpmap,offs Shl 1,nx)
			PokeByte(o\bumpmap,(offs Shl 1)+1,ny)
		Next
		yoffs=yoffs+256
	Next
	FreeBank bumpmap
	FreeImage IMG
End Function

Function CreateEnvMap(r#,g#,b#)
	ENVMAP=CreateImage(256,256)
	For y=0 To 255
		For x=0 To 255
			nx#=(Float x-128)/128
			ny#=(Float y-128)/128
			nz#=1-Sqr(nx#*nx#+ny#*ny#)
			If nz#<0 nz#=0
			WritePixel x,y,((NZ#*R#)Shl 16)+((NZ#*G#)Shl 8)+(NZ#*B#),ImageBuffer(ENVMAP)
		Next
	Next
	Return ENVMAP
End Function

Function CreatePhongEnvMap(sr#,sg#,sb#,dr#,dg#,db#,spr#,spg#,spb#,n)
	ENVMAP=CreateImage(256,256)
	For y=0 To 255
		For x=0 To 255
			nx#=(Float x-128)/128
			ny#=(Float y-128)/128
			nz#=1-Sqr(nx#*nx#+ny#*ny#)
			If nz#<0 nz#=0
			R=(sr#+Cos(90.0-(nz#*90.0))*dr#+Cos(90.0-(nz#*90.0))^n*spr#);*255
			If R>255 R=255
			G=(sg#+Cos(90.0-(nz#*90.0))*dg#+Cos(90.0-(nz#*90.0))^n*spg#);*255
			If G>255 G=255
			B=(sb#+Cos(90.0-(nz#*90.0))*db#+Cos(90.0-(nz#*90.0))^n*spb#);*255
			If B>255 B=255
			WritePixel x,y,(R Shl 16)+(G Shl 8)+B,ImageBuffer(ENVMAP)
		Next
	Next
	Return ENVMAP
End Function

Function UpdateWorld()
	InitializeObjects()
	BackFaceCullObjects()
	RotateAndLightObjects()
	CreateRenderList()
End Function

Type Normal
	Field x#,y#,z#
End Type

Function Normal(x#,y#,z#)
	For no.normal=Each normal
		If no\x#=x# And no\y#=y# And no\z#=z#
			found=True
		EndIf
	Next
	If found<>True 
		n.normal=New normal
		n\x#=x# : n\y#=y# : n\z#=z#
	EndIf
End Function

Function InitializeObjects()
	Local u.vector=Vector() 
	Local v.vector=Vector()
	For o.obj=Each obj
		If (Not o\initialized)
			firstpass=True
			Repeat
				If firstpass=True
					p.polygon=o\firstpolygon
					firstpass=False
				Else
					p=p\nextpolygon
				EndIf
				vectorsub(p\v1\c\o,p\v0\c\o,u)
				vectorsub(p\v1\c\o,p\v2\c\o,v)
				CrossProduct(u,v,p\N)
			Until p\nextpolygon=Null

			NORMAL.vector=Vector()
			For ve.vertex=Each vertex
				SetVector(NORMAL,0.0,0.0,0.0)
				firstpass=True
				SHARED=0
				Repeat
					If firstpass=True
						p.polygon=o\firstpolygon
						firstpass=False
					Else
						p=p\nextpolygon
					EndIf
					If p\v0\c=ve\c Or p\v1\c=ve\c Or p\v2\c=ve\c
					;If p\v0=ve Or p\v1=ve Or p\v2=ve
						Normal(p\N\x#,p\n\y#,p\n\z#)
						;VectorAdd(NORMAL,p\N,NORMAL)
						SHARED=SHARED+1
					EndIf
				Until p\nextpolygon=Null
				For no.normal=Each normal
					SetVector(NORMAL,NORMAL\x#+no\x#,NORMAL\y#+no\y#,NORMAL\z#+no\z#)
				Next
				VectorDivScalar(NORMAL,Float SHARED)
				Normalize(NORMAL)
				SetVector(ve\c\n,NORMAL\x#,NORMAL\y#,NORMAL\z#)
				Delete Each normal
			Next
			Delete NORMAL
			firstpass=True
			Repeat
				If firstpass=True
					p.polygon=o\firstpolygon
					firstpass=False
				Else
					p=p\nextpolygon
				EndIf
				Normalize(p\N)
			Until p\nextpolygon=Null
			
			o\initialized=True
		EndIf
	Next
	Delete u : Delete v
End Function
			


Function BackFaceCullObjects()
	E.vector=Vector()
	For o.obj=Each obj
		If o\updated MultiplyMatrix(o\r,o\t,o\m)

		x#=-o\m\da#
		y#=-o\m\db#
		z#=-o\m\dc#
		px#=x#*o\m\aa#+y#*o\m\ab#+z#*o\m\ac#
		py#=x#*o\m\ba#+y#*o\m\bb#+z#*o\m\bc#
		pz#=x#*o\m\ca#+y#*o\m\cb#+z#*o\m\cc#
		Pos.Vector=Vector(px#,py#,pz#)
		
		firstpass=True
		Repeat
			If firstpass=True
				p.polygon=o\firstpolygon
				firstpass=False
			Else
				p=p\nextpolygon
			EndIf
			
			vectorsub(pos,p\v1\c\o,E)
			Normalize(E)
			d#=DotProduct(E,p\N)
			If d#>=0
				p\backfaceculled=False
			Else
				p\backfaceculled=True
				p\v0\i#=0 : p\v1\i#=0 : p\v2\i#=0
			EndIf
		Until p\nextpolygon=Null
		
		Delete pos
	Next
	Delete E
End Function


Function RotateAndLightObjects()
	For c.coord=Each coord
		c\processed=False
	Next
	L.vector=Vector()
	V.vector=Vector()
	For o.obj=Each obj	
		firstpass=True
		Repeat
			If firstpass=True
				p.polygon=o\firstpolygon
				firstpass=False
			Else
				p=p\nextpolygon
			EndIf
			If (Not p\backfaceculled)	
				;rotate points
				If Not(p\v0\c\processed) 
					TransformVector(p\v0\c\o,o\m,p\v0\c\c)
					TransformVector(p\v0\c\n,o\r,p\v0\c\cn)
					p\v0\c\processed=True
				EndIf
				If Not(p\v1\c\processed) 
					TransformVector(p\v1\c\o,o\m,p\v1\c\c)	
					TransformVector(p\v1\c\n,o\r,p\v1\c\cn)	
					p\v1\c\processed=True
				EndIf
				If Not(p\v2\c\processed) 
					TransformVector(p\v2\c\o,o\m,p\v2\c\c)
					TransformVector(p\v2\c\n,o\r,p\v2\c\cn)			
					p\v2\c\processed=True
				EndIf
				;light vertices
				If p\obj\flag=0 Or p\obj\flag=2
					;light vertices for gouraud
					For li.light=Each light
						SetVector(l,li\x#-p\obj\w\x#,li\y#-p\obj\w\y#,li\z#-p\obj\w\z#)
					Next
					Normalize(L)
					ANG#=Abs(ACos(DotProduct(p\v0\c\cn,L)))
					If ANG#>=0.00 And ANG#<=90.00
						p\v0\i=((90-ANG#)*2.8)
					EndIf
					ANG#=Abs(ACos(DotProduct(p\v1\c\cn,L)))
					If ANG#>=0.00 And ANG#<=90.00
						p\v1\i=((90-ANG#)*2.8)
					EndIf
					ANG#=Abs(ACos(DotProduct(p\v2\c\cn,L)))
					If ANG#>=0.00 And ANG#<=90.00
						p\v2\i=((90-ANG#)*2.8)
					EndIf
				Else
					p\v0\eu#=(128+127*p\v0\c\cn\x#)And$FF
					p\v0\ev#=(128+127*p\v0\c\cn\y#)And$FF
					p\v1\eu#=(128+127*p\v1\c\cn\x#)And$FF
					p\v1\ev#=(128+127*p\v1\c\cn\y#)And$FF
					p\v2\eu#=(128+127*p\v2\c\cn\x#)And$FF
					p\v2\ev#=(128+127*p\v2\c\cn\y#)And$FF
				EndIf
			EndIf
		Until p\nextpolygon=Null
	Next
	Delete l : Delete V
End Function


Function CreateRenderList()
	For o.obj=Each obj	
		firstpass=True
		Repeat
			If firstpass=True
				p.polygon=o\firstpolygon
				firstpass=False
			Else
				p=p\nextpolygon
			EndIf
			If (Not p\backfaceculled)
				If o\flag=0 ;gouraud
					AddFaceGouraud(p\v0\c\c\x#,p\v0\c\c\y#,p\v0\c\c\z#,p\v0\i,p\v1\c\c\x#,p\v1\c\c\y#,p\v1\c\c\z#,p\v1\i,p\v2\c\c\x#,p\v2\c\c\y#,p\v2\c\c\z#,p\v2\i,o\pallette)
				Else If o\flag=1 ; envmap
					AddFaceEnvmap(p\v0\c\c\x#,p\v0\c\c\y#,p\v0\c\c\z#,p\v0\eu#,p\v0\ev#,p\v1\c\c\x#,p\v1\c\c\y#,p\v1\c\c\z#,p\v1\eu#,p\v1\ev#,p\v2\c\c\x#,p\v2\c\c\y#,p\v2\c\c\z#,p\v2\eu#,p\v2\ev#,o\envmap)
				Else If o\flag=2 ; gouraud texturemap
					AddFaceGTexMap(p\v0\c\c\x#,p\v0\c\c\y#,p\v0\c\c\z#,p\v0\tu#,p\v0\tv#,p\v0\i,p\v1\c\c\x#,p\v1\c\c\y#,p\v1\c\c\z#,p\v1\tu#,p\v1\tv#,p\v1\i,p\v2\c\c\x#,p\v2\c\c\y#,p\v2\c\c\z#,p\v2\tu#,p\v2\tv#,p\v2\i,o\texture)
				Else If o\flag=3 ; bumpmap
					AddFaceBumpMap(p\v0\c\c\x#,p\v0\c\c\y#,p\v0\c\c\z#,p\v0\tu#,p\v0\tv#,p\v0\eu#,p\v0\ev#,p\v1\c\c\x#,p\v1\c\c\y#,p\v1\c\c\z#,p\v1\tu#,p\v1\tv#,p\v1\eu#,p\v1\ev#,p\v2\c\c\x#,p\v2\c\c\y#,p\v2\c\c\z#,p\v2\tu#,p\v2\tv#,p\v2\eu#,p\v2\ev#,o\bumpmap,o\envmap)
				EndIf
			EndIf				
		Until p\nextpolygon=Null
	Next
End Function
			



Type Vertex
	Field obj.obj
	Field c.coord
	Field tu#,tv#,i
	Field eu#,ev#
	Field intensity
End Type

Function Vertex(o.obj,x#,y#,z#,tu#=0,tv#=0)
	o\numverts=o\numverts+1
	found=False
	For c.coord=Each coord
		If c\o\x#=x# And c\o\y#=y# And c\o\z#=z#
			For v.vertex=Each vertex
				If v\obj=o And v\c=c	
					found=True
					Exit
				EndIf		
			Next
		EndIf
		If found=True Exit
	Next
	If found=False
		c.coord=New coord
		c\o=Vector(x#,y#,z#)
		c\c=Vector()
		c\n=Vector()
		c\cn=Vector()
		c\processed=False
	EndIf
	
	v.vertex=New vertex
	v\obj=o
	v\c=c
	v\tu#=tu#
	v\tv#=tv#
	v\i#=0
End Function

Type Polygon
	Field obj.obj
	Field v0.vertex
	Field v1.vertex
	Field v2.vertex
	Field backfaceculled
	Field N.vector
	Field nextpolygon.polygon
End Type
	
Function Polygon(o.obj,v0,v1,v2)
	o\numpolys=o\numpolys+1
	num_polys=num_polys+1
	p.polygon=New polygon
	p\obj=o
	p\N=Vector()
	p\v0=FindVertex(o,v0) : p\v1=FindVertex(o,v1) : p\v2=FindVertex(o,v2)
	If o\firstpolygon=Null
		o\firstpolygon=p
	Else	
		fp.polygon=o\firstpolygon
		While fp\nextpolygon<>Null
			fp=fp\nextpolygon
		Wend
		fp\nextpolygon=p
	EndIf
End Function

Function FindVertex.vertex(o.obj,num)
	vertexcount=0
	For v.vertex=Each vertex
		If v\obj=o
			If vertexcount=num
				Goto found
			Else
				vertexcount=vertexcount+1
			EndIf
		EndIf
	Next
	
	.found
	Return v
End Function


Type coord
	Field o.vector
	Field n.vector
	Field c.vector
	Field cn.vector
	Field sx,sy
	Field processed
End Type




Type obj
	Field w.vector
	Field c.vector
	Field a.vector ; rotation angles
	Field numpolys,numverts
	Field r.matrix ; rotation matrix
	Field t.matrix ; translation matrix
	Field m.matrix ; final matrix
	Field firstpolygon.polygon
	Field pallette,envmap,texture,bumpmap
	Field FLAG ;0=gouraud,1=envmap,2=gouraud texture,3=bumpmap
	Field updated, initialized
End Type

Function Obj.obj()
	o.obj=New obj
	o\w.vector=Vector()
	o\c.vector=Vector()
	o\a.vector=Vector()
	o\r.matrix=Matrix()
	o\t.matrix=Matrix()
	o\m.matrix=Matrix()
	o\updated=True
	o\initialized=False
	Return o
End Function

Function PositionObj(o.obj,x#,y#,z#)
	SetVector(o\w,x#,y#,z#)
	TranslateMatrix(o\t,o\w\x#,o\w\y#,o\w\z#)
	o\updated=True
End Function

Function MoveObj(o.obj,x#,y#,z#)
	SetVector(o\w,x#+o\w\x#,y#+o\w\y#,z#+o\w\z#)
	TranslateMatrix(o\t,o\w\x#,o\w\y#,o\w\z#)
	o\updated=True
End Function

Function RotateObj(o.obj,xa#,ya#,za#)
	SetVector(o\a,xa#,ya#,za#)
	RotateMatrix(o\r,o\a\x#,o\a\y#,o\a\z#)
	o\updated=True
End Function

Function TurnObj(o.obj,xa#,ya#,za#)
	SetVector(o\a,xa#+o\a\x#,ya#+o\a\y#,za#+o\a\z#)
	RotateMatrix(o\r,o\a\x#,o\a\y#,o\a\z#)
	o\updated=True
End Function


Function CreateTorusMapping.obj(slices,spans,int_radius#,ext_radius#,val#=1)
	o.obj=Obj()

	vertex_buffer=CreateBank(slices*spans*3*4)
	offset=0
	For i=0 To (slices-1)
		ext_angle#=Float i*360/slices
		ca#=Cos(ext_angle#)
		sa#=Sin(ext_angle#)
		For j=0 To (spans-1)
			int_angle#=Float j*360/spans
			int_rad#=ext_radius#+int_radius#*Cos(int_angle#)
			PokeFloat(vertex_buffer,offset,int_rad#*ca#)
			PokeFloat(vertex_buffer,offset+4,int_radius#*Sin(int_angle#))
			PokeFloat(vertex_buffer,offset+8,int_rad#*sa#)
			offset=offset+12
		Next
	Next
	
	vertex_count=0
	For i=0 To (slices-1)
		tu=(256/slices)*i
		For j=0 To (spans-1)
			tv=(256/spans)*j
			
			v0_offs=(i*spans+j)*12
			v1_offs=(i*spans+((j+1)Mod spans))*12
			v2_offs=(((i+1)Mod slices)*spans+j)*12
			v3_offs=(((i+1)Mod slices)*spans+((j+1)Mod spans))*12
			
			v0x#=PeekFloat(vertex_buffer,v0_offs)
			v0y#=PeekFloat(vertex_buffer,v0_offs+4)
			v0z#=PeekFloat(vertex_buffer,v0_offs+8)
			v1x#=PeekFloat(vertex_buffer,v1_offs)
			v1y#=PeekFloat(vertex_buffer,v1_offs+4)
			v1z#=PeekFloat(vertex_buffer,v1_offs+8)
			v2x#=PeekFloat(vertex_buffer,v2_offs)
			v2y#=PeekFloat(vertex_buffer,v2_offs+4)
			v2z#=PeekFloat(vertex_buffer,v2_offs+8)
			v3x#=PeekFloat(vertex_buffer,v3_offs)
			v3y#=PeekFloat(vertex_buffer,v3_offs+4)
			v3z#=PeekFloat(vertex_buffer,v3_offs+8)
			
			Vertex(o,v0x#,v0y#,v0z#,Float(((256/spans)*(j))And$FF),Float(((256/slices)*(i))And$FF)*val#)
			Vertex(o,v1x#,v1y#,v1z#,Float(((256/spans)*(j+1))And$FF),Float(((256/slices)*(i))And$FF)*val#)
			Vertex(o,v2x#,v2y#,v2z#,Float(((256/spans)*(j))And$FF),Float(((256/slices)*(i+1))And$FF)*val#)
			Vertex(o,v3x#,v3y#,v3z#,Float(((256/spans)*(j+1))And$FF),Float(((256/slices)*(i+1))And$FF)*val#)
			
			Polygon(o,vertex_count+2,vertex_count+1,vertex_count)
			Polygon(o,vertex_count+3,vertex_count+1,vertex_count+2)
			
			vertex_count=vertex_count+4
		Next
	Next
	
	FreeBank vertex_buffer
	Return o
End Function

Function Cube.obj(xs#,ys#,zs#)
	o.obj=Obj()
	;front
	Vertex(o,-1*xs#	,-1*ys#	,1*zs#	,0	,0	)
	Vertex(o,1*xs# 	,-1*ys#	,1*zs#	,255,0	)
	Vertex(o,-1*xs#	,1*ys#	,1*zs#	,0	,255)
	Polygon(o,2,1,0)
	Vertex(o,1*xs#		,-1*ys#	,1*zs#	,255,0	)
	Vertex(o,-1*xs#	,1*ys#	,1*zs#	,0	,255)
	Vertex(o,1*xs#		,1*ys#	,1*zs#	,255,255)
	Polygon(o,3,4,5)
	;back
	Vertex(o,-1*xs#	,-1*ys#	,-1*zs#	,0	,0	)
	Vertex(o,1*xs# 	,-1*ys#	,-1*zs#	,255,0	)
	Vertex(o,-1*xs#	,1*ys#	,-1*zs#	,0	,255)
	Polygon(o,6,7,8)
	Vertex(o,1*xs#		,-1*ys#	,-1*zs#	,255,0	)
	Vertex(o,-1*xs#	,1*ys#	,-1*zs#	,0	,255)
	Vertex(o,1*xs#		,1*ys#	,-1*zs#	,255,255)
	Polygon(o,11,10,9)
	;top
	Vertex(o,-1*xs#	,-1*ys#	,1*zs#	,0	,0	)
	Vertex(o,-1*xs# 	,-1*ys#	,-1*zs#	,0	,255)
	Vertex(o,1*xs#		,-1*ys#	,1*zs#	,255,0	)
	Polygon(o,14,13,12)
	Vertex(o,1*xs#		,-1*ys#	,1*zs#	,255,0	)
	Vertex(o,-1*xs#	,-1*ys#	,-1*zs#	,0	,255)
	Vertex(o,1*xs#		,-1*ys#	,-1*zs#	,255,255)
	Polygon(o,17,16,15)
	;bottom
	Vertex(o,-1*xs#	,1*ys#	,1*zs#	,0	,0	)
	Vertex(o,-1*xs# 	,1*ys#	,-1*zs#	,0	,255)
	Vertex(o,1*xs#		,1*ys#	,1*zs#	,255,0	)
	Polygon(o,18,19,20)
	Vertex(o,1*xs#		,1*ys#	,1*zs#	,255,0	)
	Vertex(o,-1*xs#	,1*ys#	,-1*zs#	,0	,255)
	Vertex(o,1*xs#		,1*ys#	,-1*zs#	,255,255)
	Polygon(o,21,22,23)
	;left
	Vertex(o,-1*xs#	,-1*ys#	,1*zs#	,0	,0	)
	Vertex(o,-1*xs# 	,1*ys#	,1*zs#	,0	,255)
	Vertex(o,-1*xs#	,-1*ys#	,-1*zs#	,255,0	)
	Polygon(o,26,25,24)
	Vertex(o,-1*xs#	,-1*ys#	,-1*zs#	,255,0	)
	Vertex(o,-1*xs#	,1*ys#	,-1*zs#	,255,255)
	Vertex(o,-1*xs#	,1*ys#	,1*zs#	,0	,255)
	Polygon(o,27,28,29)
;	;right
	Vertex(o,1*xs#		,-1*ys#	,1*zs#	,0	,0	)
	Vertex(o,1*xs# 	,1*ys#	,1*zs#	,0	,255)
	Vertex(o,1*xs#		,-1*ys#	,-1*zs#	,255,0	)
	Polygon(o,30,31,32)
	Vertex(o,1*xs#		,-1*ys#	,-1*zs#	,255,0	)
	Vertex(o,1*xs#		,1*ys#	,-1*zs#	,255,255)
	Vertex(o,1*xs#		,1*ys#	,1*zs#	,0	,255)
	Polygon(o,35,34,33)
	Return o
End Function

Function RenderWorld(debug=0)
	render_num=0
	LockBuffer
		For i=SORT_TABLE_SIZE To 0 Step -1
			If SORT_TABLE(i)<>Null
				firsttime=True
				Repeat
					If firsttime=True
						s.face=SORT_TABLE(i)
						firsttime=False
					Else
						s=s\nextface
					EndIf
					x0=(s\x0#*256/s\z0#)+(GraphicsWidth()/2)
					y0=(s\y0#*256/s\z0#)+(GraphicsHeight()/2)
					x1=(s\x1#*256/s\z1#)+(GraphicsWidth()/2)
					y1=(s\y1#*256/s\z1#)+(GraphicsHeight()/2)
					x2=(s\x2#*256/s\z2#)+(GraphicsWidth()/2)
					y2=(s\y2#*256/s\z2#)+(GraphicsHeight()/2)
					If debug=0
						If s\flag=0 ; gouraud
							GouraudPolygon(x0,y0,s\i0#,x1,y1,s\i1#,x2,y2,s\i2#,s\pallette)
						Else If s\flag=1
							;PerspTexturePolygon(x0,y0,s\z0#,s\eu0#,s\ev0#,x1,y1,s\z1#,s\eu1#,s\ev1#,x2,y2,s\z2#,s\eu2#,s\ev2#,s\envmap)
							AffineTexturePolygon(x0,y0,s\eu0#,s\ev0#,x1,y1,s\eu1#,s\ev1#,x2,y2,s\eu2#,s\ev2#,s\envmap)
						Else If s\flag=2
							GouraudPerspectiveTextureMap(x0,y0,s\z0#,s\tu0#,s\tv0#,s\i0#,x1,y1,s\z1#,s\tu1#,s\tv1#,s\i1#,x2,y2,s\z2#,s\tu2#,s\tv2#,s\i2#,s\texture)
						Else If s\flag=3
							PhongBumpMap(x0,y0,s\tu0#,s\tv0#,s\eu0#,s\ev0#,x1,y1,s\tu1#,s\tv1#,s\eu1#,s\ev1#,x2,y2,s\tu2#,s\tv2#,s\eu2#,s\ev2#,s\envmap,s\bumpmap)
						EndIf							
					Else
						Line x0,y0,x1,y1
						Line x1,y1,x2,y2
						Line x2,y2,x0,y0
					EndIf
				Until s\nextface=Null
			EndIf
		Next
	UnlockBuffer
	Delete Each face
End Function

Function AddFaceGouraud(x0#,y0#,z0#,i0#,x1#,y1#,z1#,i1#,x2#,y2#,z2#,i2#,pallette)
	s.face=New face
	s\x0#=x0# : s\y0#=y0# : s\z0#=z0# : s\i0#=i0#
	s\x1#=x1# : s\y1#=y1# : s\z1#=z1# : s\i1#=i1#
	s\x2#=x2# : s\y2#=y2# : s\z2#=z2# : s\i2#=i2#
	s\pallette=pallette
	s\FLAG=0
	SortFace(s)
End Function

Function AddFaceEnvMap(x0#,y0#,z0#,u0#,v0#,x1#,y1#,z1#,u1#,v1#,x2#,y2#,z2#,u2#,v2#,envmap)
	s.face=New face
	s\x0#=x0# : s\y0#=y0# : s\z0#=z0# : s\eu0#=u0# : s\ev0#=v0#
	s\x1#=x1# : s\y1#=y1# : s\z1#=z1# : s\eu1#=u1# : s\ev1#=v1#
	s\x2#=x2# : s\y2#=y2# : s\z2#=z2# : s\eu2#=u2# : s\ev2#=v2#
	s\envmap=envmap
	s\FLAG=1
	SortFace(s)
End Function

Function AddFaceGTexMap(x0#,y0#,z0#,u0#,v0#,i0#,x1#,y1#,z1#,u1#,v1#,i1#,x2#,y2#,z2#,u2#,v2#,i2#,texture)
	s.face=New face
	s\x0#=x0# : s\y0#=y0# : s\z0#=z0# : s\tu0#=u0# : s\tv0#=v0# : s\i0#=i0#
	s\x1#=x1# : s\y1#=y1# : s\z1#=z1# : s\tu1#=u1# : s\tv1#=v1# : s\i1#=i1#
	s\x2#=x2# : s\y2#=y2# : s\z2#=z2# : s\tu2#=u2# : s\tv2#=v2# : s\i2#=i2#
	s\texture=texture
	s\FLAG=2
	SortFace(s)
End Function

Function AddFaceBumpMap(x0#,y0#,z0#,tu0#,tv0#,eu0#,ev0#,x1#,y1#,z1#,tu1#,tv1#,eu1#,ev1#,x2#,y2#,z2#,tu2#,tv2#,eu2#,ev2#,bumpmap,envmap)
	s.face=New face
	s\x0#=x0# : s\y0#=y0# : s\z0#=z0# : s\tu0#=tu0# : s\tv0#=tv0# : s\eu0#=eu0# : s\ev0#=ev0#
	s\x1#=x1# : s\y1#=y1# : s\z1#=z1# : s\tu1#=tu1# : s\tv1#=tv1# : s\eu1#=eu1# : s\ev1#=ev1#
	s\x2#=x2# : s\y2#=y2# : s\z2#=z2# : s\tu2#=tu2# : s\tv2#=tv2# : s\eu2#=eu2# : s\ev2#=ev2#
	s\bumpmap=bumpmap
	s\envmap=envmap
	s\FLAG=3
	SortFace(s)
End Function

Type face
	Field x0#,y0#,z0#,tu0#,tv0#,eu0#,ev0#,i0#
	Field x1#,y1#,z1#,tu1#,tv1#,eu1#,ev1#,i1#
	Field x2#,y2#,z2#,tu2#,tv2#,eu2#,ev2#,i2#
	Field nextface.face
	Field texture,bumpmap,envmap,pallette
	Field FLAG
End Type

Function SortFace(s.face)
	index=Int(((s\z0#+s\z1#+s\z2#)/3.00)*SORT_SCALE#)
	If index>=0 And index<=SORT_TABLE_SIZE
		If SORT_TABLE(index)=Null
			SORT_TABLE(index)=s
		Else
			s\nextface=SORT_TABLE(Index)
			SORT_TABLE(index)=s
		EndIf
	EndIf
End Function

Function PerspTexturePolygon(x0,y0,z0#,u0,v0,x1,y1,z1#,u1,v1,x2,y2,z2#,u2,v2,image)

	If y1<y0
		temp  =x0 	: x0= x1 	: x1= temp
		temp  =y0 	: y0= y1 	: y1= temp
		tempf#=z0# 	: z0#=z1# 	: z1#=tempf#
		temp  =u0 	: u0= u1 	: u1= temp
		temp  =v0	: v0= v1 	: v1= temp
	EndIf
	If y2<y1
		temp=  x1 	: x1=x2 	: x2=temp
		temp=  y1 	: y1=y2 	: y2=temp
		tempf#=z1# 	: z1#=z2# 	: z2#=tempf#
		temp=  u1 	: u1=u2 	: u2=temp
		temp=  v1 	: v1=v2 	: v2=temp
	EndIf
	If y1<y0
		temp=  x0 	: x0= x1 	: x1= temp
		temp=  y0 	: y0= y1 	: y1= temp
		tempf#=z0# 	: z0#=z1# 	: z1#=tempf#
		temp=  u0 	: u0= u1 	: u1= temp
		temp=  v0 	: v0= v1 	: v1= temp
	EndIf
	
	leftdy=y1-y0 : rightdy=y2-y0
	
	If (leftdy)<>0
		leftxm#=(Float x1-Float x0)/(Float leftdy)
		leftrm#=((1.00/z1#)-(1.00/z0#))/(Float leftdy)
		leftum#=(((Float u1)/z1#)-((Float u0)/z0#))/(Float leftdy)
		leftvm#=(((Float v1)/z1#)-((Float v0)/z0#))/(Float leftdy)
	EndIf
	If (rightdy)<>0
		rightxm#=(Float x2-Float x0)/(Float rightdy)
		rightrm#=((1.00/z2#)-(1.00/z0#))/(Float rightdy)
		rightum#=(((Float u2)/z2#)-((Float u0)/z0#))/(Float rightdy)
		rightvm#=(((Float v2)/z2#)-((Float v0)/z0#))/(Float rightdy)
	EndIf
	
	leftx#=Float x0 		: rightx#=leftx#
	leftr#=(1.0/z0#)		: rightr#=leftr#
	leftu#=((Float u0)/z0#) : rightu#=leftu#
	leftv#=((Float v0)/z0#) : rightv#=leftv#
	
;uppper half
	For y=y0 To (y1-1)
		If y>=0 And y<240
			If leftx#<rightx#
				lx#=leftx#
				lr#=leftr#
				lu#=leftu#
				lv#=leftv#
				rx#=rightx#
				rr#=rightr#
				ru#=rightu#
				rv#=rightv#
			Else
				lx#=rightx#
				lr#=rightr#
				lu#=rightu#
				lv#=rightv#
				rx#=leftx#
				rr#=leftr#
				ru#=leftu#
				rv#=leftv#
			EndIf
					
			deltax#=(rx#-lx#)
			If deltax#<>0
				hrm#=(rr#-lr#)/(deltax#)
				hum#=(ru#-lu#)/(deltax#)
				hvm#=(rv#-lv#)/(deltax#)
			EndIf
			
			hr#=lr#
			hu#=lu#
			hv#=lv#
			
			If lx#<319 And rx#>0
				If lx#<0
					S#=-lx#
					hr#=hr#+hrm#*S#
					hu#=hu#+hum#*S#
					hv#=hv#+hvm#*S#
					lx#=0
				EndIf
				If rx#>319 rx#=319
				
				For x=Int(lx#) To Int(rx#)-1
					z#=1.00/hr#
					u=Int(hu#*z#)
					v=Int(hv#*z#)
					RGB=PeekFloat(image,((v Shl 8)+u)Shl 2)
					WritePixelFast(x,y,RGB)
					hr#=hr#+hrm#
					hu#=hu#+hum#
					hv#=hv#+hvm#
				Next	
			EndIf
		EndIf
		leftx#=leftx#+leftxm#
		leftr#=leftr#+leftrm#
		leftu#=leftu#+leftum#
		leftv#=leftv#+leftvm#
		rightx#=rightx#+rightxm#
		rightr#=rightr#+rightrm#
		rightu#=rightu#+rightum#
		rightv#=rightv#+rightvm#
	Next

;Lower half
	leftdy=(y2-y1)
	
	If (leftdy)<>0
		leftxm#=(Float x2-Float x1)/(Float leftdy)
		leftrm#=((1.0/z2#)-(1.0/z1#))/(Float leftdy)
		leftum#=(((Float u2)/z2#)-((Float u1)/z1#))/(Float leftdy)
		leftvm#=(((Float v2)/z2#)-((Float v1)/z1#))/(Float leftdy)
	EndIf
	
	leftx#=Float x1
	leftr#=(1.0/z1#)
	leftu#=((Float u1)/z1#)
	leftv#=((Float v1)/z1#)
	
	For y=y1 To y2
		If y>=0 And y<240
			If leftx#<rightx#
				lx#=leftx#
				lr#=leftr#
				lu#=leftu#
				lv#=leftv#
				rx#=rightx#
				rr#=rightr#
				ru#=rightu#
				rv#=rightv#
			Else
				lx#=rightx#
				lr#=rightr#
				lu#=rightu#
				lv#=rightv#
				rx#=leftx#
				rr#=leftr#
				ru#=leftu#
				rv#=leftv#
			EndIf
					
			deltax#=(rx#-lx#)
			If deltax#<>0
				hrm#=(rr#-lr#)/(deltax#)
				hum#=(ru#-lu#)/(deltax#)
				hvm#=(rv#-lv#)/(deltax#)
			EndIf
			
			hr#=lr#
			hu#=lu#
			hv#=lv#
			
			If lx#<319 And rx#>0
				If lx#<0
					S#=-lx#
					hr#=hr#+hrm#*S#
					hu#=hu#+hum#*S#
					hv#=hv#+hvm#*S#
					lx#=0
				EndIf
				If rx#>319 rx#=319
				
				For x=(Int lx#) To ((Int rx#)-1)
					z#=1.00/hr#
					u=Int(hu#*z#)
					v=Int(hv#*z#)
					RGB=PeekFloat(image,((v Shl 8)+u)Shl 2)
					WritePixelFast(x,y,RGB)
					hr#=hr#+hrm#
					hu#=hu#+hum#
					hv#=hv#+hvm#
				Next
			EndIf
		EndIf	
		leftx#=leftx#+leftxm#
		leftr#=leftr#+leftrm#
		leftu#=leftu#+leftum#
		leftv#=leftv#+leftvm#
		rightx#=rightx#+rightxm#
		rightr#=rightr#+rightrm#
		rightu#=rightu#+rightum#
		rightv#=rightv#+rightvm#
	Next
End Function


Function AffineTexturePolygon(x0#,y0#,u0#,v0#,x1#,y1#,u1#,v1#,x2#,y2#,u2#,v2#,image)

	If y1#<y0#
		temp#  =x0#	: x0#= x1# 	: x1#= temp#
		temp#  =y0#	: y0#= y1# 	: y1#= temp#
		temp#  =u0#	: u0#= u1# 	: u1#= temp#
		temp#  =v0#	: v0#= v1# 	: v1#= temp#
	EndIf
	If y2#<y1#
		temp#=  x1#	: x1#=x2# 	: x2#=temp#
		temp#=  y1#	: y1#=y2# 	: y2#=temp#
		temp#=  u1#	: u1#=u2# 	: u2#=temp#
		temp#=  v1#	: v1#=v2# 	: v2#=temp#
	EndIf
	If y1#<y0#
		temp#=  x0#	: x0#= x1# 	: x1#= temp#
		temp#=  y0#	: y0#= y1# 	: y1#= temp#
		temp#=  u0#	: u0#= u1# 	: u1#= temp#
		temp#=  v0#	: v0#= v1# 	: v1#= temp#
	EndIf
	
	leftdy#=y1#-y0# : rightdy#=y2#-y0#
	
	If (leftdy#)<>0
		leftxm#=(x1#-x0#)/(leftdy#)
		leftum#=(u1#-u0#)/(leftdy#)
		leftvm#=(v1#-v0#)/(leftdy#)
	EndIf
	If (rightdy#)<>0
		rightxm#=(x2#-x0#)/(rightdy#)
		rightum#=(u2#-u0#)/(rightdy#)
		rightvm#=(v2#-v0#)/(rightdy#)
	EndIf
	
	leftx#=x0# : rightx#=leftx#
	leftu#=u0# : rightu#=leftu#
	leftv#=v0# : rightv#=leftv#
	
;uppper half
	For y=y0# To (y1#-1)
		If y>=0 And y<240
			If leftx#<rightx#
				lx#=leftx#
				lu#=leftu#
				lv#=leftv#
				rx#=rightx#
				ru#=rightu#
				rv#=rightv#
			Else
				lx#=rightx#
				lu#=rightu#
				lv#=rightv#
				rx#=leftx#
				ru#=leftu#
				rv#=leftv#
			EndIf
					
			deltax#=(rx#-lx#)
			If deltax#<>0
				hum#=(ru#-lu#)/(deltax#)
				hvm#=(rv#-lv#)/(deltax#)
			EndIf
			
			hu#=lu#
			hv#=lv#
			
			If lx#<319 And rx#>0
				If lx#<0
					S#=-lx#
					hu#=hu#+hum#*S#
					hv#=hv#+hvm#*S#
					lx#=0
				EndIf
				If rx#>319 rx#=319
				
				For x=Int(lx#) To Int(rx#)-1
					u=Int(hu#)
					v=Int(hv#)
					RGB=PeekFloat(image,((v Shl 8)+u)Shl 2)
					WritePixelFast(x,y,RGB)
					hu#=hu#+hum#
					hv#=hv#+hvm#
				Next	
			EndIf
		EndIf
		leftx#=leftx#+leftxm#
		leftu#=leftu#+leftum#
		leftv#=leftv#+leftvm#
		rightx#=rightx#+rightxm#
		rightu#=rightu#+rightum#
		rightv#=rightv#+rightvm#
	Next

;Lower half
	leftdy#=(y2#-y1#)
	
	If (leftdy)<>0
		leftxm#=(x2#-x1#)/leftdy#
		leftum#=(u2#-u1#)/leftdy#
		leftvm#=(v2#-v1#)/leftdy#
	EndIf
	
	leftx#=x1#
	leftu#=u1#
	leftv#=v1#
	
	For y=y1# To y2#
		If y>=0 And y<240
			If leftx#<rightx#
				lx#=leftx#
				lu#=leftu#
				lv#=leftv#
				rx#=rightx#
				ru#=rightu#
				rv#=rightv#
			Else
				lx#=rightx#
				lu#=rightu#
				lv#=rightv#
				rx#=leftx#
				ru#=leftu#
				rv#=leftv#
			EndIf
					
			deltax#=(rx#-lx#)
			If deltax#<>0
				hum#=(ru#-lu#)/(deltax#)
				hvm#=(rv#-lv#)/(deltax#)
			EndIf
			
			hu#=lu#
			hv#=lv#
			
			If lx#<319 And rx#>0
				If lx#<0
					S#=-lx#
					hu#=hu#+hum#*S#
					hv#=hv#+hvm#*S#
					lx#=0
				EndIf
				If rx#>319 rx#=319
				
				For x=(Int lx#) To ((Int rx#)-1)
					u=Int(hu#)
					v=Int(hv#)
					RGB=PeekFloat(image,((v Shl 8)+u)Shl 2)
					WritePixelFast(x,y,RGB)
					hu#=hu#+hum#
					hv#=hv#+hvm#
				Next
			EndIf
		EndIf	
		leftx#=leftx#+leftxm#
		leftu#=leftu#+leftum#
		leftv#=leftv#+leftvm#
		rightx#=rightx#+rightxm#
		rightu#=rightu#+rightum#
		rightv#=rightv#+rightvm#
	Next
	
;	Line x0#,y0#,x1#,y1#
;	Line x1#,y1#,x2#,y2#
;	Line x2#,y2#,x0#,y0#
End Function



Function GouraudPerspectiveTextureMap(x0#,y0#,z0#,u0#,v0#,i0#,x1#,y1#,z1#,u1#,v1#,i1#,x2#,y2#,z2#,u2#,v2#,i2#,material)

	If y1#<y0#
		temp#=x0# : x0#=x1# : x1#=temp#
		temp#=y0# : y0#=y1# : y1#=temp#
		temp#=z0# : z0#=z1# : z1#=temp#
		temp#=u0# : u0#=u1# : u1#=temp#
		temp#=v0# : v0#=v1# : v1#=temp#
		temp#=i0# : i0#=i1# : i1#=temp#
	EndIf
	If y2#<y1#
		temp#=x1# : x1#=x2# : x2#=temp#
		temp#=y1# : y1#=y2# : y2#=temp#
		temp#=z1# : z1#=z2# : z2#=temp#
		temp#=u1# : u1#=u2# : u2#=temp#
		temp#=v1# : v1#=v2# : v2#=temp#
		temp#=i1# : i1#=i2# : i2#=temp#
	EndIf	
	If y1#<y0#
		temp#=x0# : x0#=x1# : x1#=temp#
		temp#=y0# : y0#=y1# : y1#=temp#
		temp#=z0# : z0#=z1# : z1#=temp#
		temp#=u0# : u0#=u1# : u1#=temp#
		temp#=v0# : v0#=v1# : v1#=temp#
		temp#=i0# : i0#=i1# : i1#=temp#
	EndIf
	

	deltay#=(y1#-y0#)
	If deltay#<>0.0
		lxm#=(x1#-x0#)/deltay#
		lrm#=((1.0/z1#)-(1.0/z0#))/deltay#
		lum#=((u1#/z1#)-(u0#/z0#))/deltay#
		lvm#=((v1#/z1#)-(v0#/z0#))/deltay#
		lim#=((i1#/z1#)-(i0#/z0#))/deltay#
	EndIf

	deltay#=(y2#-y0#)
	If deltay#<>0.0
		rxm#=(x2#-x0#)/deltay#
		rrm#=((1.0/z2#)-(1.0/z0#))/deltay#
		rum#=((u2#/z2#)-(u0#/z0#))/deltay#
		rvm#=((v2#/z2#)-(v0#/z0#))/deltay#
		rim#=((i2#/z2#)-(i0#/z0#))/deltay#
	EndIf

	lx#=x0# : rx#=lx#
	lr#=(1.0/z0#) : rr#=lr#
	lu#=(u0#/z0#) : ru#=lu#
	lv#=(v0#/z0#) : rv#=lv#
	li#=(i0#/z0#) : ri#=li#
	
	For y=y0# To (y1#-1)
		If y>=0 And y<240
			If lx#>rx#
				leftx#=rx#
				leftr#=rr#
				leftu#=ru#
				leftv#=rv#
				lefti#=ri#
				rightx#=lx#
				rightr#=lr#
				rightu#=lu#
				rightv#=lv#
				righti#=li#
			Else
				leftx#=lx#
				leftr#=lr#
				leftu#=lu#
				leftv#=lv#
				lefti#=li#
				rightx#=rx#
				rightr#=rr#
				rightu#=ru#
				rightv#=rv#
				righti#=ri#
			EndIf
			deltax#=Int(rightx#-leftx#+1)
			If deltax#<>0
				hrm#=(rightr#-leftr#)/deltax#
				hum#=(rightu#-leftu#)/deltax#
				hvm#=(rightv#-leftv#)/deltax#
				him#=(righti#-lefti#)/deltax#
			EndIf
			hr#=leftr# 
			hu#=leftu#
			hv#=leftv#
			hi#=lefti#
			
			If leftx#<0
				S#=-leftx#
				hr#=hr#+hrm#*S#
				hu#=hu#+hum#*S#
				hv#=hv#+hvm#*S#
				hi#=hi#+him#*S#
				leftx#=0
			EndIf
			If rightx#>319 rightx#=319
			
			For x=leftx# To (rightx#)
				z#=1.0/hr#
				u=(hu#*z#)
				v=(hv#*z#)
				i=(hi#*z#)
				RGB=PeekFloat(material,((v Shl 8)+u)Shl 2)
				RB=(((RGB And $FF00FF)*i)Shr 8) And $FF00FF
				G=(((RGB And $00FF00)*i)Shr 8) And $00FF00
				WritePixelFast x,y,(RB Or G)
				hr#=hr#+hrm#
				hu#=hu#+hum#
				hv#=hv#+hvm#
				hi#=hi#+him#
			Next
		EndIf
		lx#=lx#+lxm#
		lr#=lr#+lrm#
		lu#=lu#+lum#
		lv#=lv#+lvm#
		li#=li#+lim#
		rx#=rx#+rxm#
		rr#=rr#+rrm#
		ru#=ru#+rum#
		rv#=rv#+rvm#
		ri#=ri#+rim#
	Next


	deltay#=(y2#-y1#)
	If deltay#<>0.0
		lxm#=(x2#-x1#)/deltay#
		lrm#=((1.0/z2#)-(1.0/z1#))/deltay#
		lum#=((u2#/z2#)-(u1#/z1#))/deltay#
		lvm#=((v2#/z2#)-(v1#/z1#))/deltay#
		lim#=((i2#/z2#)-(i1#/z1#))/deltay#
	EndIf
	
	lx#=x1#
	lr#=(1.0/z1#)
	lu#=(u1#/z1#)
	lv#=(v1#/z1#)
	li#=(i1#/z1#)

	For y=y1# To (y2#-1)
		If y>=0 And y<240
			If lx#>rx#
				leftx#=rx#
				leftr#=rr#
				leftu#=ru#
				leftv#=rv#
				lefti#=ri#
				rightx#=lx#
				rightr#=lr#
				rightu#=lu#
				rightv#=lv#
				righti#=li#
			Else
				leftx#=lx#
				leftr#=lr#
				leftu#=lu#
				leftv#=lv#
				lefti#=li#
				rightx#=rx#
				rightr#=rr#
				rightu#=ru#
				rightv#=rv#
				righti#=ri#
			EndIf
			deltax#=Int(rightx#-leftx#+1)
			If deltax#<>0
				hrm#=(rightr#-leftr#)/deltax#
				hum#=(rightu#-leftu#)/deltax#
				hvm#=(rightv#-leftv#)/deltax#
				him#=(righti#-lefti#)/deltax#
			EndIf
			hr#=leftr# 
			hu#=leftu#
			hv#=leftv#
			hi#=lefti#
			
			If leftx#<0
				S#=-leftx#
				hr#=hr#+hrm#*S#
				hu#=hu#+hum#*S#
				hv#=hv#+hvm#*S#
				hi#=hi#+him#*S#
				leftx#=0
			EndIf
			If rightx#>319 rightx#=319
			
			For x=leftx# To (rightx#)
				z#=1.0/hr#
				u=(hu#*z#)
				v=(hv#*z#)
				i=(hi#*z#)
				RGB=PeekFloat(material,((v Shl 8)+u)Shl 2)
				RB=(((RGB And $FF00FF)*i)Shr 8) And $FF00FF
				G=(((RGB And $00FF00)*i)Shr 8) And $00FF00
				WritePixelFast x,y,(RB Or G)
				hr#=hr#+hrm#
				hu#=hu#+hum#
				hv#=hv#+hvm#
				hi#=hi#+him#
			Next
		EndIf
		lx#=lx#+lxm#
		lr#=lr#+lrm#
		lu#=lu#+lum#
		lv#=lv#+lvm#
		li#=li#+lim#
		rx#=rx#+rxm#
		rr#=rr#+rrm#
		ru#=ru#+rum#
		rv#=rv#+rvm#
		ri#=ri#+rim#
	Next

;	Line x0,y0,x1,y1
;	Line x1,y1,x2,y2
;	Line x2,y2,x0,y0
	
End Function


Function GouraudPolygon(x0#,y0#,i0#,x1#,y1#,i1#,x2#,y2#,i2#,pallette)
	
	If y1#<y0#
		temp#=x0# : x0#=x1# : x1#=temp#
		temp#=y0# : y0#=y1# : y1#=temp#
		temp#=i0# : i0#=i1# : i1#=temp#
	EndIf
	If y2#<y1#
		temp#=x1# : x1#=x2# : x2#=temp#
		temp#=y1# : y1#=y2# : y2#=temp#
		temp#=i1# : i1#=i2# : i2#=temp#
	EndIf	
	If y1#<y0#
		temp#=x0# : x0#=x1# : x1#=temp#
		temp#=y0# : y0#=y1# : y1#=temp#
		temp#=i0# : i0#=i1# : i1#=temp#
	EndIf
	
	If y0#<=239 And y2#>=0
		deltay#=(y1#-y0#)
		If deltay#<>0.00
			lxm#=(x1#-x0#)/deltay#
			lim#=(i1#-i0#)/deltay#
		EndIf
		deltay#=(y2#-y0#)
		If deltay#<>0.00
			rxm#=(x2#-x0#)/deltay#
			rim#=(i2#-i0#)/deltay#
		EndIf
		
		lx#=x0# : rx#=lx#
		li#=i0# : ri#=li#
	
		For y=y0# To (y1#-1.00)
			If y>0 And y<240
				If lx#<rx#
					leftx#=lx#
					lefti#=li#
					rightx#=rx#
					righti#=ri#
				Else
					leftx#=rx#
					lefti#=ri#
					rightx#=lx#
					righti#=li#
				EndIf
				
				deltax#=Int(rightx#-leftx#+1)
				If deltax#<>0.00
					him#=(righti#-lefti#)/deltax#
				EndIf	
				hi#=lefti#
				
				;scanline clipping
				If leftx#<0	
					S#=Abs(leftx#) : hi#=hi#+him#*S# : leftx#=0
				EndIf
				If rightx#>319 rightx#=319
				
				For x=leftx# To rightx#
					WritePixelFast x,y,PeekFloat(pallette,((Int hi#)And$FF)Shl 2)
					hi#=hi#+him#
				Next
			EndIf
			lx#=lx#+lxm#
			li#=li#+lim#
			rx#=rx#+rxm#
			ri#=ri#+rim#
		Next
			
		deltay#=(y2#-y1#)
		If deltay#<>0.00
			lxm#=(x2#-x1#)/deltay#
			lim#=(i2#-i1#)/deltay#
		EndIf
			
		lx#=x1#
		li#=i1#
			
		For y=y1# To (y2#-1.00)
			If y>0 And y<240
				If lx#<rx#
					leftx#=lx#
					lefti#=li#
					rightx#=rx#
					righti#=ri#
				Else
					leftx#=rx#
					lefti#=ri#
					rightx#=lx#
					righti#=li#
				EndIf
				
				deltax#=Int(rightx#-leftx#+1)
				If deltax#<>0.00
					him#=(righti#-lefti#)/deltax#
				EndIf	
				hi#=lefti#
				
				;scanline clipping
				If leftx#<0	
					S#=Abs(leftx#) : hi#=hi#+him#*S# : leftx#=0
				EndIf
				If rightx#>319 rightx#=319
				
				For x=leftx# To rightx#
					WritePixelFast x,y,PeekFloat(pallette,((Int hi#)And$FF)Shl 2)
					hi#=hi#+him#
				Next
			EndIf
			lx#=lx#+lxm#
			li#=li#+lim#
			rx#=rx#+rxm#
			ri#=ri#+rim#
		Next
	EndIf
End Function

Function PhongBumpMap(x0#,y0#,u0#,v0#,i0#,j0#,x1#,y1#,u1#,v1#,i1#,j1#,x2#,y2#,u2#,v2#,i2#,j2#,envmap,bumpmap)

	If y1#<y0#
		temp#=x0# : x0#=x1# : x1#=temp#
		temp#=y0# : y0#=y1# : y1#=temp#
		temp#=u0# : u0#=u1# : u1#=temp#
		temp#=v0# : v0#=v1# : v1#=temp#
		temp#=i0# : i0#=i1# : i1#=temp#
		temp#=j0# : j0#=j1# : j1#=temp#
	EndIf
	If y2#<y1#
		temp#=x1# : x1#=x2# : x2#=temp#
		temp#=y1# : y1#=y2# : y2#=temp#
		temp#=u1# : u1#=u2# : u2#=temp#
		temp#=v1# : v1#=v2# : v2#=temp#
		temp#=i1# : i1#=i2# : i2#=temp#
		temp#=j1# : j1#=j2# : j2#=temp#
	EndIf	
	If y1#<y0#
		temp#=x0# : x0#=x1# : x1#=temp#
		temp#=y0# : y0#=y1# : y1#=temp#
		temp#=u0# : u0#=u1# : u1#=temp#
		temp#=v0# : v0#=v1# : v1#=temp#
		temp#=i0# : i0#=i1# : i1#=temp#
		temp#=j0# : j0#=j1# : j1#=temp#
	EndIf
	
	If y0#<=239 And y2#>=0
		deltay#=(y1#-y0#)
		If deltay#<>0.00
			lxm#=(x1#-x0#)/deltay#
			lum#=(u1#-u0#)/deltay#
			lvm#=(v1#-v0#)/deltay#
			lim#=(i1#-i0#)/deltay#
			ljm#=(j1#-j0#)/deltay#
		EndIf
		deltay#=(y2#-y0#)
		If deltay#<>0.00
			rxm#=(x2#-x0#)/deltay#
			rum#=(u2#-u0#)/deltay#
			rvm#=(v2#-v0#)/deltay#
			rim#=(i2#-i0#)/deltay#
			rjm#=(j2#-j0#)/deltay#
		EndIf
		
		lx#=x0# : rx#=lx#
		lu#=u0# : ru#=lu#
		lv#=v0# : rv#=lv#
		li#=i0# : ri#=li#
		lj#=j0# : rj#=lj#
	
		For y=y0# To (y1#-1.00)
			If y>0 And y<240
				If lx#<rx#
					leftx#=lx#
					leftu#=lu#
					leftv#=lv#
					lefti#=li#
					leftj#=lj#
					rightx#=rx#
					rightu#=ru#
					rightv#=rv#
					righti#=ri#
					rightj#=rj#
				Else
					leftx#=rx#
					leftu#=ru#
					leftv#=rv#
					lefti#=ri#
					leftj#=rj#
					rightx#=lx#
					rightu#=lu#
					rightv#=lv#
					righti#=li#
					rightj#=lj#
				EndIf
				
				deltax#=Int(rightx#-leftx#+1)
				If deltax#<>0.00
					hum#=(rightu#-leftu#)/deltax#
					hvm#=(rightv#-leftv#)/deltax#
					him#=(righti#-lefti#)/deltax#
					hjm#=(rightj#-leftj#)/deltax#
				EndIf	
				hu#=leftu#
				hv#=leftv#
				hi#=lefti#
				hj#=leftj#
				
				;scanline clipping
				If leftx#<0	
					S#=Abs(leftx#)
					hu#=hu#+hum#*S#
					hv#=hv#+hvm#*S#
					hi#=hi#+him#*S#
					hj#=hj#+hjm#*S#
					leftx#=0
				EndIf
				If rightx#>319 rightx#=319
				
				For x=leftx# To rightx#
					u=(Int hu#)And$FF: v=(Int hv#)And$FF
					OFFS=((v Shl 8)+u)Shl 1
					BU=PeekByte(bumpmap,OFFS)
					BV=PeekByte(bumpmap,OFFS+1)
					i=(hi#+BU) And$FF : j=(hj#+BV) And$FF
					RGB=PeekFloat(ENVMAP,((j Shl 8)+i)Shl 2)
					WritePixelFast(x,y,RGB)
					hu#=hu#+hum#
					hv#=hv#+hvm#
					hi#=hi#+him#
					hj#=hj#+hjm#
				Next
			EndIf
			lx#=lx#+lxm#
			lu#=lu#+lum#
			lv#=lv#+lvm#
			li#=li#+lim#
			lj#=lj#+ljm#
			rx#=rx#+rxm#
			ru#=ru#+rum#
			rv#=rv#+rvm#
			ri#=ri#+rim#
			rj#=rj#+rjm#
		Next

		deltay#=(y2#-y1#)
		If deltay#<>0.00
			lxm#=(x2#-x1#)/deltay#
			lum#=(u2#-u1#)/deltay#
			lvm#=(v2#-v1#)/deltay#
			lim#=(i2#-i1#)/deltay#
			ljm#=(j2#-j1#)/deltay#
		EndIf
			
		lx#=x1#
		lu#=u1#
		lv#=v1#
		li#=i1#
		lj#=j1#
			
		For y=y1# To (y2#-1.00)
			If y>0 And y<240
				If lx#<rx#
					leftx#=lx#
					leftu#=lu#
					leftv#=lv#
					lefti#=li#
					leftj#=lj#
					rightx#=rx#
					rightu#=ru#
					rightv#=rv#
					righti#=ri#
					rightj#=rj#
				Else
					leftx#=rx#
					leftu#=ru#
					leftv#=rv#
					lefti#=ri#
					leftj#=rj#
					rightx#=lx#
					rightu#=lu#
					rightv#=lv#
					righti#=li#
					rightj#=lj#
				EndIf
				
				deltax#=Int(rightx#-leftx#+1)
				If deltax#<>0.00
					hum#=(rightu#-leftu#)/deltax#
					hvm#=(rightv#-leftv#)/deltax#
					him#=(righti#-lefti#)/deltax#
					hjm#=(rightj#-leftj#)/deltax#
				EndIf	
				hu#=leftu#
				hv#=leftv#
				hi#=lefti#
				hj#=leftj#
				
				;scanline clipping
				If leftx#<0	
					S#=Abs(leftx#)
					hu#=hu#+hum#*S#
					hv#=hv#+hvm#*S#
					hi#=hi#+him#*S#
					hj#=hj#+hjm#*S#
					leftx#=0
				EndIf
				If rightx#>319 rightx#=319
				
				For x=leftx# To rightx#
					u=(Int hu#)And$FF: v=(Int hv#)And$FF
					OFFS=((v Shl 8)+u)Shl 1
					BU=PeekByte(bumpmap,OFFS)
					BV=PeekByte(bumpmap,OFFS+1)
					i=(hi#+BU) And$FF : j=(hj#+BV) And$FF
					RGB=PeekFloat(ENVMAP,((j Shl 8)+i)Shl 2)
					WritePixelFast(x,y,RGB)
					hu#=hu#+hum#
					hv#=hv#+hvm#
					hi#=hi#+him#
					hj#=hj#+hjm#
				Next
			EndIf
			lx#=lx#+lxm#
			lu#=lu#+lum#
			lv#=lv#+lvm#
			li#=li#+lim#
			lj#=lj#+ljm#
			rx#=rx#+rxm#
			ru#=ru#+rum#
			rv#=rv#+rvm#
			ri#=ri#+rim#
			rj#=rj#+rjm#
		Next
	EndIf
End Function


Function Writepixelsafe(x,y,RGB)
	If x>0 And x<320
		If y>0 And y<240
			WritePixelFast x,y,RGB
		EndIf
	EndIf
End Function	
		

Function LinearPallette(o.obj,r#,g#,b#)
	o\pallette=CreateBank(256*4)
	For i#=0 To 255
		PokeFloat(o\pallette,i#*4,((r#/255.0*i#)Shl 16)+((g#/255.0*i#)Shl 8)+(b#/255.0*i#))
	Next
	o\FLAG=0
End Function

Function PhongPallette(o.obj,sr#,sg#,sb#,dr#,dg#,db#,spr#,spg#,spb#,n)
	o\pallette=CreateBank(255*4)
;	sr#=255.0/sr# : sg#=255.0/sg# : sb#=255.0/sb#
;	dr#=255.0/dr# : dg#=255.0/dg# : db#=255.0/db#
;	spr#=255.0/spr# : spg#=255.0/spg# : spb#=255.0/spb#
	For i#=0 To 255
		ang#=(90.00/255.00)*(255-i#)
		R=(sr#+Cos(ang#)*dr#+Cos(ang#)^n*spr#);*255
		If R>255 R=255
		G=(sg#+Cos(ang#)*dg#+Cos(ang#)^n*spg#);*255
		If G>255 G=255
		B=(sb#+Cos(ang#)*db#+Cos(ang#)^n*spb#);*255
		If B>255 B=255
		PokeFloat(o\pallette,i#*4,(R Shl 16)+(G Shl 8)+B)
	Next
	o\FLAG=0
End Function

Type light
	Field x#,y#,z#
End Type

Function Light.light(x#,y#,z#)
	l.light=New light
	l\x#=x#
	l\y#=y#
	l\z#=z#
	Return l
End Function

Function MoveLight(l.light,x#,y#,z#)
	l\x#=l\x#+x#
	l\y#=l\y#+y#
	l\z#=l\z#+z#
End Function

Function PositionLight(l.light,x#,y#,z#)
	l\x#=x#
	l\y#=y#
	l\z#=z#
End Function