Global FOV#=250,EPSILON#=0.000001,PLANE_OFFSET=650

Dim ScrGrid(20,15,2)

Function FreePlanes(anga#,angb#,angc#)
	O.Vector=Vector() : Di.vector=Vector() : D.vector=Vector() : I.vector=Vector()
	CAM.matrix=Matrix()
	RotateMatrix(CAM,anga#,angb#,angc#)
	For y=0 To 15
		For x=0 To 20	
			SetVector(Di,((x Shl 4)-160)/FOV#,((y Shl 4)-120)/FOV#,1)
			TransformVector(Di,cam,D)
			Normalize(D)
			
			t#=((Sgn(D\y#)*PLANE_OFFSET-O\y#)/D\y#)
			
			ScaleVector(D,t#)
			VectorAdd(O,D,I)
			
			ScrGrid(x,y,0)=(i\x#)*0.3
			ScrGrid(x,y,1)=(i\z#)*0.3
			
			VectorSub(I,O,I)
			dist#=VectorLength(I)
			ScrGrid(x,y,2)=4000/Sqr(dist#)			
		Next
	Next
	Delete CAM : Delete D : Delete Di : Delete O : Delete I
End Function

Function FreeTunnel(anga#,angb#,angc#)
	Di.vector=Vector() : D.vector=Vector() : I.vector=Vector()
	CAM.matrix=Matrix()
	RotateMatrix(CAM,anga#,angb#,angc#)
	O.Vector=Vector(0,0,anga*10)
	For y=0 To 15
		For x=0 To 20	
			SetVector(Di,(Float(x Shl 4)-160.0)/FOV#,(Float(y Shl 4)-120.0)/FOV#,1)
			TransformVector(Di,cam,D)
			Normalize(D)

			a#=D\x#*D\x#+D\y#*D\y#
			b#=2.0*(O\x#*D\x#+O\y#+D\y#)
			c#=O\x#*O\x#+O\y#*O\y#-65536.0
			DD#=Sqr(b#*b#-4.0*a#*c#)
			
			t1#=(-b#+DD#)/(2.0*a#+0.00000001)
			t2#=(-b#-DD#)/(2.0*a#+0.00000001)

			If t1#>0 t#=t1# Else t#=t2#
			
			ScaleVector(D,t#)
			VectorAdd(O,D,I)
				
			ScrGrid(x,y,0)=Int(I\z#*0.6)
			ScrGrid(x,y,1)=Int((ATan2(I\y#,Abs I\x#)))*4
			ScrGrid(x,y,2)=49000.0/t#			
		Next
	Next
	Delete CAM : Delete D : Delete Di : Delete O : Delete I
End Function

Function RenderBlockScreen()
	For y=0 To 14
		For x=0 To 19
			u0=ScrGrid(x,y,0)
			u1=ScrGrid(x+1,y,0)
			u2=ScrGrid(x,y+1,0)
			u3=ScrGrid(x+1,y+1,0)
			v0=ScrGrid(x,y,1)
			v1=ScrGrid(x+1,y,1)
			v2=ScrGrid(x,y+1,1)
			v3=ScrGrid(x+1,y+1,1)
			shade=(ScrGrid(x,y,2)+ScrGrid(x+1,y,2)+ScrGrid(x,y+1,2)+ScrGrid(x+1,y+1,2))/4
			
			RenderBlock(x Shl 4,y Shl 4,u0,v0,u1,v1,u2,v2,u3,v3,shade)
		Next
	Next
End Function


Function RenderBlock(x,y,u0#,v0#,u1#,v1#,u2#,v2#,u3#,v3#,shade)

	leftu#=u0# : rightu#=u1#
	leftv#=v0# : rightv#=v1#
	
	leftum#=(u2#-u0#)/16.0
	leftvm#=(v2#-v0#)/16.0
	rightum#=(u3#-u1#)/16.0
	rightvm#=(v3#-v1#)/16.0
	
	For sy=y To (y+15)
		u#=leftu#
		v#=leftv#
		um#=(rightu#-leftu#)/16.0
		vm#=(rightv#-leftv#)/16.0
		For sx=x To (x+15)
			WritePixelFast sx,sy,(((((Int u#)And$FF) Xor ((Int v#)And$FF))*shade)Shr 8)
			u#=u#+um#
			v#=v#+vm#
		Next
		leftu#=leftu#+leftum#
		leftv#=leftv#+leftvm#
		rightu#=rightu#+rightum#
		rightv#=rightv#+rightvm#
	Next

End Function