Function MakeDotballObject(num=0)
	Select(num)
		Case 0
			Delete Each dotball	
			For z#=-10 To 10 Step 4
				For y#=-10 To 10 Step 4
					For x#=-10 To 10 Step 4
						Dotball(x*25,y*25,z*25)
					Next
				Next
			Next
			Return True
		Case 1
			Delete Each dotball
			For z#=-20 To 20 Step 4
				For ang=0 To 359 Step 30	
					Dotball(250*Cos(ang),250*Sin(ang),z*25)
				Next
			Next
			Return True
		Case 2
			Delete Each dotball
			For phi#=0 To 180 Step 18
				y#=Cos(phi#)
				rad#=Sin(phi#)
				For theta#=0 To 359 Step 18
					x#=rad#*Cos(theta#)
					z#=rad#*Sin(theta#)
					Dotball(350*x#,350*y#,350*z#)
				Next
			Next
			Return True
		Case 3
			Delete Each dotball
			For z#=-30 To 30 Step 2
				Dotball(250*Cos(z*10),250*Sin(z*10),z*25)
				Dotball(250*Cos(z*10+180),250*Sin(z*10+180),z*25)
			Next
			Return True
		Case 4
			Delete Each dotball
			For z#=-7 To 7 Step 2
				For x=-7 To 7 Step 2	
					Dotball(x*60,120,z*60)
					Dotball(x*60,-120,z*60)
				Next
			Next
			Return True
		Case 5
			Delete Each dotball
			For rad#=4 To 8
				For theta#=0 To 359 Step 30
					DotBall(rad#*80*Cos(theta#),0,rad#*80*Sin(theta#))
				Next
			Next
			Return True
		Default
			Delete Each dotball
			Return False
	End Select
End Function
	
		
Function RenderDotballs(DOTBALLS,ang,x#=0)
	m.matrix=Matrix()

	Color 64,0,64
	Rect 160,100,120,140

	RotateMatrix(m,ang,ang,ang)
	For d.dotball=Each dotball
		TransformVector(d\pos,m,d\rot)
	Next
	
	Repeat
		done=True
		For d.dotball=Each dotball
			If (After d)<>Null
				d2.dotball=After d
				If d2\rot\z#<d\rot\z#
					done=False
					Insert d2 Before d
				EndIf
			EndIf
		Next
		If KeyHit(1) End
	Until done=True 
	
	SetBuffer ImageBuffer(back)
		ClsColor 0,0,0
		Cls
		For d.dotball=Each dotball
			sx=((d\rot\x#+x#)*256/(1024-d\rot\z#))+144
			sy=(d\rot\y#*256/(1024-d\rot\z#))+104
			DrawImage DOTBALLS,sx,sy,(ang+d\offset)Mod 360
		Next
	SetBuffer BackBuffer()
	ClsColor 0,0,48
	
	DrawImage back,0,0
	
	Delete m
End Function

Type dotball
	Field pos.vector
	Field rot.vector
	Field offset
End Type

Function Dotball(x#,y#,z#)
	d.dotball=New dotball
	d\pos=Vector(x#,y#,z#)
	d\rot=Vector()
	d\offset=Rnd(0,359)
End Function


Function PrecalcDotballs()
	Color 0,0,0 : ClsColor 255,0,0
	v.vector=Vector()
	r.vector=Vector()
	m.matrix=Matrix()
	DOTBALLS=CreateImage(32,32,360) : MaskImage DOTBALLS,255,0,0
	For ang=0 To 359
		RotateMatrix(m,ang,ang*3,ang*2)
		SetBuffer ImageBuffer(DOTBALLS,ang)
		Cls : Oval 1,1,31,31
		LockBuffer
			For phi#=0 To 360 Step 12
				y#=30*Cos(phi#)
				rad#=30*Sin(phi#)
				For theta#=0 To 360 Step 24
					x#=rad#*Cos(theta#)
					z#=rad#*Sin(theta#)
					SetVector(v,x#,y#,z#)
					TransformVector(v,m,r)
					If r\z#>=0
						sx=(r\x#*256/(512-r\z#))+16
						sy=(r\y#*256/(512-r\z#))+16
						WritePixelFast sx,sy,$FFFFFF
					EndIf
				Next
			Next
		UnlockBuffer
	Next
	Delete v : Delete r : Delete m
	Return DOTBALLS
End Function