' enough - a 96k quickbasic intro
' by plasma / jon petrosky  [02-03-2006]
' www.phatcode.net

DEFINT A-Z
'$DYNAMIC
'$NEAR
'$NO_STRING_PACK

'$NO_COM
'$NO_EMU
'$SMALL_ERR

'$LIB: 'LIBS\DQB.LIB'
'$OBJ: 'LIBS\QBX_MSE.OBJ'
'$OBJ: 'LIBS\DOSFILE.OBJ'
'$OBJ: 'RES\OBJ\GDM.OBJ'
'$OBJ: 'RES\OBJ\SB2X.OBJ'
'$OBJ: 'RES\OBJ\SB16.OBJ'
'$OBJ: 'RES\OBJ\GUS.OBJ'
'$OBJ: 'RES\OBJ\PAL.OBJ'
'$OBJ: 'RES\OBJ\FONT.OBJ'
'$OBJ: 'RES\OBJ\PLASMA.OBJ'
'$OBJ: 'RES\OBJ\IBM.OBJ'

'$INCLUDE: 'LIBS\INC\DIRECTQB.BI'
'$INCLUDE: 'LIBS\INC\BWSB.BI'
'$INCLUDE: 'LIBS\INC\GDMTYPE.BI'
'$INCLUDE: 'LIBS\INC\DOSFILE.BI'
'$INCLUDE: 'RES\INC\GDM.BI'
'$INCLUDE: 'RES\INC\SB2X.BI'
'$INCLUDE: 'RES\INC\SB16.BI'
'$INCLUDE: 'RES\INC\GUS.BI'
'$INCLUDE: 'RES\INC\PAL.BI'
'$INCLUDE: 'RES\INC\FONT.BI'
'$INCLUDE: 'RES\INC\PLASMA.BI'
'$INCLUDE: 'RES\INC\IBM.BI'

DECLARE SUB GetBlaster (BaseAddr, IRQ, DMA)
DECLARE SUB GetUltrasnd (BaseAddr, IRQ, DMA)

' From Rel's 3D Tut #3
DECLARE SUB CalcNormals (Model() AS ANY, Poly() AS ANY, v() AS ANY, v2() AS ANY)
DECLARE SUB DrawCube (Model() AS ANY, Vector() AS ANY)
DECLARE SUB LoadCube (Model() AS ANY, Vector() AS ANY)
DECLARE SUB RotateAndProject (Model() AS ANY, AngleX, AngleY, AngleZ)
DECLARE SUB RotateNormals (v() AS ANY, v2() AS ANY, AngleX, AngleY, AngleZ)

' From PP256
DECLARE SUB InitImageData (ImageSeg, ImageOff, ImageLen, ImageArray())
DECLARE SUB MakeImageIndex (ImageArray(), IndexArray())

' From RelLib 5
DECLARE SUB RelFont256 (DestSeg, x, y, Text$, Centered, FontArray(), FontArrayIndex())
DECLARE SUB RelFadeToPalX (StartCol, EndCol, PalString$, Counts, FadeMusic)
DECLARE SUB RelFadeToPalStep (StartCol, EndCol, PalString$)
DECLARE SUB RelReadPal (PalString$)
DECLARE SUB RelReadRGB (ColorVal, r, g, b)
DECLARE SUB RelWriteRGB (ColorNum, r, g, b)

TYPE PointType
  x AS SINGLE
  y AS SINGLE
  z AS SINGLE
  xr AS SINGLE
  yr AS SINGLE
  zr AS SINGLE
  sx AS INTEGER
  sy AS INTEGER
END TYPE

TYPE PolyType
  p1 AS INTEGER
  p2 AS INTEGER
  p3 AS INTEGER
END TYPE

TYPE VectorType
  x AS SINGLE
  y AS SINGLE
  z AS SINGLE
END TYPE

CONST Pi = 3.14151693#
CONST Lens = 256
CONST CenterX = 160
CONST CenterY = 100
CONST MinX = -300
CONST MaxX = 300
CONST MinY = -200
CONST MaxY = 200
CONST MinZ = 0
CONST MaxZ = 500

CONST NONE = 0
CONST SB2X = 1
CONST SB16 = 2
CONST GUS = 3

' Lookup tables for speed
DIM SHARED LCos(359) AS SINGLE
DIM SHARED LSin(359) AS SINGLE

REDIM SHARED CubeModel(1) AS PointType
REDIM SHARED CubePoly(1) AS PolyType
REDIM SHARED CubeNormal(1) AS VectorType     ' Original Face normal
REDIM SHARED CubeVtxNormal(1) AS VectorType  ' Original Vertex normal
REDIM SHARED CubeVtxNormal2(1) AS VectorType ' Rotated Vertex normal

DIM SHARED ThetaX, ThetaY, ThetaZ     ' Angle of rotation
DIM SHARED LightNormal AS VectorType  ' Our light normal
DIM SHARED CamX, CamY, CamZ           ' Camera offset

RANDOMIZE TIMER


' Process command line
SoundDev = SB2X
IF INSTR(COMMAND$, "NOSOUND") THEN
  SoundDev = NONE
ELSEIF INSTR(COMMAND$, "GUS") THEN
  SoundDev = GUS
ELSEIF INSTR(COMMAND$, "SB16") THEN
  SoundDev = SB16
ELSEIF INSTR(COMMAND$, "H") OR INSTR(COMMAND$, "?") THEN
  PRINT "enough - a 96k quickbasic intro by plasma"
  PRINT
  PRINT "/nosound  disables music"
  PRINT "/sb2x     use SB2X driver (mono, default)"
  PRINT "/sb16     use SB16 driver (stereo)"
  PRINT "/gus      use Gravis Ultrasound driver"
  END
END IF


' Memory check
HeapSize& = SETMEM(0)
MemLeft& = SETMEM(-294912)
IF (HeapSize& - MemLeft&) < 294912 THEN
  PRINT "error: not enough free conventional memory (520k needed)"
  END
END IF


' Setup DQB
IF DQBinit(0, 0, 0) > 0 THEN
  PRINT "error: 386 or better cpu required"
  END
END IF

IF DQBsetBaseLayer(B0) = 0 OR DQBsetBaseLayer(B1) = 0 OR DQBcreateBMap(1, 128, 191) > 0 THEN
  PRINT "error: not enough free conventional memory (520k needed)"
  DQBclose
  END
END IF

' FFix
DQBfpu

' Blender map
FOR Blue = 128 TO 191
  FOR Red = 96 TO 127
    RedInt = (Red - 96)
    BlueInt = (Blue - 128)
    New = (RedInt + BlueInt) / 4 + 64
    DQBsetBMap 1, Blue, Red, New
  NEXT
  FOR Gray = 192 TO 255
    grayint = (Gray - 192) / 1.5
    BlueInt = (Blue - 128) * 1.5
    New = (grayint + BlueInt) / 2 + 128
    DQBsetBMap 1, Blue, Gray, New
    IF Gray = 192 THEN DQBsetBMap 1, Blue, 0, New
  NEXT
NEXT


' Setup BWSB
IF SoundDev <> NONE THEN

  DIM ModHeader AS GDMHeader

  TempFile$ = "________.$$$" + CHR$(0)
  TempSeg = VARSEG(TempFile$)
  TempOff = SADD(TempFile$)

  BaseAddr = &HFFFF
  IRQ = &HFF
  DMA = &HFF

  IF SoundDev = GUS THEN
    GetUltrasnd BaseAddr, IRQ, DMA
    IF NOT WriteGUS(TempSeg, TempOff) THEN
      PRINT "error: intro must be run from a writeable drive"
      DQBclose
      END
    END IF
  ELSE
    GetBlaster BaseAddr, IRQ, DMA
    IF SoundDev = SB16 THEN
      IF NOT WriteSB16(TempSeg, TempOff) THEN
        PRINT "error: intro must be run from a writeable drive"
        DQBclose
        END
      END IF
    ELSE
      IF NOT WriteSB2X(TempSeg, TempOff) THEN
        PRINT "error: intro must be run from a writeable drive"
        DQBclose
        END
      END IF
    END IF
  END IF

  rc = xLoadMSE(TempSeg, TempOff, 0, 44, 32767, BaseAddr, IRQ, DMA)
  DeleteFile TempSeg, TempOff

  IF rc <> 0 THEN
    SoundDev = NONE
  ELSE
    IF NOT WriteGDM(TempSeg, TempOff) THEN
      SoundDev = NONE
    ELSE
      Handle = OpenFile(TempSeg, TempOff)
      LoadGDM Handle, 0, ErrorFlag, VARSEG(ModHeader), VARPTR(ModHeader)
      CloseFile Handle
      DeleteFile TempSeg, TempOff
      IF ErrorFlag <> 0 THEN SoundDev = NONE
    END IF
    IF SoundDev = NONE THEN
      FreeMSE
    ELSE
      rc& = StartOutput(4, 0)
      rc = MusicVolume(0)
    END IF
  END IF

END IF


' Setup cube
' Precalc sin and cos lookup table
FOR i = 0 TO 359
  a! = i * Pi / 180
  LCos(i) = COS(a!)
  LSin(i) = SIN(a!)
NEXT

' Light normal
LightNormal.x = 0
LightNormal.y = -.3
LightNormal.z = -.6

' Setup cube including normals
LoadCube CubeModel(), CubePoly()
RotateAndProject CubeModel(), 0, 0, 0
CalcNormals CubeModel(), CubePoly(), CubeNormal(), CubeVtxNormal()

' Starting cube angles
ThetaX = INT(RND * 360)
ThetaY = INT(RND * 360)
ThetaZ = INT(RND * 360)

' Starting camera coords
CamX = 400
CamY = -400
CamZ = 128

' Starting camera velocities
VelX! = -2
VelY! = 0
VelZ! = 2

' Number of cycles to wait before "dropping" cube
WaitCube = 180

' Logo coords and velocity info
BounceX = 34
BounceY = 117
BounceInc! = 0
BounceDir = 1


' Setup font
REDIM FontData(1 TO 1)
REDIM FontIndex(1 TO 1)
FontLen = GetFont(FontSeg, FontOff)
InitImageData FontSeg, FontOff, FontLen, FontData()
MakeImageIndex FontData(), FontIndex()


' Setup palette
rc = GetPal(PalSeg, PalOff)
DIM GradPal AS STRING * 768
DEF SEG = PalSeg
FOR i = 1 TO 768
  MID$(GradPal, i, 1) = CHR$(PEEK(i + PalOff - 1))
NEXT


' Setup scroll text
Scroll$ = ""
RESTORE Scroller
READ NumLines
FOR i = 1 TO NumLines
  READ Text$
  Scroll$ = Scroll$ + Text$
NEXT

' Starting scroll coord
ScrollX = 320


' Start demo
DQBinitVGA

rc = GetIBM(BackSeg, BackOff)
DQBfput B0, 0, 0, BackSeg, BackOff

rc = GetPlasma(PlasSeg, PlasOff)
DQBput B0, 34, 81, PlasSeg, PlasOff

DQBpalOff
DQBcopyLayer B0, VIDEO

IF SoundDev <> NONE THEN
  StartMusic
  RelFadeToPalX 0, 63, GradPal, 512, TRUE
ELSE
  RelFadeToPalX 0, 63, GradPal, 512, FALSE
END IF
DQBwait 240
RelFadeToPalX 0, 255, GradPal, 256, FALSE


DO WHILE INKEY$ <> ""
LOOP


DO
  ' "Bounce" logo
  DQBfput B0, 0, 0, BackSeg, BackOff
  IF BounceDir = 1 THEN
    BounceInc! = BounceInc! + .1
    BounceY = BounceY + BounceInc!
    IF BounceY > 199 THEN
      BounceY = 199
      BounceDir = -1
      BounceInc! = RND(1) * 3 + 3
    END IF
  ELSE
    BounceInc! = BounceInc! - .1
    IF BounceInc! < 0 THEN
      BounceInc! = 0
      BounceDir = 1
    END IF
    BounceY = BounceY - BounceInc!
  END IF
  DQBput B0, BounceX, BounceY - 36, PlasSeg, PlasOff

  ' Scroller
  IF WaitCube = 0 THEN
    RelFont256 B0, (ScrollX), 90, Scroll$, FALSE, FontData(), FontIndex()
    ScrollX = ScrollX - 1
    IF ScrollX < -11000 THEN ScrollX = 320
  END IF

  ' Increment cube angles
  ThetaX = (ThetaX + 1) MOD 360
  ThetaY = (ThetaY + 1) MOD 360
  ThetaZ = (ThetaZ + 1) MOD 360

  ' Move camera
  IF WaitCube > 0 THEN
    WaitCube = WaitCube - 1
  ELSE
    VelY! = VelY! + .25
    CamY = CamY + VelY!
    IF CamY > MaxY THEN
      CamY = MaxY - (CamY - MaxY)
      VelY! = -10 - (RND(1) * 4)
    END IF

    CamX = CamX + VelX!
    IF CamX < MinX THEN
      CamX = MinX - (CamX - MinX)
      VelX! = 2 + RND(1) * 2
    ELSEIF CamX > MaxX THEN
      CamX = MaxX - (CamX - MaxX)
      VelX! = -2 - RND(1) * 2
    END IF

    CamZ = CamZ + VelZ!
    IF CamZ < MinZ THEN
      CamZ = MinZ - (CamZ - MinZ)
      VelZ! = 2 + RND(1) * 2
    ELSEIF CamZ > MaxZ THEN
      CamZ = MaxZ - (CamZ - MaxZ)
      VelZ! = -2 - RND(1) * 2
    END IF
  END IF

  ' Rotate cube
  RotateAndProject CubeModel(), ThetaX, ThetaY, ThetaZ
  RotateNormals CubeVtxNormal(), CubeVtxNormal2(), ThetaX, ThetaY, ThetaZ

  DQBclearLayer B1
  DrawCube CubeModel(), CubePoly()
  DQBcopyBlendLayer B1, B0, 1

  DQBwait 1
  DQBcopyLayer B0, VIDEO

  IF INKEY$ <> "" AND EndIt = 0 THEN EndIt = 1

  ' Fade Out
  IF EndIt > 0 THEN
    EndIt = EndIt + 1
    IF (EndIt AND 3) = 0 THEN
      RelFadeToPalStep 0, 255, STRING$(768, 0)
      IF SoundDev <> NONE THEN rc = MusicVolume(64 - (EndIt \ 4))
    END IF
    IF EndIt >= 256 THEN EXIT DO
  END IF

LOOP


IF SoundDev <> NONE THEN
  StopMusic
  StopOutput
  UnloadModule
  FreeMSE
END IF

DQBinitText
DQBclose

END


' Cube Data
NumPoints:
DATA 8
VertexData:
DATA -50,50,50
DATA 50,50,50
DATA 50,50,-50
DATA -50,50,-50
DATA -50,-50,50
DATA 50,-50,50
DATA 50,-50,-50
DATA -50,-50,-50
NumPoly:
DATA 12
ConnectData:
DATA 5,4,0, 5,0,1
DATA 6,2,3, 3,7,6
DATA 6,5,1, 6,1,2
DATA 7,0,4, 7,3,0
DATA 6,7,4, 6,4,5
DATA 0,3,2, 1,0,2

' Scroll Text
Scroller:
DATA 12
DATA "  96K OUGHT TO BE ENOUGH FOR ANYBODY ... RIGHT?                       "
DATA "    SORRY FOR THE CRAPPY INTRO, I GUESS THAT'S WHAT HAPPENS WHEN YOU "
DATA "START THE DAY IT'S DUE. MAYBE NEXT TIME I'LL HAVE SOME REAL EFFECTS "
DATA "IN HERE :) AND YES, I USED A FEW LIBS ... NOW CREDIT WHERE IT'S DUE "
DATA "... MOD PLAYER IS BWSB, GRAPHICS ARE DONE WITH DQB AND A LITTLE RELLIB"
DATA " ... ORIGINAL CUBE SHADING CODE FROM ONE OF REL'S TUTS ... THE MUSIC "
DATA "PLAYING IS 'PLEASURE TO PASO' BY PASO OF DYTEC                        "
DATA "   RESPECT TO:  SUBXERO  REL  DAV  TOSHI  OPTIMUS  GLENN  V1C  BLITZ  "
DATA "ANGELO  JOCKE  JOFERS  MARCADE  AGS  19DAY  CHAOTICMASS  ALIAS  SYN9  "
DATA "WISDOMDUDE  VON  LITHIUM  WILDCARD  MRMOOSE  FLING  NEO  CHAOS  PIPTOL"
DATA "  STERLING                              WELL, THAT'S ALL I GOT, SORRY,"
DATA " NO SECRET CHEAT CODES FOR WATCHING THIS LAME SCROLLER ...    GOTO 100"

SUB CalcNormals (Model() AS PointType, Poly() AS PolyType, v() AS VectorType, v2() AS VectorType)
  ' Calculates the face and vertex normals of all the polygons of the cube

  ' Face normals
  FOR i = 1 TO UBOUND(v)

    ' Vertex
    p1 = Poly(i).p1
    p2 = Poly(i).p2
    p3 = Poly(i).p3

    ' Coords
    x1 = Model(p1).x
    x2 = Model(p2).x
    x3 = Model(p3).x
    y1 = Model(p1).y
    y2 = Model(p2).y
    y3 = Model(p3).y
    Z1 = Model(p1).z
    Z2 = Model(p2).z
    Z3 = Model(p3).z

    ' Vectors
    ax! = x2 - x1
    bx! = x3 - x2
    ay! = y2 - y1
    by! = y3 - y2
    az! = Z2 - Z1
    bz! = Z3 - Z2

    ' Cross product
    xNormal! = ay! * bz! - az! * by!
    yNormal! = az! * bx! - ax! * bz!
    zNormal! = ax! * by! - ay! * bx!

    ' Normalize
    Mag! = SQR(xNormal! * xNormal! + yNormal! * yNormal! + zNormal! * zNormal!)
    IF Mag! <> 0 THEN
      xNormal! = xNormal! / Mag!
      yNormal! = yNormal! / Mag!
      zNormal! = zNormal! / Mag!
    END IF

    ' Final face normal
    v(i).x = xNormal!
    v(i).y = yNormal!
    v(i).z = zNormal!

  NEXT

  ' Vertex Normals
  ' Algo: Since we cannot find a normal to a point (doh?!!!) we find adjacent
  ' planes (faces) of the polyhedra, then add the facenormals of all the
  ' faces where a particular vertex is located.
  FOR i = 1 TO UBOUND(Model)
    xNormal! = 0
    yNormal! = 0
    zNormal! = 0
    FaceFound = 0

    FOR j = 1 TO UBOUND(Poly)
      IF Poly(j).p1 = i OR Poly(j).p2 = i OR Poly(j).p3 = i THEN
        xNormal! = xNormal! + v(j).x
        yNormal! = yNormal! + v(j).y
        zNormal! = zNormal! + v(j).z
        FaceFound = FaceFound + 1
      END IF
    NEXT

    xNormal! = xNormal! / FaceFound
    yNormal! = yNormal! / FaceFound
    zNormal! = zNormal! / FaceFound

    ' Normalize
    Mag! = SQR(xNormal! * xNormal! + yNormal! * yNormal! + zNormal! * zNormal!)
    IF Mag! <> 0 THEN
      xNormal! = xNormal! / Mag!
      yNormal! = yNormal! / Mag!
      zNormal! = zNormal! / Mag!
    END IF

    ' Vertex normals
    v2(i).x = xNormal!
    v2(i).y = yNormal!
    v2(i).z = zNormal!
  NEXT

END SUB

SUB DrawCube (Model() AS PointType, Poly() AS PolyType) STATIC

  FOR i = 1 TO UBOUND(Poly)

    x1 = Model(Poly(i).p1).sx  ' Get triangles from "projected"
    x2 = Model(Poly(i).p2).sx  ' X and Y coords since zNormal
    x3 = Model(Poly(i).p3).sx  ' does not require a Z coord
    y1 = Model(Poly(i).p1).sy  ' V1 = Point1 connected to V2 then
    y2 = Model(Poly(i).p2).sy  ' V2 to V3 and so on...
    y3 = Model(Poly(i).p3).sy

    zNormal = (x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3)
    IF zNormal < 0 THEN

      ' Vertex 1
      nx1! = CubeVtxNormal2(Poly(i).p1).x
      ny1! = CubeVtxNormal2(Poly(i).p1).y
      nz1! = CubeVtxNormal2(Poly(i).p1).z

      ' Vertex 2
      nx2! = CubeVtxNormal2(Poly(i).p2).x
      ny2! = CubeVtxNormal2(Poly(i).p2).y
      nz2! = CubeVtxNormal2(Poly(i).p2).z

      ' Vertex 3
      nx3! = CubeVtxNormal2(Poly(i).p3).x
      ny3! = CubeVtxNormal2(Poly(i).p3).y
      nz3! = CubeVtxNormal2(Poly(i).p3).z

      lx! = LightNormal.x
      ly! = LightNormal.y
      lz! = LightNormal.z

      ' Calculate dot-products of vertex normals
      Dot1! = (nx1! * lx!) + (ny1! * ly!) + (nz1! * lz!)
      IF Dot1! < 0 THEN  ' Limit
        Dot1! = 0
      ELSEIF Dot1! > 1 THEN
        Dot1! = 1
      END IF

      Dot2! = (nx2! * lx!) + (ny2! * ly!) + (nz2! * lz!)
      IF Dot2! < 0 THEN
        Dot2! = 0
      ELSEIF Dot2! > 1 THEN
        Dot2! = 1
      END IF

      Dot3! = (nx3! * lx!) + (ny3! * ly!) + (nz3! * lz!)
      IF Dot3! < 0 THEN
        Dot3! = 0
      ELSEIF Dot3! > 1 THEN
        Dot3! = 1
      END IF

      ' Multiply by color range
      clr1 = Dot1! * 64 + 128
      clr2 = Dot2! * 64 + 128
      clr3 = Dot3! * 64 + 128

      DQBgtri B1, x1, y1, clr1, x2, y2, clr2, x3, y3, clr3

    END IF
  NEXT

END SUB

SUB GetBlaster (BaseAddr, IRQ, DMA)

  Config$ = UCASE$(ENVIRON$("BLASTER"))

  FOR i = 1 TO LEN(Config$)
    SELECT CASE MID$(Config$, i, 1)
      CASE "A"
        BaseAddr = VAL("&H" + MID$(Config$, i + 1, 3))
      CASE "I"
        IRQ = VAL(MID$(Config$, i + 1, 2))
      CASE "D"
        DMA = VAL(MID$(Config$, i + 1, 1))
    END SELECT
  NEXT

END SUB

SUB GetUltrasnd (BaseAddr, IRQ, DMA)

  Config$ = UCASE$(ENVIRON$("ULTRASND")) + ","

  Tag = 0
  Prev = 0
  Split = INSTR(1, Config$, ",")
  DO WHILE Split > 0
    Token$ = LTRIM$(MID$(Config$, Prev + 1, Split - Prev - 1))
    IF LEN(Token$) THEN
      SELECT CASE Tag
        CASE 0
          BaseAddr = VAL("&H" + Token$)
        CASE 1
          DMA = VAL(Token$)
        CASE 3
          IRQ = VAL(Token$)
          EXIT DO
      END SELECT
      Tag = Tag + 1
    END IF
    Prev = Split
    Split = INSTR(Split + 1, Config$, ",")
  LOOP

  IF BaseAddr = 0 THEN BaseAddr = &HFFFF
  IF IRQ = 0 THEN IRQ = &HFF
  IF DMA = 0 THEN DMA = &HFF

END SUB

SUB InitImageData (ImageSeg, ImageOff, ImageLen, ImageArray())

  Ints = (ImageLen - 7) \ 2
  REDIM ImageArray(1 TO Ints)

  FOR i = 0 TO ImageLen - 8
    DEF SEG = ImageSeg
    Byte = PEEK(i + ImageOff + 7)
    DEF SEG = VARSEG(ImageArray(1))
    POKE i + VARPTR(ImageArray(1)), Byte
  NEXT

END SUB

SUB LoadCube (Model() AS PointType, Tri() AS PolyType) STATIC

  RESTORE NumPoints
  READ MaxVertex
  REDIM Model(1 TO MaxVertex) AS PointType

  RESTORE VertexData
  FOR v = 1 TO UBOUND(Model)
    READ xt, tt, zt
    Model(v).x = xt
    Model(v).y = tt
    Model(v).z = zt
  NEXT

  RESTORE NumPoly
  READ MaxPoly
  REDIM Tri(MaxPoly) AS PolyType

  RESTORE ConnectData
  FOR v = 1 TO UBOUND(Tri)
    READ t1, t2, t3
    Tri(v).p1 = t1 + 1
    Tri(v).p2 = t2 + 1
    Tri(v).p3 = t3 + 1
  NEXT

  ' Face normals
  REDIM CubeNormal(1 TO UBOUND(Tri)) AS VectorType

  ' Vertex normals
  REDIM CubeVtxNormal(1 TO UBOUND(Model)) AS VectorType
  REDIM CubeVtxNormal2(1 TO UBOUND(Model)) AS VectorType

END SUB

SUB MakeImageIndex (ImageArray(), IndexArray())

  ' The index will initially be built in a temporary array, allowing
  ' for the maximum 1000 images per file.
  DIM Temp(1 TO 1000)
  Ptr& = 1
  IndexNo = 1
  LastInt = UBOUND(ImageArray)

  DO
    Temp(IndexNo) = Ptr&
    IndexNo = IndexNo + 1

    ' Evaluate descriptor of currently referenced image to
    ' calculate the beginning of the next image.
    x& = (ImageArray(Ptr&) \ 8) * (ImageArray(Ptr& + 1)) + 4
    IF x& MOD 2 THEN x& = x& + 1
    Ptr& = Ptr& + (x& \ 2)
  LOOP WHILE Ptr& < LastInt

  LastImage = IndexNo - 1

  ' Copy the image index values into the actual index array.
  REDIM IndexArray(1 TO LastImage)
  FOR n = 1 TO LastImage
    IndexArray(n) = Temp(n)
  NEXT

END SUB

SUB RelFadeToPalStep (StartCol, EndCol, PalString$) STATIC

  ' This sub fades the current palette to the palette in the
  ' 768 byte Palstring$ in steps, so if you want to fade
  ' fully call this sub 64 times from StartColor to Endcolor

  Steps = Steps + 1

  IF Steps > 63 THEN
    Steps = 0
    EXIT SUB
  END IF

  ' Current pal
  REDIM TempPalArray(2, 255)

  ColorVal = 0
  FOR i = 1 TO 768 STEP 3
    TempPalArray(0, ColorVal) = ASC(MID$(PalString$, i, 1))
    TempPalArray(1, ColorVal) = ASC(MID$(PalString$, i + 1, 1))
    TempPalArray(2, ColorVal) = ASC(MID$(PalString$, i + 2, 1))
    ColorVal = ColorVal + 1
  NEXT

  IF StartCol > EndCol THEN SWAP StartCol, EndCol

  FOR j = StartCol TO EndCol

    RelReadRGB j, Red, Green, Blue
    r = TempPalArray(0, j)
    IF r > Red THEN
      Red = Red + 1
    ELSEIF r < Red THEN
      Red = Red - 1
    END IF

    g = TempPalArray(1, j)
    IF g > Green THEN
      Green = Green + 1
    ELSEIF g < Green THEN
      Green = Green - 1
    END IF

    b = TempPalArray(2, j)
    IF b > Blue THEN
      Blue = Blue + 1
    ELSEIF b < Blue THEN
      Blue = Blue - 1
    END IF

    RelWriteRGB j, Red, Green, Blue

  NEXT

  ERASE TempPalArray

END SUB

SUB RelFadeToPalX (StartCol, EndCol, PalString$, Counts, FadeMusic) STATIC

  ' This sub fades the current palette to the specified palette comtained
  ' in the 768 byte PalString$ from StartCol to EndCol in the number of
  ' Counts specified

  TempPal$ = SPACE$(768)
  RelReadPal TempPal$

  REDIM TempPalArray(2, 255) AS SINGLE   ' Current pal
  REDIM TempPalArray2(2, 255) AS SINGLE  ' PalString$ pal
  REDIM FadePal(2, 255) AS SINGLE
  DIM PalDiff AS SINGLE

  ColorVal = 0
  FOR i = 1 TO 768 STEP 3
    TempPalArray(0, ColorVal) = ASC(MID$(TempPal$, i, 1))
    TempPalArray(1, ColorVal) = ASC(MID$(TempPal$, i + 1, 1))
    TempPalArray(2, ColorVal) = ASC(MID$(TempPal$, i + 2, 1))
    ColorVal = ColorVal + 1
  NEXT

  ColorVal = 0
  FOR i = 1 TO 768 STEP 3
    TempPalArray2(0, ColorVal) = ASC(MID$(PalString$, i, 1))
    TempPalArray2(1, ColorVal) = ASC(MID$(PalString$, i + 1, 1))
    TempPalArray2(2, ColorVal) = ASC(MID$(PalString$, i + 2, 1))
    ColorVal = ColorVal + 1
  NEXT

  IF Counts < 1 THEN Counts = 1

  ' Morphing algorithm used
  IF StartCol > EndCol THEN SWAP StartCol, EndCol

  FOR i = StartCol TO EndCol
    PalDiff = TempPalArray2(0, i) - TempPalArray(0, i)
    FadePal(0, i) = PalDiff / Counts

    PalDiff = TempPalArray2(1, i) - TempPalArray(1, i)
    FadePal(1, i) = PalDiff / Counts

    PalDiff = TempPalArray2(2, i) - TempPalArray(2, i)
    FadePal(2, i) = PalDiff / Counts
  NEXT

  FOR i = 1 TO Counts

    FOR j = StartCol TO EndCol
      TempPalArray(0, j) = TempPalArray(0, j) + FadePal(0, j)
      TempPalArray(1, j) = TempPalArray(1, j) + FadePal(1, j)
      TempPalArray(2, j) = TempPalArray(2, j) + FadePal(2, j)
    NEXT

    IF FadeMusic THEN
      rc = MusicVolume(i / Counts * 64)
    END IF

    WAIT &H3DA, 8, 8
    WAIT &H3DA, 8

    FOR j = StartCol TO EndCol
      OUT &H3C8, j
      OUT &H3C9, TempPalArray(0, j)
      OUT &H3C9, TempPalArray(1, j)
      OUT &H3C9, TempPalArray(2, j)
    NEXT

  NEXT

  ERASE TempPalArray
  ERASE TempPalArray2
  ERASE FadePal

END SUB

SUB RelFont256 (DestSeg, x, y, Text$, Centered, FontArray(), FontArrayIndex()) STATIC

  FontSeg = VARSEG(FontArray(1))

  ' Modified for a little sine wave action
  FOR i = 1 TO LEN(Text$)
    FontChar = ASC(MID$(Text$, i, 1)) - 31
    IF x > -20 THEN
      DQBput DestSeg, x, SIN(x / 30) * 16 + 100, FontSeg, VARPTR(FontArray(FontArrayIndex(FontChar)))
    END IF
    x = x + (FontArray(FontArrayIndex(FontChar)) \ 8)
    IF x > 320 THEN EXIT FOR
  NEXT

END SUB

SUB RelReadPal (PalString$) STATIC

  TempPal$ = SPACE$(768)

  OUT &H3C7, 0
  FOR i = 0 TO 255
    MID$(TempPal$, (i * 3) + 1, 1) = CHR$(INP(&H3C9))
    MID$(TempPal$, (i * 3) + 2, 1) = CHR$(INP(&H3C9))
    MID$(TempPal$, (i * 3) + 3, 1) = CHR$(INP(&H3C9))
  NEXT

  PalString$ = TempPal$

END SUB

SUB RelReadRGB (ColorVal, r, g, b)

  OUT &H3C7, ColorVal
  r = INP(&H3C9)
  g = INP(&H3C9)
  b = INP(&H3C9)

END SUB

SUB RelWriteRGB (ColorNum, r, g, b)

  OUT &H3C8, ColorNum
  OUT &H3C9, r
  OUT &H3C9, g
  OUT &H3C9, b

END SUB

SUB RotateAndProject (Model() AS PointType, AngleX, AngleY, AngleZ) STATIC

  ' Right handed system
  ' x = goes right
  ' y = up
  ' z = goes into you (out of the screen)

  ' Precalculate the SIN and COS of each angle
  cx! = LCos(AngleX)
  sx! = LSin(AngleX)
  cy! = LCos(AngleY)
  sy! = LSin(AngleY)
  cz! = LCos(AngleZ)
  sz! = LSin(AngleZ)

  ' After 2 hours of work, I was able to weed out the constants from
  ' rotate and project N to reduce my muls to 9 instead of 12. woot!!!!
  xx! = cy! * cz!
  xy! = sx! * sy! * cz! - cx! * sz!
  xz! = cx! * sy! * cz! + sx! * sz!

  yx! = cy! * sz!
  yy! = cx! * cz! + sx! * sy! * sz!
  yz! = -sx! * cz! + cx! * sy! * sz!

  zx! = -sy!
  zy! = sx! * cy!
  zz! = cx! * cy!

  FOR i = 1 TO UBOUND(Model)

    x! = Model(i).x
    y! = Model(i).y
    z! = Model(i).z

    RotX! = (x! * xx! + y! * xy! + z! * xz!) - CamX
    RotY! = (x! * yx! + y! * yy! + z! * yz!) - CamY
    RotZ! = (x! * zx! + y! * zy! + z! * zz!) - CamZ

    Model(i).xr = RotX!
    Model(i).yr = RotY!
    Model(i).zr = RotZ!

    ' Project
    Distance = (Lens - RotZ!)
    IF Distance THEN
      Model(i).sx = CenterX + (Lens * RotX! / Distance)
      Model(i).sy = CenterY - (Lens * RotY! / Distance)
    END IF

  NEXT

END SUB

SUB RotateNormals (v() AS VectorType, v2() AS VectorType, AngleX, AngleY, AngleZ)

  ' We don't have to calculate normals in real time but we could instead
  ' rotate them just as we would rotate our points.

  ' Precalculate the SIN and COS of each angle
  cx! = LCos(AngleX)
  sx! = LSin(AngleX)
  cy! = LCos(AngleY)
  sy! = LSin(AngleY)
  cz! = LCos(AngleZ)
  sz! = LSin(AngleZ)

  ' After 2 hours of work, I was able to weed out the constants from
  ' rotate and project N to reduce my muls to 9 instead of 12. woot!!!!
  xx! = cy! * cz!
  xy! = sx! * sy! * cz! - cx! * sz!
  xz! = cx! * sy! * cz! + sx! * sz!

  yx! = cy! * sz!
  yy! = cx! * cz! + sx! * sy! * sz!
  yz! = -sx! * cz! + cx! * sy! * sz!

  zx! = -sy!
  zy! = sx! * cy!
  zz! = cx! * cy!

  FOR i = 1 TO UBOUND(v)

    ' Load Original normals
    x! = v(i).x
    y! = v(i).y
    z! = v(i).z

    RotX! = (x! * xx! + y! * xy! + z! * xz!)
    RotY! = (x! * yx! + y! * yy! + z! * yz!)
    RotZ! = (x! * zx! + y! * zy! + z! * zz!)

    ' Rotated normals
    v2(i).x = RotX!
    v2(i).y = RotY!
    v2(i).z = RotZ!

  NEXT

END SUB

