/********************************************************************************************/
//Program name:
//Date:
/********************************************************************************************/
//Author: Richard van der Brugge,/Email: richard@vanderbrugge.com
//Copyright 2000, All rights reserved
/***********************************************/
//Description:
//
//
/***********************************************/
//Revision history:
//
//
//21-5-2000 being bored i added another 40 sprite star giving the illusion of 80 sprites on screen...
//
//11-5-2000 giving it another shot... rev 3
//		    This time its working properly on GBC emulators
//
/***********************************************/

/***********************************************/
/* Starfield                                                             */
/*                                                                        */
/* An attempt to recreate an old asm starfield              */
/* in GBDK C for the gameboy                                  */
/*                                                                        */
/* Yes this must be the most trivial demoeffect             */
/* in the book, but still fun...                                      */
/*                              */
/* You can use this freely in whatever way you  */
/* want.                            */
/*                              */
/* All rights reserved                  */
/* Code: Richard van der Brugge,Jan 2000        */
/*                              */
/* Email: rvdbrugge@yahoo.com           */
/*                              */
/***********************************************/

//version2 - trying some speed optimizing...

//this version is slightly different from the first.
//i've tried some loop unrolling by removing the procedures
//and putting them into the main code loop
//also removed the randomize functions now using
//precalculated values from the xarray.c file
//so what did we gain in speed? basicly nothing...... :-)

//standard GBDK includes
#include <gb.h>
#include <cgb.h>
//arrays holding precalc. "random" numbers
#include "xarray.c"

//include title screen gfx data
#include"gfx\title_t.h"
#include"gfx\title_t.c"
#include"gfx\title_p.h"
#include"gfx\title_p.c"
#include"gfx\title_m.h"
#include"gfx\title_m.c"

//include the sprite data from GBTD
// sprite 0 smallest star
// sprite 1 a bit bigger
// sprite 2 biggest star
#include "sprite_t.c"
#include "sprite_t.h"




UWORD TitlePalCGB[] =
{
  TitleTilesCGBPal0c0,TitleTilesCGBPal0c1,TitleTilesCGBPal0c2,TitleTilesCGBPal0c3,
  TitleTilesCGBPal1c0,TitleTilesCGBPal1c1,TitleTilesCGBPal1c2,TitleTilesCGBPal1c3,
  TitleTilesCGBPal2c0,TitleTilesCGBPal2c1,TitleTilesCGBPal2c2,TitleTilesCGBPal2c3,
  TitleTilesCGBPal3c0,TitleTilesCGBPal3c1,TitleTilesCGBPal3c2,TitleTilesCGBPal3c3,
  TitleTilesCGBPal4c0,TitleTilesCGBPal4c1,TitleTilesCGBPal4c2,TitleTilesCGBPal4c3,
  TitleTilesCGBPal5c0,TitleTilesCGBPal5c1,TitleTilesCGBPal5c2,TitleTilesCGBPal5c3,
  TitleTilesCGBPal6c0,TitleTilesCGBPal6c1,TitleTilesCGBPal6c2,TitleTilesCGBPal6c3,
  TitleTilesCGBPal7c0,TitleTilesCGBPal7c1,TitleTilesCGBPal7c2,TitleTilesCGBPal7c3
};

UWORD SpritePalList[]=
{
StarSpriteCGBPal1c0,StarSpriteCGBPal1c1,StarSpriteCGBPal1c2,StarSpriteCGBPal1c3,
StarSpriteCGBPal2c0,StarSpriteCGBPal2c1,StarSpriteCGBPal2c2,StarSpriteCGBPal2c3,
StarSpriteCGBPal3c0,StarSpriteCGBPal3c1,StarSpriteCGBPal3c2,StarSpriteCGBPal3c3,
StarSpriteCGBPal4c0,StarSpriteCGBPal4c1,StarSpriteCGBPal4c2,StarSpriteCGBPal4c3,

};


//array to hold all star positions
long  starx[80];
long  stary[80];
long  starz[80];

UBYTE rndcounter;


UBYTE i;
long  posx;
long  posy;
long relposx;
long relposy;
UBYTE relposdirection;

void init();



void main()
{




disable_interrupts();
cpu_fast();
enable_interrupts();

//setup all sprites
init();

DISPLAY_OFF;
HIDE_BKG;

set_bkg_palette( 7, 1, &TitlePalCGB[28] );
set_bkg_palette( 6, 1, &TitlePalCGB[24] );
set_bkg_palette( 5, 1, &TitlePalCGB[20] );
set_bkg_palette( 4, 1, &TitlePalCGB[16] );
set_bkg_palette( 3, 1, &TitlePalCGB[12] );
set_bkg_palette( 2, 1, &TitlePalCGB[8] );
set_bkg_palette( 1, 1, &TitlePalCGB[4] );
set_bkg_palette( 0, 1, &TitlePalCGB[0] );
set_bkg_data(0 /* first tile */, 197 /* number of tiles */, TitleTiles /* label of tiles */);
VBK_REG = 1;
set_bkg_tiles(0,0,TitleMapWidth,TitleMapHeight,TitlePal);
VBK_REG = 0;
set_bkg_tiles(0,0,TitleMapWidth,TitleMapHeight,TitleMap);
SHOW_BKG;
DISPLAY_ON;

relposx=72;
relposy=80;
relposdirection=1;

//keep doing this forever
while(1){

	/*	the formula for the starfield is:
				x=(starX*32)/starZ+72 (yes 72=gameboy screen width/2)
				y=(starY*32)/starZ+80 (guess what ? 80=gameboy screen height/2)
	*/

	//move the centre of the starfield a bit...
	if (relposdirection){relposx++;relposy++;}
	if (!relposdirection){relposx--;relposy--;}
	if (relposx==90){relposdirection=0;}
	if (relposx==50){relposdirection=1;}

    for (i=0;i!=41;i++){

		// do posx=startx[i]*32 a bit faster
        posx=starx[i]<<5;
        posx=posx/starz[i];
        posx+=relposx;

        posy=stary[i]<<5;
        posy=posy/starz[i];
        posy+=relposy;

        starz[i]--;



		//hit the bottom or top ?
        if (starz[i]==0||posx>160||posx<0||posy>144||posy<0){
            starx[i]=xarray[rndcounter];
            stary[i]=yarray[rndcounter];
            rndcounter++;
            if(rndcounter==160){rndcounter=0;}
            starz[i]=32;
            set_sprite_tile(i,0);
        }


		//move first 40 sprites
        move_sprite(i,posx,posy);
    }

	//do it all again, but now with the next 40 sprites
	//if you move the 40 sprites fast enough to a new position
	//it will seems if there are 80 sprites.....
    for (i=41;i!=81;i++){

			// do posx=startx[i]*32 a bit faster
	        posx=starx[i]<<5;
	        posx=posx/starz[i];
	        posx+=relposx;

	        posy=stary[i]<<5;
	        posy=posy/starz[i];
	        posy+=relposy;

	        starz[i]--;

			//hit the bottom or top ?
	        if (starz[i]==0||posx>160||posx<0||posy>144||posy<0){
	            starx[i]=xarray[rndcounter];
	            stary[i]=yarray[rndcounter];
	            rndcounter++;
	            if(rndcounter==160){rndcounter=0;}
	            starz[i]=32;
	            set_sprite_tile(i,0);

	        }



		//move next 40 sprites
	        move_sprite(i-40,posx,posy);
    }
//wait_vbl_done();


}//end while
}//end main

void init()
{
UBYTE i;
UBYTE r;
UBYTE palcounter;
DISPLAY_OFF;
HIDE_SPRITES;
//load sprite data from include file sprite_t.c

set_sprite_palette( 0, 1, &SpritePalList[0] );
set_sprite_palette( 1, 1, &SpritePalList[4] );
set_sprite_palette( 2, 1, &SpritePalList[8] );
set_sprite_palette( 3, 1, &SpritePalList[12] );
set_sprite_palette( 4, 1, &SpritePalList[16] );
set_sprite_palette( 5, 1, &SpritePalList[20] );
set_sprite_palette( 6, 1, &SpritePalList[24] );

set_sprite_data(0,4,StarSprite);
VBK_REG = 1;
set_sprite_prop(0,SpritePalList[3]);
VBK_REG = 0;

palcounter=0;
//setup all star x/y/z data
for (i=0;i!=81;i++){
        starx[i]=xarray[rndcounter];
        stary[i]=yarray[rndcounter];
        rndcounter++;
        starz[i]=32;

			set_sprite_tile(i,0);
        	palcounter++;
        	if (palcounter==4){palcounter=0;}
        	set_sprite_prop(i,SpritePalList[palcounter*4]);

}
DISPLAY_ON;
SHOW_SPRITES;

}//end init

