;pressure / tension inverted
;sensenstahl
;www.sensenstahl.com
;fasm 1.69.31
;listening: kanako hara - akatsuki
;____________________________________________________________________________

;shoot a colored block to the top. if the player gets 2x the same color
;AND those colors are light blue and light green and cyan (09h+0ah+0bh) the
;blocks from the top will lower 1 row while the top gets filled with a random
;new row of blocks. if the blocks reach the bottom where you are: game over.

;if the shot player block forms a vertical line of 3 or more identical blocks
;these will get deleted. each block earns you 1000pts. after shooting the
;player gets another random colored block.

;yes, you can take your time to aim and think, the playfield will stay
;static while you do so. but don't worry, you will run out of space ;)

;and yes. this might make you hate light blue and light green 

;controls:
;a:   left
;d:   rite
;s:   fire
;esc: gtfo
;____________________________________________________________________________

;the core is identical to my 256 byte game release "tension", changed and
;even optimized here and there. i thought about beginning from 0 but that
;made no sense.

;in the 1st version every 1500 frames a new row of random blocks got added
;while the blocks got moved down. but that made it more or less impossible
;to have some actual gameplay.
;____________________________________________________________________________

;assuming ax = 0 cx = 255 bx = 0

;used global variables: si = pos of player block
;                       bp = color of active player block

;no screen buffer. everything done directly in video memory. also no vsync
;since there is nothing to sync

org 100h
use16

start:   push 0b800h ;textmooooooode
frmz:    pop ds
         ;mov al,03h  ;50*25
         inc ax ;mov al,01h; 1 = 40*25 16 colors
         int 10h

mov si,80*23+40 ;init player pos
call newcolor
mov bp,ax
;mov bp,0edbh    ;init player color
                ;solid yellow block

;clear whole segment
clear:
mov byte[ds:bx],ch;0
dec bx
jnz clear

;draw borders, field will be 10 wide
;bottom is made by displaying score
;mov bx,80*25;80*32=0a00h
mov bh,0ah
brdr2:
mov dx,78b0h
mov word[ds:bx+30-80],dx    ;left
mov word[ds:bx+50-80],dx    ;right
sub bx,80;bp;160
jnz brdr2

;draw initial score on screen
;to replace a variable system (saving overall 7 bytes because of direct access)
mov bl,18
scrz:
mov word[ds:30+bx],78b0h ;this is the top border of the playfield
                         ;this is needed because you could shoot into nothingness
mov word[ds:80*24+30+bx],7130h ;'0' = 48 = 30h / 16*7+1 = 113 = 71h
dec bx
dec bx
jnz scrz
dec byte[ds:80*24+30+18] ;make score -1 so game does not start with 000000001


mov cl,1   ;score + 1 so it is shown from the beginning
jmp addor  ;jump to the score routine + create a new block


;player shot
shoot:
mov di,si ;get player pos
mov dx,80 ;reuse to save 1b in total
up:
sub di,dx;80         ;move up from player
cmp word[ds:di],bx;0 ;still space?
je up                ;yes so move more

;cmp di,80*22
;jae breaker

add di,dx;80         ;adjust so all checks below
                     ;start at the set block
mov word[ds:di],bp   ;set block that got sent


call newcolor ;create a new color for the next player block
xchg bp,ax    ;set new player color
              ;and get the old one for checking into ax

;check if there is a column of 3 or more
;blocks that can be deleted, starting with the block that
;just got set

xor cx,cx ;zero that for checking
check:
inc cx             ;found a block
sub di,dx;80       ;move up
cmp word[ds:di],ax ;check next one
je check           ;there is still the same color?

cmp cx,3           ;minimum of 3 needed
jnae new_row       ;if below then skip score

imul cx,cx,1000    ;points!

;erase the column by just putting 0 into memory
;in 1 line to the bottom
delete:
add di,dx;80
mov word[ds:di],bx;0
cmp di,si;80*22
jne delete

new_row:
cmp bp,ax      ;was previous player color identical with new one?
jne check_more ;nope

cmp ah,0ch;0bh    ;blue,green, cyan will cause trouble
jae check_more

;color is identical, so move all blocks down and create a new random
;line of blocks
mov di,80*22+48   ;just move all the memory contents up
mover:
mov ax,word[ds:di]    ;grab
mov word[ds:di+80],ax ;set below
dec di
dec di
jnz mover

;bx = 0 here
;di = 0 here
;add a new random row of blocks on the top
mov bl,9*2
blokk:
call newcolor                ;returns ax = new block
mov word[ds:bx+30+80],ax     ;set new block
;add di,word[ds:bx+30+80*23] ;row of player empty after lowering blocks?
                             ;player got deleted by moving
                             ;anyway
cmp word[ds:bx+30+80*23],di;0
jne breaker ;game ovurr

dec bx
dec bx
jnz blokk

;cmp di,bx;0 ;block reached the bottom
;jne breaker ;game over

check_more:
cmp cx,3000  ;not having 3k means no blocks got deleted
jnae main    ;so do not add score

addor:

mov al,1 ;indicate that score +1 has to be proceeded

;ax, bx, di usable here
;bx = 0 here
mov bl,9*2; score numbers/digits * 2

scorehandler:
;mov dl,byte[cs:score+bx-1]
mov ah,byte[ds:80*24+30+bx] ;only grab ascii from screen buffer
cmp al,1                    ;next row is coming so +1, set above
jne fine3
inc ah ;score +1
cmp ah,"9"
jna fine4  ;no reminder
mov ah,"0" ;reminder
jmp fine3  ;update score
fine4:
mov al,bh   ;no more change
fine3:

mov byte[ds:80*24+30+bx],ah ;set new ascii to the screen

dec bx           ;next digit
dec bx           ;next digit
jnz scorehandler
loop addor       ;add up all score


;well, that might be the shortest main section in all of my intros ;)
main:

mov word[ds:si],bp ;draw player

         mov ah,01h
         int 16h
         jz main               ;if no key pressed do nothing

         mov ah,00h            ;key pressed so get the code
         int 16h

         cmp al,27             ;esc
         je breaker            ;bye bye

mov word[ds:si],bx ;del player

cut1:    cmp al,'a'          ;left
         jne cut4
         cmp si,80*23+32
         je cutx
         dec si
         dec si
cut4:    cmp al,'d'          ;rite
         jne cut3
         cmp si,80*23+48
         je cutx
         inc si
         inc si
cut3:    cmp al,'s'          ;s like shoot!
         je shoot            ;do ze shoot!

cutx:
jmp main

;create new color and store it in ax
newcolor:
in al,40h      ;rnd
imul ax,ax,713 ;rnd enough
shr ah,4       ;col 0 - 15
;shr ax,10
;mov ah,al
add ah,9     ;colors 9-15
cmp ah,16    ;above 15?
jae newcolor ;repeat until no 16 (blue blink) or above
mov al,219   ;solid block

breaker: ret ;halt!